/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.mixin.spell_mob;

import com.google.common.collect.Maps;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.spells.fire.BurningDashSpell;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PathfinderMob.class})
public class PathfinderMobMixin
extends Mob
implements IMagicEntity {
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_CANCEL_CAST = SynchedEntityData.m_135353_(PathfinderMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_DRINKING_POTION = SynchedEntityData.m_135353_(PathfinderMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private final MagicData playerMagicData = new MagicData(true);
    @Unique
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E"), "Drinking speed penalty", -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL);
    @Unique
    @Nullable
    public SpellData castingSpell;
    @Unique
    public final HashMap<String, AbstractSpell> spells = Maps.newHashMap();
    @Unique
    public int drinkTime;
    @Unique
    public boolean hasUsedSingleAttack;

    protected PathfinderMobMixin(EntityType<? extends Mob> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
    }

    public PathfinderMob self() {
        return (PathfinderMob)this;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    public void init(EntityType<? extends PathfinderMob> entityType, Level level, CallbackInfo ci) {
        if (!(this.self() instanceof AbstractSpellCastingMob)) {
            this.playerMagicData.setSyncedData(new SyncedSpellData((LivingEntity)this.self()));
            this.f_21365_ = this.createLookControl();
        }
    }

    @Unique
    private LookControl createLookControl() {
        return new LookControl(this){

            protected boolean m_8106_() {
                return PathfinderMobMixin.this.m_5448_() == null;
            }
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        if (!(this.self() instanceof AbstractSpellCastingMob)) {
            this.f_19804_.m_135372_(DATA_CANCEL_CAST, (Object)false);
            this.f_19804_.m_135372_(DATA_DRINKING_POTION, (Object)false);
        }
    }

    public MagicData getMagicData() {
        return this.playerMagicData;
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DRINKING_POTION);
    }

    public void setDrinkingPotion(boolean drinkingPotion) {
        this.f_19804_.m_135381_(DATA_DRINKING_POTION, (Object)drinkingPotion);
    }

    public void startDrinkingPotion() {
        if (!this.m_9236_().f_46443_) {
            this.setDrinkingPotion(true);
            this.drinkTime = 35;
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            attributeinstance.m_22130_(SPEED_MODIFIER_DRINKING);
            attributeinstance.m_22118_(SPEED_MODIFIER_DRINKING);
        }
    }

    private void finishDrinkingPotion() {
        this.setDrinkingPotion(false);
        this.m_5634_(Math.min(Math.max(10.0f, this.m_21233_() / 10.0f), this.m_21233_() / 4.0f));
        this.m_21051_(Attributes.f_22279_).m_22130_(SPEED_MODIFIER_DRINKING);
        if (this.m_20067_()) {
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12551_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (!(this.self() instanceof AbstractSpellCastingMob)) {
            if (!this.self().m_9236_().f_46443_) {
                return;
            }
            if (pKey.m_135015_() == DATA_CANCEL_CAST.m_135015_()) {
                this.cancelCast();
            }
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (!(this.self() instanceof AbstractSpellCastingMob)) {
            this.playerMagicData.getSyncedData().saveNBTData(pCompound);
            pCompound.m_128379_("usedSpecial", this.hasUsedSingleAttack);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (!(this.self() instanceof AbstractSpellCastingMob)) {
            SyncedSpellData syncedSpellData = new SyncedSpellData((LivingEntity)this.self());
            syncedSpellData.loadNBTData(pCompound);
            if (syncedSpellData.isCasting()) {
                AbstractSpell spell = SpellRegistry.getSpell((String)syncedSpellData.getCastingSpellId());
                this.initiateCastSpell(spell, syncedSpellData.getCastingSpellLevel());
            }
            this.playerMagicData.setSyncedData(syncedSpellData);
            this.hasUsedSingleAttack = pCompound.m_128471_("usedSpecial");
        }
    }

    public void cancelCast() {
        if (this.isCasting()) {
            if (!this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(DATA_CANCEL_CAST, (Object)((Boolean)this.f_19804_.m_135370_(DATA_CANCEL_CAST) == false ? 1 : 0));
            }
            this.castComplete();
        }
    }

    public void castComplete() {
        if (!this.m_9236_().f_46443_) {
            if (this.castingSpell != null) {
                this.castingSpell.getSpell().onServerCastComplete(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this.self(), this.playerMagicData, false);
            }
        } else {
            this.playerMagicData.resetCastingState();
        }
        this.castingSpell = null;
    }

    public void setSyncedSpellData(SyncedSpellData syncedSpellData) {
        if (this.m_9236_().f_46443_) {
            boolean isCasting = this.playerMagicData.isCasting();
            this.playerMagicData.setSyncedData(syncedSpellData);
            this.castingSpell = this.playerMagicData.getCastingSpell();
            if (this.castingSpell != null) {
                if (!this.playerMagicData.isCasting() && isCasting) {
                    this.castComplete();
                } else if (this.playerMagicData.isCasting() && !isCasting) {
                    AbstractSpell spell = this.playerMagicData.getCastingSpell().getSpell();
                    this.initiateCastSpell(spell, this.playerMagicData.getCastingSpellLevel());
                    if (this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                        this.castingSpell.getSpell().onClientPreCast(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this.self(), InteractionHand.MAIN_HAND, this.playerMagicData);
                        this.castComplete();
                    }
                }
            }
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (!(this.self() instanceof AbstractSpellCastingMob)) {
            if (this.isDrinkingPotion()) {
                if (this.drinkTime-- <= 0) {
                    this.finishDrinkingPotion();
                } else if (this.drinkTime % 4 == 0 && this.m_20067_()) {
                    this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11911_, this.m_5720_(), 1.0f, Utils.random.m_188501_() * 0.1f + 0.9f);
                }
            }
            if (this.castingSpell != null) {
                this.playerMagicData.handleCastDuration();
                if (this.playerMagicData.isCasting()) {
                    this.castingSpell.getSpell().onServerCastTick(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this.self(), this.playerMagicData);
                }
                this.forceLookAtTarget(this.m_5448_());
                if (this.playerMagicData.getCastDurationRemaining() <= 0) {
                    if (this.castingSpell.getSpell().getCastType() == CastType.LONG || this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                        this.castingSpell.getSpell().onCast(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this.self(), CastSource.MOB, this.playerMagicData);
                    }
                    this.castComplete();
                } else if (this.castingSpell.getSpell().getCastType() == CastType.CONTINUOUS && (this.playerMagicData.getCastDurationRemaining() + 1) % 10 == 0) {
                    this.castingSpell.getSpell().onCast(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this.self(), CastSource.MOB, this.playerMagicData);
                }
            }
        }
    }

    public void initiateCastSpell(AbstractSpell spell, int spellLevel) {
        if (spell == SpellRegistry.none()) {
            this.castingSpell = null;
        } else {
            this.castingSpell = new SpellData(spell, spellLevel);
            if (this.m_5448_() != null) {
                this.forceLookAtTarget(this.m_5448_());
            }
            if (!this.m_9236_().f_46443_ && !this.castingSpell.getSpell().checkPreCastConditions(this.m_9236_(), spellLevel, (LivingEntity)this.self(), this.playerMagicData)) {
                this.castingSpell = null;
            } else {
                if (spell != SpellRegistry.TELEPORT_SPELL.get() && spell != SpellRegistry.FROST_STEP_SPELL.get()) {
                    if (spell == SpellRegistry.BLOOD_STEP_SPELL.get()) {
                        this.setTeleportLocationBehindTarget(3);
                    } else if (spell == SpellRegistry.BURNING_DASH_SPELL.get()) {
                        this.setBurningDashDirectionData();
                    }
                } else {
                    this.setTeleportLocationBehindTarget(10);
                }
                this.playerMagicData.initiateCast(this.castingSpell.getSpell(), this.castingSpell.getLevel(), this.castingSpell.getSpell().getEffectiveCastTime(this.castingSpell.getLevel(), (LivingEntity)this.self()), CastSource.MOB, SpellSelectionManager.MAINHAND);
                if (!this.m_9236_().f_46443_) {
                    this.castingSpell.getSpell().onServerPreCast(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this.self(), this.playerMagicData);
                }
            }
        }
    }

    public void notifyDangerousProjectile(Projectile projectile) {
    }

    public boolean isCasting() {
        return this.playerMagicData.isCasting();
    }

    public boolean setTeleportLocationBehindTarget(int distance) {
        LivingEntity target = this.m_5448_();
        boolean valid = false;
        if (target != null) {
            Vec3 rotation = target.m_20154_().m_82541_().m_82490_((double)(-distance));
            Vec3 pos = target.m_20182_();
            Vec3 teleportPos = rotation.m_82549_(pos);
            for (int i = 0; i < 24; ++i) {
                Vec3 randomness = Utils.getRandomVec3((double)(0.15f * (float)i)).m_82542_(1.0, 0.0, 1.0);
                teleportPos = Utils.moveToRelativeGroundLevel((Level)this.m_9236_(), (Vec3)target.m_20182_().m_82546_(new Vec3(0.0, 0.0, (double)((float)distance / (float)(i / 7 + 1))).m_82524_(-(target.m_146908_() + (float)(i * 45)) * ((float)Math.PI / 180))).m_82549_(randomness), (int)5);
                teleportPos = new Vec3(teleportPos.f_82479_, teleportPos.f_82480_ + (double)0.1f, teleportPos.f_82481_);
                AABB reposBB = this.m_20191_().m_82383_(teleportPos.m_82546_(this.m_20182_()));
                if (this.m_9236_().m_186437_((Entity)this.self(), reposBB.m_82400_((double)-0.05f))) continue;
                valid = true;
                break;
            }
            if (valid) {
                this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(teleportPos));
            } else {
                this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(this.m_20182_()));
            }
        } else {
            this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(this.m_20182_()));
        }
        return valid;
    }

    public void setBurningDashDirectionData() {
        this.playerMagicData.setAdditionalCastData((ICastData)new BurningDashSpell.BurningDashDirectionOverrideCastData());
    }

    private void forceLookAtTarget(LivingEntity target) {
        if (target != null) {
            double d0 = target.m_20185_() - this.m_20185_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d1 = target.m_20188_() - this.m_20188_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
            this.m_146926_(f1 % 360.0f);
            this.m_146922_(f % 360.0f);
        }
    }

    public boolean getHasUsedSingleAttack() {
        return this.hasUsedSingleAttack;
    }

    public void setHasUsedSingleAttack(boolean hasUsedSingleAttack) {
        this.hasUsedSingleAttack = hasUsedSingleAttack;
    }
}

