/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.mixin.minecraft;

import com.kurome.ageofmythology.capability.PlayerDataCapability;
import com.kurome.ageofmythology.config.CurioUtils;
import com.kurome.ageofmythology.data.ItemTagGenerator;
import com.kurome.ageofmythology.data.tag.EntityTagGenerator;
import com.kurome.ageofmythology.item.foodie.FoodieExpertItem;
import liushuangwuyin.bettermorph.api.PlayerIdentity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        Player player;
        LivingEntity identity;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player && (identity = PlayerIdentity.getIdentity((Player)(player = (Player)entityMixin))) != null && identity.m_6095_().m_204039_(EntityTagGenerator.NO_PHYSICS)) {
            player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                if (data.getNoPhysics()) {
                    player.f_19794_ = true;
                }
            });
        }
    }

    @Inject(method={"isInvulnerableTo"}, at={@At(value="HEAD")}, cancellable=true)
    void isInvulnerableTo(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player entity = (Player)entityMixin;
            boolean flag = false;
            if (damageSource.m_276093_(DamageTypes.f_268671_) && CurioUtils.hasTag((LivingEntity)entity, ItemTagGenerator.FALL)) {
                flag = true;
            }
            if ((damageSource.m_276093_(DamageTypes.f_268631_) || damageSource.m_276093_(DamageTypes.f_268468_) || damageSource.m_276093_(DamageTypes.f_268434_) || damageSource.m_276093_(DamageTypes.f_268556_) || damageSource.m_276093_(DamageTypes.f_268684_)) && (CurioUtils.hasTag((LivingEntity)entity, ItemTagGenerator.FIRE) || FoodieExpertItem.immuneFireAndLava((LivingEntity)entity))) {
                flag = true;
            }
            if (damageSource.m_276093_(DamageTypes.f_268546_) && (CurioUtils.hasTag((LivingEntity)entity, ItemTagGenerator.LAVA) || FoodieExpertItem.immuneFireAndLava((LivingEntity)entity))) {
                flag = true;
            }
            if (damageSource.m_276093_(DamageTypes.f_268612_) && CurioUtils.hasTag((LivingEntity)entity, ItemTagGenerator.IN_WALL)) {
                flag = true;
            }
            if (flag) {
                cir.setReturnValue((Object)flag);
            }
        }
    }
}

