/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.mixin.ironspell;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.fire.FireballSpell;
import liushuangwuyin.bettermorph.api.PlayerIdentity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FireballSpell.class}, remap=false)
public abstract class FireballSpellMixin
extends AbstractSpell {
    @Inject(method={"getRadius"}, at={@At(value="HEAD")}, cancellable=true)
    private void modify(int spellLevel, LivingEntity caster, CallbackInfoReturnable<Integer> cir) {
        int radius = 2 + (int)this.getSpellPower(spellLevel, (Entity)caster);
        double limit = 20.0 * FireballSpellMixin.getDragonStageMultiply(caster);
        cir.setReturnValue((Object)((int)Math.min((double)radius, limit)));
    }

    private static double getDragonStageMultiply(LivingEntity livingEntity) {
        Player player;
        LivingEntity identity;
        double mul = 1.0;
        if (livingEntity instanceof Player && (identity = PlayerIdentity.getIdentity((Player)(player = (Player)livingEntity))) instanceof EntityDragonBase) {
            EntityDragonBase dragonBase = (EntityDragonBase)identity;
            int stage = dragonBase.getDragonStage();
            switch (stage) {
                case 1: {
                    mul = 1.0;
                    break;
                }
                case 2: {
                    mul = 2.0;
                    break;
                }
                case 3: {
                    mul = 5.0;
                    break;
                }
                case 4: {
                    mul = 50.0;
                }
            }
        }
        return mul;
    }
}

