/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.mixin.ironspell;

import com.gametechbc.traveloptics.compat.spells.holy.SolarFlareSpell;
import com.gametechbc.traveloptics.spells.aqua.RainfallSpell;
import com.gametechbc.traveloptics.spells.blood.VigorSiphonSpell;
import com.gametechbc.traveloptics.spells.eldritch.ShadowedMiasmaSpell;
import com.gametechbc.traveloptics.spells.ender.CursedMinefieldSpell;
import com.gametechbc.traveloptics.spells.ender.ShearOfTheStarsSpell;
import com.gametechbc.traveloptics.spells.fire.LavaBombSpell;
import com.gametechbc.traveloptics.spells.lightning.EmPulse;
import com.gametechbc.traveloptics.spells.nature.AerialCollapseSpell;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.data.tag.EntityTagGenerator;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.spells.blood.AcupunctureSpell;
import io.redspace.ironsspellbooks.spells.blood.HeartstopSpell;
import io.redspace.ironsspellbooks.spells.eldritch.AbyssalShroudSpell;
import io.redspace.ironsspellbooks.spells.ender.EvasionSpell;
import io.redspace.ironsspellbooks.spells.evocation.ChainCreeperSpell;
import io.redspace.ironsspellbooks.spells.evocation.LobCreeperSpell;
import io.redspace.ironsspellbooks.spells.evocation.SpectralHammerSpell;
import io.redspace.ironsspellbooks.spells.holy.FortifySpell;
import io.redspace.ironsspellbooks.spells.lightning.ChargeSpell;
import io.redspace.ironsspellbooks.spells.lightning.ThunderstormSpell;
import io.redspace.ironsspellbooks.spells.nature.OakskinSpell;
import io.redspace.ironsspellbooks.spells.nature.RootSpell;
import java.util.Arrays;
import java.util.List;
import liushuangwuyin.bettermorph.api.PlayerIdentity;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractSpell.class}, remap=false)
public abstract class AbstractSpellMixin {
    @Shadow
    protected int baseSpellPower;
    @Shadow
    protected int spellPowerPerLevel;

    @Shadow
    public abstract SchoolType getSchoolType();

    @Inject(method={"getSpellPower"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifySpellPower(int spellLevel, Entity sourceEntity, CallbackInfoReturnable<Float> cir) {
        if (sourceEntity instanceof Player) {
            Player player = (Player)sourceEntity;
            LivingEntity identity = PlayerIdentity.getIdentity((Player)player);
            float configPowerModifier = (float)ServerConfigs.getSpellConfig((AbstractSpell)((AbstractSpell)this)).powerMultiplier();
            double entitySpellPowerModifier = 1.0;
            double entitySchoolPowerModifier = 1.0;
            if (sourceEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)sourceEntity;
                entitySpellPowerModifier = (float)livingEntity.m_21133_((Attribute)AttributeRegistry.SPELL_POWER.get());
                entitySchoolPowerModifier = this.getSchoolType().getPowerFor(livingEntity);
            }
            float level = (float)((double)(this.baseSpellPower + this.spellPowerPerLevel * (spellLevel - 1)) * entitySpellPowerModifier * entitySchoolPowerModifier * (double)configPowerModifier);
            if (this instanceof AerialCollapseSpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 5.0f)));
            } else if (this instanceof ShadowedMiasmaSpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 10.0f)));
            } else if (this instanceof VigorSiphonSpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 5.0f)));
            } else if (this instanceof EmPulse) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 10.0f)));
            } else if (this instanceof AcupunctureSpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 10.0f)));
            } else if (this instanceof SpectralHammerSpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 19.0f)));
            } else if (this instanceof AbyssalShroudSpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 6.0f)));
            } else if (this instanceof ChargeSpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 30.0f)));
            } else if (this instanceof HeartstopSpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 300.0f)));
            } else if (this instanceof RootSpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 8.0f)));
            } else if (this instanceof FortifySpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 50.0f)));
            } else if (this instanceof OakskinSpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 60.0f)));
            } else if (this instanceof LobCreeperSpell) {
                double damage = (double)AOMUtil.getExplosionPower(player) * 1.75;
                cir.setReturnValue((Object)Float.valueOf((float)Math.max(damage, (double)level)));
            } else if (this instanceof ChainCreeperSpell) {
                double damage = (double)AOMUtil.getExplosionPower(player) * 0.75;
                cir.setReturnValue((Object)Float.valueOf((float)Math.max(damage, (double)level)));
            } else if (this instanceof LavaBombSpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 10.0f)));
            } else if (this instanceof SolarFlareSpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 5.0f)));
            } else if (this instanceof CursedMinefieldSpell) {
                double damage = (double)this.baseSpellPower + AOMUtil.getRealDamage((LivingEntity)player, Arrays.asList(EntityTagGenerator.MAGIC));
                cir.setReturnValue((Object)Float.valueOf((float)Math.min(damage, 5.0)));
            } else if (this instanceof ShearOfTheStarsSpell) {
                double damage = (double)this.baseSpellPower + AOMUtil.getRealDamage((LivingEntity)player, Arrays.asList(EntityTagGenerator.MAGIC));
                cir.setReturnValue((Object)Float.valueOf((float)(damage * 0.5)));
            } else if (this instanceof RainfallSpell) {
                double damage = (double)this.baseSpellPower + AOMUtil.getRealDamage((LivingEntity)player, Arrays.asList(EntityTagGenerator.MAGIC));
                cir.setReturnValue((Object)Float.valueOf((float)Math.min(damage, 10.0)));
            } else if (this instanceof EvasionSpell) {
                double damage = (double)this.baseSpellPower + AOMUtil.getRealDamage((LivingEntity)player, Arrays.asList(EntityTagGenerator.MAGIC));
                cir.setReturnValue((Object)Float.valueOf((float)Math.min(damage, 5.0)));
            } else if (identity != null) {
                double factor = 1.2;
                if (identity.m_6095_().m_204039_(EntityTagGenerator.EXPLODE)) {
                    factor = 0.1;
                }
                double damage = (double)this.baseSpellPower + AOMUtil.getRealDamage((LivingEntity)player, Arrays.asList(new TagKey[0])) * factor;
                cir.setReturnValue((Object)Float.valueOf((float)damage + level * 2.0f));
            } else if (this instanceof ThunderstormSpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(level, 10.0f)));
            } else {
                List<TagKey<EntityType<?>>> applyList = Arrays.asList(EntityTagGenerator.MAGIC, EntityTagGenerator.MACHINE, EntityTagGenerator.FLESH);
                float damage = (float)((double)this.baseSpellPower + AOMUtil.getRealDamage((LivingEntity)player, applyList));
                cir.setReturnValue((Object)Float.valueOf(damage + level * 2.0f));
            }
        }
    }

    @Inject(method={"getEntityPowerMultiplier"}, at={@At(value="HEAD")}, cancellable=true)
    public void getEntityPowerMultiplier(LivingEntity entity, CallbackInfoReturnable<Float> cir) {
        float base = (float)ServerConfigs.getSpellConfig((AbstractSpell)((AbstractSpell)this)).powerMultiplier();
        if (entity == null) {
            cir.setReturnValue((Object)Float.valueOf(base));
        } else {
            float entitySpellPowerModifier = (float)entity.m_21133_((Attribute)AttributeRegistry.SPELL_POWER.get());
            double entitySchoolPowerModifier = this.getSchoolType().getPowerFor(entity);
            float power = (float)((double)(base * entitySpellPowerModifier) * entitySchoolPowerModifier);
            if (this instanceof ThunderstormSpell) {
                cir.setReturnValue((Object)Float.valueOf(Math.min(10.0f, power)));
            }
        }
    }
}

