/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.mixin.ironspell;

import com.kurome.ageofmythology.bettermorph.api.IAnimation;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;

@Mixin(value={AbstractSpellCastingMob.class}, remap=false)
public abstract class AbstractSpellCastingMobMixin
implements IAnimation {
    @Unique
    AbstractSpell animationSpell = SpellRegistry.none();
    @Unique
    AbstractSpell animationInstantSpell = SpellRegistry.none();
    @Unique
    AbstractSpell lastAnimationSpell = SpellRegistry.none();
    @Unique
    boolean animationTrigger = false;
    @Unique
    private final AnimationController animationLongHook = new AnimationController((GeoAnimatable)((AbstractSpellCastingMob)this), "animation_long_hook", 0, this::morphLongPredicate);
    @Unique
    private final AnimationController animationInstantHook = new AnimationController((GeoAnimatable)((AbstractSpellCastingMob)this), "animation_instant_hook", 0, this::morphInstantPredicate);
    @Unique
    private final AnimationController animationOtherHook = new AnimationController((GeoAnimatable)((AbstractSpellCastingMob)this), "animation_other_hook", 0, this::morphOtherPredicate);

    private PlayState morphInstantPredicate(AnimationState event) {
        AnimationController controller = event.getController();
        if (this.animationInstantSpell != SpellRegistry.none() && controller.getAnimationState() == AnimationController.State.STOPPED) {
            this.animationInstantSpell.getCastStartAnimation().getForMob().ifPresent(animation -> {
                controller.forceAnimationReset();
                controller.setAnimation(animation);
            });
            this.animationInstantSpell = SpellRegistry.none();
        }
        return PlayState.CONTINUE;
    }

    private PlayState morphLongPredicate(AnimationState event) {
        AnimationController controller = event.getController();
        if (!(controller.getAnimationState() != AnimationController.State.STOPPED || this.animationTrigger && this.animationSpell != null && this.animationSpell.getCastType() == CastType.LONG)) {
            return PlayState.STOP;
        }
        if (this.animationTrigger) {
            if (controller.getAnimationState() == AnimationController.State.STOPPED) {
                this.animationSpell.getCastStartAnimation().getForMob().ifPresent(animation -> {
                    controller.forceAnimationReset();
                    controller.setAnimation(animation);
                });
                this.lastAnimationSpell = this.animationSpell;
            }
        } else if (this.lastAnimationSpell.getCastType() == CastType.LONG) {
            this.lastAnimationSpell.getCastFinishAnimation().getForMob().ifPresent(animation -> {
                controller.forceAnimationReset();
                controller.setAnimation(animation);
            });
            this.lastAnimationSpell = SpellRegistry.none();
        }
        return PlayState.CONTINUE;
    }

    private PlayState morphOtherPredicate(AnimationState event) {
        AnimationController controller = event.getController();
        if (this.animationTrigger && this.animationSpell != SpellRegistry.none() && controller.getAnimationState() == AnimationController.State.STOPPED) {
            if (this.animationSpell.getCastType() == CastType.CONTINUOUS) {
                this.animationSpell.getCastStartAnimation().getForMob().ifPresent(animation -> {
                    controller.forceAnimationReset();
                    controller.setAnimation(animation);
                });
            }
            return PlayState.CONTINUE;
        }
        if (this.animationTrigger) {
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Inject(method={"registerControllers"}, at={@At(value="HEAD")})
    public void registerAnimationHook(AnimatableManager.ControllerRegistrar controllerRegistrar, CallbackInfo ci) {
        controllerRegistrar.add(new AnimationController[]{this.animationLongHook});
        controllerRegistrar.add(new AnimationController[]{this.animationInstantHook});
        controllerRegistrar.add(new AnimationController[]{this.animationOtherHook});
    }

    @Inject(method={"isAnimating"}, at={@At(value="HEAD")}, cancellable=true)
    public void isAnimating(CallbackInfoReturnable<Boolean> cir) {
        if (this.animationLongHook.getAnimationState() != AnimationController.State.STOPPED || this.animationInstantHook.getAnimationState() != AnimationController.State.STOPPED || this.animationOtherHook.getAnimationState() != AnimationController.State.STOPPED) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    @Unique
    public void setAnimation(AbstractSpell spell) {
        if (spell.getCastType() == CastType.LONG) {
            this.animationSpell = spell;
        } else if (spell.getCastType() == CastType.INSTANT) {
            this.animationInstantSpell = spell;
        } else {
            this.animationSpell = spell;
        }
        this.animationTrigger = true;
    }

    @Override
    @Unique
    public void resetAnimation() {
        this.animationTrigger = false;
        this.animationSpell = SpellRegistry.none();
        this.animationInstantSpell = SpellRegistry.none();
    }
}

