/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.mixin.bettermorph.twilightforest;

import com.kurome.ageofmythology.bettermorph.api.IAnimation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import twilightforest.entity.boss.Naga;
import twilightforest.entity.boss.NagaSegment;

@Mixin(value={Naga.class}, remap=false)
public abstract class NagaMixin
extends Monster
implements IAnimation {
    @Final
    @Shadow
    private NagaSegment[] bodySegments;

    protected NagaMixin(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    @Override
    @Unique
    public void moveSegments(Player player) {
        for (int i = 0; i < this.bodySegments.length; ++i) {
            this.check(player, this.bodySegments[i], i);
            Player leader = i == 0 ? player : this.bodySegments[i - 1];
            double followX = leader.m_20185_();
            double followY = leader.m_20186_();
            double followZ = leader.m_20189_();
            float angle = (leader.m_146908_() + 180.0f) * (float)Math.PI / 180.0f;
            double straightenForce = 0.05 + 1.0 / (double)(i + 1) * 0.5;
            if (player.m_21224_()) {
                straightenForce = 0.0;
            }
            double idealX = (double)(-Mth.m_14031_((float)angle)) * straightenForce;
            double idealZ = (double)Mth.m_14089_((float)angle) * straightenForce;
            double groundY = this.bodySegments[i].m_5830_() ? followY + 2.0 : followY;
            double idealY = (groundY - followY) * straightenForce;
            Vec3 diff = new Vec3(this.bodySegments[i].m_20185_() - followX, this.bodySegments[i].m_20186_() - followY, this.bodySegments[i].m_20189_() - followZ);
            diff = diff.m_82541_();
            diff = diff.m_82520_(idealX, idealY, idealZ).m_82541_();
            double f = 2.0;
            double destX = followX + f * diff.m_7096_();
            double destY = followY + f * diff.m_7098_();
            double destZ = followZ + f * diff.m_7094_();
            this.bodySegments[i].m_6034_(destX, destY, destZ);
            double distance = Mth.m_14116_((float)((float)(diff.m_7096_() * diff.m_7096_() + diff.m_7094_() * diff.m_7094_())));
            this.bodySegments[i].m_19915_((float)(Math.atan2(diff.m_7094_(), diff.m_7096_()) * 180.0 / Math.PI) + 90.0f, -((float)(Math.atan2(diff.m_7098_(), distance) * 180.0 / Math.PI)));
        }
    }

    @Unique
    private void check(Player player, NagaSegment segment, int i) {
        segment.activate();
        Vec3 playerPos = player.m_20182_();
        Vec3 segmentPos = segment.m_20182_();
        if (playerPos.m_82554_(segmentPos) > 100.0) {
            segment.m_7678_(playerPos.f_82479_ + 0.1 * (double)i, playerPos.f_82480_ + 0.5, playerPos.f_82481_ + 0.1 * (double)i, this.m_217043_().m_188501_() * 360.0f, 0.0f);
        }
    }
}

