/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.mixin;

import com.github.alexthe666.iceandfire.world.IafWorldData;
import com.kurome.ageofmythology.AOMConfig;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IafWorldData.class}, remap=false)
public class IafWorldDataMixin {
    @Shadow
    private static Map<IafWorldData.FeatureType, List<Pair<String, BlockPos>>> LAST_GENERATED;

    @Inject(method={"load"}, at={@At(value="HEAD")}, cancellable=true)
    public void load(CompoundTag tag, CallbackInfoReturnable<IafWorldData> cir) {
        if (AOMConfig.enable_iaf_optimization) {
            IafWorldData.FeatureType[] types;
            for (IafWorldData.FeatureType type : types = IafWorldData.FeatureType.values()) {
                ListTag list = tag.m_128437_(type.toString(), 10);
                int size = Math.min(1000, list.size());
                for (int i = 0; i < size; ++i) {
                    CompoundTag entry = list.m_128728_(i);
                    String id = entry.m_128461_("id");
                    BlockPos position = NbtUtils.m_129239_((CompoundTag)entry.m_128469_("position"));
                    LAST_GENERATED.computeIfAbsent(type, key -> new ArrayList()).add(Pair.of((Object)id, (Object)position));
                }
            }
            cir.setReturnValue((Object)((IafWorldData)this));
        }
    }
}

