/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.item.travel;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.capability.PlayerDataCapability;
import com.kurome.ageofmythology.config.AOMUUIDConfig;
import com.kurome.ageofmythology.config.CurioUtils;
import com.kurome.ageofmythology.config.ability_config.TravelAbility;
import com.kurome.ageofmythology.init.AOMItems;
import com.kurome.ageofmythology.item.AOMSkullItem;
import com.kurome.ageofmythology.item.AOMSkullProps;
import com.kurome.ageofmythology.utils.ClientTextUtil;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class TravelSkullItem
extends AOMSkullItem {
    public RecordDimension recordDimension;

    public TravelSkullItem(Block floorBlock, Block wallBlock, Item.Properties properties, AOMSkullProps props, RecordDimension dimension) {
        super(floorBlock, wallBlock, properties, props);
        this.recordDimension = dimension;
    }

    @Override
    public void curioTick(LivingEntity entity, ItemStack stack) {
        super.curioTick(entity, stack);
        entity.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
            if (this.recordDimension == RecordDimension.TRAVEL_CORE) {
                Player player;
                if (entity instanceof Player && this.isActivatedTravelCore(player = (Player)entity)) {
                    this.modifyAttribute(entity, Attributes.f_22276_, 50.0, this.skullProps.skullName + "_max_health");
                    this.modifyAttribute(entity, Attributes.f_22281_, 20.0, this.skullProps.skullName + "_attack_damage");
                }
            } else {
                long visitCount = data.getVisitBiomes().stream().filter(biome -> ((String)TravelAbility.unWrapBiomeKey(biome).getFirst()).equals(this.recordDimension.dimension)).count();
                int multiply = 1;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (CurioUtils.isEquipSkullCurio(entity, (Item)AOMItems.AGEOFMYTHOLOGY_TRAVEL_CORE_ITEM.get()) && this.isActivatedTravelCore(player)) {
                        multiply = 2;
                    }
                }
                this.modifyAttribute(entity, Attributes.f_22276_, this.recordDimension.maxHealth * (double)visitCount * (double)multiply, this.skullProps.skullName + "_max_health");
                this.modifyAttribute(entity, Attributes.f_22281_, this.recordDimension.attack * (double)visitCount * (double)multiply, this.skullProps.skullName + "_attack_damage");
            }
        });
    }

    @Override
    public void onUnequip(LivingEntity entity, ItemStack stack) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        this.removeAttribute(entity, Attributes.f_22276_);
        this.removeAttribute(entity, Attributes.f_22281_);
    }

    private void removeAttribute(LivingEntity entity, Attribute attribute) {
        AttributeModifier modify;
        UUID uuid = AOMUUIDConfig.getUUID(this.skullProps.skullName);
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null && (modify = instance.m_22111_(uuid)) != null) {
            instance.m_22120_(uuid);
        }
    }

    private void modifyAttribute(LivingEntity entity, Attribute attribute, Double value, String name) {
        UUID uuid = AOMUUIDConfig.getUUID(this.skullProps.skullName);
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            AttributeModifier modify = instance.m_22111_(uuid);
            if (modify != null) {
                instance.m_22120_(uuid);
            }
            AttributeModifier attr = new AttributeModifier(uuid, name, value.doubleValue(), AttributeModifier.Operation.ADDITION);
            instance.m_22125_(attr);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        if (this.allowShiftToolTip() && ClientTextUtil.hasControlDown()) {
            this.shiftTooltip(stack, world, tooltipList, flags);
        } else if (this.recordDimension == RecordDimension.TRAVEL_CORE) {
            Player player = AgeOfMythologyMod.PROXY.getClientPlayer();
            if (player != null) {
                tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.travel_core.status", (Object[])new Object[]{this.isActivatedTravelCore(player) ? Component.m_237115_((String)"ageofmythology.special.travel_core.status.success").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"ageofmythology.special.travel_core.status.idle").m_130940_(ChatFormatting.GRAY)}));
            }
            tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.special.travel_core.desc"));
            tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.special.travel_core.desc2"));
            tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.special.travel_core.desc3"));
        } else {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.travelskull.desc", (Object[])new Object[]{this.recordDimension.maxHealth, this.recordDimension.attack}).m_130940_(ChatFormatting.GOLD));
        }
        if (this.allowShiftToolTip() && !ClientTextUtil.hasControlDown()) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.tooltip.press_button_to_more_info", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.tooltip.shift")}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public boolean allowShiftToolTip() {
        return true;
    }

    @Override
    public void shiftTooltip(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        Player owner = AgeOfMythologyMod.PROXY.getClientPlayer();
        if (owner != null) {
            if (this.recordDimension == RecordDimension.TRAVEL_CORE) {
                this.travelInfo(owner).forEach((dimension, count) -> this.getRecordDimension((String)dimension).ifPresent(record -> {
                    int maxCount = record.activeCount;
                    tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.travel_core.more_info", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.skill.travel.%s".formatted(dimension)), Component.m_237115_((String)String.valueOf(count)), Component.m_237115_((String)String.valueOf(maxCount))}).m_130940_(count >= maxCount ? ChatFormatting.WHITE : ChatFormatting.GRAY));
                }));
            } else {
                owner.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                    Set<String> set = data.getVisitBiomes();
                    set.forEach(biome -> {
                        Pair<String, String> pair = TravelAbility.unWrapBiomeKey(biome);
                        if (((String)pair.getFirst()).equals(this.recordDimension.dimension)) {
                            tooltipList.add((Component)Component.m_237115_((String)((String)pair.getSecond())));
                        }
                    });
                });
            }
        }
    }

    private boolean isActivatedTravelCore(Player player) {
        HashMap<String, Integer> countMap = this.travelInfo(player);
        return this.checkActiveDimension(countMap, RecordDimension.OVERWORLD) && this.checkActiveDimension(countMap, RecordDimension.THE_NETHER) && this.checkActiveDimension(countMap, RecordDimension.THE_END) && this.checkActiveDimension(countMap, RecordDimension.TWILIGHT_FOREST) && this.checkActiveDimension(countMap, RecordDimension.OTHERSIDE) && this.checkActiveDimension(countMap, RecordDimension.LOSTCITY) && this.checkActiveDimension(countMap, RecordDimension.the_aether);
    }

    private boolean checkActiveDimension(HashMap<String, Integer> travelInfo, RecordDimension dimension) {
        return travelInfo.get(dimension.dimension) >= dimension.activeCount;
    }

    private HashMap<String, Integer> travelInfo(Player player) {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        Arrays.stream(RecordDimension.values()).filter(dimension -> !dimension.filter).toList().forEach(record -> {
            if (record != RecordDimension.TRAVEL_CORE) {
                countMap.put(record.dimension, 0);
            }
        });
        player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
            Set<String> biomesSet = data.getVisitBiomes();
            biomesSet.forEach(biome -> {
                Pair<String, String> pair = TravelAbility.unWrapBiomeKey(biome);
                String dimension = (String)pair.getFirst();
                if (countMap.containsKey(dimension)) {
                    countMap.put(dimension, (Integer)countMap.get(dimension) + 1);
                } else {
                    countMap.put(dimension, 1);
                }
            });
        });
        return countMap;
    }

    private Optional<RecordDimension> getRecordDimension(String dimension) {
        return Arrays.stream(RecordDimension.values()).filter(recode -> recode.dimension == dimension).findFirst();
    }

    public static enum RecordDimension {
        OVERWORLD("overworld", 2.0, 1.0, 10),
        the_aether("the_aether", 4.0, 2.0, 3),
        dyedream_world("dyedream_world", 4.0, 2.0, 2, true),
        lamp_shadow_world("lamp_shadow_world", 4.0, 2.0, 2, true),
        wind_journey_world("wind_journey_world", 4.0, 2.0, 2, true),
        THE_NETHER("the_nether", 8.0, 4.0, 3),
        THE_END("the_end", 8.0, 4.0, 3),
        TWILIGHT_FOREST("twilight_forest", 4.0, 2.0, 8),
        OTHERSIDE("otherside", 8.0, 4.0, 2),
        LOSTCITY("lostcity", 8.0, 4.0, 10),
        TRAVEL_CORE("travel_core", 1.0, 1.0, 0);

        public final String dimension;
        public final double maxHealth;
        public final double attack;
        public final int activeCount;
        public final boolean filter;

        private RecordDimension(String dimension, double maxHealth, double attack, int activeCount) {
            this.dimension = dimension;
            this.maxHealth = maxHealth;
            this.attack = attack;
            this.activeCount = activeCount;
            this.filter = false;
        }

        private RecordDimension(String dimension, double maxHealth, double attack, int activeCount, boolean filter) {
            this.dimension = dimension;
            this.maxHealth = maxHealth;
            this.attack = attack;
            this.activeCount = activeCount;
            this.filter = filter;
        }
    }
}

