/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.item.magic;

import com.Polarice3.Goety.common.items.ModItems;
import com.kurome.ageofmythology.config.AOMRarityConfig;
import com.kurome.ageofmythology.config.CurioUtils;
import com.kurome.ageofmythology.init.AOMAttributes;
import com.kurome.ageofmythology.item.AOMSkullItem;
import com.kurome.ageofmythology.item.AOMSkullProps;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ManaSurgeCoreItem
extends AOMSkullItem {
    public ManaSurgeCoreItem(Block floorBlock, Block wallBlock, Item.Properties properties, AOMSkullProps props) {
        super(floorBlock, wallBlock, properties.m_41497_(AOMRarityConfig.EPIC), props);
    }

    @Override
    public void curioTick(LivingEntity entity, ItemStack stack) {
        super.curioTick(entity, stack);
        double level = 0.0;
        for (MagicMaterial material : MagicMaterial.values()) {
            level += (double)CurioUtils.getEquipCurioCount(entity, material.item);
        }
        this.modifyAttribute(entity, (Attribute)AOMAttributes.ABILITY_LEVEL.get(), level, AttributeModifier.Operation.ADDITION);
    }

    @Override
    public void onUnequip(LivingEntity entity, ItemStack stack) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        this.removeAttribute(entity, (Attribute)AOMAttributes.ABILITY_LEVEL.get());
    }

    private void removeAttribute(LivingEntity entity, Attribute attribute) {
        AttributeModifier modify;
        UUID uuid = this.getUUID();
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null && (modify = instance.m_22111_(uuid)) != null) {
            instance.m_22120_(uuid);
        }
    }

    private void modifyAttribute(LivingEntity entity, Attribute attribute, Double value, AttributeModifier.Operation operation) {
        UUID uuid = this.getUUID();
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            AttributeModifier modify = instance.m_22111_(uuid);
            if (modify != null) {
                instance.m_22120_(uuid);
            }
            AttributeModifier attr = new AttributeModifier(uuid, this.skullProps.skullName, value.doubleValue(), operation);
            instance.m_22125_(attr);
        }
    }

    @Override
    public void normalTooltip(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.special.mana_surge_core.desc"));
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltipList, flags);
    }

    public static enum MagicMaterial {
        ECTOPLASM((Item)ModItems.ECTOPLASM.get(), 0.1),
        MAGIC_EMERALD((Item)ModItems.MAGIC_EMERALD.get(), 0.2),
        TOTEM_OF_ROOTS((Item)ModItems.TOTEM_OF_ROOTS.get(), 0.2),
        TOTEM_OF_SOULS((Item)ModItems.TOTEM_OF_SOULS.get(), 0.3),
        INK_COMMON((Item)ItemRegistry.INK_COMMON.get(), 0.05),
        INK_UNCOMMON((Item)ItemRegistry.INK_UNCOMMON.get(), 0.1),
        INK_RARE((Item)ItemRegistry.INK_RARE.get(), 0.15),
        INK_EPIC((Item)ItemRegistry.INK_EPIC.get(), 0.2),
        INK_LEGENDARY((Item)ItemRegistry.INK_LEGENDARY.get(), 0.3),
        ARCANE_ESSENCE((Item)ItemRegistry.ARCANE_ESSENCE.get(), 0.1);

        public final Item item;
        public final double damage;

        private MagicMaterial(Item item, double damage) {
            this.item = item;
            this.damage = damage;
        }
    }
}

