/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.item.machine;

import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.config.CurioUtils;
import com.kurome.ageofmythology.init.AOMAttributes;
import com.kurome.ageofmythology.item.AOMSkullItem;
import com.kurome.ageofmythology.item.AOMSkullProps;
import com.simibubi.create.AllBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class MachineEnergyCoreItem
extends AOMSkullItem {
    private final int core_level;
    private static final UUID MACHINE_DAMAGE_BONUS_UUID = UUID.fromString("0a7c4ac2-69ba-4d52-8ae0-2083b7ff1664");
    private static final String MACHINE_DAMAGE_BONUS_NAME = "MACHINE_DAMAGE_BONUS_NAME";

    public MachineEnergyCoreItem(Block floorBlock, Block wallBlock, Item.Properties properties, AOMSkullProps props, int core_level) {
        super(floorBlock, wallBlock, properties, props);
        this.core_level = core_level;
    }

    @Override
    public void curioTick(LivingEntity entity, ItemStack stack) {
        super.curioTick(entity, stack);
        double bonus = 0.0;
        List<Material> list = Arrays.stream(Material.values()).filter(material -> material.require_level <= this.core_level).toList();
        for (Material material2 : list) {
            if (!CurioUtils.isEquipSkullCurio(entity, material2.item)) continue;
            if (material2.item == AllBlocks.LARGE_COGWHEEL.m_5456_()) {
                bonus += (double)CurioUtils.getEquipCurioCount(entity, AllBlocks.HAND_CRANK.m_5456_()) * material2.bonus;
            }
            if (material2.item == AllBlocks.WATER_WHEEL.m_5456_()) {
                bonus += (double)CurioUtils.getEquipCurioCount(entity, Items.f_42447_) * material2.bonus;
            }
            if (material2.item == AllBlocks.LARGE_WATER_WHEEL.m_5456_()) {
                bonus += (double)CurioUtils.getEquipCurioCount(entity, Items.f_42447_) * material2.bonus;
            }
            if (material2.item == AllBlocks.WINDMILL_BEARING.m_5456_()) {
                bonus += (double)CurioUtils.getEquipCurioCount(entity, AllBlocks.SAIL.m_5456_()) * material2.bonus;
            }
            if (material2.item != AllBlocks.STEAM_ENGINE.m_5456_()) continue;
            bonus += (double)CurioUtils.getEquipCurioCount(entity, AllBlocks.BLAZE_BURNER.m_5456_()) * material2.bonus;
        }
        AOMUtil.modifyAttribute(entity, (Attribute)AOMAttributes.MACHINE_DAMAGE.get(), MACHINE_DAMAGE_BONUS_UUID, MACHINE_DAMAGE_BONUS_NAME, bonus, AttributeModifier.Operation.ADDITION);
    }

    @Override
    public void onUnequip(LivingEntity entity, ItemStack stack) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        AOMUtil.removeAttribute(entity, (Attribute)AOMAttributes.MACHINE_DAMAGE.get(), MACHINE_DAMAGE_BONUS_UUID);
    }

    @Override
    public void normalTooltip(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.machine.energy_core.core.desc", (Object[])new Object[]{MachineEnergyCoreItem.yellow_component(MachineEnergyCoreItem.stringConvert(this.core_level))}));
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.machine.energy_core.level.desc", (Object[])new Object[]{MachineEnergyCoreItem.yellow_component(MachineEnergyCoreItem.stringConvert(1))}));
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.machine.energy_core.hand_crank.desc", (Object[])new Object[]{MachineEnergyCoreItem.yellow_component(Material.LARGE_COGWHEEL.bonus), MachineEnergyCoreItem.yellow_component(Material.LARGE_COGWHEEL.require_level)}));
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.machine.energy_core.water_wheel.desc", (Object[])new Object[]{MachineEnergyCoreItem.yellow_component(Material.WATER_WHEEL.bonus), MachineEnergyCoreItem.yellow_component(Material.WATER_WHEEL.require_level)}));
        tooltipList.add((Component)Component.m_237119_());
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.machine.energy_core.level.desc", (Object[])new Object[]{MachineEnergyCoreItem.yellow_component(MachineEnergyCoreItem.stringConvert(2))}));
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.machine.energy_core.large_water_wheel.desc", (Object[])new Object[]{MachineEnergyCoreItem.yellow_component(Material.LARGE_WATER_WHEEL.bonus), MachineEnergyCoreItem.yellow_component(Material.LARGE_WATER_WHEEL.require_level)}));
        tooltipList.add((Component)Component.m_237119_());
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.machine.energy_core.level.desc", (Object[])new Object[]{MachineEnergyCoreItem.yellow_component(MachineEnergyCoreItem.stringConvert(3))}));
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.machine.energy_core.windmill_bearing.desc", (Object[])new Object[]{MachineEnergyCoreItem.yellow_component(Material.WINDMILL_BEARING.bonus), MachineEnergyCoreItem.yellow_component(Material.WINDMILL_BEARING.require_level)}));
        tooltipList.add((Component)Component.m_237119_());
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.machine.energy_core.level.desc", (Object[])new Object[]{MachineEnergyCoreItem.yellow_component(MachineEnergyCoreItem.stringConvert(4))}));
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.machine.energy_core.stem_engine.desc", (Object[])new Object[]{MachineEnergyCoreItem.yellow_component(Material.STEAM_ENGINE.bonus), MachineEnergyCoreItem.yellow_component(Material.STEAM_ENGINE.require_level)}));
        this.appendSpecialEffectsHoverText(stack, world, tooltipList, flags);
        this.appendEffectsHoverText(stack, world, tooltipList, flags);
    }

    private static String stringConvert(int level) {
        return String.valueOf(level);
    }

    private static Component yellow_component(int desc) {
        return MachineEnergyCoreItem.yellow_component(String.valueOf(desc));
    }

    private static Component yellow_component(double desc) {
        return MachineEnergyCoreItem.yellow_component(String.valueOf(desc));
    }

    private static Component yellow_component(String desc) {
        return Component.m_237115_((String)desc).m_130940_(ChatFormatting.YELLOW);
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltipList, flags);
    }

    public static enum Material {
        LARGE_COGWHEEL(AllBlocks.LARGE_COGWHEEL.m_5456_(), 1.0, 1),
        WATER_WHEEL(AllBlocks.WATER_WHEEL.m_5456_(), 1.25, 1),
        LARGE_WATER_WHEEL(AllBlocks.LARGE_WATER_WHEEL.m_5456_(), 1.5, 2),
        WINDMILL_BEARING(AllBlocks.WINDMILL_BEARING.m_5456_(), 3.0, 3),
        STEAM_ENGINE(AllBlocks.STEAM_ENGINE.m_5456_(), 3.75, 4);

        public final Item item;
        public final double bonus;
        public final int require_level;

        private Material(Item item, double bonus, int require_level) {
            this.item = item;
            this.bonus = bonus;
            this.require_level = require_level;
        }
    }
}

