/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.item.general;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.net.Messages;
import com.kurome.ageofmythology.net.general.ClientSyncToolTip;
import java.util.List;
import liushuangwuyin.bettermorph.api.PlayerUnlocks;
import liushuangwuyin.bettermorph.api.variant.IdentityType;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeirdBottleItem
extends Item {
    private static final String MOB_NAME = "MOB_NAME";
    private static final float COLLECT_CHANCE = 0.1f;

    public WeirdBottleItem(Item.Properties properties) {
        super(properties);
    }

    public static String getMobName(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41783_();
        if (nbtCompound == null) {
            return "";
        }
        return nbtCompound.m_128461_(MOB_NAME);
    }

    public static void setMobName(ItemStack stack, @NotNull String mobName) {
        CompoundTag nbtCompound = stack.m_41784_();
        nbtCompound.m_128359_(MOB_NAME, mobName);
    }

    public int m_8105_(ItemStack p_41454_) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.DRINK;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity player) {
        ItemStack bottle;
        if (!player.m_9236_().f_46443_ && (bottle = stack).m_41720_() instanceof WeirdBottleItem) {
            if (player.m_6144_()) {
                WeirdBottleItem.setMobName(bottle, "");
                player.m_213846_((Component)Component.m_237115_((String)"ageofmythology.tooltip.weird_bottle.clear"));
            } else {
                AOMUtil.getEntityType(WeirdBottleItem.getMobName(bottle)).ifPresent(entityType -> {
                    Entity entity = entityType.m_20615_(level);
                    if (entity instanceof LivingEntity && player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        IdentityType type = IdentityType.from((EntityType)entityType, (int)-1);
                        if (type != null) {
                            PlayerUnlocks.unlock((ServerPlayer)serverPlayer, (IdentityType)type);
                            WeirdBottleItem.setMobName(bottle, "");
                            Messages.sendToPlayer(new ClientSyncToolTip(1, (Component)Component.m_237110_((String)"identity.unlock_entity", (Object[])new Object[]{entityType.m_20676_()})), serverPlayer);
                        }
                    }
                });
            }
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!WeirdBottleItem.getMobName(player.m_21120_(hand)).isEmpty()) {
            return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        String mobName = WeirdBottleItem.getMobName(stack);
        tooltip.add((Component)Component.m_237115_((String)(stack.m_41778_() + ".desc")));
        tooltip.add((Component)Component.m_237119_());
        if (mobName.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)(stack.m_41778_() + ".desc.none")));
        } else {
            AOMUtil.getEntityType(mobName).ifPresent(type -> {
                MutableComponent displayName = Component.m_237115_((String)type.m_20675_()).m_130940_(ChatFormatting.YELLOW);
                tooltip.add((Component)Component.m_237110_((String)(stack.m_41778_() + ".desc.exist"), (Object[])new Object[]{displayName}));
            });
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!player.m_9236_().f_46443_) {
            if (target instanceof Enemy || target instanceof EntityDragonBase || target instanceof Player) {
                player.m_213846_((Component)Component.m_237115_((String)"ageofmythology.tooltip.weird_bottle.monster"));
                return super.m_6880_(stack, player, target, hand);
            }
            String mobName = AOMUtil.getMobName((Entity)target);
            MutableComponent displayName = Component.m_237115_((String)target.m_6095_().m_20675_()).m_130940_(ChatFormatting.YELLOW);
            ItemStack bottle = player.m_21205_();
            if (bottle.m_150930_(stack.m_41720_())) {
                if (WeirdBottleItem.getMobName(bottle).isEmpty()) {
                    if (player.m_217043_().m_188501_() <= 0.1f) {
                        WeirdBottleItem.setMobName(bottle, mobName);
                        player.m_213846_((Component)Component.m_237110_((String)"ageofmythology.tooltip.weird_bottle.success", (Object[])new Object[]{displayName}));
                    } else {
                        player.m_213846_((Component)Component.m_237110_((String)"ageofmythology.tooltip.weird_bottle.fail", (Object[])new Object[]{displayName}));
                    }
                    return InteractionResult.SUCCESS;
                }
                player.m_213846_((Component)Component.m_237110_((String)"ageofmythology.tooltip.weird_bottle.exist", (Object[])new Object[]{displayName}));
            }
        }
        return super.m_6880_(stack, player, target, hand);
    }
}

