/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.item.general;

import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.data.tag.EntityTagGenerator;
import com.kurome.ageofmythology.init.AOMItems;
import com.kurome.ageofmythology.init.AOMMobEffect;
import com.kurome.ageofmythology.net.Messages;
import com.kurome.ageofmythology.net.general.ClientSyncToolTip;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BloodBottleItem
extends Item {
    private static final String MOB_NAME = "MOB_NAME";
    private static final String BLOOD_LEVEL = "BLOOD_LEVEL";
    public static final ResourceLocation BLOOD_BOTTLE_STATE = AgeOfMythologyMod.prefix("blood_bottle_state");

    public BloodBottleItem(Item.Properties properties) {
        super(properties);
    }

    public static float getBloodBottleState(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41783_();
        if (nbtCompound != null && nbtCompound.m_128461_(MOB_NAME) != "") {
            return 1.0f;
        }
        return 0.0f;
    }

    public static String getMobName(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41783_();
        if (nbtCompound == null) {
            return "";
        }
        return nbtCompound.m_128461_(MOB_NAME);
    }

    public static void setMobName(ItemStack stack, @NotNull String mobName) {
        CompoundTag nbtCompound = stack.m_41784_();
        nbtCompound.m_128359_(MOB_NAME, mobName);
        Optional<EntityType<?>> entityType = AOMUtil.getEntityType(mobName);
        if (entityType.isPresent()) {
            BloodLevel blood = BloodBottleItem.getBloodLevel(entityType.get());
            nbtCompound.m_128405_(BLOOD_LEVEL, blood.level);
        } else {
            nbtCompound.m_128405_(BLOOD_LEVEL, -1);
        }
    }

    public int m_8105_(ItemStack p_41454_) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.DRINK;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity player) {
        ItemStack bottle;
        if (!player.m_9236_().f_46443_ && (bottle = stack).m_41720_() instanceof BloodBottleItem) {
            if (player.m_6144_()) {
                BloodBottleItem.setMobName(bottle, "");
                player.m_213846_((Component)Component.m_237115_((String)"ageofmythology.tooltip.blood_bottle.clear"));
            } else {
                AOMUtil.getEntityType(BloodBottleItem.getMobName(bottle)).ifPresent(entityType -> {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        BloodLevel bloodLevel = BloodBottleItem.getBloodLevel(entityType);
                        BloodBottleItem.setMobName(bottle, "");
                        if (bloodLevel.level <= 2) {
                            Messages.sendToPlayer(new ClientSyncToolTip(1, (Component)Component.m_237115_((String)(((Item)AOMItems.BLOOD_BOTTLE.get()).m_5524_() + ".level_%s.drink".formatted(bloodLevel.level)))), serverPlayer);
                            player.m_7292_(new MobEffectInstance((MobEffect)AOMMobEffect.BLOOD_BATH.get(), bloodLevel.time, bloodLevel.level - 1, true, true));
                        } else {
                            Messages.sendToPlayer(new ClientSyncToolTip(1, (Component)Component.m_237115_((String)(((Item)AOMItems.BLOOD_BOTTLE.get()).m_5524_() + ".level_max.drink"))), serverPlayer);
                            bloodLevel = BloodLevel.LEVEL_MAX;
                            player.m_7292_(new MobEffectInstance((MobEffect)AOMMobEffect.BLOOD_BATH.get(), bloodLevel.time, bloodLevel.level - 1, true, true));
                        }
                    }
                });
            }
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!BloodBottleItem.getMobName(player.m_21120_(hand)).isEmpty()) {
            return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        String mobName = BloodBottleItem.getMobName(stack);
        tooltip.add((Component)Component.m_237115_((String)(stack.m_41778_() + ".desc_0")));
        tooltip.add((Component)Component.m_237115_((String)(stack.m_41778_() + ".desc_1")));
        tooltip.add((Component)Component.m_237115_((String)(stack.m_41778_() + ".desc_2")));
        tooltip.add((Component)Component.m_237119_());
        if (!mobName.isEmpty()) {
            AOMUtil.getEntityType(mobName).ifPresent(type -> {
                BloodLevel blood = BloodBottleItem.getBloodLevel(type);
                MutableComponent bloodLevel = Component.m_237115_((String)(((Item)AOMItems.BLOOD_BOTTLE.get()).m_5524_() + ".level_%s".formatted(blood.level)));
                MutableComponent bloodLevelDesc = Component.m_237115_((String)(((Item)AOMItems.BLOOD_BOTTLE.get()).m_5524_() + ".level_%s.desc".formatted(blood.level)));
                tooltip.add((Component)Component.m_237110_((String)(((Item)AOMItems.BLOOD_BOTTLE.get()).m_5524_() + ".desc"), (Object[])new Object[]{bloodLevel}));
                tooltip.add((Component)bloodLevelDesc);
                if (blood.level > 2) {
                    tooltip.add((Component)Component.m_237119_());
                    tooltip.add((Component)Component.m_237115_((String)(stack.m_41778_() + ".desc_3")));
                }
            });
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!player.m_9236_().f_46443_) {
            if (target.m_21223_() > target.m_21233_() / 2.0f || target.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_1) || target.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_2) || target.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_3) || target.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_4) || target.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_5) || target.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_6)) {
                player.m_213846_((Component)Component.m_237115_((String)"ageofmythology.tooltip.blood_bottle.fail"));
                return super.m_6880_(stack, player, target, hand);
            }
            String mobName = AOMUtil.getMobName((Entity)target);
            MutableComponent displayName = Component.m_237115_((String)target.m_6095_().m_20675_()).m_130940_(ChatFormatting.YELLOW);
            ItemStack bottle = player.m_21205_();
            if (bottle.m_150930_(stack.m_41720_())) {
                if (BloodBottleItem.getMobName(bottle).isEmpty()) {
                    BloodBottleItem.setMobName(bottle, mobName);
                    player.m_213846_((Component)Component.m_237110_((String)"ageofmythology.tooltip.blood_bottle.success", (Object[])new Object[]{displayName}));
                    target.m_6469_(player.m_9236_().m_269111_().m_269075_(player), 1.0f);
                    return InteractionResult.SUCCESS;
                }
                player.m_213846_((Component)Component.m_237115_((String)"ageofmythology.tooltip.blood_bottle.exist"));
            }
        }
        return super.m_6880_(stack, player, target, hand);
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41784_();
        if (compoundTag.m_128441_(MOB_NAME) && !compoundTag.m_128461_(MOB_NAME).isEmpty()) {
            AtomicReference<EntityType> entityType = new AtomicReference<EntityType>(EntityType.f_217014_);
            AOMUtil.getEntityType(compoundTag.m_128461_(MOB_NAME)).ifPresent(entityType::set);
            return Component.m_237110_((String)(this.m_5524_() + ".full"), (Object[])new Object[]{entityType.get().m_20676_()});
        }
        return super.m_7626_(stack);
    }

    public static BloodLevel getBloodLevel(EntityType<?> entityType) {
        if (entityType.equals(IafEntityRegistry.CYCLOPS.get()) || entityType.equals(IafEntityRegistry.GORGON.get())) {
            return BloodLevel.LEVEL_2;
        }
        if (entityType.equals(ModEntities.ANCIENT_REMNANT.get())) {
            return BloodLevel.LEVEL_5;
        }
        if (entityType.equals(ACEntityRegistry.LUXTRUCTOSAURUS.get()) || entityType.equals(ACEntityRegistry.HULLBREAKER.get())) {
            return BloodLevel.LEVEL_5;
        }
        if (entityType.m_204039_(EntityTagGenerator.BLOOD_LEVEL_2)) {
            return BloodLevel.LEVEL_2;
        }
        if (entityType.m_204039_(EntityTagGenerator.BLOOD_LEVEL_3)) {
            return BloodLevel.LEVEL_3;
        }
        if (entityType.m_204039_(EntityTagGenerator.BLOOD_LEVEL_4)) {
            return BloodLevel.LEVEL_4;
        }
        if (entityType.m_204039_(EntityTagGenerator.BLOOD_LEVEL_5)) {
            return BloodLevel.LEVEL_5;
        }
        if (entityType.m_204039_(EntityTagGenerator.BLOOD_LEVEL_6)) {
            return BloodLevel.LEVEL_6;
        }
        return BloodLevel.LEVEL_1;
    }

    public static enum BloodLevel {
        LEVEL_1(1, 400, 0.05),
        LEVEL_2(2, 400, 0.1),
        LEVEL_3(3, 600, 0.15),
        LEVEL_4(4, 600, 0.2),
        LEVEL_5(5, 1200, 0.2),
        LEVEL_6(6, 1200, 0.25),
        LEVEL_MAX(7, 1200, 1.0);

        public final int level;
        public final int time;
        public final double damage;

        private BloodLevel(int level, int time, double damage) {
            this.level = level;
            this.time = time;
            this.damage = damage;
        }
    }
}

