/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.item.foodie;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.capability.PlayerDataCapability;
import com.kurome.ageofmythology.config.AOMRarityConfig;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.config.CurioUtils;
import com.kurome.ageofmythology.item.AOMSkullItem;
import com.kurome.ageofmythology.item.AOMSkullProps;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class GummyItem
extends AOMSkullItem {
    public static double GUMMY_BONUS = 1.2;
    public static double GUMMY_BONUS_PRO = 1.3;
    public static int ACTIVE_COUNT = 20;

    public GummyItem(Block floorBlock, Block wallBlock, Item.Properties properties, AOMSkullProps props) {
        super(floorBlock, wallBlock, properties.m_41497_(AOMRarityConfig.LEGENDARY), props);
    }

    @Override
    public boolean attributeActive(@Nullable LivingEntity entity, ItemStack stack) {
        if (!(entity instanceof Player)) {
            return true;
        }
        return GummyItem.gummyActiveState(entity, ACTIVE_COUNT);
    }

    @Override
    public boolean allowShiftToolTip() {
        return true;
    }

    @Override
    public void shiftTooltip(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        int count = GummyItem.gummyActiveCount((LivingEntity)AgeOfMythologyMod.PROXY.getClientPlayer());
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.foodie.gummy.active.count", (Object[])new Object[]{Component.m_237115_((String)String.valueOf(count)), Component.m_237115_((String)String.valueOf(ACTIVE_COUNT))}).m_130940_(count >= ACTIVE_COUNT ? ChatFormatting.WHITE : ChatFormatting.GRAY));
    }

    @Override
    public void normalTooltip(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.special.foodie.gummy.tooltip"));
        tooltipList.add((Component)Component.m_237119_());
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.skull.status", (Object[])new Object[]{GummyItem.gummyActiveState((LivingEntity)AgeOfMythologyMod.PROXY.getClientPlayer(), ACTIVE_COUNT) ? Component.m_237115_((String)"ageofmythology.special.skull.status.success").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"ageofmythology.special.skull.status.idle").m_130940_(ChatFormatting.GRAY)}));
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.foodie.gummy.desc", (Object[])new Object[]{Component.m_237115_((String)String.valueOf(GummyItem.getRealGummyBonus((LivingEntity)AgeOfMythologyMod.PROXY.getClientPlayer()))).m_130940_(ChatFormatting.GREEN)}));
        super.normalTooltip(stack, world, tooltipList, flags);
    }

    public static boolean gummyActiveState(LivingEntity entity, int count) {
        return GummyItem.gummyActiveCount(entity) >= count;
    }

    public static int gummyActiveCount(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return 0;
        }
        Player player = (Player)entity;
        AtomicInteger count = new AtomicInteger(0);
        player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
            Set<String> set = data.getFoodList();
            for (String id : set) {
                Item food = AOMUtil.getItemDefault(id);
                FoodProperties foodProperties = food.m_41473_();
                float saturationLevel = 0.0f;
                if (foodProperties != null) {
                    saturationLevel = (float)foodProperties.m_38744_() * foodProperties.m_38745_() * 2.0f;
                }
                if (!(saturationLevel >= 20.0f)) continue;
                count.getAndIncrement();
            }
        });
        return count.get();
    }

    public static double getRealGummyBonus(LivingEntity entity) {
        return CurioUtils.isEquipSkullCurio(entity, AOMUtil.getItemDefault("goety_revelation:ascension_hard_candy")) ? GUMMY_BONUS_PRO : GUMMY_BONUS;
    }
}

