/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.item.foodie;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.capability.PlayerDataCapability;
import com.kurome.ageofmythology.capability.api.IPlayerData;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.item.AOMSkullItem;
import com.kurome.ageofmythology.item.AOMSkullProps;
import com.kurome.ageofmythology.item.foodie.GummyItem;
import com.kurome.ageofmythology.utils.ClientTextUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;

public abstract class FoodieItem
extends AOMSkullItem {
    public static Supplier<List<ItemLike>> candyListSupply = () -> Arrays.asList((ItemLike)ACItemRegistry.PURPLE_SODA_BUCKET.get(), (ItemLike)ACItemRegistry.PURPLE_SODA_BOTTLE.get(), (ItemLike)ACItemRegistry.SWEETISH_FISH_RED_BUCKET.get(), (ItemLike)ACItemRegistry.SWEETISH_FISH_GREEN_BUCKET.get(), (ItemLike)ACItemRegistry.SWEETISH_FISH_YELLOW_BUCKET.get(), (ItemLike)ACItemRegistry.SWEETISH_FISH_BLUE_BUCKET.get(), (ItemLike)ACItemRegistry.SWEETISH_FISH_PINK_BUCKET.get(), (ItemLike)ACItemRegistry.SWEETISH_FISH_RED.get(), (ItemLike)ACItemRegistry.SWEETISH_FISH_GREEN.get(), (ItemLike)ACItemRegistry.SWEETISH_FISH_YELLOW.get(), (ItemLike)ACItemRegistry.SWEETISH_FISH_BLUE.get(), (ItemLike)ACItemRegistry.SWEETISH_FISH_PINK.get(), (ItemLike)ACItemRegistry.GELATIN_RED.get(), (ItemLike)ACItemRegistry.GELATIN_GREEN.get(), (ItemLike)ACItemRegistry.GELATIN_YELLOW.get(), (ItemLike)ACItemRegistry.GELATIN_BLUE.get(), (ItemLike)ACItemRegistry.GELATIN_PINK.get(), (ItemLike)ACItemRegistry.HOT_CHOCOLATE_BOTTLE.get(), (ItemLike)ACItemRegistry.VANILLA_ICE_CREAM_SCOOP.get(), (ItemLike)ACItemRegistry.CHOCOLATE_ICE_CREAM_SCOOP.get(), (ItemLike)ACItemRegistry.SWEETBERRY_ICE_CREAM_SCOOP.get(), (ItemLike)ACItemRegistry.SUNDAE.get(), (ItemLike)ACItemRegistry.SHARPENED_CANDY_CANE.get(), (ItemLike)ACItemRegistry.PEPPERMINT_POWDER.get(), (ItemLike)ACItemRegistry.RAINBOUNCE_BOOTS.get(), (ItemLike)ACItemRegistry.GUMBALL_PILE.get(), (ItemLike)ACItemRegistry.SHOT_GUM.get(), (ItemLike)ACItemRegistry.CARAMEL.get(), (ItemLike)ACItemRegistry.CARAMEL_APPLE.get(), (ItemLike)ACItemRegistry.CANDY_CANE_HOOK.get(), (ItemLike)ACItemRegistry.SWEET_TOOTH.get(), (ItemLike)ACItemRegistry.RADIANT_ESSENCE.get(), (ItemLike)ACItemRegistry.SACK_OF_SATING.get(), (ItemLike)ACItemRegistry.SUGAR_STAFF.get(), (ItemLike)ACItemRegistry.GINGERBREAD_CRUMBS.get(), (ItemLike)ACItemRegistry.GINGERBREAD_HELMET.get(), (ItemLike)ACItemRegistry.GINGERBREAD_CHESTPLATE.get(), (ItemLike)ACItemRegistry.GINGERBREAD_LEGGINGS.get(), (ItemLike)ACItemRegistry.GINGERBREAD_BOOTS.get(), (ItemLike)ACItemRegistry.PURPLE_SODA_BOTTLE_ROCKET.get(), (ItemLike)ACItemRegistry.FROSTMINT_SPEAR.get(), (ItemLike)ACItemRegistry.MUSIC_DISC_TASTY_FRAGMENT.get(), (ItemLike)ACItemRegistry.MUSIC_DISC_TASTY.get(), (ItemLike)ACItemRegistry.BIOME_TREAT.get(), (ItemLike)ACBlockRegistry.BLOCK_OF_CHOCOLATE.get(), (ItemLike)ACBlockRegistry.BLOCK_OF_POLISHED_CHOCOLATE.get(), (ItemLike)ACBlockRegistry.BLOCK_OF_CHISELED_CHOCOLATE.get(), (ItemLike)ACBlockRegistry.BLOCK_OF_FROSTED_CHOCOLATE.get(), (ItemLike)ACBlockRegistry.BLOCK_OF_FROSTING.get(), (ItemLike)ACBlockRegistry.BLOCK_OF_VANILLA_FROSTING.get(), (ItemLike)ACBlockRegistry.BLOCK_OF_CHOCOLATE_FROSTING.get(), (ItemLike)ACBlockRegistry.SWEET_PUFF.get(), (ItemLike)ACBlockRegistry.CAKE_LAYER.get(), (ItemLike)ACBlockRegistry.DOUGH_BLOCK.get(), (ItemLike)ACBlockRegistry.COOKIE_BLOCK.get(), (ItemLike)ACBlockRegistry.WAFER_COOKIE_BLOCK.get(), (ItemLike)ACBlockRegistry.WAFER_COOKIE_STAIRS.get(), (ItemLike)ACBlockRegistry.WAFER_COOKIE_SLAB.get(), (ItemLike)ACBlockRegistry.WAFER_COOKIE_WALL.get(), (ItemLike)ACBlockRegistry.LICOROOT.get(), (ItemLike)ACBlockRegistry.LICOROOT_VINE.get(), (ItemLike)ACBlockRegistry.LICOROOT_SPROUT.get(), (ItemLike)ACBlockRegistry.SMALL_PEPPERMINT.get(), (ItemLike)ACBlockRegistry.LARGE_PEPPERMINT.get(), (ItemLike)ACBlockRegistry.VANILLA_ICE_CREAM.get(), (ItemLike)ACBlockRegistry.CHOCOLATE_ICE_CREAM.get(), (ItemLike)ACBlockRegistry.SWEETBERRY_ICE_CREAM.get(), (ItemLike)ACBlockRegistry.SPRINKLES.get(), (ItemLike)ACBlockRegistry.GIANT_SWEETBERRY.get(), (ItemLike)ACBlockRegistry.CANDY_CANE.get(), (ItemLike)ACBlockRegistry.CANDY_CANE_BLOCK.get(), (ItemLike)ACBlockRegistry.CHISELED_CANDY_CANE_BLOCK.get(), (ItemLike)ACBlockRegistry.STRIPPED_CANDY_CANE_BLOCK.get(), (ItemLike)ACBlockRegistry.CANDY_CANE_POLE.get(), (ItemLike)ACBlockRegistry.STRIPPED_CANDY_CANE_POLE.get(), (ItemLike)ACBlockRegistry.LOLLIPOP_BUNCH.get(), (ItemLike)ACBlockRegistry.FROSTMINT.get(), (ItemLike)ACBlockRegistry.SUGAR_GLASS.get(), (ItemLike)ACBlockRegistry.SUNDROP.get(), (ItemLike)ACBlockRegistry.GUMMY_RING_RED.get(), (ItemLike)ACBlockRegistry.GUMMY_RING_GREEN.get(), (ItemLike)ACBlockRegistry.GUMMY_RING_YELLOW.get(), (ItemLike)ACBlockRegistry.GUMMY_RING_BLUE.get(), (ItemLike)ACBlockRegistry.GUMMY_RING_PINK.get(), (ItemLike)ACBlockRegistry.GOBTHUMPER.get(), (ItemLike)ACBlockRegistry.CONVERSION_CRUCIBLE.get(), (ItemLike)ACBlockRegistry.WHITE_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.ORANGE_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.MAGENTA_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.LIGHT_BLUE_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.YELLOW_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.LIME_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.PINK_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.GRAY_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.LIGHT_GRAY_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.CYAN_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.PURPLE_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.BLUE_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.BROWN_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.GREEN_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.RED_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.BLACK_ROCK_CANDY.get(), (ItemLike)ACBlockRegistry.GINGERBREAD_BLOCK.get(), (ItemLike)ACBlockRegistry.GINGERBREAD_STAIRS.get(), (ItemLike)ACBlockRegistry.GINGERBREAD_SLAB.get(), (ItemLike)ACBlockRegistry.GINGERBREAD_WALL.get(), (ItemLike)ACBlockRegistry.GINGERBREAD_DOOR.get(), (ItemLike)ACBlockRegistry.GINGERBARREL.get(), (ItemLike)ACBlockRegistry.FROSTED_GINGERBREAD_BLOCK.get(), (ItemLike)ACBlockRegistry.FROSTED_GINGERBREAD_STAIRS.get(), (ItemLike)ACBlockRegistry.FROSTED_GINGERBREAD_SLAB.get(), (ItemLike)ACBlockRegistry.FROSTED_GINGERBREAD_WALL.get(), (ItemLike)ACBlockRegistry.FROSTED_GINGERBREAD_DOOR.get(), (ItemLike)ACBlockRegistry.GINGERBREAD_BRICKS.get(), (ItemLike)ACBlockRegistry.GINGERBREAD_BRICK_STAIRS.get(), (ItemLike)ACBlockRegistry.GINGERBREAD_BRICK_SLAB.get(), (ItemLike)ACBlockRegistry.GINGERBREAD_BRICK_WALL.get(), (ItemLike)ACBlockRegistry.FROSTED_GINGERBREAD_BRICKS.get(), (ItemLike)ACBlockRegistry.FROSTED_GINGERBREAD_BRICK_STAIRS.get(), (ItemLike)ACBlockRegistry.FROSTED_GINGERBREAD_BRICK_SLAB.get(), (ItemLike)ACBlockRegistry.FROSTED_GINGERBREAD_BRICK_WALL.get(), (ItemLike)ACBlockRegistry.CONFECTION_OVEN.get());

    public FoodieItem(Block floorBlock, Block wallBlock, Item.Properties properties, AOMSkullProps props) {
        super(floorBlock, wallBlock, properties, props);
    }

    abstract double getMaxHealthBonus();

    abstract double getDamageBonus();

    abstract String getFoodieDesc();

    public String getFoodieCount() {
        return "ageofmythology.special.foodie.count.desc";
    }

    public boolean showCountInfo() {
        return false;
    }

    abstract Set<String> getFoodList(IPlayerData var1);

    @Override
    public void curioTick(LivingEntity entity, ItemStack stack) {
        super.curioTick(entity, stack);
        entity.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
            int count = this.getFoodList((IPlayerData)data).size();
            double bonus = GummyItem.getRealGummyBonus(entity);
            AtomicInteger gummyCount = new AtomicInteger(0);
            CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(curiosInventory -> curiosInventory.getStacksHandler("skull").ifPresent(skullInventory -> {
                for (int i = 0; i < skullInventory.getSlots(); ++i) {
                    ItemStack itemStack = skullInventory.getStacks().getStackInSlot(i);
                    if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof GummyItem)) continue;
                    gummyCount.incrementAndGet();
                }
            }));
            AOMUtil.modifyAttribute(entity, Attributes.f_22276_, this.getUUID(), this.skullProps.skullName + "_max_health", this.getMaxHealthBonus() * (double)count * Math.pow(bonus, gummyCount.get()), AttributeModifier.Operation.ADDITION);
            AOMUtil.modifyAttribute(entity, Attributes.f_22281_, this.getUUID(), this.skullProps.skullName + "_attack_damage", this.getDamageBonus() * (double)count * Math.pow(bonus, gummyCount.get()), AttributeModifier.Operation.ADDITION);
        });
    }

    @Override
    public void onUnequip(LivingEntity entity, ItemStack stack) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        AOMUtil.removeAttribute(entity, Attributes.f_22276_, this.getUUID());
        AOMUtil.removeAttribute(entity, Attributes.f_22281_, this.getUUID());
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        if (this.allowShiftToolTip() && ClientTextUtil.hasControlDown()) {
            this.shiftTooltip(stack, world, tooltipList, flags);
        } else {
            tooltipList.add((Component)Component.m_237110_((String)this.getFoodieDesc(), (Object[])new Object[]{Component.m_237115_((String)String.valueOf(this.getMaxHealthBonus())).m_130940_(ChatFormatting.GREEN), Component.m_237115_((String)String.valueOf(this.getDamageBonus())).m_130940_(ChatFormatting.GREEN)}));
        }
        if (this.allowShiftToolTip() && !ClientTextUtil.hasControlDown()) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.tooltip.press_button_to_more_info", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.tooltip.shift")}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public boolean allowShiftToolTip() {
        return true;
    }

    @Override
    public void shiftTooltip(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        Player owner = AgeOfMythologyMod.PROXY.getClientPlayer();
        AtomicInteger eatenCount = new AtomicInteger();
        if (owner != null) {
            owner.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                Set<String> set = this.getFoodList((IPlayerData)data);
                eatenCount.set(set.size());
                set.forEach(food -> tooltipList.add(AOMUtil.getItemDefault(food).m_41466_()));
            });
            if (this.showCountInfo()) {
                tooltipList.add((Component)Component.m_237110_((String)this.getFoodieCount(), (Object[])new Object[]{eatenCount, ForgeRegistries.ITEMS.getValues().stream().filter(Item::m_41472_).count()}));
            }
        }
    }

    public static Set<String> getCoffeeList(Set<String> foodList) {
        return FoodieItem.getModFoodList(foodList, "coffee_delight");
    }

    public static Set<String> getBBQList(Set<String> foodList) {
        return foodList.stream().filter(food -> {
            ResourceLocation foodResource = new ResourceLocation(food);
            return foodResource.m_135827_().equals("alexsdelight") || foodResource.m_135827_().equals("alexsmobs");
        }).collect(Collectors.toSet());
    }

    public static Set<String> getWineList(Set<String> foodList) {
        return FoodieItem.getModFoodList(foodList, "vinery");
    }

    public static Set<String> getMonsterList(Set<String> foodList) {
        return FoodieItem.getModFoodList(foodList, "dungeonsdelight");
    }

    public static Set<String> getImmortalersList(Set<String> foodList) {
        return FoodieItem.getModFoodList(foodList, "immortalers_delight");
    }

    public static Set<String> getNetherFoodList(Set<String> foodList) {
        return FoodieItem.getModFoodList(foodList, "mynethersdelight");
    }

    public static Set<String> getEndFoodList(Set<String> foodList) {
        return FoodieItem.getModFoodList(foodList, "ends_delight");
    }

    public static Set<String> getCandyList(Set<String> foodList) {
        List<Item> list = candyListSupply.get().stream().map(ItemLike::m_5456_).toList();
        String mod = "alexscaves";
        return foodList.stream().filter(food -> {
            ResourceLocation foodResource = new ResourceLocation(food);
            return foodResource.m_135827_().equals(mod) && list.contains(AOMUtil.getItemDefault(food));
        }).collect(Collectors.toSet());
    }

    public static Set<String> getModFoodList(Set<String> foodList, String mod) {
        return foodList.stream().filter(food -> {
            ResourceLocation foodResource = new ResourceLocation(food);
            return foodResource.m_135827_().equals(mod);
        }).collect(Collectors.toSet());
    }
}

