/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.item.foodie;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.capability.PlayerDataCapability;
import com.kurome.ageofmythology.config.AOMRarityConfig;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.config.CurioUtils;
import com.kurome.ageofmythology.init.AOMItems;
import com.kurome.ageofmythology.item.AOMSkullItem;
import com.kurome.ageofmythology.item.AOMSkullProps;
import com.kurome.ageofmythology.utils.ClientTextUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class FoodieExpertItem
extends AOMSkullItem {
    public FoodieExpertItem(Block floorBlock, Block wallBlock, Item.Properties properties, AOMSkullProps props) {
        super(floorBlock, wallBlock, properties.m_41497_(AOMRarityConfig.LEGENDARY), props);
    }

    String getFoodieDesc() {
        return "ageofmythology.special.foodie.expert.desc";
    }

    @Override
    public void curioTick(LivingEntity entity, ItemStack stack) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        entity.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
            Set<String> foodList = data.getFoodList();
            if (entity.m_21023_(MobEffects.f_19614_) && foodList.contains(ExpertFood.bloated_baked_potato.getItemId())) {
                entity.m_21195_(MobEffects.f_19614_);
            }
            if (entity.m_21023_(MobEffects.f_19597_) && foodList.contains(ExpertFood.iced_black_tea.getItemId())) {
                entity.m_21195_(MobEffects.f_19597_);
            }
            if (entity.m_21023_(MobEffects.f_19612_) && foodList.contains(ExpertFood.dog_food.getItemId())) {
                entity.m_21195_(MobEffects.f_19612_);
            }
            if (entity.m_21023_(MobEffects.f_19620_) && foodList.contains(ExpertFood.ghastly_spirits.getItemId())) {
                entity.m_21195_(MobEffects.f_19620_);
            }
            if (entity.m_21023_(MobEffects.f_19604_) && foodList.contains(ExpertFood.blue_tenderloin_steak.getItemId())) {
                entity.m_21195_(MobEffects.f_19604_);
            }
            if (entity.m_21023_(MobEffects.f_19610_) && foodList.contains(ExpertFood.liquid_dragon_egg.getItemId())) {
                entity.m_21195_(MobEffects.f_19610_);
            }
            if (entity.m_21023_(MobEffects.f_19613_) && foodList.contains(ExpertFood.dragon_breath_soda.getItemId())) {
                entity.m_21195_(MobEffects.f_19613_);
            }
            if (foodList.contains(ExpertFood.aurora_ice_cream.getItemId()) && entity.f_19797_ % 20 == 0) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 400, 0, false, false, false));
            }
            if (foodList.contains(ExpertFood.cristel_wine.getItemId())) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 199, 0, false, false, false));
            }
        });
    }

    @Override
    public void onUnequip(LivingEntity entity, ItemStack stack) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        entity.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
            Set<String> foodList = data.getFoodList();
            if (entity.m_21023_(MobEffects.f_19611_) && foodList.contains(ExpertFood.aurora_ice_cream.getItemId())) {
                entity.m_21195_(MobEffects.f_19611_);
            }
            if (entity.m_21023_(MobEffects.f_19608_) && foodList.contains(ExpertFood.cristel_wine.getItemId())) {
                entity.m_21195_(MobEffects.f_19608_);
            }
        });
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        if (this.allowShiftToolTip() && ClientTextUtil.hasControlDown()) {
            this.shiftTooltip(stack, world, tooltipList, flags);
        } else {
            tooltipList.add((Component)Component.m_237115_((String)this.getFoodieDesc()));
            Player clientPlayer = AgeOfMythologyMod.PROXY.getClientPlayer();
            if (clientPlayer != null) {
                clientPlayer.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                    Set<String> foodList = data.getFoodList();
                    this.appendSpecialEffectsHoverText(foodList, tooltipList);
                });
            }
            tooltipList.add((Component)Component.m_237119_());
        }
        if (this.allowShiftToolTip() && !ClientTextUtil.hasControlDown()) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.tooltip.press_button_to_more_info", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.tooltip.shift")}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public boolean allowShiftToolTip() {
        return true;
    }

    @Override
    public void shiftTooltip(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        Player owner = AgeOfMythologyMod.PROXY.getClientPlayer();
        if (owner != null) {
            owner.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                Set<String> set = data.getFoodList();
                for (ExpertFood specialFood : ExpertFood.values()) {
                    boolean eaten = set.contains(specialFood.getItemId());
                    MutableComponent component = Component.m_237110_((String)"ageofmythology.special.foodie.expert.eat", (Object[])new Object[]{Component.m_237115_((String)specialFood.getDescriptionId()), Component.m_237115_((String)String.valueOf(eaten ? 1 : 0))}).m_130940_(eaten ? ChatFormatting.WHITE : ChatFormatting.GRAY);
                    tooltipList.add((Component)component);
                }
            });
        }
    }

    public void appendSpecialEffectsHoverText(Set<String> foodList, List<Component> tooltipList) {
        if (foodList.contains(ExpertFood.bloated_baked_potato.getItemId())) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.poison")}).m_130940_(ChatFormatting.GRAY));
        }
        if (foodList.contains(ExpertFood.iced_black_tea.getItemId())) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.slowness")}).m_130940_(ChatFormatting.GRAY));
        }
        if (foodList.contains(ExpertFood.liquid_dragon_egg.getItemId())) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.blindness")}).m_130940_(ChatFormatting.GRAY));
        }
        if (foodList.contains(ExpertFood.dog_food.getItemId())) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.hunger")}).m_130940_(ChatFormatting.GRAY));
        }
        if (foodList.contains(ExpertFood.dragon_breath_soda.getItemId())) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.weakness")}).m_130940_(ChatFormatting.GRAY));
        }
        if (foodList.contains(ExpertFood.ghastly_spirits.getItemId())) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.levitation")}).m_130940_(ChatFormatting.GRAY));
        }
        if (foodList.contains(ExpertFood.blue_tenderloin_steak.getItemId())) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.nausea")}).m_130940_(ChatFormatting.GRAY));
        }
        if (foodList.contains(ExpertFood.aromatic_pod_affogato.getItemId())) {
            tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.damagetype.fire").m_130940_(ChatFormatting.GRAY));
        }
        if (foodList.contains(ExpertFood.aromatic_pod_affogato.getItemId())) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.damagetype.lava")}).m_130940_(ChatFormatting.GRAY));
        }
        if (foodList.contains(ExpertFood.aurora_ice_cream.getItemId())) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.get", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.effect.night_vision")}).m_130940_(ChatFormatting.GRAY));
        }
        if (foodList.contains(ExpertFood.cristel_wine.getItemId())) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.get", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.effect.water_breathing")}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static boolean immuneFireAndLava(LivingEntity livingEntity) {
        if (!(livingEntity instanceof Player)) {
            return false;
        }
        Player player = (Player)livingEntity;
        AtomicBoolean result = new AtomicBoolean(false);
        player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
            Set<String> set = data.getFoodList();
            if (CurioUtils.isEquipSkullCurio((LivingEntity)player, (Item)AOMItems.AGEOFMYTHOLOGY_FOODIE_EXPERT_ITEM.get()) && set.contains(ExpertFood.aromatic_pod_affogato.getItemId())) {
                result.set(true);
            }
        });
        return result.get();
    }

    public static enum ExpertFood {
        bloated_baked_potato(AOMUtil.getItem("dungeonsdelight:bloated_baked_potato"), 1.0),
        iced_black_tea(AOMUtil.getItem("immortalers_delight:iced_black_tea"), 1.0),
        liquid_dragon_egg(AOMUtil.getItem("ends_delight:liquid_dragon_egg"), 1.0),
        dog_food(AOMUtil.getItem("farmersdelight:dog_food"), 1.0),
        dragon_breath_soda(AOMUtil.getItem("ends_delight:dragon_breath_soda"), 1.0),
        ghastly_spirits(AOMUtil.getItem("dungeonsdelight:ghastly_spirits"), 1.0),
        blue_tenderloin_steak(AOMUtil.getItem("mynethersdelight:blue_tenderloin_steak"), 1.0),
        aromatic_pod_affogato(AOMUtil.getItem("immortalers_delight:aromatic_pod_affogato"), 1.0),
        cristel_wine(AOMUtil.getItem("vinery:cristel_wine"), 1.0),
        aurora_ice_cream(AOMUtil.getItem("dungeonsdelight:aurora_ice_cream"), 1.0);

        @Nullable
        public final Item item;
        public final double count;

        private ExpertFood(Item item, double count) {
            this.item = item;
            this.count = count;
        }

        public String getItemId() {
            if (this.item != null) {
                return AOMUtil.getKey(this.item).toString();
            }
            return "";
        }

        public String getDescriptionId() {
            if (this.item != null) {
                return this.item.m_5524_();
            }
            return "";
        }
    }
}

