/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.item.fire;

import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.item.AOMSkullItem;
import com.kurome.ageofmythology.item.AOMSkullProps;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class BurningCoreItem
extends AOMSkullItem {
    public BurningCoreItem(Block floorBlock, Block wallBlock, Item.Properties properties, AOMSkullProps props) {
        super(floorBlock, wallBlock, properties, props);
    }

    @Override
    public void curioTick(LivingEntity entity, ItemStack stack) {
        super.curioTick(entity, stack);
        double playerFireDamage = AOMUtil.getFireDamage((Player)entity);
        this.modifyAttribute(entity, Attributes.f_22281_, playerFireDamage / 2.0, AttributeModifier.Operation.ADDITION);
    }

    @Override
    public void onUnequip(LivingEntity entity, ItemStack stack) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        this.removeAttribute(entity, Attributes.f_22281_);
    }

    private void removeAttribute(LivingEntity entity, Attribute attribute) {
        AttributeModifier modify;
        UUID uuid = this.getUUID();
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null && (modify = instance.m_22111_(uuid)) != null) {
            instance.m_22120_(uuid);
        }
    }

    private void modifyAttribute(LivingEntity entity, Attribute attribute, Double value, AttributeModifier.Operation operation) {
        UUID uuid = this.getUUID();
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            AttributeModifier modify = instance.m_22111_(uuid);
            if (modify != null) {
                instance.m_22120_(uuid);
            }
            AttributeModifier attr = new AttributeModifier(uuid, this.skullProps.skullName, value.doubleValue(), operation);
            instance.m_22125_(attr);
        }
    }

    @Override
    public void normalTooltip(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.burning_core.desc", (Object[])new Object[]{Component.m_237115_((String)"2").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"1").m_130940_(ChatFormatting.YELLOW)}));
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltipList, flags);
    }
}

