/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.item.blood;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.config.AOMRarityConfig;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.init.AOMAttributes;
import com.kurome.ageofmythology.init.AOMItems;
import com.kurome.ageofmythology.item.AOMSkullItem;
import com.kurome.ageofmythology.item.AOMSkullProps;
import com.kurome.ageofmythology.utils.ClientTextUtil;
import dev.shadowsoffire.attributeslib.api.ALObjects;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BloodCoreItem
extends AOMSkullItem {
    private static final String CORE_LEVEL = "CORE_LEVEL";
    private static final String KILL_COUNT = "KILL_COUNT";
    private static final String UPGRADE_KILL_COUNT = "UPGRADE_KILL_COUNT";

    public BloodCoreItem(Block floorBlock, Block wallBlock, Item.Properties properties, AOMSkullProps props) {
        super(floorBlock, wallBlock, properties.m_41497_(AOMRarityConfig.MYTHIC).m_41487_(1), props);
    }

    protected boolean m_246210_(LevelReader p_250350_, BlockState p_249311_, BlockPos p_250328_) {
        return false;
    }

    public static int getCoreLevel(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41783_();
        if (nbtCompound == null) {
            return 0;
        }
        return nbtCompound.m_128451_(CORE_LEVEL);
    }

    public static void setCoreLevel(ItemStack stack, int level) {
        CompoundTag nbtCompound = stack.m_41784_();
        nbtCompound.m_128405_(CORE_LEVEL, level);
    }

    public static double getKillCount(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41783_();
        if (nbtCompound == null) {
            return 0.0;
        }
        return nbtCompound.m_128451_(KILL_COUNT);
    }

    public static void setKillCount(ItemStack stack, double count) {
        CompoundTag nbtCompound = stack.m_41784_();
        nbtCompound.m_128347_(KILL_COUNT, count);
    }

    public static double getUpgradeKillCount(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41783_();
        if (nbtCompound == null) {
            return 0.0;
        }
        return nbtCompound.m_128451_(UPGRADE_KILL_COUNT);
    }

    public static void setUpgradeKillCount(ItemStack stack, double count) {
        CompoundTag nbtCompound = stack.m_41784_();
        nbtCompound.m_128347_(UPGRADE_KILL_COUNT, count);
    }

    public static void upgrade(ItemStack stack) {
        BloodCoreItem.setCoreLevel(stack, BloodCoreItem.getCoreLevel(stack) + 1);
        BloodCoreItem.setUpgradeKillCount(stack, 0.0);
    }

    public double getMaxHealthBonus() {
        return 1.0;
    }

    public double getDamageBonus() {
        return 1.0;
    }

    public String getDesc() {
        return "ageofmythology.special.blood.core.desc";
    }

    @Override
    public void curioTick(LivingEntity entity, ItemStack stack) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int coreLevel = BloodCoreItem.getCoreLevel(stack) + 1;
        Attribute bloodAttribute = (Attribute)AOMAttributes.BLOOD_POWER.get();
        AOMUtil.modifyAttribute(entity, bloodAttribute, this.getUUID(), this.skullProps.skullName + ":" + bloodAttribute.m_22087_(), 0.01 * (double)coreLevel, AttributeModifier.Operation.ADDITION);
        double bloodPower = AOMUtil.getBloodPower(player);
        for (BloodActiveAttribute activeAttribute : BloodActiveAttribute.values()) {
            double value = BloodCoreItem.getBloodBonus(activeAttribute, stack, bloodPower);
            if (activeAttribute.requiredLevel > coreLevel) continue;
            AOMUtil.modifyAttribute(entity, activeAttribute.attribute, this.getUUID(), this.skullProps.skullName + ":" + activeAttribute.attribute.m_22087_(), value, AttributeModifier.Operation.ADDITION);
        }
    }

    public static double getBloodBonus(BloodActiveAttribute activeAttribute, ItemStack stack, double bloodPower) {
        int coreLevel = BloodCoreItem.getCoreLevel(stack) + 1;
        double kill = BloodCoreItem.getKillCount(stack);
        double value = kill * (double)activeAttribute.bonus;
        if (coreLevel - 1 < activeAttribute.limit.size()) {
            value = Math.min(value, (double)activeAttribute.limit.get(coreLevel - 1).floatValue());
        } else if (!activeAttribute.limit.isEmpty()) {
            value = Math.min(value, (double)activeAttribute.limit.get(activeAttribute.limit.size() - 1).floatValue());
        }
        return value * (0.4 + bloodPower);
    }

    @Override
    public void onUnequip(LivingEntity entity, ItemStack stack) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        AOMUtil.removeAttribute(entity, (Attribute)AOMAttributes.BLOOD_POWER.get(), this.getUUID());
        for (BloodActiveAttribute activeAttribute : BloodActiveAttribute.values()) {
            AOMUtil.removeAttribute(entity, activeAttribute.attribute, this.getUUID());
        }
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        if (this.allowShiftToolTip() && ClientTextUtil.hasControlDown()) {
            this.shiftTooltip(stack, world, tooltipList, flags);
        } else {
            MutableComponent bloodLevelDesc;
            double upgradeKillCount = BloodCoreItem.getUpgradeKillCount(stack);
            int coreLevel = BloodCoreItem.getCoreLevel(stack) + 1;
            MutableComponent bloodLevel = Component.m_237115_((String)(((Item)AOMItems.AGEOFMYTHOLOGY_BLOOD_CORE_ITEM.get()).m_5524_() + ".level_%s".formatted(Math.min(coreLevel, 6))));
            MutableComponent mutableComponent = bloodLevelDesc = coreLevel == 1 ? Component.m_237115_((String)(((Item)AOMItems.AGEOFMYTHOLOGY_BLOOD_CORE_ITEM.get()).m_5524_() + ".level_1.desc")) : Component.m_237110_((String)(((Item)AOMItems.AGEOFMYTHOLOGY_BLOOD_CORE_ITEM.get()).m_5524_() + ".level.kill_health.desc"), (Object[])new Object[]{Component.m_237115_((String)String.valueOf(BloodCoreItem.getRequiredKillMobHealth(coreLevel))).m_130940_(ChatFormatting.YELLOW)});
            if (coreLevel > 6) {
                bloodLevelDesc = Component.m_237115_((String)(((Item)AOMItems.AGEOFMYTHOLOGY_BLOOD_CORE_ITEM.get()).m_5524_() + ".level.kill_health.finish"));
            }
            tooltipList.add((Component)Component.m_237115_((String)this.getDesc()));
            tooltipList.add((Component)bloodLevelDesc);
            tooltipList.add((Component)Component.m_237119_());
            tooltipList.add((Component)Component.m_237110_((String)(((Item)AOMItems.AGEOFMYTHOLOGY_BLOOD_CORE_ITEM.get()).m_5524_() + ".desc"), (Object[])new Object[]{bloodLevel}));
            if (coreLevel <= 6) {
                tooltipList.add((Component)Component.m_237110_((String)(((Item)AOMItems.AGEOFMYTHOLOGY_BLOOD_CORE_ITEM.get()).m_5524_() + ".upgrade_kill_count.desc"), (Object[])new Object[]{(int)upgradeKillCount, BloodCoreItem.getUpgradeRequiredKillCount(coreLevel)}));
            }
            tooltipList.add((Component)Component.m_237119_());
            tooltipList.add((Component)Component.m_237110_((String)(((Item)AOMItems.AGEOFMYTHOLOGY_BLOOD_CORE_ITEM.get()).m_5524_() + ".kill_count.desc"), (Object[])new Object[]{(int)BloodCoreItem.getKillCount(stack)}));
            tooltipList.add((Component)Component.m_237119_());
            double bloodPower = AOMUtil.getBloodPower(AgeOfMythologyMod.PROXY.getClientPlayer());
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.blood.core.attribute.1.desc", (Object[])new Object[]{Component.m_237115_((String)String.format("%.2f", bloodPower)).m_130940_(ChatFormatting.RED)}));
            tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.special.blood.core.attribute.2.desc"));
            for (BloodActiveAttribute activeAttribute : BloodActiveAttribute.values()) {
                double value = BloodCoreItem.getBloodBonus(activeAttribute, stack, bloodPower);
                if (activeAttribute.requiredLevel > coreLevel) continue;
                String description = "attribute.modifier.plus." + AttributeModifier.Operation.ADDITION.m_22235_();
                tooltipList.add((Component)Component.m_237110_((String)description, (Object[])new Object[]{ItemStack.f_41584_.format(value), Component.m_237115_((String)activeAttribute.attribute.m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
        if (this.allowShiftToolTip() && !ClientTextUtil.hasControlDown()) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.tooltip.press_button_to_more_info", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.tooltip.shift")}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static int getUpgradeRequiredKillCount(int level) {
        switch (level) {
            case 1: {
                return 200;
            }
            case 2: {
                return 100;
            }
            case 3: {
                return 50;
            }
            case 4: {
                return 20;
            }
            case 5: {
                return 10;
            }
            case 6: {
                return 10;
            }
        }
        return 10;
    }

    public static int getRequiredKillMobHealth(int level) {
        switch (level) {
            case 1: {
                return 0;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 100;
            }
            case 4: {
                return 500;
            }
            case 5: {
                return 2000;
            }
            case 6: {
                return 10000;
            }
        }
        return 0;
    }

    public static double getHealthBonusByBloodPower(double bloodPower) {
        if (0.0 < bloodPower && bloodPower < 0.2) {
            return 20.0;
        }
        if (0.2 <= bloodPower && bloodPower < 0.4) {
            return 50.0;
        }
        if (0.4 <= bloodPower && bloodPower < 0.6) {
            return 200.0;
        }
        if (0.6 <= bloodPower && bloodPower < 0.8) {
            return 500.0;
        }
        if (0.8 <= bloodPower && bloodPower < 1.0) {
            return 1000.0;
        }
        if (1.0 <= bloodPower) {
            return 2000.0;
        }
        return 0.0;
    }

    public static enum BloodActiveAttribute {
        ATTACK_DAMAGE(1, Attributes.f_22281_, 0.2f, Arrays.asList(Float.valueOf(20.0f), Float.valueOf(50.0f), Float.valueOf(100.0f), Float.valueOf(500.0f), Float.valueOf(2000.0f), Float.valueOf(5000.0f))),
        MAX_HEALTH(2, (Attribute)ALObjects.Attributes.ARMOR_SHRED.get(), 2.0E-4f, Arrays.asList(Float.valueOf(0.1f), Float.valueOf(0.2f), Float.valueOf(0.35f), Float.valueOf(0.5f), Float.valueOf(0.75f), Float.valueOf(1.0f))),
        ARMOR(3, Attributes.f_22284_, 0.1f, Arrays.asList(Float.valueOf(20.0f), Float.valueOf(50.0f), Float.valueOf(100.0f), Float.valueOf(200.0f), Float.valueOf(500.0f), Float.valueOf(500.0f))),
        ARMOR_TOUGHNESS(4, Attributes.f_22285_, 0.05f, Arrays.asList(Float.valueOf(10.0f), Float.valueOf(20.0f), Float.valueOf(50.0f), Float.valueOf(100.0f), Float.valueOf(200.0f), Float.valueOf(300.0f))),
        ATTACK_SPEED(5, Attributes.f_22283_, 2.0E-4f, Arrays.asList(Float.valueOf(0.1f), Float.valueOf(0.2f), Float.valueOf(0.35f), Float.valueOf(0.5f), Float.valueOf(0.75f), Float.valueOf(1.0f))),
        CRITICAL_CHANCE(6, (Attribute)AOMAttributes.CRITICAL_CHANCE.get(), 1.0E-4f, Arrays.asList(Float.valueOf(0.1f), Float.valueOf(0.2f), Float.valueOf(0.35f), Float.valueOf(0.5f), Float.valueOf(0.75f), Float.valueOf(1.0f))),
        LIFE_DRAIN(7, (Attribute)AOMAttributes.LIFE_DRAIN.get(), 2.0E-5f, Arrays.asList(Float.valueOf(0.02f), Float.valueOf(0.04f), Float.valueOf(0.08f), Float.valueOf(0.12f), Float.valueOf(0.15f), Float.valueOf(0.2f)));

        public final int requiredLevel;
        public final Attribute attribute;
        public final float bonus;
        public final List<Float> limit;

        private BloodActiveAttribute(int requiredLevel, Attribute attribute, float bonus, List<Float> limit1) {
            this.requiredLevel = requiredLevel;
            this.attribute = attribute;
            this.bonus = bonus;
            this.limit = limit1;
        }
    }
}

