/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.item.autism;

import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.capability.PlayerDataCapability;
import com.kurome.ageofmythology.capability.api.IPlayerData;
import com.kurome.ageofmythology.config.AOMTradeConfig;
import com.kurome.ageofmythology.config.AOMUUIDConfig;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.config.CurioUtils;
import com.kurome.ageofmythology.enums.MobVariant;
import com.kurome.ageofmythology.init.AOMItems;
import com.kurome.ageofmythology.item.AOMSkullItem;
import com.kurome.ageofmythology.item.AOMSkullProps;
import com.kurome.ageofmythology.item.autism.IAutism;
import com.kurome.ageofmythology.utils.BiomeUtil;
import com.mega.revelationfix.common.init.GRItems;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import lykrast.meetyourfight.registry.MYFItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class AutismSkullItem
extends AOMSkullItem {
    public static List<Supplier<Item>> specialDisc = new ArrayList<Supplier>(Arrays.asList(AOMItems.MUSIC_DISC_QINGXINGMENG, () -> Items.f_186363_, () -> Items.f_42711_, () -> Items.f_283830_, () -> Items.f_42708_));
    public static List<Supplier<Item>> rareDisc = new ArrayList<RegistryObject>(Arrays.asList(ACItemRegistry.MUSIC_DISC_FUSION, ACItemRegistry.MUSIC_DISC_TASTY, AMItemRegistry.MUSIC_DISC_DAZE, AMItemRegistry.MUSIC_DISC_THIME, com.Polarice3.Goety.common.items.ModItems.MUSIC_DISC_VIZIER, com.Polarice3.Goety.common.items.ModItems.MUSIC_DISC_APOSTLE, MYFItems.discSwampjaw, MYFItems.discBellringer, MYFItems.discFortuna, MYFItems.discRosalyne, GRItems.DISC_1, GRItems.DISC_2, GRItems.DISC_3, TravelopticsItems.MUSIC_DISC_NIGHTWARDEN, ModItems.MUSIC_DISC_SCYLLA, ModItems.MUSIC_DISC_THE_CATACLYSMFARER, ModItems.MUSIC_DISC_NETHERITE_MONSTROSITY, ModItems.MUSIC_DISC_ENDER_GUARDIAN, ModItems.MUSIC_DISC_IGNIS, ModItems.MUSIC_DISC_THE_HARBINGER, ModItems.MUSIC_DISC_THE_LEVIATHAN, ModItems.MUSIC_DISC_MALEDICTUS, ModItems.MUSIC_DISC_ANCIENT_REMNANT));
    public AutismType type;

    public AutismSkullItem(Block floorBlock, Block wallBlock, Item.Properties properties, AOMSkullProps props, AutismType dimension) {
        super(floorBlock, wallBlock, properties, props);
        this.type = dimension;
    }

    @Override
    public void curioTick(LivingEntity entity, ItemStack stack) {
        super.curioTick(entity, stack);
        entity.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
            double multiply = 1.0;
            int listenCount = this.getDiscs((IPlayerData)data, AutismType.listen).size();
            int performCount = this.getDiscs((IPlayerData)data, AutismType.perform).size();
            int specialCount = this.getActiveCount((IPlayerData)data, specialDisc.stream().map(Supplier::get).toList());
            int rareCount = this.getActiveCount((IPlayerData)data, rareDisc.stream().map(Supplier::get).toList());
            if (listenCount >= 30) {
                multiply *= 1.5;
            }
            if (performCount >= 20) {
                multiply *= 1.5;
            }
            if (specialCount >= specialDisc.size()) {
                multiply *= 1.5;
            }
            if (rareCount >= rareDisc.size()) {
                multiply *= 2.0;
            }
            AtomicInteger count = new AtomicInteger(0);
            CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(curiosInventory -> curiosInventory.getStacksHandler("skull").ifPresent(skullInventory -> {
                for (int i = 0; i < skullInventory.getSlots(); ++i) {
                    ItemStack itemStack = skullInventory.getStacks().getStackInSlot(i);
                    if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof AOMSkullItem) || itemStack.m_41720_() instanceof AutismSkullItem || itemStack.m_41720_() instanceof IAutism) continue;
                    count.incrementAndGet();
                }
            }));
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (CurioUtils.isEquipSkullCurio((LivingEntity)player, (Item)AOMItems.AGEOFMYTHOLOGY_AUTISM_END_3_ITEM.get()) && CurioUtils.isEquipSkullCurio((LivingEntity)player, (Item)AOMItems.AGEOFMYTHOLOGY_TRAVEL_CORE_ITEM.get()) && AOMUtil.getEmotionValue(player) < -20.0) {
                    effectFactor = 1.0f - (float)count.get() * (float)AutismSkullItem.getEffectValue(player) / 100.0f;
                    multiply *= (double)Math.abs(effectFactor);
                } else {
                    effectFactor = Math.max(0.0f, 1.0f - (float)count.get() * (float)AutismSkullItem.getEffectValue(player) / 100.0f);
                    multiply *= (double)effectFactor;
                }
            }
            if (this.type == AutismType.autismer) {
                this.modifyAttribute(entity, Attributes.f_22276_, 50.0 + this.type.maxHealth * (double)rareCount * multiply, this.skullProps.skullName + "_max_health");
                this.modifyAttribute(entity, Attributes.f_22281_, 25.0 + this.type.attack * (double)rareCount * multiply, this.skullProps.skullName + "_attack_damage");
            } else if (this.type == AutismType.listen) {
                discs = this.getDiscs((IPlayerData)data, AutismType.listen);
                this.modifyAttribute(entity, Attributes.f_22276_, this.type.maxHealth * (double)discs.size() * multiply, this.skullProps.skullName + "_max_health");
                this.modifyAttribute(entity, Attributes.f_22281_, this.type.attack * (double)discs.size() * multiply, this.skullProps.skullName + "_attack_damage");
            } else if (this.type == AutismType.perform) {
                discs = this.getDiscs((IPlayerData)data, AutismType.perform);
                this.modifyAttribute(entity, Attributes.f_22276_, this.type.maxHealth * (double)discs.size() * multiply, this.skullProps.skullName + "_max_health");
                this.modifyAttribute(entity, Attributes.f_22281_, this.type.attack * (double)discs.size() * multiply, this.skullProps.skullName + "_attack_damage");
            } else if (this.type == AutismType.silent) {
                List<String> set = this.getDiscs((IPlayerData)data, AutismType.listen);
                AtomicInteger activeCount = new AtomicInteger(0);
                specialDisc.stream().map(itemSupplier -> ((Item)itemSupplier.get()).m_5524_()).toList().forEach(needDisc -> {
                    if (set.contains(needDisc)) {
                        activeCount.addAndGet(1);
                    }
                });
                this.modifyAttribute(entity, Attributes.f_22276_, this.type.maxHealth * (double)activeCount.get() * multiply, this.skullProps.skullName + "_max_health");
                this.modifyAttribute(entity, Attributes.f_22281_, this.type.attack * (double)activeCount.get() * multiply, this.skullProps.skullName + "_attack_damage");
            }
        });
    }

    @Override
    public void onUnequip(LivingEntity entity, ItemStack stack) {
        super.onUnequip(entity, stack);
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        this.removeAttribute(entity, Attributes.f_22276_);
        this.removeAttribute(entity, Attributes.f_22281_);
    }

    private void removeAttribute(LivingEntity entity, Attribute attribute) {
        AttributeModifier modify;
        UUID uuid = AOMUUIDConfig.getUUID(this.skullProps.skullName);
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null && (modify = instance.m_22111_(uuid)) != null) {
            instance.m_22120_(uuid);
        }
    }

    private void modifyAttribute(LivingEntity entity, Attribute attribute, Double value, String name) {
        UUID uuid = AOMUUIDConfig.getUUID(this.skullProps.skullName);
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            AttributeModifier modify = instance.m_22111_(uuid);
            if (modify != null) {
                instance.m_22120_(uuid);
            }
            AttributeModifier attr = new AttributeModifier(uuid, name, value.doubleValue(), AttributeModifier.Operation.ADDITION);
            instance.m_22125_(attr);
        }
    }

    public static int getEffectValue(Player player) {
        if (AOMUtil.getEmotionValue(player) < -10.0) {
            return 20;
        }
        return 10;
    }

    @Override
    public void normalTooltip(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.autism.effect.desc", (Object[])new Object[]{Component.m_237115_((String)(AutismSkullItem.getEffectValue(AgeOfMythologyMod.PROXY.getClientPlayer()) + "%")).m_130940_(ChatFormatting.GOLD)}));
        if (this.type == AutismType.autismer) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.autismer.desc", (Object[])new Object[]{50, 25}).m_130940_(ChatFormatting.GOLD));
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.autismer.desc2", (Object[])new Object[]{this.type.maxHealth, this.type.attack}).m_130940_(ChatFormatting.GOLD));
            tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.special.autismer.desc3"));
        } else if (this.type == AutismType.listen) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.autism.listen.desc", (Object[])new Object[]{this.type.attack}).m_130940_(ChatFormatting.GOLD));
            tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.special.autism.listen.desc2"));
        } else if (this.type == AutismType.perform) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.autism.perform.desc", (Object[])new Object[]{this.type.maxHealth, this.type.attack}).m_130940_(ChatFormatting.GOLD));
            tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.special.autism.perform.desc2"));
        } else if (this.type == AutismType.silent) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.autism.silent.desc", (Object[])new Object[]{this.type.maxHealth, this.type.attack}).m_130940_(ChatFormatting.GOLD));
            tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.special.autism.silent.desc2"));
        }
        super.normalTooltip(stack, world, tooltipList, flags);
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltipList, flags);
    }

    @Override
    public boolean allowShiftToolTip() {
        return true;
    }

    @Override
    public void shiftTooltip(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        Player owner = AgeOfMythologyMod.PROXY.getClientPlayer();
        if (owner != null) {
            if (this.type == AutismType.autismer) {
                owner.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                    List<String> set = this.getDiscs((IPlayerData)data, AutismType.listen);
                    rareDisc.stream().map(itemSupplier -> ((Item)itemSupplier.get()).m_5524_()).toList().forEach(needDisc -> {
                        boolean isActive = set.contains(needDisc);
                        MutableComponent discName = Component.m_237115_((String)(needDisc + ".desc"));
                        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.listen.shift.tip.desc", (Object[])new Object[]{discName, isActive ? "1" : "0"}).m_130940_(isActive ? ChatFormatting.WHITE : ChatFormatting.GRAY));
                    });
                });
            } else if (this.type == AutismType.listen) {
                owner.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                    List<String> set = this.getDiscs((IPlayerData)data, this.type);
                    set.forEach(disc -> tooltipList.add((Component)Component.m_237115_((String)(disc + ".desc"))));
                });
            } else if (this.type == AutismType.perform) {
                owner.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                    List<String> set = this.getDiscs((IPlayerData)data, this.type);
                    set.forEach(biomeKey -> tooltipList.add((Component)Component.m_237115_((String)biomeKey)));
                });
            } else if (this.type == AutismType.silent) {
                owner.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                    List<String> set = this.getDiscs((IPlayerData)data, AutismType.listen);
                    specialDisc.stream().map(itemSupplier -> ((Item)itemSupplier.get()).m_5524_()).toList().forEach(needDisc -> {
                        boolean isActive = set.contains(needDisc);
                        MutableComponent discName = Component.m_237115_((String)(needDisc + ".desc"));
                        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.special.listen.shift.tip.desc", (Object[])new Object[]{discName, isActive ? "1" : "0"}).m_130940_(isActive ? ChatFormatting.WHITE : ChatFormatting.GRAY));
                    });
                });
            }
        }
    }

    public static void handleListenEvent(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos blockpos = event.getPos();
        BlockState blockstate = level.m_8055_(blockpos);
        ItemStack disc = event.getItemStack();
        Item item = disc.m_41720_();
        if (item instanceof RecordItem) {
            Player player;
            RecordItem recordItem = (RecordItem)item;
            if (blockstate.m_60713_(Blocks.f_50131_) && !((Boolean)blockstate.m_61143_((Property)JukeboxBlock.f_54254_)).booleanValue() && !level.f_46443_ && (player = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                    String discId = recordItem.m_5524_();
                    String wrapId = AutismSkullItem.wrapDiscId(AutismType.listen, discId);
                    if (!data.hasListened(wrapId)) {
                        data.addDisc(wrapId);
                        data.sync((Player)serverPlayer);
                        serverPlayer.m_213846_((Component)Component.m_237110_((String)"ageofmythology.special.autism.listen", (Object[])new Object[]{recordItem.m_43050_().m_130940_(ChatFormatting.BLUE)}));
                        Vec3 pos = player.m_20182_();
                        ExperienceOrb orb = new ExperienceOrb(level, pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_, 100);
                        level.m_7967_((Entity)orb);
                    } else {
                        serverPlayer.m_213846_((Component)Component.m_237110_((String)"ageofmythology.special.autism.hasListened", (Object[])new Object[]{recordItem.m_43050_().m_130940_(ChatFormatting.BLUE)}));
                    }
                });
            }
        }
    }

    public static void handlePerformEvent(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos blockpos = event.getPos();
        BlockState blockstate = level.m_8055_(blockpos);
        ItemStack disc = event.getItemStack();
        Item item = disc.m_41720_();
        if (item instanceof RecordItem) {
            Player player;
            RecordItem recordItem = (RecordItem)item;
            if (blockstate.m_60713_(Blocks.f_50131_) && !((Boolean)blockstate.m_61143_((Property)JukeboxBlock.f_54254_)).booleanValue() && !level.f_46443_ && (player = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                    Holder biomeHolder = level.m_204166_(player.m_20183_());
                    String biomeKey = BiomeUtil.getBiomeName(level, (Biome)biomeHolder.get());
                    String wrapId = AutismSkullItem.wrapDiscId(AutismType.perform, biomeKey);
                    if (!data.hasListened(wrapId)) {
                        data.addDisc(wrapId);
                        data.sync((Player)serverPlayer);
                        serverPlayer.m_213846_((Component)Component.m_237110_((String)"ageofmythology.special.autism.perform", (Object[])new Object[]{Component.m_237115_((String)biomeKey).m_130940_(ChatFormatting.YELLOW), recordItem.m_43050_()}));
                        Vec3 pos = player.m_20182_();
                        ExperienceOrb orb = new ExperienceOrb(level, pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_, 100);
                        level.m_7967_((Entity)orb);
                    } else {
                        serverPlayer.m_213846_((Component)Component.m_237110_((String)"ageofmythology.special.autism.hasPerformed", (Object[])new Object[]{Component.m_237115_((String)biomeKey).m_130940_(ChatFormatting.YELLOW)}));
                    }
                });
            }
        }
    }

    public static String wrapDiscId(AutismType prefix, String id) {
        return prefix.name + ":" + id;
    }

    public static Pair<AutismType, String> unWrapDiscId(String id) {
        Pair empty = new Pair((Object)AutismType.empty, (Object)"");
        String[] list = id.split(":");
        if (list.length < 2) {
            return empty;
        }
        Optional<AutismType> autismType = Arrays.stream(AutismType.values()).filter(type -> type.name.equals(list[0])).findFirst();
        return autismType.map(value -> new Pair((Object)value, (Object)list[1])).orElse(empty);
    }

    public List<String> getDiscs(IPlayerData data, AutismType autismType) {
        return data.getListenedDisc().stream().filter(id -> AutismSkullItem.unWrapDiscId(id).getFirst() == autismType).map(id -> (String)AutismSkullItem.unWrapDiscId(id).getSecond()).toList();
    }

    public int getActiveCount(IPlayerData data, List<Item> disc) {
        List<String> set = this.getDiscs(data, AutismType.listen);
        AtomicInteger activeCount = new AtomicInteger(0);
        disc.stream().map(Item::m_5524_).toList().forEach(needDisc -> {
            if (set.contains(needDisc)) {
                activeCount.addAndGet(1);
            }
        });
        return activeCount.get();
    }

    public static void autismTradeConfig(MobVariant mobVariant, List<VillagerTrades.ItemListing> list) {
        switch (mobVariant) {
            case MINECRAFT_SKELETON: {
                list.add(AOMTradeConfig.createItemListing(Items.f_41859_, 1, AOMUtil.getCurrency(2), 1, (Item)AOMItems.AGEOFMYTHOLOGY_AUTISM_SILENT_ITEM.get(), 1));
                break;
            }
            case MINECRAFT_WARDEN: {
                list.add(AOMTradeConfig.createItemListing(Items.f_41859_, 1, AOMUtil.getCurrency(4), 1, (Item)AOMItems.AGEOFMYTHOLOGY_AUTISM_LISTEN_ITEM.get(), 1));
                break;
            }
            case MINECRAFT_GHAST: {
                list.add(AOMTradeConfig.createItemListing(Items.f_41859_, 1, AOMUtil.getCurrency(4), 1, (Item)AOMItems.AGEOFMYTHOLOGY_AUTISM_PERFORM_ITEM.get(), 1));
                break;
            }
            case MINECRAFT_ENDER_DRAGON: {
                list.add(AOMTradeConfig.createItemListing(Items.f_41859_, 1, AOMUtil.getCurrency(5), 1, (Item)AOMItems.AGEOFMYTHOLOGY_AUTISMER_ITEM.get(), 1));
            }
        }
    }

    public static enum AutismType {
        silent("silent", 4.0, 4.0, 0),
        listen("listen", 0.0, 4.0, 0),
        perform("perform", 4.0, 2.0, 0),
        autismer("autismer", 8.0, 8.0, 0),
        empty("empty", 0.0, 0.0, 0);

        public final String name;
        public final double maxHealth;
        public final double attack;
        public final int activeCount;

        private AutismType(String dimension, double maxHealth, double attack, int activeCount) {
            this.name = dimension;
            this.maxHealth = maxHealth;
            this.attack = attack;
            this.activeCount = activeCount;
        }
    }
}

