/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.item;

import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.config.AOMSpecialSkullConfig;
import com.kurome.ageofmythology.data.ItemTagGenerator;
import com.kurome.ageofmythology.dimension.AOMDimension;
import com.kurome.ageofmythology.init.AOMAttributes;
import com.kurome.ageofmythology.item.AOMAttributeModifier;
import com.kurome.ageofmythology.item.AOMSkullProps;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import liushuangwuyin.bettermorph.api.FlightHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;

public interface ICurioSkull {
    public static final int EFFECT_UPDATE_INTERVAL = 1;
    public static final int EFFECT_DURATION = 40;
    public static final List<Attribute> showAttributeTooltipList = new ArrayList<Attribute>(Arrays.asList((Attribute)AOMAttributes.ABILITY_LEVEL.get(), (Attribute)AttributeRegistry.SPELL_POWER.get(), (Attribute)AOMAttributes.EXPLOSION_POWER.get(), (Attribute)AOMAttributes.EXPLOSION_RANGE.get(), (Attribute)AOMAttributes.EXPLOSION_COOLDOWN.get(), (Attribute)AOMAttributes.POTION_ATTACK.get(), (Attribute)AOMAttributes.Debilitating_Sting.get(), (Attribute)AOMAttributes.Exsanguination.get(), (Attribute)AOMAttributes.FIRE_DAMAGE.get(), (Attribute)AOMAttributes.DRAGON_LEVEL.get(), (Attribute)AOMAttributes.DRAGON_POWER.get(), (Attribute)AOMAttributes.ABYSS_LEVEL.get(), (Attribute)AOMAttributes.ABYSS_DAMAGE.get(), (Attribute)AOMAttributes.MACHINE_LEVEL.get(), (Attribute)AOMAttributes.MACHINE_DAMAGE.get(), (Attribute)AOMAttributes.FLESH_LEVEL.get(), (Attribute)AOMAttributes.BLOOD_POWER.get(), (Attribute)AOMAttributes.EMOTION_VALUE.get()));

    default public SoundEvent getEquipSound() {
        return SoundEvents.f_11675_;
    }

    public String getSkullName();

    default public boolean attributeActive(@Nullable LivingEntity entity, ItemStack stack) {
        return true;
    }

    default public void appendSpecialEffectsHoverText(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        if (stack.m_204117_(ItemTagGenerator.POISON)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.poison")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.MOVEMENT_SLOWDOWN)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.slowness")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.BLINDNESS)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.blindness")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.HUNGER)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.hunger")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.WEAKNESS)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.weakness")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.WITHER)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.wither")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.LEVITATION)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.levitation")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.DARKNESS)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.darkness")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.CONFUSION)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"effect.minecraft.nausea")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.FALL)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.damagetype.fall")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.FIRE)) {
            tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.damagetype.fire").m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.LAVA)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.damagetype.lava")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.IN_WALL)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.damagetype.in_wall")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.NIGHT_VISION)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.get", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.effect.night_vision")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.WATER_BREATHING)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.get", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.effect.water_breathing")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.JUMP)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.get", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.effect.jump")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.DIG_SLOWDOWN)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.immune", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.damagetype.dig_slowdown")}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTagGenerator.LAVA_WALKER)) {
            tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.special.lava_walker").m_130940_(ChatFormatting.GOLD));
        }
        if (stack.m_204117_(ItemTagGenerator.WATER_WALKER)) {
            tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.special.water_walker").m_130940_(ChatFormatting.GOLD));
        }
        if (this.getSkullProps().lootingLevel != 0) {
            tooltipList.add((Component)Component.m_237110_((String)"%s %s", (Object[])new Object[]{Component.m_237115_((String)"enchantment.minecraft.looting"), Component.m_237115_((String)"enchantment.level.%s".formatted(this.getSkullProps().lootingLevel))}).m_130940_(ChatFormatting.GOLD));
        }
        if (stack.m_204117_(ItemTagGenerator.SUNBIRD_BLESSING)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.get", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.effect.sunbird_blessing")}).m_130940_(ChatFormatting.GOLD));
        }
        if (stack.m_204117_(ItemTagGenerator.SUNBIRD_CURSE)) {
            tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.item.effect.get", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.effect.sunbird_curse")}).m_130940_(ChatFormatting.GOLD));
        }
        if (stack.m_204117_(ItemTagGenerator.FLYING)) {
            tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.special.flying").m_130940_(ChatFormatting.RED));
        }
        if (stack.m_204117_(ItemTagGenerator.CLIMB)) {
            tooltipList.add((Component)Component.m_237115_((String)"ageofmythology.special.climb").m_130940_(ChatFormatting.GOLD));
        }
        if (this.getSkullProps().fortuneLevel != 0) {
            tooltipList.add((Component)Component.m_237110_((String)"%s %s", (Object[])new Object[]{Component.m_237115_((String)"enchantment.minecraft.fortune"), Component.m_237115_((String)"enchantment.level.%s".formatted(this.getSkullProps().fortuneLevel))}).m_130940_(ChatFormatting.GOLD));
        }
    }

    default public boolean isCosmetic() {
        return this.getSkullProps().isCosmetic;
    }

    default public List<AOMAttributeModifier> getAttributeModifiers() {
        return this.getSkullProps().attributeModifiers;
    }

    default public void appendEffectsHoverText(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        Set curioTags = CuriosApi.getItemStackSlots((ItemStack)stack, (boolean)true).keySet();
        ArrayList slots = new ArrayList(curioTags);
        if (this.isCosmetic() || slots.isEmpty() || this.getAttributeModifiers().isEmpty()) {
            return;
        }
        tooltipList.add((Component)Component.m_237119_());
        String identifier = slots.contains("curio") ? "curio" : (String)slots.get(0);
        tooltipList.add((Component)Component.m_237115_((String)("curios.modifiers." + identifier)));
        for (AOMAttributeModifier modifier : this.getAttributeModifiers()) {
            double amount = modifier.getAmount();
            if (amount == 0.0) continue;
            if (modifier.getOperation() == AttributeModifier.Operation.ADDITION) {
                if (modifier.getAttribute().equals(Attributes.f_22278_)) {
                    amount *= 10.0;
                }
            } else {
                amount *= 100.0;
            }
            Object description = "attribute.modifier.plus." + modifier.getOperation().m_22235_();
            if (amount < 0.0) {
                description = "%s %s";
            } else if (modifier.getOperation().m_22235_() == 2) {
                description = "\u00d7%s%% %s";
                amount += 100.0;
            }
            tooltipList.add((Component)Component.m_237110_((String)description, (Object[])new Object[]{ItemStack.f_41584_.format(amount), Component.m_237115_((String)modifier.getAttribute().m_22087_())}).m_130940_(ChatFormatting.BLUE));
        }
    }

    default public void appendAttributeTooltipHoverText(List<Component> tooltipList) {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        list.add(Component.m_237119_());
        for (AOMAttributeModifier modifier : this.getSkullProps().attributeModifiers) {
            Attribute attribute = modifier.getAttribute();
            for (Attribute showAttr : showAttributeTooltipList) {
                if (!attribute.equals(showAttr)) continue;
                list.add(Component.m_237110_((String)"%s: %s", (Object[])new Object[]{Component.m_237115_((String)showAttr.m_22087_()), Component.m_237115_((String)(showAttr.m_22087_() + ".desc"))}).m_130940_(ChatFormatting.GOLD));
            }
        }
        if (list.size() > 1) {
            tooltipList.addAll(list);
        }
    }

    default public void normalTooltip(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        AOMSpecialSkullConfig.appendSpecialItemHoverText(stack, world, tooltipList);
        this.appendSpecialEffectsHoverText(stack, world, tooltipList, flags);
        if (this.attributeActive((LivingEntity)AgeOfMythologyMod.PROXY.getClientPlayer(), stack)) {
            this.appendEffectsHoverText(stack, world, tooltipList, flags);
            this.appendAttributeTooltipHoverText(tooltipList);
        }
    }

    default public void pressShiftTooltip(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        tooltipList.add((Component)Component.m_237110_((String)"ageofmythology.tooltip.press_button_to_more_info", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.tooltip.shift")}).m_130940_(ChatFormatting.GRAY));
    }

    default public boolean allowShiftToolTip() {
        return false;
    }

    public AOMSkullProps getSkullProps();

    default public void onEquip(LivingEntity entity, ItemStack stack) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (!this.attributeActive(entity, stack)) {
            return;
        }
        for (AOMAttributeModifier modifier : this.getSkullProps().attributeModifiers) {
            AttributeInstance attributeInstance = entity.m_21051_(modifier.getAttribute());
            if (attributeInstance == null) continue;
            attributeInstance.m_22120_(modifier.getModifierId());
            AttributeModifier attributeModifier = modifier.createModifier();
            attributeInstance.m_22125_(attributeModifier);
            modifier.onAttributeUpdated(entity);
        }
    }

    default public void onUnequip(LivingEntity entity, ItemStack stack) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        for (AOMAttributeModifier modifier : this.getSkullProps().attributeModifiers) {
            AttributeInstance attributeInstance = entity.m_21051_(modifier.getAttribute());
            if (attributeInstance == null) continue;
            attributeInstance.m_22120_(modifier.getModifierId());
            modifier.onAttributeUpdated(entity);
        }
        this.removeEffect(entity, stack);
    }

    default public void curioTick(LivingEntity entity, ItemStack stack) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (entity.m_21023_(MobEffects.f_19614_) && stack.m_204117_(ItemTagGenerator.POISON)) {
            entity.m_21195_(MobEffects.f_19614_);
        }
        if (entity.m_21023_(MobEffects.f_19597_) && stack.m_204117_(ItemTagGenerator.MOVEMENT_SLOWDOWN)) {
            entity.m_21195_(MobEffects.f_19597_);
        }
        if (entity.m_21023_(MobEffects.f_19610_) && stack.m_204117_(ItemTagGenerator.BLINDNESS)) {
            entity.m_21195_(MobEffects.f_19610_);
        }
        if (entity.m_21023_(MobEffects.f_19612_) && stack.m_204117_(ItemTagGenerator.HUNGER)) {
            entity.m_21195_(MobEffects.f_19612_);
        }
        if (entity.m_21023_(MobEffects.f_19613_) && stack.m_204117_(ItemTagGenerator.WEAKNESS)) {
            entity.m_21195_(MobEffects.f_19613_);
        }
        if (entity.m_21023_(MobEffects.f_19615_) && stack.m_204117_(ItemTagGenerator.WITHER)) {
            entity.m_21195_(MobEffects.f_19615_);
        }
        if (entity.m_21023_(MobEffects.f_19620_) && stack.m_204117_(ItemTagGenerator.LEVITATION)) {
            entity.m_21195_(MobEffects.f_19620_);
        }
        if (entity.m_21023_(MobEffects.f_216964_) && stack.m_204117_(ItemTagGenerator.DARKNESS)) {
            entity.m_21195_(MobEffects.f_216964_);
        }
        if (entity.m_21023_(MobEffects.f_19604_) && stack.m_204117_(ItemTagGenerator.CONFUSION)) {
            entity.m_21195_(MobEffects.f_19604_);
        }
        if (stack.m_204117_(ItemTagGenerator.NIGHT_VISION) && entity.f_19797_ % 1 == 0) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 39, 0, false, false, false));
        }
        if (stack.m_204117_(ItemTagGenerator.WATER_BREATHING) && entity.f_19797_ % 1 == 0) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 39, 0, false, false, false));
        }
        if (entity.m_21023_(MobEffects.f_19599_) && stack.m_204117_(ItemTagGenerator.DIG_SLOWDOWN)) {
            entity.m_21195_(MobEffects.f_19599_);
        }
        if (stack.m_204117_(ItemTagGenerator.JUMP) && entity.f_19797_ % 1 == 0) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 39, 1, false, false, false));
        }
        if (stack.m_204117_(ItemTagGenerator.SUNBIRD_BLESSING) && entity.f_19797_ % 1 == 0) {
            entity.m_7292_(new MobEffectInstance((MobEffect)AMEffectRegistry.SUNBIRD_BLESSING.get(), 39, 1, false, false, false));
        }
        if (stack.m_204117_(ItemTagGenerator.SUNBIRD_CURSE) && entity.f_19797_ % 1 == 0) {
            entity.m_7292_(new MobEffectInstance((MobEffect)AMEffectRegistry.SUNBIRD_CURSE.get(), 39, 1, false, false, false));
        }
        if (stack.m_204117_(ItemTagGenerator.FLYING) && entity.f_19797_ % 1 == 0 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!FlightHelper.hasFlight((ServerPlayer)player) && player.m_9236_().m_46472_() != AOMDimension.THE_PATH_LEVEL) {
                FlightHelper.grantFlightTo((ServerPlayer)player);
                player.m_6885_();
            }
            if (player.m_9236_().m_46472_() == AOMDimension.THE_PATH_LEVEL) {
                FlightHelper.revokeFlight((ServerPlayer)player);
                player.m_6885_();
            }
        }
        if (this.attributeActive(entity, stack)) {
            for (AOMAttributeModifier modifier : this.getSkullProps().attributeModifiers) {
                AttributeModifier existingModifier;
                AttributeInstance attributeInstance = entity.m_21051_(modifier.getAttribute());
                if (attributeInstance == null || (existingModifier = attributeInstance.m_22111_(modifier.getModifierId())) != null && existingModifier.m_22218_() == modifier.getAmount()) continue;
                attributeInstance.m_22120_(modifier.getModifierId());
                attributeInstance.m_22125_(modifier.createModifier());
                modifier.onAttributeUpdated(entity);
            }
        }
        AOMSpecialSkullConfig.registerCurioTick(entity, stack, this.getSkullProps());
    }

    default public void removeEffect(LivingEntity entity, ItemStack stack) {
        ServerPlayer player;
        if (entity.m_21023_(MobEffects.f_19611_) && stack.m_204117_(ItemTagGenerator.NIGHT_VISION)) {
            entity.m_21195_(MobEffects.f_19611_);
        }
        if (entity.m_21023_(MobEffects.f_19608_) && stack.m_204117_(ItemTagGenerator.WATER_BREATHING)) {
            entity.m_21195_(MobEffects.f_19608_);
        }
        if (entity.m_21023_(MobEffects.f_19603_) && stack.m_204117_(ItemTagGenerator.JUMP)) {
            entity.m_21195_(MobEffects.f_19603_);
        }
        if (entity.m_21023_((MobEffect)AMEffectRegistry.SUNBIRD_BLESSING.get()) && stack.m_204117_(ItemTagGenerator.SUNBIRD_BLESSING)) {
            entity.m_21195_((MobEffect)AMEffectRegistry.SUNBIRD_BLESSING.get());
        }
        if (entity.m_21023_((MobEffect)AMEffectRegistry.SUNBIRD_CURSE.get()) && stack.m_204117_(ItemTagGenerator.SUNBIRD_CURSE)) {
            entity.m_21195_((MobEffect)AMEffectRegistry.SUNBIRD_CURSE.get());
        }
        if (stack.m_204117_(ItemTagGenerator.FLYING) && entity instanceof ServerPlayer && FlightHelper.hasFlight((ServerPlayer)(player = (ServerPlayer)entity))) {
            FlightHelper.revokeFlight((ServerPlayer)player);
            player.m_6885_();
        }
    }
}

