/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.item;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public abstract class AOMAttributeModifier {
    private final Attribute attribute;
    private final UUID modifierId;
    private final String modifierName;

    public AOMAttributeModifier(Attribute attribute, UUID modifierId, String modifierName) {
        this.attribute = attribute;
        this.modifierId = modifierId;
        this.modifierName = modifierName;
    }

    public AttributeModifier createModifier() {
        return new AttributeModifier(this.modifierId, this.modifierName, this.getAmount(), this.getOperation());
    }

    public AttributeModifier createModifier(int m) {
        return new AttributeModifier(this.modifierId, this.modifierName, this.getAmount() * (double)m, this.getOperation());
    }

    public AttributeModifier createModifier(int m, int a) {
        return new AttributeModifier(this.modifierId, this.modifierName, this.getAmount() * (double)m + (double)a, this.getOperation());
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public UUID getModifierId() {
        return this.modifierId;
    }

    public abstract double getAmount();

    public AttributeModifier.Operation getOperation() {
        return AttributeModifier.Operation.ADDITION;
    }

    public void onAttributeUpdated(LivingEntity entity) {
    }

    public static AOMAttributeModifier create(Attribute attribute, UUID modifierId, String modifierName, final Supplier<Double> amount) {
        return new AOMAttributeModifier(attribute, modifierId, modifierName){

            @Override
            public double getAmount() {
                return (Double)amount.get();
            }
        };
    }

    public static AOMAttributeModifier create_op(Attribute attribute, UUID modifierId, String modifierName, final Supplier<Double> amount, final AttributeModifier.Operation operation) {
        return new AOMAttributeModifier(attribute, modifierId, modifierName){

            @Override
            public double getAmount() {
                return (Double)amount.get();
            }

            @Override
            public AttributeModifier.Operation getOperation() {
                return operation;
            }
        };
    }
}

