/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.events;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ageofmythology", bus=Mod.EventBusSubscriber.Bus.MOD)
public class KeyMap {
    public static final String KEY_BIND_GENERAL_CATEGORY = "key.ageofmythology.group_1";
    public static final String KEY_BIND_QUICK_CAST_CATEGORY = "key.ageofmythology.group_2";
    public static final KeyMapping ABILITY_WHEEL_KEYMAP = new KeyMapping(KeyMap.getResourceName("ability_wheel"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 90, "key.ageofmythology.group_1");
    public static final KeyMapping MORPH_WHEEL_KEYMAP = new KeyMapping(KeyMap.getResourceName("morph_wheel"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 88, "key.ageofmythology.group_1");
    public static final List<KeyMapping> QUICK_CAST_MAPPINGS = KeyMap.createQuickCastKeybinds();

    private static String getResourceName(String name) {
        return String.format("key.%s.%s", "ageofmythology", name);
    }

    @SubscribeEvent
    public static void onRegisterKeybinds(RegisterKeyMappingsEvent event) {
        event.register(ABILITY_WHEEL_KEYMAP);
        event.register(MORPH_WHEEL_KEYMAP);
    }

    private static List<KeyMapping> createQuickCastKeybinds() {
        ArrayList<KeyMapping> qcm = new ArrayList<KeyMapping>();
        try {
            for (int i = 1; i <= 15; ++i) {
                qcm.add(new KeyMapping(KeyMap.getResourceName(String.format("ability_quick_cast_%d", i)), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, InputConstants.f_84822_.m_84873_(), KEY_BIND_QUICK_CAST_CATEGORY));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return qcm;
    }
}

