/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.events;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.config.CurioUtils;
import com.kurome.ageofmythology.events.KeyMap;
import com.kurome.ageofmythology.events.KeyState;
import com.kurome.ageofmythology.gui.AbilityWheelOverlay;
import com.kurome.ageofmythology.gui.MorphWheelOverlay;
import com.kurome.ageofmythology.init.AOMItems;
import com.kurome.ageofmythology.net.Messages;
import com.kurome.ageofmythology.net.ServerCastFireBall;
import java.util.ArrayList;
import liushuangwuyin.bettermorph.api.PlayerIdentity;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ageofmythology", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class AOMClientInputEvents {
    private static final ArrayList<KeyState> KEY_STATES = new ArrayList();
    private static final KeyState ABILITY_WHEEL_STATE = AOMClientInputEvents.register(KeyMap.ABILITY_WHEEL_KEYMAP);
    private static final KeyState MORPH_WHEEL_STATE = AOMClientInputEvents.register(KeyMap.MORPH_WHEEL_KEYMAP);

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        AOMClientInputEvents.handleInputEvent(event.getKey(), event.getAction());
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Pre event) {
        AOMClientInputEvents.handleInputEvent(event.getButton(), event.getAction());
        AOMClientInputEvents.registerMouseEvent(event);
    }

    public static void registerMouseEvent(InputEvent.MouseButton.Pre event) {
        int button = event.getButton();
        Player player = AgeOfMythologyMod.PROXY.getClientPlayer();
        if (player == null) {
            return;
        }
        if (button == 0 && event.getAction() == 1 && Minecraft.m_91087_().f_91080_ == null && CurioUtils.isEquipSkullCurio((LivingEntity)player, (Item)AOMItems.MINECRAFT_GHAST_ITEM.get())) {
            LivingEntity identity = PlayerIdentity.getIdentity((Player)player);
            if ((double)player.m_217043_().m_188501_() < 0.2 || identity != null && identity.m_6095_() == EntityType.f_20453_) {
                Messages.sendToServer(new ServerCastFireBall());
            }
        }
    }

    private static void handleInputEvent(int button, int action) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (ABILITY_WHEEL_STATE.wasPressed() && minecraft.f_91080_ == null) {
            AbilityWheelOverlay.instance.open();
        }
        if (ABILITY_WHEEL_STATE.wasReleased() && minecraft.f_91080_ == null && AbilityWheelOverlay.instance.active) {
            AbilityWheelOverlay.instance.close();
        }
        if (MORPH_WHEEL_STATE.wasPressed() && minecraft.f_91080_ == null) {
            MorphWheelOverlay.instance.open();
        }
        if (MORPH_WHEEL_STATE.wasReleased() && minecraft.f_91080_ == null && MorphWheelOverlay.instance.active) {
            MorphWheelOverlay.instance.close();
        }
        AOMClientInputEvents.update();
    }

    private static KeyState register(KeyMapping key) {
        KeyState k = new KeyState(key);
        KEY_STATES.add(k);
        return k;
    }

    private static void update() {
        for (KeyState k : KEY_STATES) {
            k.update();
        }
    }
}

