/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.entity.ShadowDemon;

import com.gametechbc.traveloptics.init.TravelopticsSpells;
import com.kurome.ageofmythology.advancement.AOMAdvancement;
import com.kurome.ageofmythology.capability.PlayerDataCapability;
import com.kurome.ageofmythology.config.ability_config.AOMAbilityConfig;
import com.kurome.ageofmythology.dimension.AOMDimension;
import com.kurome.ageofmythology.entity.AbstractBossEntity;
import com.kurome.ageofmythology.utils.BossFightUtil;
import com.kurome.ageofmythology.utils.TooltipUtil;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.entity.mobs.goals.AttackAnimationData;
import io.redspace.ironsspellbooks.entity.mobs.goals.PatrolNearLocationGoal;
import io.redspace.ironsspellbooks.entity.mobs.wizards.GenericAnimatedWarlockAttackGoal;
import io.redspace.ironsspellbooks.spells.lightning.ShockwaveSpell;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ShadowDemonEntity
extends AbstractBossEntity {
    private int transitionAnimationTime = 300;

    public ShadowDemonEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21365_ = this.createLookControl();
        this.f_21342_ = this.createMoveControl();
        if (pLevel.m_46472_().equals(AOMDimension.LOST_DREAM_LEVEL)) {
            this.setPhase(AbstractBossEntity.Phases.FinalPhase);
            this.setAbyssModePhaseGoals();
            this.setBossEventName(3);
        }
    }

    @Override
    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.setBossEventName();
    }

    public void setBossEventName() {
        MutableComponent nameComponent = this.m_5446_().m_6881_();
        MutableComponent phaseComponent = this.getPhase() == AbstractBossEntity.Phases.FirstPhase.value ? Component.m_237115_((String)"ageofmythology.entity.boss.shadow_demon.name.phase1") : Component.m_237115_((String)"ageofmythology.entity.boss.shadow_demon.name.phase2");
        this.bossEvent.m_6456_((Component)Component.m_237110_((String)"%s %s", (Object[])new Object[]{nameComponent, phaseComponent}));
    }

    public void setBossEventName(int mode) {
        MutableComponent nameComponent = this.m_5446_().m_6881_();
        MutableComponent phaseComponent = Component.m_237115_((String)"ageofmythology.entity.boss.shadow_demon.name.phase.%s".formatted(mode));
        this.bossEvent.m_6456_((Component)Component.m_237110_((String)"%s %s", (Object[])new Object[]{nameComponent, phaseComponent}));
    }

    protected void m_6153_() {
        if (this.f_20919_ == 10 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            for (Player player : BossFightUtil.getEntitiesNearby((LivingEntity)this, Player.class, 64.0)) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AOMAbilityConfig.playSound((Player)serverPlayer, SoundEvents.f_12275_);
                player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                    if (data.getExtraInfo().color_phase == 404) {
                        data.getExtraInfo().setColorPhase(6);
                        data.sync(player);
                        TooltipUtil.delayTitleText(player, (Component)Component.m_237115_((String)"ageofmythology.dream_ritual.phase7.desc1"), 0);
                        TooltipUtil.delayTitleText(player, (Component)Component.m_237115_((String)"ageofmythology.dream_ritual.phase7.desc2"), 3000);
                        AOMAdvancement.DREAM_P7_RITUAL_TRIGGER.trigger(serverPlayer);
                    }
                });
            }
        }
        super.m_6153_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.isPhase(AbstractBossEntity.Phases.FirstPhase)) {
                this.setBossEventName();
                if ((double)this.m_21223_() <= (double)this.m_21233_() * 0.5) {
                    this.setPhase(AbstractBossEntity.Phases.Transitioning);
                    Player player = this.m_9236_().m_45930_((Entity)this, 16.0);
                    if (player != null) {
                        this.m_21391_((Entity)player, 360.0f, 360.0f);
                    }
                }
            } else if (this.isPhase(AbstractBossEntity.Phases.Transitioning)) {
                if (this.transitionAnimationTime == 298) {
                    this.m_9236_().m_254849_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, Level.ExplosionInteraction.NONE);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                    new ShockwaveSpell().onCast(this.m_9236_(), 5, (LivingEntity)this, CastSource.MOB, new MagicData(true));
                    this.setTransitionPhaseGoals();
                }
                if (this.transitionAnimationTime == 250 || this.transitionAnimationTime == 1) {
                    int distance = this.transitionAnimationTime / 50;
                    for (int i = 0; i < 10; ++i) {
                        double angle = Math.toRadians(i * 36);
                        double x = this.m_20185_() + Math.cos(angle) * 10.0 * (double)distance;
                        double z = this.m_20189_() + Math.sin(angle) * 10.0 * (double)distance;
                        LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                        if (lightning == null) continue;
                        lightning.m_6027_(x, this.m_20186_(), z);
                        this.m_9236_().m_7967_((Entity)lightning);
                    }
                }
                if (--this.transitionAnimationTime <= 0) {
                    this.setPhase(AbstractBossEntity.Phases.FinalPhase);
                    this.setFinalPhaseGoals();
                    this.setBossEventName();
                }
            } else if (this.isPhase(AbstractBossEntity.Phases.FinalPhase)) {
                // empty if block
            }
        }
    }

    @Override
    protected void m_8099_() {
        this.setFirstPhaseGoals();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractIllager.class, true));
    }

    @Override
    protected void setFirstPhaseGoals() {
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21345_.m_262460_(x -> true);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GenericAnimatedWarlockAttackGoal((PathfinderMob)this, 1.25, 50, 75, 3.0f).setMoveset(List.of(new AttackAnimationData(9, "simple_sword_upward_swipe", new int[]{5}), new AttackAnimationData(8, "simple_sword_lunge_stab", new int[]{6}), new AttackAnimationData(10, "simple_sword_stab_alternate", new int[]{8}), new AttackAnimationData(10, "simple_sword_horizontal_cross_swipe", new int[]{8}))).setComboChance(0.4f).setMeleeAttackInverval(10, 30).setMeleeMovespeedModifier(1.5f).setSpells(List.of((AbstractSpell)SpellRegistry.ARROW_VOLLEY_SPELL.get()), List.of((AbstractSpell)SpellRegistry.GUST_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.HEAL_SPELL.get(), (AbstractSpell)SpellRegistry.INVISIBILITY_SPELL.get())));
        this.f_21345_.m_25352_(5, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 32.0f, (double)0.9f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    protected void setTransitionPhaseGoals() {
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21345_.m_262460_(x -> true);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
    }

    protected void setFinalPhaseGoals() {
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21345_.m_262460_(x -> true);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GenericAnimatedWarlockAttackGoal((PathfinderMob)this, 1.25, 50, 75, 3.0f).setMoveset(List.of(new AttackAnimationData(9, "simple_sword_upward_swipe", new int[]{5}), new AttackAnimationData(8, "simple_sword_lunge_stab", new int[]{6}), new AttackAnimationData(10, "simple_sword_stab_alternate", new int[]{8}), new AttackAnimationData(10, "simple_sword_horizontal_cross_swipe", new int[]{8}))).setComboChance(0.4f).setMeleeAttackInverval(10, 30).setMeleeMovespeedModifier(1.5f).setSpellQuality(2.0f, 4.0f).setSpells(List.of((AbstractSpell)SpellRegistry.ACID_ORB_SPELL.get(), (AbstractSpell)SpellRegistry.POISON_ARROW_SPELL.get(), (AbstractSpell)SpellRegistry.POISON_BREATH_SPELL.get(), (AbstractSpell)SpellRegistry.POISON_SPLASH_SPELL.get()), List.of((AbstractSpell)SpellRegistry.ROOT_SPELL.get(), (AbstractSpell)SpellRegistry.STOMP_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.SPIDER_ASPECT_SPELL.get())));
        this.f_21345_.m_25352_(5, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 32.0f, (double)0.9f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    protected void setAbyssModePhaseGoals() {
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21345_.m_262460_(x -> true);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GenericAnimatedWarlockAttackGoal((PathfinderMob)this, 1.25, 20, 65, 3.0f).setComboChance(0.4f).setSpellQuality(3.0f, 5.0f).setSpells(List.of((AbstractSpell)TravelopticsSpells.ABYSSAL_BLAST_SPELL.get(), (AbstractSpell)TravelopticsSpells.EXTINCTION_SPELL.get(), (AbstractSpell)TravelopticsSpells.VORTEX_PUNCH_SPELL.get()), List.of((AbstractSpell)TravelopticsSpells.EM_PULSE.get()), List.of((AbstractSpell)SpellRegistry.TELEPORT_SPELL.get(), (AbstractSpell)SpellRegistry.EVASION_SPELL.get()), List.of((AbstractSpell)TravelopticsSpells.BLACKOUT_SPELL.get())));
        this.f_21345_.m_25352_(5, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 32.0f, (double)0.9f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    @Override
    public void startMusic(ServerPlayer player) {
    }

    @Override
    public void stopMusic(ServerPlayer player) {
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("phase", this.getPhase());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (this.isPhase(AbstractBossEntity.Phases.FinalPhase)) {
            this.setFinalPhaseGoals();
        } else if (this.isPhase(AbstractBossEntity.Phases.Transitioning)) {
            this.setTransitionPhaseGoals();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22278_, 0.6).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22277_, 64.0);
    }
}

