/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.entity.EntityPart;

import com.kurome.ageofmythology.api.ITitan;
import com.kurome.ageofmythology.init.AOMEntities;
import com.mojang.logging.LogUtils;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;

public class EntityPart
extends Entity {
    private static final EntityDataAccessor<Float> WIDTH = SynchedEntityData.m_135353_(EntityPart.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> HEIGHT = SynchedEntityData.m_135353_(EntityPart.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;

    public EntityPart(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public EntityPart(LivingEntity parent, float width, float height) {
        this((EntityType)AOMEntities.ENTITY_PART.get(), parent.m_9236_());
        this.setOwner((Entity)parent);
        this.setSize(width, height);
        this.m_6210_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(WIDTH, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(HEIGHT, (Object)Float.valueOf(1.0f));
    }

    public float getWidth() {
        return ((Float)this.f_19804_.m_135370_(WIDTH)).floatValue();
    }

    public void setWidth(float width) {
        this.f_19804_.m_135381_(WIDTH, (Object)Float.valueOf(width));
    }

    public float getHeight() {
        return ((Float)this.f_19804_.m_135370_(HEIGHT)).floatValue();
    }

    public void setHeight(float height) {
        this.f_19804_.m_135381_(HEIGHT, (Object)Float.valueOf(height));
    }

    public void setSize(float width, float height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setOwner(@Nullable Entity owner) {
        if (owner != null) {
            this.ownerUUID = owner.m_20148_();
            this.cachedOwner = owner;
        }
    }

    @Nullable
    public Entity getOwner() {
        Level var2;
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (var2 = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var2;
            this.cachedOwner = serverlevel.m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        Entity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entity != null ? entity.m_19879_() : 0);
    }

    public void m_141965_(ClientboundAddEntityPacket entityPacket) {
        super.m_141965_(entityPacket);
        Entity entity = this.m_9236_().m_6815_(entityPacket.m_131509_());
        if (entity != null) {
            this.setOwner(entity);
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)this.getWidth(), (float)this.getHeight());
    }

    public boolean m_7306_(Entity entity) {
        return this == entity || this.getOwner() == entity;
    }

    public boolean m_142391_() {
        return false;
    }

    public void updateFluidHeightAndDoFluidPushing(Predicate<FluidState> shouldUpdate) {
    }

    public void m_142687_(Entity.RemovalReason reason) {
        LivingEntity livingEntity;
        Entity entity;
        if ((reason == Entity.RemovalReason.KILLED || reason == Entity.RemovalReason.DISCARDED) && this.m_9236_().m_46805_(this.m_20183_()) && this.getOwner() != null && this.getOwner() instanceof ITitan && (entity = this.getOwner()) instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_213877_()) {
            return;
        }
        super.m_142687_(reason);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        Entity entity;
        LogUtils.getLogger().info("EntityPart hurt 1 %s %s".formatted(damageSource.m_7639_(), Float.valueOf(amount)));
        if (!this.m_6673_(damageSource) && this.getOwner() != null && (entity = this.getOwner()) instanceof ITitan) {
            ITitan iTitan = (ITitan)entity;
            LogUtils.getLogger().info("EntityPart hurt 2 %s %s".formatted(damageSource.m_7639_(), Float.valueOf(amount)));
            return iTitan.partHurt(this, damageSource, amount);
        }
        LogUtils.getLogger().info("EntityPart hurt 3 %s %s".formatted(damageSource.m_7639_(), Float.valueOf(amount)));
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6210_();
        if (!this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
        if (this.getOwner() != null) {
            this.m_146868_(this.getOwner().m_6060_());
        }
    }

    public void m_7378_(CompoundTag tag) {
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
            this.cachedOwner = null;
        }
        this.setWidth(tag.m_128457_("Width"));
        this.setHeight(tag.m_128457_("Height"));
    }

    public void m_7380_(CompoundTag tag) {
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
        tag.m_128350_("Width", this.getWidth());
        tag.m_128350_("Height", this.getHeight());
    }

    public boolean m_6087_() {
        return true;
    }

    public ItemStack getPickedResult(HitResult target) {
        if (this.cachedOwner != null) {
            ItemStack itemStack = this.cachedOwner.m_142340_();
            return itemStack == null ? ItemStack.f_41583_ : itemStack;
        }
        return ItemStack.f_41583_;
    }
}

