/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.entity;

import com.mojang.logging.LogUtils;
import io.redspace.ironsspellbooks.entity.mobs.IAnimatedAttacker;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public abstract class AbstractBossEntity
extends AbstractSpellCastingMob
implements Enemy,
IAnimatedAttacker {
    public final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(AbstractBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final AttributeModifier PHASE_SPEED_MODIFY = new AttributeModifier(UUID.fromString("28633ddc-9cca-45e9-b782-0b104bf423a9"), "phase_speed_modify", -100.0, AttributeModifier.Operation.ADDITION);
    private final RawAnimation phase_transition_animation = RawAnimation.begin().thenPlay("dead_king_rise");
    RawAnimation animationToPlay = null;
    private int transitionAnimationTime = 300;
    private final AnimationController<AbstractBossEntity> transitionController = new AnimationController((GeoAnimatable)this, "abstract_boss_transition", 0, this::transitionPredicate);
    public final AnimationController<AbstractBossEntity> meleeController = new AnimationController((GeoAnimatable)this, "abstract_boss_animations", 0, this::meleePredicate);

    private PlayState meleePredicate(AnimationState<AbstractBossEntity> animationEvent) {
        AnimationController controller = animationEvent.getController();
        if (this.animationToPlay != null) {
            controller.forceAnimationReset();
            controller.setAnimation(this.animationToPlay);
            this.animationToPlay = null;
        }
        return this.transitionController.getAnimationState() == AnimationController.State.STOPPED ? PlayState.CONTINUE : PlayState.STOP;
    }

    private PlayState transitionPredicate(AnimationState animationEvent) {
        AnimationController controller = animationEvent.getController();
        if (this.isPhase(Phases.Transitioning)) {
            controller.setAnimation(this.phase_transition_animation);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void playAnimation(String animationId) {
        try {
            this.animationToPlay = RawAnimation.begin().thenPlay(animationId);
        }
        catch (Exception ignored) {
            LogUtils.getLogger().error("Entity {} Failed to play animation: {}", (Object)this, (Object)animationId);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.transitionController});
        controllerRegistrar.add(new AnimationController[]{this.meleeController});
        super.registerControllers(controllerRegistrar);
    }

    public boolean shouldAlwaysAnimateHead() {
        return !this.isPhase(Phases.Transitioning);
    }

    public boolean shouldAlwaysAnimateLegs() {
        return this.isPhase(Phases.FirstPhase);
    }

    public boolean isAnimating() {
        return this.transitionController.getAnimationState() != AnimationController.State.STOPPED || this.meleeController.getAnimationState() != AnimationController.State.STOPPED || super.isAnimating();
    }

    public AbstractBossEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21365_ = this.createLookControl();
        this.f_21342_ = this.createMoveControl();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (this.isPhase(Phases.Transitioning)) {
            return false;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    protected void m_8099_() {
        this.setFirstPhaseGoals();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractIllager.class, true));
    }

    protected abstract void setFirstPhaseGoals();

    public abstract void startMusic(ServerPlayer var1);

    public abstract void stopMusic(ServerPlayer var1);

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
        this.startMusic(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
        this.stopMusic(pPlayer);
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public void setPhase(Phases phase) {
        this.setPhase(phase.value);
    }

    public boolean isPhase(Phases phase) {
        return phase.value == this.getPhase();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("phase", this.getPhase());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (this.m_8077_()) {
            this.m_6593_(this.m_5446_());
        }
        this.setPhase(pCompound.m_128451_("phase"));
        if (this.isPhase(Phases.FinalPhase)) {
            // empty if block
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PHASE, (Object)0);
    }

    protected LookControl createLookControl() {
        return new LookControl((Mob)this){

            protected float m_24956_(float pFrom, float pTo, float pMaxDelta) {
                return super.m_24956_(pFrom, pTo, pMaxDelta * 2.5f);
            }

            protected boolean m_8106_() {
                return AbstractBossEntity.this.m_5448_() == null;
            }
        };
    }

    protected MoveControl createMoveControl() {
        return new MoveControl((Mob)this){

            protected float m_24991_(float pSourceAngle, float pTargetAngle, float pMaximumChange) {
                double d1;
                double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                if (d0 * d0 + (d1 = this.f_24977_ - this.f_24974_.m_20189_()) * d1 < 0.5) {
                    return pSourceAngle;
                }
                return super.m_24991_(pSourceAngle, pTargetAngle, pMaximumChange * 0.25f);
            }
        };
    }

    public static enum Phases {
        FirstPhase(0),
        Transitioning(1),
        FinalPhase(2);

        public final int value;

        private Phases(int value) {
            this.value = value;
        }
    }
}

