/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.effect;

import com.kurome.ageofmythology.advancement.AOMAdvancement;
import com.kurome.ageofmythology.config.CurioUtils;
import com.kurome.ageofmythology.init.AOMItems;
import com.kurome.ageofmythology.init.AOMMobEffect;
import com.kurome.ageofmythology.item.blood.BloodCoreItem;
import com.kurome.ageofmythology.item.general.BloodBottleItem;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BloodBathEffect
extends MobEffect {
    public BloodBathEffect(MobEffectCategory mobEffectCategory, int color) {
        super(mobEffectCategory, color);
    }

    public void m_6742_(LivingEntity livingEntity, int level) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            Optional<BloodBottleItem.BloodLevel> bloodLevelOptional = Arrays.stream(BloodBottleItem.BloodLevel.values()).filter(level1 -> level1.level == level + 1).findFirst();
            BloodBottleItem.BloodLevel bloodLevel = bloodLevelOptional.orElse(BloodBottleItem.BloodLevel.LEVEL_1);
            double damage = Math.max((double)serverPlayer.m_21233_() * bloodLevel.damage, 2.0);
            MobEffectInstance instance = serverPlayer.m_21124_((MobEffect)AOMMobEffect.BLOOD_BATH.get());
            if (instance != null) {
                int duration = instance.m_19557_();
                ItemStack bloodCore = CurioUtils.getEquipSkullCurio((LivingEntity)serverPlayer, (Item)AOMItems.AGEOFMYTHOLOGY_BLOOD_CORE_ITEM.get());
                if (bloodCore != null) {
                    int coreLevel = BloodCoreItem.getCoreLevel(bloodCore) + 1;
                    double upgradeKillCount = BloodCoreItem.getUpgradeKillCount(bloodCore);
                    int requiredKillCount = BloodCoreItem.getUpgradeRequiredKillCount(coreLevel);
                    if (coreLevel <= Math.min(6, bloodLevel.level) && duration <= 20 && !serverPlayer.m_21224_() && upgradeKillCount >= (double)requiredKillCount) {
                        BloodCoreItem.upgrade(bloodCore);
                        if (bloodLevel.level == 1) {
                            AOMAdvancement.FIRST_BLOOD_EVOLUTION_TRIGGER.trigger(serverPlayer);
                        } else if (bloodLevel.level == 2) {
                            AOMAdvancement.SECOND_BLOOD_EVOLUTION_TRIGGER.trigger(serverPlayer);
                        } else if (bloodLevel.level == 3) {
                            AOMAdvancement.THIRD_BLOOD_EVOLUTION_TRIGGER.trigger(serverPlayer);
                        } else if (bloodLevel.level == 4) {
                            AOMAdvancement.FOURTH_BLOOD_EVOLUTION_TRIGGER.trigger(serverPlayer);
                        } else if (bloodLevel.level == 5) {
                            AOMAdvancement.FIFTH_BLOOD_EVOLUTION_TRIGGER.trigger(serverPlayer);
                        } else if (bloodLevel.level == 6) {
                            AOMAdvancement.SIX_BLOOD_EVOLUTION_TRIGGER.trigger(serverPlayer);
                        }
                    }
                }
            }
            serverPlayer.m_6469_(livingEntity.m_269291_().m_269425_(), (float)damage);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 20 == 0;
    }
}

