/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.dimension.teleporter;

import com.kurome.ageofmythology.dimension.AOMDimension;
import com.kurome.ageofmythology.dimension.ThePathTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.AbyssalChasmTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.CandyCavityTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.ForlornHollowsTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.LostDreamTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.LostEndTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.MagneticCavesTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.NormalTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.PrimordialCavesTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.TheEndlessTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.ToxicCavesTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.the_poles.BloodNetherTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.the_poles.ChaosRealmTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.the_poles.DeepDesertTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.the_poles.FrozenRealmTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.the_poles.MagicForestTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.the_poles.PutridCathedralTeleporter;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.ITeleporter;

public class TeleporterUtils {
    public static HashMap<ResourceKey<Level>, Supplier<ITeleporter>> dimensionMap = new HashMap<ResourceKey<Level>, Supplier<ITeleporter>>(){
        {
            this.put(AOMDimension.THE_ENDLESS_LEVEL, TheEndlessTeleporter::new);
            this.put(AOMDimension.ABYSSAL_CHASM_LEVEL, AbyssalChasmTeleporter::new);
            this.put(AOMDimension.MAGNETIC_CAVES_LEVEL, MagneticCavesTeleporter::new);
            this.put(AOMDimension.CANDY_CAVITY_LEVEL, CandyCavityTeleporter::new);
            this.put(AOMDimension.FORLORN_HOLLOWS_LEVEL, ForlornHollowsTeleporter::new);
            this.put(AOMDimension.PRIMORDIAL_CAVES_LEVEL, PrimordialCavesTeleporter::new);
            this.put(AOMDimension.TOXIC_CAVES_LEVEL, ToxicCavesTeleporter::new);
            this.put(AOMDimension.BLOOD_NETHER_LEVEL, BloodNetherTeleporter::new);
            this.put(AOMDimension.CHAOS_REALM_LEVEL, ChaosRealmTeleporter::new);
            this.put(AOMDimension.DEEP_DESERT_LEVEL, DeepDesertTeleporter::new);
            this.put(AOMDimension.FROZEN_REALM_LEVEL, FrozenRealmTeleporter::new);
            this.put(AOMDimension.MAGIC_FOREST_LEVEL, MagicForestTeleporter::new);
            this.put(AOMDimension.PUTRID_CATHEDRAL_LEVEL, PutridCathedralTeleporter::new);
            this.put(AOMDimension.LOST_DREAM_LEVEL, LostDreamTeleporter::new);
            this.put(AOMDimension.LOST_END_LEVEL, LostEndTeleporter::new);
            this.put(Level.f_46429_, NormalTeleporter::new);
        }
    };

    public static ITeleporter getDimensionTeleporter(ResourceKey<Level> key) {
        return dimensionMap.getOrDefault(key, ThePathTeleporter::new).get();
    }

    private static ResourceKey<Level> getDestination(Entity entity, ResourceKey<Level> targetDimension) {
        return !entity.m_20193_().m_46472_().equals(targetDimension) ? targetDimension : Level.f_46428_;
    }

    public static void changeEntityDimension(Entity entity, ResourceKey<Level> targetDimension) {
        if (!entity.m_6084_() || entity.m_9236_().m_5776_()) {
            return;
        }
        if (entity.m_20159_() || entity.m_20160_() || !entity.m_6072_()) {
            return;
        }
        ResourceKey<Level> destination = TeleporterUtils.getDestination(entity, targetDimension);
        ServerLevel serverWorld = entity.m_20193_().m_7654_().m_129880_(destination);
        if (serverWorld == null) {
            return;
        }
        entity.changeDimension(serverWorld, TeleporterUtils.getDimensionTeleporter(targetDimension));
    }

    public static void changeEntityDimension(Entity entity, ResourceKey<Level> targetDimension, ITeleporter teleporter) {
        if (!entity.m_6084_() || entity.m_9236_().m_5776_()) {
            return;
        }
        if (entity.m_20159_() || entity.m_20160_() || !entity.m_6072_()) {
            return;
        }
        ResourceKey<Level> destination = TeleporterUtils.getDestination(entity, targetDimension);
        ServerLevel serverWorld = entity.m_20193_().m_7654_().m_129880_(destination);
        if (serverWorld == null) {
            return;
        }
        entity.changeDimension(serverWorld, teleporter);
    }
}

