/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.dimension;

import com.kurome.ageofmythology.dimension.AOMDimension;
import com.kurome.ageofmythology.dimension.AOMDimensionSaveData;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public class ThePathTeleporter
implements ITeleporter {
    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        if (destWorld.m_46472_() != AOMDimension.THE_PATH_LEVEL) {
            ServerPlayer player;
            if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).m_8963_() == destWorld.m_46472_()) {
                BlockPos pos = player.m_8961_();
                if (pos != null) {
                    Optional optional = Player.m_36130_((ServerLevel)destWorld, (BlockPos)pos, (float)player.m_8962_(), (boolean)player.m_8964_(), (boolean)true);
                    if (optional.isPresent()) {
                        pos = new BlockPos(new Vec3i((int)((Vec3)optional.get()).f_82479_, (int)((Vec3)optional.get()).f_82480_, (int)((Vec3)optional.get()).f_82481_));
                    }
                } else {
                    pos = destWorld.m_220360_();
                }
                return new PortalInfo(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), Vec3.f_82478_, player.m_8962_(), 0.0f);
            }
            return super.getPortalInfo(entity, destWorld, defaultPortalInfo);
        }
        AOMDimensionSaveData saveData = AOMDimensionSaveData.get(destWorld.m_7654_().m_129783_());
        Vec3 pos = saveData.getEntrancePos();
        return new PortalInfo(pos, Vec3.f_82478_, 0.0f, 0.0f);
    }

    private static ResourceKey<Level> getDestination(Entity entity) {
        return !entity.m_20193_().m_46472_().equals(AOMDimension.THE_PATH_LEVEL) ? AOMDimension.THE_PATH_LEVEL : Level.f_46428_;
    }

    public static void changeEntityDimension(Entity entity) {
        if (!entity.m_6084_() || entity.m_9236_().m_5776_()) {
            return;
        }
        if (entity.m_20159_() || entity.m_20160_() || !entity.m_6072_()) {
            return;
        }
        ResourceKey<Level> destination = ThePathTeleporter.getDestination(entity);
        ServerLevel serverWorld = entity.m_20193_().m_7654_().m_129880_(destination);
        if (serverWorld == null) {
            return;
        }
        entity.changeDimension(serverWorld, (ITeleporter)new ThePathTeleporter());
    }
}

