/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.dimension;

import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.advancement.AOMAdvancement;
import com.kurome.ageofmythology.advancement.criterion.RedemptionTrigger;
import com.kurome.ageofmythology.api.ILevel;
import com.kurome.ageofmythology.block.AOMSkullBlock;
import com.kurome.ageofmythology.block.AOMSkullWallBlock;
import com.kurome.ageofmythology.capability.PlayerDataCapability;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.dimension.AOMDimension;
import com.kurome.ageofmythology.dimension.AOMDimensionSaveData;
import com.kurome.ageofmythology.dimension.DimensionBuildHelper;
import com.kurome.ageofmythology.dimension.teleporter.NormalTeleporter;
import com.kurome.ageofmythology.dimension.teleporter.TeleporterUtils;
import com.kurome.ageofmythology.item.AOMSkullItem;
import com.kurome.ageofmythology.net.Messages;
import com.kurome.ageofmythology.net.general.ClientSyncToolTip;
import com.kurome.ageofmythology.net.the_fool.ClientSyncUpdateDimensionTime;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import liushuangwuyin.bettermorph.Identity;
import liushuangwuyin.bettermorph.api.FlightHelper;
import liushuangwuyin.bettermorph.api.platform.IdentityConfig;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import twilightforest.world.registration.TFGenerationSettings;

@Mod.EventBusSubscriber(modid="ageofmythology", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DimensionEvent {
    private static final UUID THE_PATH_DEBUFF_UUID = UUID.fromString("9092399d-5ab2-4c43-b541-6ece5c02abee");

    @SubscribeEvent
    public static void loadThePath(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            if (serverLevel.m_46472_() == AOMDimension.THE_PATH_LEVEL) {
                ServerLevel level;
                MinecraftServer server = serverLevel.m_7654_();
                AOMDimensionSaveData saveData = AOMDimensionSaveData.get(server.m_129783_());
                if (!saveData.isLoaded() && (level = server.m_129880_(AOMDimension.THE_PATH_LEVEL)) != null) {
                    DimensionBuildHelper.thePathBuild((Level)level);
                    saveData.setLoaded(true);
                }
            } else if (serverLevel.m_46472_() == AOMDimension.THE_ENDLESS_LEVEL) {
                ServerLevel level;
                MinecraftServer server = serverLevel.m_7654_();
                AOMDimensionSaveData saveData = AOMDimensionSaveData.get(server.m_129783_());
                if (!saveData.isLoadedTheEndless() && (level = server.m_129880_(AOMDimension.THE_ENDLESS_LEVEL)) != null) {
                    DimensionBuildHelper.theEndlessBuild((Level)level);
                    saveData.setLoadedTheEndless(true);
                }
            } else if (serverLevel.m_46472_() == AOMDimension.BEAST_ARENA_LEVEL) {
                ServerLevel level;
                MinecraftServer server = serverLevel.m_7654_();
                AOMDimensionSaveData saveData = AOMDimensionSaveData.get(server.m_129783_());
                if (!saveData.isLoadedBeastArena() && (level = server.m_129880_(AOMDimension.BEAST_ARENA_LEVEL)) != null) {
                    DimensionBuildHelper.beastArenaBuild((Level)level);
                    saveData.setLoadedBeastArena(true);
                }
            } else if (serverLevel.m_46472_() == TFGenerationSettings.DIMENSION_KEY) {
                MinecraftServer server = serverLevel.m_7654_();
                AOMDimensionSaveData saveData = AOMDimensionSaveData.get(server.m_129783_());
                try {
                    ServerLevel level = server.m_129880_(TFGenerationSettings.DIMENSION_KEY);
                    if (level != null) {
                        long fixedTime = saveData.getTwilightFixedTime();
                        if (fixedTime > 0L) {
                            ((ILevel)level.m_6042_()).updateTfTime(fixedTime);
                            Messages.sendToAllPlayers(new ClientSyncUpdateDimensionTime(fixedTime));
                        }
                        LogUtils.getLogger().info("DimensionEvent load event updateTfTime %s".formatted(fixedTime));
                    }
                }
                catch (Exception e) {
                    LogUtils.getLogger().error("DimensionEvent load event updateTfTime error %s".formatted(e.toString()));
                }
            } else if (serverLevel.m_46472_() == AetherDimensions.AETHER_LEVEL) {
                MinecraftServer server = serverLevel.m_7654_();
                AOMDimensionSaveData saveData = AOMDimensionSaveData.get(server.m_129783_());
                try {
                    ServerLevel level = server.m_129880_(AetherDimensions.AETHER_LEVEL);
                    if (level != null) {
                        long fixedTime = saveData.getAetherFixedTime();
                        if (fixedTime > 0L) {
                            ((ILevel)level.m_6042_()).updateAetherTime(fixedTime);
                        }
                        LogUtils.getLogger().info("DimensionEvent load event updateAetherTime %s".formatted(fixedTime));
                    }
                }
                catch (Exception e) {
                    LogUtils.getLogger().error("DimensionEvent load event updateAetherTime error %s".formatted(e.toString()));
                }
            }
        }
    }

    private static List<StructureTemplate> loadTemplates(StructureTemplateManager manager) {
        ArrayList<StructureTemplate> templates = new ArrayList<StructureTemplate>();
        for (int i = 0; i < 1; ++i) {
            String var10000;
            switch (i) {
                default: 
            }
            String path = var10000 = "";
            ResourceLocation resourceLocation = AgeOfMythologyMod.prefix(path);
            templates.add(manager.m_230359_(resourceLocation));
        }
        return templates;
    }

    @SubscribeEvent
    public static void Tick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_9236_().m_46472_().equals((Object)Level.f_46429_) && player.f_19797_ % 20 == 0) {
            if (player.m_20186_() <= -32.0 && AOMUtil.checkAdvancementProgress((LivingEntity)player, RedemptionTrigger.ID)) {
                TeleporterUtils.changeEntityDimension((Entity)player, AOMDimension.BLOOD_NETHER_LEVEL);
            }
            if (player.m_20186_() >= 192.0 && AOMUtil.checkAdvancementProgress((LivingEntity)player, RedemptionTrigger.ID)) {
                TeleporterUtils.changeEntityDimension((Entity)player, AOMDimension.PUTRID_CATHEDRAL_LEVEL);
            }
        } else if (player.m_9236_().m_46472_().equals(AOMDimension.PUTRID_CATHEDRAL_LEVEL) && player.f_19797_ % 5 == 0) {
            if (player.m_20186_() <= 0.0) {
                TeleporterUtils.changeEntityDimension((Entity)player, (ResourceKey<Level>)Level.f_46429_, new NormalTeleporter(1));
            }
        } else if (player.m_9236_().m_46472_().equals(AOMDimension.BLOOD_NETHER_LEVEL) && player.f_19797_ % 5 == 0 && player.m_20186_() >= 160.0) {
            TeleporterUtils.changeEntityDimension((Entity)player, (ResourceKey<Level>)Level.f_46429_, new NormalTeleporter(2));
        }
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (Identity.hasFlyingPermissions((ServerPlayer)serverPlayer)) {
                FlightHelper.grantFlightTo((ServerPlayer)serverPlayer);
                player.m_150110_().m_35943_(IdentityConfig.getInstance().flySpeed());
                player.m_6885_();
            } else {
                FlightHelper.revokeFlight((ServerPlayer)serverPlayer);
                player.m_150110_().m_35943_(0.05f);
                player.m_6885_();
            }
            if (serverPlayer.m_9236_().m_46472_() == AOMDimension.THE_PATH_LEVEL) {
                Messages.sendToPlayer(new ClientSyncToolTip(ClientSyncToolTip.ToolTipType.OVERLAY_MESSAGE.getId(), (Component)Component.m_237115_((String)"ageofmythology.tooltip.the_path.disable.flying")), serverPlayer);
            }
            if (event.getTo().equals(AOMDimension.LOST_DREAM_LEVEL)) {
                AOMAdvancement.DREAM_P1_RITUAL_TRIGGER.trigger(serverPlayer);
            }
            if (event.getTo().equals(AOMDimension.PUTRID_CATHEDRAL_LEVEL)) {
                player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                    data.getExtraInfo().set_pride_sin_lord_boss_fight(0);
                    data.sync((Player)serverPlayer);
                });
            }
        }
    }

    public static boolean flyingPermissionsCheck(Player player) {
        return true;
    }

    @SubscribeEvent
    public static void RightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Item item = player.m_21120_(event.getHand()).m_41720_();
        Block block = player.m_9236_().m_8055_(event.getPos()).m_60734_();
        if (!(player.m_9236_().m_46472_() != AOMDimension.THE_PATH_LEVEL || player.m_7500_() || item instanceof AOMSkullItem || block instanceof WaystoneBlock)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Messages.sendToPlayer(new ClientSyncToolTip(ClientSyncToolTip.ToolTipType.OVERLAY_MESSAGE.getId(), (Component)Component.m_237115_((String)"ageofmythology.tooltip.the_path.right_click.fail")), serverPlayer);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        Level level;
        Player player = event.getPlayer();
        BlockPos pos = event.getPos();
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level) || (level = (Level)levelAccessor).m_5776_()) {
            return;
        }
        if (level.m_46472_().equals(AOMDimension.THE_PATH_LEVEL) && !player.m_7500_() && !(event.getState().m_60734_() instanceof AOMSkullBlock) && !(event.getState().m_60734_() instanceof AOMSkullWallBlock)) {
            event.setCanceled(true);
        }
    }

    private static void modifyAttribute(LivingEntity entity, Attribute attribute, UUID uuid, String name, Double value, AttributeModifier.Operation operation) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            AttributeModifier modify = instance.m_22111_(uuid);
            if (modify != null) {
                instance.m_22120_(uuid);
            }
            AttributeModifier attr = new AttributeModifier(uuid, name, value.doubleValue(), operation);
            instance.m_22125_(attr);
        }
    }

    private static void removeAttribute(LivingEntity entity, Attribute attribute, UUID uuid) {
        AttributeModifier modify;
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null && (modify = instance.m_22111_(uuid)) != null) {
            instance.m_22120_(uuid);
        }
    }
}

