/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.dimension;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.kyanite.deeperdarker.content.DDBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.common.util.TriPredicate;

public class DimensionBuildHelper {
    public static Vec3i globalOffset = new Vec3i(0, 0, 0);

    public static int thePathBuild(Level level) {
        DimensionBuildHelper.build(level, new Vec3i(0, 0, 0), false);
        DimensionBuildHelper.build(level, new Vec3i(1000000, 0, 0), true);
        return 1;
    }

    public static int theEndlessBuild(Level level) {
        BlockPos startPosition = new BlockPos(0, 0, 0);
        DimensionBuildHelper.buildPlatform(level, startPosition, 50, Blocks.f_50714_);
        return 1;
    }

    public static int beastArenaBuild(Level level) {
        BlockPos startPosition = new BlockPos(0, 0, 0);
        DimensionBuildHelper.buildPlatform(level, startPosition, 50, Blocks.f_50222_);
        return 1;
    }

    public static int build(Level level, Vec3i offset, boolean isMirror) {
        globalOffset = offset;
        int length = 50;
        int width = 40;
        int height = 50;
        BlockPos startPosition = new BlockPos(1, 1, 0);
        DimensionBuildHelper.buildWall(level, startPosition, 40, 50, 0, 0, Blocks.f_50222_);
        startPosition = new BlockPos(17, 2, 5);
        level.m_7731_(startPosition, (BlockState)ModBlocks.waystone.m_49966_().m_61124_((Property)WaystoneBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
        level.m_7731_(startPosition.m_7494_(), (BlockState)ModBlocks.waystone.m_49966_().m_61124_((Property)WaystoneBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        startPosition = new BlockPos(1, 1, 1);
        DimensionBuildHelper.buildTunnel(level, startPosition, length, width, height, true, Blocks.f_50222_, Blocks.f_50222_, Blocks.f_50141_);
        startPosition = new BlockPos(1, 1, 51);
        DimensionBuildHelper.buildTunnel(level, startPosition, length, width, height, true, Blocks.f_50222_, Blocks.f_50222_, Blocks.f_50141_);
        int stairX = 40;
        int stairY = 50;
        int stairZ = 50;
        startPosition = new BlockPos(1, 1, 101);
        DimensionBuildHelper.buildCentralStairs(level, startPosition, stairX, stairY, stairZ, Blocks.f_50194_, Blocks.f_50222_);
        startPosition = new BlockPos(1, 50, 151);
        DimensionBuildHelper.buildWall(level, startPosition, 40, 50, 10, 10, Blocks.f_50222_);
        startPosition = new BlockPos(15, 50, 152);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 12, 10, false, Blocks.f_50222_, Blocks.f_50222_, Blocks.f_50141_);
        startPosition = new BlockPos(21, -20, 197);
        TriPredicate predicate = (x, y, z) -> {
            if (DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, 50, 60) && DimensionBuildHelper.inRangeZ(z, 0, 171)) {
                return true;
            }
            return DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, -18, -9) && DimensionBuildHelper.inRangeZ(z, 223, 323);
        };
        DimensionBuildHelper.buildCylinder(level, startPosition, 30, 100, Blocks.f_50493_, Blocks.f_50016_, (TriPredicate<Integer, Integer, Integer>)predicate);
        startPosition = new BlockPos(15, -19, 223);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 12, 10, false, Blocks.f_50440_, Blocks.f_50493_, Blocks.f_50141_);
        startPosition = new BlockPos(21, -19, 268);
        predicate = (x, y, z) -> {
            if (DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, 51, 60)) {
                return true;
            }
            return DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, -18, -9);
        };
        DimensionBuildHelper.buildCylinder(level, startPosition, 30, 20, Blocks.f_50493_, Blocks.f_50016_, (TriPredicate<Integer, Integer, Integer>)predicate);
        startPosition = new BlockPos(21, -19, 268);
        DimensionBuildHelper.buildPlatform(level, startPosition, 30, Blocks.f_50440_);
        startPosition = new BlockPos(21, 1, 268);
        DimensionBuildHelper.buildDome(level, startPosition, 30, 20, Blocks.f_50493_, true);
        startPosition = new BlockPos(15, -19, 298);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 12, 10, false, Blocks.f_50378_, Blocks.f_50378_, Blocks.f_50377_);
        startPosition = new BlockPos(21, -20, 353);
        predicate = (x, y, z) -> {
            if (DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, -15, -15) && DimensionBuildHelper.inRangeZ(z, 248, 348)) {
                return true;
            }
            return DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, 51, 51) && DimensionBuildHelper.inRangeZ(z, 348, 448);
        };
        DimensionBuildHelper.buildCylinder(level, startPosition, 30, 100, Blocks.f_50378_, Blocks.f_49990_, (TriPredicate<Integer, Integer, Integer>)predicate);
        startPosition = new BlockPos(15, 50, 383);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 12, 10, false, (Block)IafBlockRegistry.DRAGON_ICE.get(), (Block)IafBlockRegistry.DRAGON_ICE.get(), (Block)IafBlockRegistry.DRAGON_ICE.get());
        startPosition = new BlockPos(15, 51, 384);
        DimensionBuildHelper.buildWall(level, startPosition, 12, 1, 0, 0, (Block)IafBlockRegistry.DRAGON_ICE.get());
        startPosition = new BlockPos(21, 50, 428);
        predicate = (x, y, z) -> DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, 51, 60);
        DimensionBuildHelper.buildCylinder(level, startPosition, 30, 20, (Block)IafBlockRegistry.DRAGON_ICE.get(), Blocks.f_50016_, (TriPredicate<Integer, Integer, Integer>)predicate);
        startPosition = new BlockPos(21, 50, 428);
        DimensionBuildHelper.buildPlatform(level, startPosition, 30, (Block)IafBlockRegistry.DRAGON_ICE.get());
        startPosition = new BlockPos(21, 70, 428);
        DimensionBuildHelper.buildDome(level, startPosition, 30, 20, (Block)IafBlockRegistry.DRAGON_ICE.get(), true);
        startPosition = new BlockPos(15, 50, 453);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 12, 10, false, (Block)DDBlocks.SCULK_STONE.get(), (Block)DDBlocks.ECHO_SOIL.get(), (Block)DDBlocks.SCULK_GLEAM.get());
        startPosition = new BlockPos(21, 50, 498);
        predicate = (x, y, z) -> {
            if (DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, 51, 60) && DimensionBuildHelper.inRangeZ(z, 398, 498)) {
                return true;
            }
            return DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, 141, 150) && DimensionBuildHelper.inRangeZ(z, 498, 598);
        };
        DimensionBuildHelper.buildCloseCylinder(level, startPosition, 30, 101, (Block)DDBlocks.SCULK_STONE.get(), Blocks.f_50016_, (Block)DDBlocks.SCULK_STONE.get(), (Block)DDBlocks.SCULK_STONE.get(), (TriPredicate<Integer, Integer, Integer>)predicate);
        startPosition = new BlockPos(15, 140, 523);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 12, 10, false, (Block)DDBlocks.SCULK_STONE.get(), (Block)DDBlocks.ECHO_SOIL.get(), (Block)DDBlocks.SCULK_GLEAM.get());
        startPosition = new BlockPos(21, 140, 568);
        predicate = (x, y, z) -> DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, 141, 150);
        DimensionBuildHelper.buildCylinder(level, startPosition, 30, 20, (Block)DDBlocks.SCULK_STONE.get(), Blocks.f_50016_, (TriPredicate<Integer, Integer, Integer>)predicate);
        startPosition = new BlockPos(21, 140, 568);
        DimensionBuildHelper.buildPlatform(level, startPosition, 30, (Block)DDBlocks.SCULK_STONE.get());
        startPosition = new BlockPos(21, 160, 568);
        DimensionBuildHelper.buildDome(level, startPosition, 30, 20, (Block)DDBlocks.SCULK_STONE.get(), true);
        startPosition = new BlockPos(15, 140, 593);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 12, 10, false, Blocks.f_50134_, Blocks.f_50135_, Blocks.f_50450_);
        startPosition = new BlockPos(1, 140, 613);
        DimensionBuildHelper.buildWall(level, startPosition, 40, 50, 10, 10, Blocks.f_50134_);
        startPosition = new BlockPos(1, 140, 614);
        DimensionBuildHelper.buildTrapTunnel(level, startPosition, 100, 40, 50, true, Blocks.f_50134_, Blocks.f_50134_, Blocks.f_50450_, Blocks.f_49991_);
        startPosition = new BlockPos(1, 140, 714);
        DimensionBuildHelper.buildWall(level, startPosition, 40, 50, 10, 10, Blocks.f_50134_);
        startPosition = new BlockPos(15, 140, 715);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 12, 10, false, Blocks.f_50134_, Blocks.f_50135_, Blocks.f_50450_);
        startPosition = new BlockPos(21, 140, 760);
        predicate = (x, y, z) -> DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, 141, 150);
        DimensionBuildHelper.buildCylinder(level, startPosition, 30, 20, Blocks.f_50450_, Blocks.f_50016_, (TriPredicate<Integer, Integer, Integer>)predicate);
        startPosition = new BlockPos(21, 140, 760);
        DimensionBuildHelper.buildPlatform(level, startPosition, 30, Blocks.f_50080_);
        startPosition = new BlockPos(21, 160, 760);
        DimensionBuildHelper.buildDome(level, startPosition, 30, 20, Blocks.f_50080_, true);
        startPosition = new BlockPos(15, 140, 785);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 12, 10, false, Blocks.f_50259_, Blocks.f_50443_, Blocks.f_50492_);
        startPosition = new BlockPos(21, 50, 830);
        predicate = (x, y, z) -> {
            if (DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, 141, 150) && DimensionBuildHelper.inRangeZ(z, 730, 830)) {
                return true;
            }
            return DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, 101, 110) && DimensionBuildHelper.inRangeZ(z, 830, 930);
        };
        DimensionBuildHelper.buildCylinder(level, startPosition, 30, 120, Blocks.f_50443_, Blocks.f_50016_, (TriPredicate<Integer, Integer, Integer>)predicate);
        startPosition = new BlockPos(21, 140, 830);
        DimensionBuildHelper.buildSpiralInCylinder(level, startPosition, 30, 50, Blocks.f_50259_);
        startPosition = new BlockPos(15, 100, 857);
        DimensionBuildHelper.buildTunnel(level, startPosition, 18, 12, 10, false, Blocks.f_50259_, Blocks.f_50443_, Blocks.f_50492_);
        startPosition = new BlockPos(21, 100, 900);
        predicate = (x, y, z) -> DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, 101, 110);
        DimensionBuildHelper.buildCylinder(level, startPosition, 30, 20, Blocks.f_50443_, Blocks.f_50016_, (TriPredicate<Integer, Integer, Integer>)predicate);
        startPosition = new BlockPos(21, 100, 900);
        DimensionBuildHelper.buildPlatform(level, startPosition, 30, Blocks.f_50259_);
        startPosition = new BlockPos(21, 120, 900);
        DimensionBuildHelper.buildDome(level, startPosition, 30, 20, Blocks.f_50492_, true);
        Block blcok1 = Blocks.f_50730_;
        Block blcok2 = Blocks.f_50730_;
        Block blcok3 = Blocks.f_50733_;
        Block blcok4 = Blocks.f_50730_;
        startPosition = new BlockPos(15, 100, 925);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 12, 10, false, blcok1, blcok1, blcok1);
        ArrayList<Block> infectTunnelBlocks = new ArrayList<Block>(Arrays.asList(Blocks.f_50730_, Blocks.f_50730_, Blocks.f_50730_, Blocks.f_50730_, Blocks.f_50730_));
        for (int i = 0; i <= 4; ++i) {
            startPosition = new BlockPos(15 + i, 100, 925 + 20 * i);
            Block infectBlock = i < infectTunnelBlocks.size() ? infectTunnelBlocks.get(i) : blcok2;
            DimensionBuildHelper.buildTunnel(level, startPosition, 20, 12 - 2 * i, 10 - i, false, infectBlock, infectBlock, infectBlock);
        }
        startPosition = new BlockPos(19, 100, 1025);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 4, 6, false, blcok2, blcok2, blcok2);
        startPosition = new BlockPos(19, 100, 1045);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 4, 5, false, blcok2, blcok2, blcok2);
        startPosition = new BlockPos(19, 100, 1065);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 4, 4, false, blcok2, blcok2, blcok2);
        startPosition = new BlockPos(19, 100, 1085);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 4, 3, false, blcok2, blcok2, blcok2);
        startPosition = new BlockPos(19, 100, 1105);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 4, 2, false, blcok2, blcok2, blcok2);
        startPosition = new BlockPos(19, 100, 1125);
        DimensionBuildHelper.buildInfectTunnel(level, startPosition, 50, 4, 3, false, blcok2, blcok3, blcok4);
        startPosition = new BlockPos(21, 100, 1200);
        predicate = (x, y, z) -> {
            if (DimensionBuildHelper.inRangeX(x, 19, 22) && DimensionBuildHelper.inRangeY(y, 101, 102) && DimensionBuildHelper.inRangeZ(z, 1100, 1200)) {
                return true;
            }
            return DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, 101, 110) && DimensionBuildHelper.inRangeZ(z, 1200, 1300);
        };
        DimensionBuildHelper.buildCylinder(level, startPosition, 30, 20, blcok4, Blocks.f_50016_, (TriPredicate<Integer, Integer, Integer>)predicate);
        startPosition = new BlockPos(21, 100, 1200);
        DimensionBuildHelper.buildPlatform(level, startPosition, 30, blcok4);
        startPosition = new BlockPos(21, 120, 1200);
        DimensionBuildHelper.buildDome(level, startPosition, 30, 20, blcok4, true);
        startPosition = new BlockPos(15, 100, 1225);
        DimensionBuildHelper.buildTunnel(level, startPosition, 20, 12, 10, false, Blocks.f_50333_, Blocks.f_50333_, Blocks.f_50333_);
        if (!isMirror) {
            startPosition = new BlockPos(1, 100, 1245);
            DimensionBuildHelper.buildWall(level, startPosition, 40, 50, 10, 10, Blocks.f_50333_);
        } else {
            startPosition = new BlockPos(1, 100, 1245);
            DimensionBuildHelper.buildWall(level, startPosition, 40, 50, 10, 10, Blocks.f_50080_);
        }
        if (!isMirror) {
            startPosition = new BlockPos(1, 100, 1246);
            DimensionBuildHelper.buildTunnel(level, startPosition, 50, 40, 50, true, Blocks.f_50333_, Blocks.f_50333_, Blocks.f_50333_);
        }
        if (!isMirror) {
            startPosition = new BlockPos(20, 100, 1296);
            DimensionBuildHelper.buildFloor(level, startPosition, 2, 2, 1, Blocks.f_50080_);
        } else {
            startPosition = new BlockPos(20, 100, 1296);
            DimensionBuildHelper.buildFloor(level, startPosition, 2, 2, 1, Blocks.f_50333_);
        }
        if (isMirror) {
            startPosition = new BlockPos(1, 100, 1298);
            DimensionBuildHelper.buildTunnel(level, startPosition, 50, 40, 50, true, Blocks.f_50080_, Blocks.f_50080_, Blocks.f_50080_);
        }
        if (!isMirror) {
            startPosition = new BlockPos(20, 100, 1348);
            DimensionBuildHelper.buildFloor(level, startPosition, 2, 2, 1, Blocks.f_50080_);
        } else {
            startPosition = new BlockPos(20, 100, 1348);
            DimensionBuildHelper.buildFloor(level, startPosition, 2, 2, 1, Blocks.f_50333_);
        }
        if (!isMirror) {
            startPosition = new BlockPos(1, 100, 1350);
            DimensionBuildHelper.buildTrapTunnel(level, startPosition, 50, 40, 50, false, Blocks.f_50333_, Blocks.f_50333_, Blocks.f_50333_, Blocks.f_49990_);
        } else {
            startPosition = new BlockPos(1, 100, 1350);
            DimensionBuildHelper.buildTrapTunnel(level, startPosition, 50, 40, 50, false, Blocks.f_50080_, Blocks.f_50080_, Blocks.f_50080_, Blocks.f_49991_);
        }
        if (!isMirror) {
            startPosition = new BlockPos(1, 100, 1400);
            DimensionBuildHelper.buildWall(level, startPosition, 40, 50, 10, 10, Blocks.f_50333_);
            startPosition = new BlockPos(15, 100, 1401);
            DimensionBuildHelper.buildTunnel(level, startPosition, 20, 12, 10, false, Blocks.f_50333_, Blocks.f_50333_, Blocks.f_50333_);
        } else {
            startPosition = new BlockPos(1, 100, 1400);
            DimensionBuildHelper.buildWall(level, startPosition, 40, 50, 10, 10, Blocks.f_50080_);
            startPosition = new BlockPos(15, 100, 1401);
            DimensionBuildHelper.buildTunnel(level, startPosition, 20, 12, 10, false, Blocks.f_50080_, Blocks.f_50080_, Blocks.f_50080_);
        }
        startPosition = new BlockPos(21, 100, 1446);
        predicate = (x, y, z) -> DimensionBuildHelper.inRangeX(x, 15, 26) && DimensionBuildHelper.inRangeY(y, 101, 110) && DimensionBuildHelper.inRangeZ(z, 1346, 1446);
        DimensionBuildHelper.buildCylinder(level, startPosition, 30, 20, (Block)com.github.L_Ender.cataclysm.init.ModBlocks.VOID_STONE.get(), Blocks.f_50016_, (TriPredicate<Integer, Integer, Integer>)predicate);
        startPosition = new BlockPos(21, 100, 1446);
        DimensionBuildHelper.buildPlatform(level, startPosition, 30, (Block)com.github.L_Ender.cataclysm.init.ModBlocks.VOID_STONE.get());
        startPosition = new BlockPos(21, 120, 1446);
        DimensionBuildHelper.buildDome(level, startPosition, 30, 20, (Block)com.github.L_Ender.cataclysm.init.ModBlocks.VOID_STONE.get(), true);
        return 1;
    }

    private static BlockPos fixPosition(BlockPos pos) {
        return pos.m_121955_(globalOffset);
    }

    private static void buildCentralStairs(Level level, BlockPos stairsStart, int width, int height, int length, Block stairBlock, Block wallBlock) {
        stairsStart = DimensionBuildHelper.fixPosition(stairsStart);
        Direction facing = Direction.SOUTH;
        for (int z = 0; z < length; ++z) {
            for (int x = 0; x < width; ++x) {
                level.m_7731_(stairsStart.m_7918_(x, z, z), (BlockState)((BlockState)stairBlock.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)facing)).m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.BOTTOM), 3);
                level.m_7731_(stairsStart.m_7918_(x, z + height, z), (BlockState)((BlockState)stairBlock.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)facing)).m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.BOTTOM), 3);
                if (x != 0 && x != width - 1) continue;
                for (int y = z; y < height + z; ++y) {
                    level.m_7731_(stairsStart.m_7918_(x, y, z), wallBlock.m_49966_(), 3);
                }
            }
        }
    }

    public static int buildFloor(Level level, BlockPos startPos, int length, int width, int height, Block floorBlock) {
        startPos = DimensionBuildHelper.fixPosition(startPos);
        for (int z = 0; z < length; ++z) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    level.m_7731_(startPos.m_7918_(x, y, z), floorBlock.m_49966_(), 3);
                }
            }
        }
        return 1;
    }

    public static int buildTunnel(Level level, BlockPos startPos, int length, int width, int height, boolean needDecoration, Block bottomBlock, Block wallBlock, Block topBlock) {
        startPos = DimensionBuildHelper.fixPosition(startPos);
        for (int z = 0; z < length; ++z) {
            for (int x = 0; x < width; ++x) {
                level.m_7731_(startPos.m_7918_(x, 0, z), bottomBlock.m_49966_(), 3);
                level.m_7731_(startPos.m_7918_(x, height, z), topBlock.m_49966_(), 3);
            }
            for (int y = 1; y < height; ++y) {
                level.m_7731_(startPos.m_7918_(0, y, z), wallBlock.m_49966_(), 3);
                level.m_7731_(startPos.m_7918_(width - 1, y, z), wallBlock.m_49966_(), 3);
            }
        }
        if (needDecoration) {
            Block decorationBlock = wallBlock == Blocks.f_50080_ ? Blocks.f_50333_ : Blocks.f_50080_;
            BlockState blockState = decorationBlock.m_49966_();
            for (int z = 10; z < length; z += 10) {
                for (int y = 1; y < height; ++y) {
                    level.m_7731_(startPos.m_7918_(width / 4, y, z), blockState, 3);
                    level.m_7731_(startPos.m_7918_(width / 4, y, z + 1), blockState, 3);
                    level.m_7731_(startPos.m_7918_(width / 4 + 1, y, z), blockState, 3);
                    level.m_7731_(startPos.m_7918_(width / 4 + 1, y, z + 1), blockState, 3);
                    level.m_7731_(startPos.m_7918_(width * 3 / 4, y, z), blockState, 3);
                    level.m_7731_(startPos.m_7918_(width * 3 / 4, y, z + 1), blockState, 3);
                    level.m_7731_(startPos.m_7918_(width * 3 / 4 - 1, y, z), blockState, 3);
                    level.m_7731_(startPos.m_7918_(width * 3 / 4 - 1, y, z + 1), blockState, 3);
                }
            }
        }
        return 1;
    }

    public static int buildInfectTunnel(Level level, BlockPos startPos, int length, int width, int height, boolean needDecoration, Block coverBlock, Block fillBlock1, Block fillBlock2) {
        startPos = DimensionBuildHelper.fixPosition(startPos);
        for (int z = 0; z < length; ++z) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (x == 0 || x == width - 1 || y == height - 1 || y == 0) {
                        level.m_7731_(startPos.m_7918_(x, y, z), coverBlock.m_49966_(), 3);
                        continue;
                    }
                    if (y == 1) {
                        level.m_7731_(startPos.m_7918_(x, y, z), (BlockState)fillBlock1.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP), 3);
                        continue;
                    }
                    level.m_7731_(startPos.m_7918_(x, y, z), fillBlock2.m_49966_(), 3);
                }
            }
        }
        return 1;
    }

    public static int buildTrapTunnel(Level level, BlockPos startPos, int length, int width, int height, boolean needDecoration, Block bottomBlock, Block wallBlock, Block topBlock, Block trapBlock) {
        DimensionBuildHelper.buildTunnel(level, startPos, length, width, height, needDecoration, bottomBlock, wallBlock, topBlock);
        startPos = DimensionBuildHelper.fixPosition(startPos);
        int trapHeight = 8;
        for (int z = 0; z < length; ++z) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < trapHeight; ++y) {
                    if (x == 0 || x == width - 1 || z == 0 || z == length - 1 || y == trapHeight - 1) {
                        level.m_7731_(startPos.m_7918_(x, -y, z), bottomBlock.m_49966_(), 3);
                        continue;
                    }
                    level.m_7731_(startPos.m_7918_(x, -y, z), trapBlock.m_49966_(), 3);
                }
            }
        }
        return 1;
    }

    public static int buildWall(Level level, BlockPos startPos, int width, int height, int doorWidth, int doorHeight, Block block) {
        startPos = DimensionBuildHelper.fixPosition(startPos);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (x >= (width - doorWidth) / 2 && x < (width + doorWidth) / 2 && y < doorHeight && y != 0) continue;
                level.m_7731_(startPos.m_7918_(x, y, 0), block.m_49966_(), 3);
            }
        }
        return 1;
    }

    private static void buildCylinder(Level level, BlockPos center, int radius, int height, Block material, Block fill, TriPredicate<Integer, Integer, Integer> predicate) {
        center = DimensionBuildHelper.fixPosition(center);
        for (int y = 0; y <= height; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + z * z > radius * radius) continue;
                    BlockPos pos = center.m_7918_(x, y, z);
                    if (x * x + z * z >= (radius - 3) * (radius - 3)) {
                        if (predicate.test((Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_()) || x == 0 && z * z == radius * radius) continue;
                        level.m_7731_(pos, material.m_49966_(), 3);
                        continue;
                    }
                    if (fill == Blocks.f_50016_) continue;
                    level.m_7731_(pos, fill.m_49966_(), 3);
                }
            }
        }
        if (fill == Blocks.f_49990_) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + z * z > radius * radius) continue;
                    BlockPos pos = center.m_7918_(x, -1, z);
                    level.m_7731_(pos, material.m_49966_(), 3);
                    pos = center.m_7918_(x, height + 1, z);
                    level.m_7731_(pos, material.m_49966_(), 3);
                }
            }
        }
    }

    private static void buildCloseCylinder(Level level, BlockPos center, int radius, int height, Block material, Block fill, Block top, Block bottom, TriPredicate<Integer, Integer, Integer> predicate) {
        DimensionBuildHelper.buildCylinder(level, center, radius, height, material, fill, predicate);
        center = DimensionBuildHelper.fixPosition(center);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > radius * radius) continue;
                BlockPos pos = center.m_7918_(x, -1, z);
                level.m_7731_(pos, bottom.m_49966_(), 3);
                pos = center.m_7918_(x, height + 1, z);
                level.m_7731_(pos, top.m_49966_(), 3);
            }
        }
    }

    private static void buildSpiralInCylinder(Level level, BlockPos center, int radius, int height, Block spiralMaterial) {
        center = DimensionBuildHelper.fixPosition(center);
        int startHeight = height;
        int spiralRadius = radius - 8;
        int quarters = 4;
        int heightDropPerQuarter = 3;
        int totalCircles = height / (quarters * heightDropPerQuarter) + 1;
        for (int circle = 0; circle < totalCircles; ++circle) {
            int currentHeight;
            for (int quarter = 0; quarter < quarters && (currentHeight = startHeight - (circle * quarters + quarter) * heightDropPerQuarter) >= 0; ++quarter) {
                double angle = 1.5707963267948966 * (double)quarter;
                int x = (int)Math.round((double)spiralRadius * Math.sin(angle));
                int z = (int)Math.round((double)spiralRadius * Math.cos(angle + Math.PI));
                BlockPos pos1 = center.m_7918_(x, -currentHeight, z);
                BlockPos pos2 = center.m_7918_(x + 1, -currentHeight, z);
                BlockPos pos3 = center.m_7918_(x, -currentHeight, z + 1);
                BlockPos pos4 = center.m_7918_(x + 1, -currentHeight, z + 1);
                level.m_7731_(pos1, spiralMaterial.m_49966_(), 3);
                level.m_7731_(pos2, spiralMaterial.m_49966_(), 3);
                level.m_7731_(pos3, spiralMaterial.m_49966_(), 3);
                level.m_7731_(pos4, spiralMaterial.m_49966_(), 3);
            }
        }
    }

    private static void buildPlatform(Level level, BlockPos center, int radius, Block mainMaterial) {
        center = DimensionBuildHelper.fixPosition(center);
        int thickness = 4;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > radius * radius) continue;
                for (int y = 0; y < thickness; ++y) {
                    BlockPos pos = center.m_7918_(x, -y, z);
                    if (y == thickness - 1) {
                        level.m_7731_(pos, Blocks.f_50752_.m_49966_(), 3);
                        continue;
                    }
                    if (x == 0 && z * z == radius * radius) continue;
                    level.m_7731_(pos, mainMaterial.m_49966_(), 3);
                }
            }
        }
        BlockPos pos = center.m_7918_(-4, 1, -radius);
        level.m_7731_(pos, (BlockState)ModBlocks.waystone.m_49966_().m_61124_((Property)WaystoneBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
        level.m_7731_(pos.m_7494_(), (BlockState)ModBlocks.waystone.m_49966_().m_61124_((Property)WaystoneBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    private static void buildDome(Level level, BlockPos center, int radius, int height, Block material, boolean isUpper) {
        center = DimensionBuildHelper.fixPosition(center);
        int thickness = 3;
        for (int y = 0; y <= height; ++y) {
            double normalizedY = (double)y / (double)height;
            double layerRadius = (double)radius * Math.cos(normalizedY * Math.PI / 2.0);
            layerRadius = Math.max(layerRadius, 3.0);
            int x = -((int)layerRadius);
            while ((double)x <= layerRadius) {
                int z = -((int)layerRadius);
                while ((double)z <= layerRadius) {
                    double distanceSq = x * x + z * z;
                    if (distanceSq <= layerRadius * layerRadius && distanceSq >= (layerRadius - 3.0) * (layerRadius - 3.0)) {
                        BlockPos pos = center.m_7918_(x, isUpper ? y : -y, z);
                        level.m_7731_(pos, material.m_49966_(), 3);
                    }
                    ++z;
                }
                ++x;
            }
        }
    }

    private static boolean inRangeX(int value, int left, int right) {
        return value >= left + globalOffset.m_123341_() && value <= right + globalOffset.m_123341_();
    }

    private static boolean inRangeY(int value, int left, int right) {
        return value >= left + globalOffset.m_123342_() && value <= right + globalOffset.m_123342_();
    }

    private static boolean inRangeZ(int value, int left, int right) {
        return value >= left + globalOffset.m_123343_() && value <= right + globalOffset.m_123343_();
    }
}

