/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.difficulty.config;

import com.Polarice3.Goety.common.entities.boss.Apostle;
import com.Polarice3.Goety.common.entities.boss.Vizier;
import com.Polarice3.Goety.common.entities.hostile.WitherNecromancer;
import com.Polarice3.Goety.common.entities.hostile.cultists.Crone;
import com.Polarice3.Goety.common.entities.hostile.illagers.Crusher;
import com.Polarice3.Goety.common.entities.hostile.illagers.Minister;
import com.Polarice3.Goety.common.entities.hostile.illagers.Piker;
import com.Polarice3.Goety.common.entities.hostile.illagers.Sorcerer;
import com.Polarice3.Goety.common.entities.hostile.illagers.StormCaster;
import com.Polarice3.Goety.common.entities.hostile.servants.ObsidianMonolith;
import com.Polarice3.Goety.utils.NoKnockBackDamageSource;
import com.Polarice3.Goety.utils.OwnedDamageSource;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.ObsidilithEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomEntity;
import com.gametechbc.traveloptics.entity.mobs.EnragedDeadKingBoss;
import com.gametechbc.traveloptics.entity.mobs.nightwarden_boss.NightwardenBossEntity;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.Ender_Guardian_Entity;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.Ignis_Entity;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.The_Harbinger_Entity;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.The_Leviathan.The_Leviathan_Entity;
import com.github.L_Ender.cataclysm.entity.Deepling.Coral_Golem_Entity;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.Coralssus_Entity;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters.Ancient_Remnant.Ancient_Remnant_Entity;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters.Maledictus.Maledictus_Entity;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters.NewNetherite_Monstrosity.Netherite_Monstrosity_Entity;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.The_Prowler_Entity;
import com.github.L_Ender.cataclysm.entity.Pet.Netherite_Ministrosity_Entity;
import com.github.L_Ender.cataclysm.entity.Pet.The_Baby_Leviathan_Entity;
import com.github.alexmodguy.alexscaves.server.entity.living.AtlatitanEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GammaroachEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.HullbreakerEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.LuxtructosaurusEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.NucleeperEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorsaurusEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import com.github.alexthe666.alexsmobs.entity.EntityFarseer;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWorm;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.config.CurioUtils;
import com.kurome.ageofmythology.data.tag.EntityTagGenerator;
import com.kurome.ageofmythology.difficulty.api.IMobDifficulty;
import com.kurome.ageofmythology.dimension.AOMDimension;
import com.kurome.ageofmythology.entity.EndScholar.EndScholarEntity;
import com.kurome.ageofmythology.entity.GoodEvilSoul.GoodEvilEntity;
import com.kurome.ageofmythology.entity.HellTraveler.HellTravelerEntity;
import com.kurome.ageofmythology.entity.IceThunderSoul.IceThunderSoulEntity;
import com.kurome.ageofmythology.entity.LostOne.LostOneEntity;
import com.kurome.ageofmythology.entity.SculkShrieker.SculkShriekerEntity;
import com.kurome.ageofmythology.entity.ShadowDemon.ShadowDemonEntity;
import com.kurome.ageofmythology.init.AOMEntities;
import com.kurome.ageofmythology.init.AOMItems;
import com.kyanite.deeperdarker.world.otherside.OthersideDimension;
import com.mega.revelationfix.common.compat.SafeClass;
import com.mojang.logging.LogUtils;
import io.redspace.ironsspellbooks.entity.mobs.dead_king_boss.DeadKingBoss;
import io.redspace.ironsspellbooks.entity.mobs.necromancer.NecromancerEntity;
import io.redspace.ironsspellbooks.entity.mobs.wizards.archevoker.ArchevokerEntity;
import io.redspace.ironsspellbooks.entity.mobs.wizards.cryomancer.CryomancerEntity;
import io.redspace.ironsspellbooks.entity.mobs.wizards.priest.PriestEntity;
import io.redspace.ironsspellbooks.entity.mobs.wizards.pyromancer.PyromancerEntity;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import mcjty.lostcities.setup.Registration;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.world.registration.TFGenerationSettings;
import z1gned.goetyrevelation.util.ApollyonAbilityHelper;

public class DifficultyConfig {
    public static List<Supplier<EntityType<?>>> DIFFICULTY_WHITE_LIST_NEW;
    public static Difficulty LEVEL_1;
    public static Difficulty LEVEL_3;
    public static Difficulty LEVEL_5;
    public static Difficulty LEVEL_8;
    public static Difficulty LEVEL_10;
    public static Difficulty LEVEL_15;
    public static Difficulty LEVEL_30;
    public static Difficulty LEVEL_LOST_CITY;

    public static Difficulty areaDifficulty(Entity entity) {
        ResourceKey dimension = entity.m_9236_().m_46472_();
        Vec3 position = entity.m_20182_();
        if (dimension.equals((Object)Level.f_46428_)) {
            if (position.f_82481_ <= -1000000.0 || position.f_82481_ >= 1000000.0 || position.f_82479_ <= -1000000.0 || position.f_82479_ >= 1000000.0) {
                return LEVEL_15;
            }
            return LEVEL_1;
        }
        if (dimension.equals((Object)Level.f_46429_)) {
            return LEVEL_5;
        }
        if (dimension.equals((Object)Level.f_46430_)) {
            return LEVEL_8;
        }
        if (dimension.equals((Object)TFGenerationSettings.DIMENSION_KEY)) {
            return LEVEL_3;
        }
        if (dimension.equals((Object)OthersideDimension.OTHERSIDE_LEVEL)) {
            return LEVEL_3;
        }
        if (dimension.equals((Object)Registration.DIMENSION)) {
            return LEVEL_LOST_CITY;
        }
        if (dimension.equals(AOMDimension.DEEP_DESERT_LEVEL) || dimension.equals(AOMDimension.CHAOS_REALM_LEVEL) || dimension.equals(AOMDimension.FROZEN_REALM_LEVEL) || dimension.equals(AOMDimension.MAGIC_FOREST_LEVEL) || dimension.equals(AOMDimension.LOST_DREAM_LEVEL) || dimension.equals(AOMDimension.LOST_END_LEVEL)) {
            return new Difficulty(75.0f, 25.0f, 20.0f, 10.0f);
        }
        if (dimension.equals(AOMDimension.BLOOD_NETHER_LEVEL)) {
            return new Difficulty(100.0f, 25.0f, 20.0f, 10.0f);
        }
        if (dimension.equals(AOMDimension.PUTRID_CATHEDRAL_LEVEL)) {
            return new Difficulty(150.0f, 30.0f, 20.0f, 10.0f);
        }
        return LEVEL_1;
    }

    public static Difficulty specialMobDifficulty(Entity entity) {
        if (entity instanceof EntityFarseer) {
            return new Difficulty(200.0f, 20.0f, 20.0f, 10.0f);
        }
        if (entity instanceof Netherite_Monstrosity_Entity) {
            return LEVEL_15;
        }
        if (entity instanceof Ender_Guardian_Entity) {
            return LEVEL_15;
        }
        if (entity instanceof Ancient_Remnant_Entity) {
            return LEVEL_15;
        }
        if (entity instanceof Maledictus_Entity) {
            return LEVEL_15;
        }
        if (entity instanceof EnderDragon) {
            return LEVEL_LOST_CITY;
        }
        if (entity instanceof Ignis_Entity) {
            return LEVEL_5;
        }
        if (entity instanceof ObsidianMonolith && entity.m_9236_().m_46472_().equals(AOMDimension.DEEP_DESERT_LEVEL)) {
            return new Difficulty(2000.0f, 10.0f, 10.0f, 10.0f);
        }
        if (entity instanceof ObsidilithEntity) {
            return LEVEL_10;
        }
        if (entity instanceof VoidBlossomEntity) {
            return LEVEL_10;
        }
        if (entity instanceof NightwardenBossEntity) {
            return new Difficulty(30.0f, 10.0f, 10.0f, 5.0f);
        }
        if (entity.m_6095_().m_204039_(EntityTagGenerator.MAGIC)) {
            if (entity instanceof EnragedDeadKingBoss) {
                return LEVEL_30;
            }
            if (entity instanceof DeadKingBoss) {
                return LEVEL_15;
            }
            if (entity instanceof com.lion.graveyard.entities.LichEntity) {
                return LEVEL_10;
            }
            if (entity instanceof LichEntity) {
                return LEVEL_10;
            }
            if (entity instanceof ArchevokerEntity) {
                return LEVEL_5;
            }
            if (entity instanceof CryomancerEntity) {
                return LEVEL_5;
            }
            if (entity instanceof NecromancerEntity) {
                return LEVEL_8;
            }
            if (entity instanceof PyromancerEntity) {
                return LEVEL_5;
            }
            if (entity instanceof PriestEntity) {
                return new Difficulty(2.0f, 2.0f, 2.0f, 1.0f);
            }
            return LEVEL_3;
        }
        if (entity.m_6095_().m_204039_(EntityTagGenerator.ABYSS)) {
            if (entity instanceof The_Leviathan_Entity) {
                return LEVEL_15;
            }
            if (entity instanceof HullbreakerEntity) {
                return LEVEL_10;
            }
            if (entity instanceof Coralssus_Entity || entity instanceof Coral_Golem_Entity) {
                return LEVEL_5;
            }
            return LEVEL_3;
        }
        if (entity.m_6095_().m_204039_(EntityTagGenerator.EXPLODE)) {
            if (entity instanceof TremorzillaEntity) {
                return LEVEL_15;
            }
            if (entity instanceof GammaroachEntity) {
                return new Difficulty(50.0f, 1.0f, 5.0f, 1.0f);
            }
            if (entity instanceof NucleeperEntity) {
                return LEVEL_10;
            }
            if (entity instanceof GauntletEntity) {
                return LEVEL_10;
            }
            return LEVEL_3;
        }
        if (entity.m_6095_().m_204039_(EntityTagGenerator.MACHINE)) {
            if (entity instanceof The_Harbinger_Entity) {
                return LEVEL_15;
            }
            if (entity instanceof The_Prowler_Entity) {
                return LEVEL_10;
            }
            return LEVEL_3;
        }
        if (entity.m_6095_().m_204039_(EntityTagGenerator.DRAGON)) {
            if (entity instanceof AtlatitanEntity) {
                return LEVEL_10;
            }
            if (entity instanceof LuxtructosaurusEntity) {
                return LEVEL_10;
            }
            if (entity instanceof TremorsaurusEntity) {
                return LEVEL_5;
            }
            if (entity instanceof EntityIceDragon || entity instanceof EntityFireDragon || entity instanceof EntityLightningDragon) {
                return LEVEL_1;
            }
            return LEVEL_3;
        }
        if (entity.m_6095_().m_204039_(EntityTagGenerator.GOETY)) {
            if (entity instanceof Apostle) {
                Apostle apostle = (Apostle)entity;
                return LEVEL_1;
            }
            if (entity instanceof Minister) {
                return new Difficulty(30.0f, 10.0f, 5.0f, 5.0f);
            }
            if (entity instanceof Sorcerer) {
                return new Difficulty(30.0f);
            }
            if (entity instanceof Crusher) {
                return new Difficulty(30.0f, 5.0f, 5.0f, 5.0f);
            }
            if (entity instanceof Piker) {
                return new Difficulty(30.0f, 5.0f, 5.0f, 5.0f);
            }
            if (entity instanceof StormCaster) {
                return new Difficulty(30.0f, 5.0f, 5.0f, 5.0f);
            }
            if (entity instanceof Vizier) {
                return new Difficulty(30.0f, 5.0f, 5.0f, 5.0f);
            }
            if (entity instanceof Crone) {
                return new Difficulty(5.0f, 5.0f, 5.0f, 5.0f);
            }
            if (entity instanceof WitherNecromancer) {
                return new Difficulty(30.0f, 5.0f, 5.0f, 5.0f);
            }
            if (entity.m_9236_().m_46472_().equals((Object)Level.f_46429_)) {
                return LEVEL_10;
            }
            return LEVEL_5;
        }
        if (entity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_1)) {
            return new Difficulty(5.0f, 2.0f, 2.0f, 2.0f);
        }
        if (entity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_2)) {
            return new Difficulty(10.0f, 5.0f, 3.0f, 3.0f);
        }
        if (entity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_3)) {
            return new Difficulty(20.0f, 5.0f, 5.0f, 5.0f);
        }
        if (entity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_4)) {
            return new Difficulty(50.0f, 10.0f, 10.0f, 5.0f);
        }
        if (entity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_5)) {
            return new Difficulty(100.0f, 20.0f, 20.0f, 10.0f);
        }
        if (entity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_6)) {
            // empty if block
        }
        return LEVEL_1;
    }

    public static void modify(LivingEntity entity, IMobDifficulty mobInfo) {
        Difficulty difficulty = mobInfo.getDifficulty();
        if (!entity.m_6084_() || difficulty.getId() <= 0.0f) {
            return;
        }
        List<EntityType> list = DIFFICULTY_WHITE_LIST_NEW.stream().map(Supplier::get).toList();
        if (list.contains(entity.m_6095_())) {
            return;
        }
        if (entity instanceof The_Baby_Leviathan_Entity || entity instanceof Netherite_Ministrosity_Entity) {
            return;
        }
        if (entity instanceof EntityVoidWorm) {
            AOMUtil.modifyAttribute(entity, Attributes.f_22276_, UUID.fromString("11c9ad04-65af-4386-a17f-59c11fa0d931"), "void_worm_max_health", 2000.0, AttributeModifier.Operation.ADDITION);
            AOMUtil.modifyAttribute(entity, Attributes.f_22281_, UUID.fromString("11c9ad04-65af-4386-a17f-59c11fa0d931"), "void_worm_max_health", 30.0, AttributeModifier.Operation.ADDITION);
            AOMUtil.modifyAttribute(entity, Attributes.f_22284_, UUID.fromString("11c9ad04-65af-4386-a17f-59c11fa0d931"), "void_worm_max_health", 20.0, AttributeModifier.Operation.ADDITION);
            AOMUtil.modifyAttribute(entity, Attributes.f_22285_, UUID.fromString("11c9ad04-65af-4386-a17f-59c11fa0d931"), "void_worm_max_health", 20.0, AttributeModifier.Operation.ADDITION);
            entity.m_21153_(entity.m_21233_());
            return;
        }
        DifficultyConfig.modifyAttribute(entity, Attributes.f_22276_, difficulty.getHealthAmplify());
        DifficultyConfig.modifyAttribute(entity, Attributes.f_22281_, difficulty.getAttackDamageAmplify());
        DifficultyConfig.modifyAttribute(entity, Attributes.f_22284_, difficulty.getArmorAmplify());
        DifficultyConfig.modifyAttribute(entity, Attributes.f_22285_, difficulty.getArmorToughnessAmplify());
    }

    public static void modifyAttribute(LivingEntity entity, Attribute attribute, float amplify) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance == null) {
            return;
        }
        instance.m_22100_(Math.min(instance.m_22115_() * (double)amplify, Double.MAX_VALUE));
        if (attribute == Attributes.f_22276_) {
            entity.m_21153_(entity.m_21233_());
        }
    }

    public static void hurtDamageModify(LivingHurtEvent event) {
        DamageSource damageSource = event.getSource();
        LivingEntity entity = event.getEntity();
        double damageFactor = 0.0;
        if (entity instanceof Player) {
            OwnedDamageSource oDs;
            NoKnockBackDamageSource nDs;
            Entity entity2;
            Apostle a;
            Entity damageSourceEntity;
            Player player = (Player)entity;
            ResourceKey dimension = player.m_9236_().m_46472_();
            Vec3 position = entity.m_20182_();
            if (dimension.equals((Object)Level.f_46428_)) {
                if (position.f_82481_ <= -1000000.0 || position.f_82481_ >= 1000000.0 || position.f_82479_ <= -1000000.0 || position.f_82479_ >= 1000000.0) {
                    damageFactor = 0.22;
                }
            } else if (dimension.equals((Object)Level.f_46429_)) {
                damageFactor = 0.1;
            } else if (dimension.equals((Object)Level.f_46430_)) {
                damageFactor = 0.13;
            } else if (dimension.equals((Object)TFGenerationSettings.DIMENSION_KEY)) {
                damageFactor = 0.06;
            } else if (dimension.equals((Object)OthersideDimension.OTHERSIDE_LEVEL)) {
                damageFactor = 0.06;
            } else if (dimension.equals((Object)Registration.DIMENSION)) {
                damageFactor = CurioUtils.isEquipSkullCurio((LivingEntity)player, (Item)AOMItems.AGEOFMYTHOLOGY_DEMON_HEART_ITEM.get()) ? 0.15 : 0.15;
            } else if (dimension.equals(AOMDimension.THE_PATH_LEVEL)) {
                damageFactor = 0.1;
            } else if (dimension.equals(AOMDimension.DEEP_DESERT_LEVEL) || dimension.equals(AOMDimension.CHAOS_REALM_LEVEL) || dimension.equals(AOMDimension.FROZEN_REALM_LEVEL) || dimension.equals(AOMDimension.MAGIC_FOREST_LEVEL)) {
                damageFactor = 0.15;
            } else if (dimension.equals(AOMDimension.BLOOD_NETHER_LEVEL)) {
                damageFactor = 0.15;
            } else if (dimension.equals(AOMDimension.PUTRID_CATHEDRAL_LEVEL)) {
                damageFactor = 0.15;
            }
            float maxHealth = player.m_21233_();
            int armor = player.m_21230_();
            double dynamicDefense = 1.0;
            int dynamicDefenseLevel = (int)(maxHealth / 150.0f + (float)armor / 35.0f);
            dynamicDefense = dynamicDefenseLevel <= 0 ? 1.0 : (dynamicDefenseLevel <= 2 ? 0.9 : (dynamicDefenseLevel <= 5 ? 0.8 : (dynamicDefenseLevel <= 8 ? 0.7 : (dynamicDefenseLevel <= 10 ? 0.65 : 0.6))));
            if (dimension.equals(AOMDimension.THE_PATH_LEVEL)) {
                dynamicDefense = 1.0;
            }
            if (damageSource.m_276093_(DamageTypes.f_268612_) || damageSource.m_276093_(DamageTypes.f_268546_) || damageSource.m_276093_(DamageTypes.f_268631_) || damageSource.m_276093_(DamageTypes.f_268468_) || damageSource.m_276093_(DamageTypes.f_268671_)) {
                damageFactor = 0.01;
            }
            if ((damageSourceEntity = damageSource.m_7639_()) != null) {
                double damageFactorBonus = 0.0;
                if (damageSourceEntity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_1)) {
                    damageFactorBonus = 0.03;
                } else if (damageSourceEntity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_2)) {
                    damageFactorBonus = 0.05;
                } else if (damageSourceEntity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_3)) {
                    damageFactorBonus = 0.08;
                } else if (damageSourceEntity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_4)) {
                    damageFactorBonus = 0.12;
                } else if (damageSourceEntity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_5)) {
                    damageFactorBonus = 0.15;
                } else if (damageSourceEntity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_6)) {
                    damageFactorBonus = 0.2;
                }
                damageFactor += damageFactorBonus;
            }
            LogUtils.getLogger().debug("hurtDamageModify %s %s %s %s %s".formatted(Float.valueOf(event.getAmount()), Float.valueOf(player.m_21233_()), damageFactor, dynamicDefense, (double)player.m_21233_() * damageFactor * dynamicDefense));
            Apostle apostle = null;
            Entity entity3 = damageSource.m_7639_();
            if (entity3 instanceof Apostle) {
                apostle = a = (Apostle)entity3;
            }
            if ((entity3 = damageSource.m_7640_()) instanceof Apostle) {
                apostle = a = (Apostle)entity3;
            }
            if (damageSource instanceof NoKnockBackDamageSource && (entity2 = (nDs = (NoKnockBackDamageSource)damageSource).getOwner()) instanceof Apostle) {
                Apostle a2;
                apostle = a2 = (Apostle)entity2;
            } else if (damageSource instanceof OwnedDamageSource && (entity2 = (oDs = (OwnedDamageSource)damageSource).getOwner()) instanceof Apostle) {
                Apostle a3;
                apostle = a3 = (Apostle)entity2;
            }
            if (apostle != null && ((ApollyonAbilityHelper)apostle).allTitlesApostle_1_20_1$isApollyon() && apostle.isInNether()) {
                if (SafeClass.isDoom((Apostle)apostle)) {
                    event.setAmount(1.0f);
                } else {
                    event.setAmount(Math.min(event.getAmount(), player.m_21233_() * 0.1f));
                }
            } else {
                event.setAmount((float)((double)event.getAmount() + (double)player.m_21233_() * damageFactor * dynamicDefense));
            }
        }
        if (entity instanceof ShadowDemonEntity) {
            float hurtDamage = event.getAmount();
            float maxHealth = entity.m_21233_();
            event.setAmount(Math.min(hurtDamage, maxHealth / 11.0f));
        } else if (entity instanceof IceThunderSoulEntity) {
            float hurtDamage = event.getAmount();
            float maxHealth = entity.m_21233_();
            event.setAmount(Math.min(hurtDamage, maxHealth / 16.0f));
        } else if (entity instanceof SculkShriekerEntity) {
            float hurtDamage = event.getAmount();
            float maxHealth = entity.m_21233_();
            event.setAmount(Math.min(hurtDamage, maxHealth / 16.0f));
        } else if (entity instanceof HellTravelerEntity) {
            float hurtDamage = event.getAmount();
            float maxHealth = entity.m_21233_();
            event.setAmount(Math.min(hurtDamage, maxHealth / 21.0f));
        } else if (entity instanceof EndScholarEntity) {
            float hurtDamage = event.getAmount();
            float maxHealth = entity.m_21233_();
            event.setAmount(Math.min(hurtDamage, maxHealth / 21.0f));
        } else if (entity instanceof LostOneEntity) {
            float hurtDamage = event.getAmount();
            float maxHealth = entity.m_21233_();
            event.setAmount(Math.min(hurtDamage, maxHealth / 21.0f));
        } else if (entity instanceof GoodEvilEntity) {
            float hurtDamage = event.getAmount();
            float maxHealth = entity.m_21233_();
            event.setAmount(Math.min(hurtDamage, maxHealth / 31.0f));
        } else if (entity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_1)) {
            float hurtDamage = event.getAmount();
            float maxHealth = entity.m_21233_();
            event.setAmount(Math.min(hurtDamage, maxHealth / 6.0f));
        } else if (entity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_2)) {
            float hurtDamage = event.getAmount();
            float maxHealth = entity.m_21233_();
            event.setAmount(Math.min(hurtDamage, maxHealth / 6.0f));
        } else if (entity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_3)) {
            float hurtDamage = event.getAmount();
            float maxHealth = entity.m_21233_();
            event.setAmount(Math.min(hurtDamage, maxHealth / 11.0f));
        } else if (entity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_4)) {
            float hurtDamage = event.getAmount();
            float maxHealth = entity.m_21233_();
            event.setAmount(Math.min(hurtDamage, maxHealth / 11.0f));
        } else if (entity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_5)) {
            float hurtDamage = event.getAmount();
            float maxHealth = entity.m_21233_();
            event.setAmount(Math.min(hurtDamage, maxHealth / 16.0f));
        } else if (entity.m_6095_().m_204039_(EntityTagGenerator.BOSS_LEVEL_6)) {
            float hurtDamage = event.getAmount();
            float maxHealth = entity.m_21233_();
            event.setAmount(Math.min(hurtDamage, maxHealth / 21.0f));
        }
    }

    static {
        Supplier[] supplierArray = new Supplier[15];
        supplierArray[0] = () -> ((RegistryObject)AetherEntityTypes.SUN_SPIRIT).get();
        supplierArray[1] = () -> AOMEntities.SHADOW_DEMON.get();
        supplierArray[2] = () -> AOMEntities.ICE_THUNDER_SOUL.get();
        supplierArray[3] = () -> AOMEntities.SCULK_SHRIEKER.get();
        supplierArray[4] = () -> AOMEntities.HELL_TRAVELER.get();
        supplierArray[5] = () -> AOMEntities.END_SCHOLAR.get();
        supplierArray[6] = () -> AOMEntities.LOST_ONE.get();
        supplierArray[7] = () -> AOMEntities.GOOD_EVIL.get();
        supplierArray[8] = () -> AOMEntities.PRIDE.get();
        supplierArray[9] = () -> AOMEntities.GREED.get();
        supplierArray[10] = () -> AOMEntities.LUST.get();
        supplierArray[11] = () -> AOMEntities.ENVY.get();
        supplierArray[12] = () -> AOMEntities.GLUTTONY.get();
        supplierArray[13] = () -> AOMEntities.WRATH.get();
        supplierArray[14] = () -> AOMEntities.SLOTH.get();
        DIFFICULTY_WHITE_LIST_NEW = Arrays.asList(supplierArray);
        LEVEL_1 = new Difficulty(1.0f, 1.0f, 1.0f, 1.0f);
        LEVEL_3 = new Difficulty(3.0f, 2.0f, 2.0f, 1.0f);
        LEVEL_5 = new Difficulty(5.0f, 3.0f, 2.0f, 2.0f);
        LEVEL_8 = new Difficulty(8.0f, 4.0f, 3.0f, 3.0f);
        LEVEL_10 = new Difficulty(10.0f, 5.0f, 5.0f, 5.0f);
        LEVEL_15 = new Difficulty(15.0f, 10.0f, 10.0f, 5.0f);
        LEVEL_30 = new Difficulty(30.0f, 10.0f, 10.0f, 5.0f);
        LEVEL_LOST_CITY = new Difficulty(50.0f, 20.0f, 20.0f, 10.0f);
    }

    public static class Difficulty {
        private final float id;
        private final float healthAmplify;
        private final float attackDamageAmplify;
        private final float armorAmplify;
        private final float armorToughnessAmplify;

        public Difficulty(float healthAmplify, float attackDamageAmplify, float armorAmplify, float armorToughnessAmplify) {
            this.id = healthAmplify;
            this.healthAmplify = healthAmplify;
            this.attackDamageAmplify = attackDamageAmplify;
            this.armorAmplify = armorAmplify;
            this.armorToughnessAmplify = armorToughnessAmplify;
        }

        public Difficulty(float healthAmplify) {
            this.id = healthAmplify;
            this.healthAmplify = healthAmplify;
            this.attackDamageAmplify = healthAmplify / 2.0f;
            this.armorAmplify = healthAmplify / 2.0f;
            this.armorToughnessAmplify = healthAmplify / 2.0f;
        }

        public float getHealthAmplify() {
            return this.healthAmplify;
        }

        public float getAttackDamageAmplify() {
            return this.attackDamageAmplify;
        }

        public float getArmorAmplify() {
            return this.armorAmplify;
        }

        public float getArmorToughnessAmplify() {
            return this.armorToughnessAmplify;
        }

        public float getId() {
            return this.id;
        }
    }
}

