/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.difficulty.capability;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.difficulty.api.IMobDifficulty;
import com.kurome.ageofmythology.difficulty.config.DifficultyConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class MobDifficultyCapability
implements IMobDifficulty,
ICapabilitySerializable<CompoundTag> {
    public static Capability<IMobDifficulty> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IMobDifficulty>(){});
    public static ResourceLocation NAME = AgeOfMythologyMod.id("mob_difficulty");
    private static final String Difficulty_ID = "Difficulty_ID";
    private static final String Difficulty_HEALTH = "Difficulty_HEALTH";
    private static final String Difficulty_DAMAGE = "Difficulty_DAMAGE";
    private static final String Difficulty_ARMOR = "Difficulty_ARMOR";
    private static final String Difficulty_ARMOR_TOUGHNESS = "Difficulty_ARMOR_TOUGHNESS";
    private static final String NBT_PROCESSED = "Processed";
    private final LazyOptional<IMobDifficulty> holder = LazyOptional.of(() -> this);
    private DifficultyConfig.Difficulty difficulty = DifficultyConfig.LEVEL_1;
    private boolean processed = false;

    @Override
    public DifficultyConfig.Difficulty getDifficulty() {
        return this.difficulty;
    }

    @Override
    public void setDifficulty(Mob mob) {
        DifficultyConfig.Difficulty areaDiff = DifficultyConfig.areaDifficulty((Entity)mob);
        DifficultyConfig.Difficulty specialMobDiff = DifficultyConfig.specialMobDifficulty((Entity)mob);
        this.difficulty = areaDiff.getId() > specialMobDiff.getId() ? areaDiff : specialMobDiff;
    }

    @Override
    public void setDifficulty(DifficultyConfig.Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    @Override
    public void tick(Mob entity) {
        if (!this.processed && entity.m_6084_() && entity.f_19797_ > 2) {
            this.processed = true;
            this.setDifficulty(entity);
            DifficultyConfig.modify((LivingEntity)entity, this);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return INSTANCE.orEmpty(cap, this.holder);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_(Difficulty_ID, this.difficulty.getId());
        nbt.m_128350_(Difficulty_HEALTH, this.difficulty.getHealthAmplify());
        nbt.m_128350_(Difficulty_DAMAGE, this.difficulty.getAttackDamageAmplify());
        nbt.m_128350_(Difficulty_ARMOR, this.difficulty.getArmorAmplify());
        nbt.m_128350_(Difficulty_ARMOR_TOUGHNESS, this.difficulty.getArmorToughnessAmplify());
        nbt.m_128379_(NBT_PROCESSED, this.processed);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.difficulty = new DifficultyConfig.Difficulty(nbt.m_128457_(Difficulty_ID), nbt.m_128457_(Difficulty_DAMAGE), nbt.m_128457_(Difficulty_ARMOR), nbt.m_128457_(Difficulty_ARMOR_TOUGHNESS));
        this.processed = nbt.m_128471_(NBT_PROCESSED);
    }

    public static boolean canAttachTo(ICapabilityProvider entity) {
        return entity instanceof Mob && !entity.getCapability(INSTANCE).isPresent();
    }
}

