/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.data.language;

import com.kurome.ageofmythology.block.AOMSkullBlock;
import com.kurome.ageofmythology.init.AOMBlocks;
import com.kurome.ageofmythology.utils.LangUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;

public class AOMEnglishProvider
extends LanguageProvider {
    private ExistingFileHelper helper;
    private final Map<String, String> translations = new HashMap<String, String>();
    private static final String LANGUAGE = "en_us";

    public AOMEnglishProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "ageofmythology", LANGUAGE);
        this.helper = helper;
    }

    protected void addTranslations() {
        LangUtils.loadLanguage("minecraft", this.helper, LANGUAGE);
        LangUtils.loadModLanguage("alexsmobs", "alexsmobs-1.22.9.jar", LANGUAGE);
        LangUtils.loadModLanguage("alexscaves", "alexscaves-2.0.2.jar", LANGUAGE);
        LangUtils.loadModLanguage("biomancy", "biomancy-forge-1.20.1-2.8.19.0.jar", LANGUAGE);
        LangUtils.loadModLanguage("bosses_of_mass_destruction", "BOMD-Forge-1.20.1-1.1.2.jar", LANGUAGE);
        LangUtils.loadModLanguage("bygonenether", "bygonenether-1.3.2-1.20.x.jar", LANGUAGE);
        LangUtils.loadModLanguage("cataclysm", "L_Enders_Cataclysm-3.07.jar", LANGUAGE);
        LangUtils.loadModLanguage("crittersandcompanions", "crittersandcompanions-forge-2.2.2.jar", LANGUAGE);
        LangUtils.loadModLanguage("conjurer_illager", "the-conjurer-1.20.1-1.1.6.jar", LANGUAGE);
        LangUtils.loadModLanguage("deeperdarker", "deeperdarker-forge-1.20.1-1.3.3.jar", LANGUAGE);
        LangUtils.loadModLanguage("graveyard", "The-Graveyard-3.1.jar", LANGUAGE);
        LangUtils.loadModLanguage("goety", "goety-2.5.36.1.jar", LANGUAGE);
        LangUtils.loadModLanguage("raided", "Raided-1.20.1-0.1.4.jar", LANGUAGE);
        LangUtils.loadModLanguage("takesapillage", "takesapillage-1.0.3-1.20.1.jar", LANGUAGE);
        LangUtils.loadModLanguage("twilightforest", "twilightforest-1.20.1-4.3.2508-universal.jar", LANGUAGE);
        LangUtils.loadModLanguage("iceandfire", "iceandfire-2.1.13-1.20.1-beta-5.jar", LANGUAGE);
        LangUtils.loadModLanguage("irons_spellbooks", "irons_spellbooks-1.20.1-3.4.0.9-fix.jar", LANGUAGE);
        LangUtils.loadModLanguage("traveloptics", "traveloptics-5.3.1-1.20.1.jar", LANGUAGE);
        AOMBlocks.BLOCKS.getEntries().forEach(block -> {
            if (block.get() instanceof AOMSkullBlock) {
                ArrayList<String> info = LangUtils.getInfoByBlockID(block.getId().toString());
                this.addSafe((Block)block.get(), LangUtils.getTranslation("entity." + info.get(0) + "." + info.get(1)) + "'s Hallow");
            }
        });
        this.addSafe("ageofmythology.tooltip.item.bee_skull", "increase speed and damage");
        this.addSafe("ageofmythology.tooltip.item.nucleeper", "increase boom damage");
        this.addSafe("ageofmythology.tooltip.item.minecraft_warden_item", "It's Warden Hallow");
        this.addSafe("ageofmythology.tooltip.cosmetic", "Cosmetic");
        this.addSafe("curios.identifier.skull", "Hallow");
        this.addSafe("curios.modifiers.skull", "When Equip:");
        this.addSafe((Block)AOMBlocks.AGEOFMYTHOLOGY_CATACLYSMIC_BLOCK.get(), "Cataclysmic Hallow");
        this.addSafe((Block)AOMBlocks.AGEOFMYTHOLOGY_FLESH_BLOCK.get(), "Flesh Hallow");
        this.addSafe((Block)AOMBlocks.AGEOFMYTHOLOGY_VERDANT_BLOCK.get(), "Verdant Hallow");
        this.addSafe((Block)AOMBlocks.AGEOFMYTHOLOGY_ELDRITCH_BLOCK.get(), "Eldritch Hallow");
        this.addSafe((Block)AOMBlocks.AGEOFMYTHOLOGY_UMBRAL_BLOCK.get(), "Umbral Hallow");
        this.addSafe((Block)AOMBlocks.AGEOFMYTHOLOGY_DREAD_BLOCK.get(), "Dread Hallow");
        this.addSafe((Block)AOMBlocks.BOSSES_OF_MASS_DESTRUCTION_GAUNTLET_BLOCK.get(), "Nether Gauntlet's Hallow");
        this.addSafe((Block)AOMBlocks.BOSSES_OF_MASS_DESTRUCTION_LICH_BLOCK.get(), "Lich's Hallow");
        this.addSafe((Block)AOMBlocks.BOSSES_OF_MASS_DESTRUCTION_OBSIDILITH_BLOCK.get(), "Obsidilith's Hallow");
        this.addSafe((Block)AOMBlocks.BOSSES_OF_MASS_DESTRUCTION_VOID_BLOSSOM_WALL_BLOCK.get(), "Void Blossom's Hallow");
        this.addSafe((Block)AOMBlocks.CONJURER_ILLAGER_CONJURER_BLOCK.get(), "Conjurer's Hallow");
        this.addSafe("itemGroup.ageofmythology", "The Fool");
        this.translations.forEach((arg_0, arg_1) -> ((AOMEnglishProvider)this).add(arg_0, arg_1));
    }

    private void addSafe(String key, String value) {
        this.translations.put(key, value);
    }

    private void addSafe(Block key, String value) {
        this.translations.put(key.m_7705_(), value);
    }
}

