/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.data;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.init.AOMEntities;
import com.kurome.ageofmythology.init.AOMItems;
import com.kurome.ageofmythology.item.AOMRelicItem;
import com.kurome.ageofmythology.item.AOMSkullItem;
import com.kurome.ageofmythology.item.autism.IAutism;
import com.kurome.ageofmythology.item.general.BloodBottleItem;
import com.wuest.prefab.structures.items.ItemBasicStructure;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.ItemLayerModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "ageofmythology", existingFileHelper);
    }

    protected void registerModels() {
        AOMItems.ITEMS.getEntries().forEach(item -> {
            if (item.get() instanceof AOMSkullItem) {
                this.withExistingParent(item.getId().toString(), AgeOfMythologyMod.prefix("item/template_skull"));
            }
            if (item.get() instanceof ItemBasicStructure) {
                this.generatedHelper((RegistryObject<Item>)item, new ResourceLocation("ageofmythology", "item/ritual_structure"));
            }
            if (item.get() instanceof AOMRelicItem) {
                if (item.get() instanceof IAutism) {
                    this.generatedHelper((RegistryObject<Item>)item, new ResourceLocation("ageofmythology", "item/autism/%s".formatted(item.getId().m_135815_())));
                } else {
                    this.generatedHelper((RegistryObject<Item>)item, new ResourceLocation("ageofmythology", "item/%s".formatted(item.getId().m_135815_())));
                }
            }
        });
        AOMEntities.SPAWN_EGGS.getEntries().forEach(spawn_egg -> this.withExistingParent(spawn_egg.getId().toString(), new ResourceLocation("item/template_spawn_egg")));
        this.generatedHelper(AOMItems.WEIRD_BOTTLE);
        this.generatedHelper(AOMItems.DEBUG_STICK);
        this.generatedHelper(AOMItems.nature_shard);
        this.generatedHelper(AOMItems.dead_shard);
        this.generatedHelper(AOMItems.sanctum_star);
        this.generatedHelper(AOMItems.flesh_star);
        this.generatedHelper(AOMItems.winter_star);
        this.generatedHelper(AOMItems.blaze_star);
        this.generatedHelper(AOMItems.arcane_star);
        this.generatedHelper(AOMItems.chaos_star);
        this.generatedHelper(AOMItems.LIFE_OAK_SAPLING, new ResourceLocation("block/oak_sapling"));
        ItemModelBuilder fullBloodBottle = this.generated("item/blood_bottle_1", AgeOfMythologyMod.prefix("item/blood_bottle_1"));
        ItemModelBuilder fullBloodBottle_0 = this.generated("item/blood_bottle", AgeOfMythologyMod.prefix("item/blood_bottle"));
        this.generated(AOMItems.BLOOD_BOTTLE.getId().m_135815_(), AgeOfMythologyMod.prefix("item/blood_bottle_1")).override().predicate(BloodBottleItem.BLOOD_BOTTLE_STATE, 1.0f).model((ModelFile)fullBloodBottle).end().override().predicate(BloodBottleItem.BLOOD_BOTTLE_STATE, 0.0f).model((ModelFile)fullBloodBottle_0).end();
        this.singleTex(AOMItems.MUSIC_DISC_QINGXINGMENG);
    }

    private void generatedHelper(RegistryObject<Item> itemRegistryObject) {
        String id = itemRegistryObject.getId().m_135815_();
        ((ItemModelBuilder)this.withExistingParent(id, "item/generated")).texture("layer0", AgeOfMythologyMod.prefix("item/%s".formatted(id)));
    }

    private void generatedHelper(RegistryObject<Item> itemRegistryObject, ResourceLocation resourceLocation) {
        String id = itemRegistryObject.getId().m_135815_();
        ((ItemModelBuilder)this.withExistingParent(id, "item/generated")).texture("layer0", resourceLocation);
    }

    private ItemModelBuilder singleTex(RegistryObject<?> item) {
        return this.generated(item.getId().m_135815_(), AgeOfMythologyMod.prefix("item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder generated(String name, ResourceLocation ... layers) {
        return this.buildItem(name, "item/generated", 0, layers);
    }

    private ItemModelBuilder buildItem(String name, String parent, int emissivity, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, parent);
        for (int i = 0; i < layers.length; ++i) {
            builder = (ItemModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        if (emissivity > 0) {
            builder = (ItemModelBuilder)((ItemLayerModelBuilder)builder.customLoader(ItemLayerModelBuilder::begin)).emissive(emissivity, emissivity, new int[]{0}).renderType("minecraft:translucent", new int[]{0}).end();
        }
        return builder;
    }
}

