/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.config.spell_mob_ability_config;

import com.cerbon.bosses_of_mass_destruction.entity.BMDEntities;
import com.gametechbc.traveloptics.init.TravelopticsSpells;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.elenterius.biomancy.init.ModEntityTypes;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.config.ability_config.AOMAbilityConfig;
import com.kurome.ageofmythology.init.AOMEntities;
import com.kurome.ageofmythology.model.Ability;
import com.legacy.conjurer_illager.registry.IllagerEntityTypes;
import com.lion.graveyard.init.TGEntities;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import twilightforest.init.TFEntities;

public class IronMagicAbility {
    public static List<Pair<Supplier<EntityType<?>>, List<Ability>>> FIRE_MOB_ABILITY_POOL;
    public static List<Pair<Supplier<EntityType<?>>, List<Ability>>> ICE_MOB_ABILITY_POOL;
    public static List<Pair<Supplier<EntityType<?>>, List<Ability>>> BLOOD_MOB_ABILITY_POOL;
    public static List<Pair<Supplier<EntityType<?>>, List<Ability>>> WATER_MOB_ABILITY_POOL;
    public static List<Pair<Supplier<EntityType<?>>, List<Ability>>> LIGHTNING_MOB_ABILITY_POOL;
    public static List<Pair<Supplier<EntityType<?>>, List<Ability>>> ENDER_MOB_ABILITY_POOL;
    public static List<Pair<Supplier<EntityType<?>>, List<Ability>>> OTHER_MOB_ABILITY_POOL;
    public static List<Pair<Supplier<EntityType<?>>, List<Ability>>> BOSS_MOB_ABILITY_POOL;
    public static List<Pair<Supplier<EntityType<?>>, List<Ability>>> MOB_ABILITY_POOL;

    public static List<? extends EntityType<?>> getMobAbilityList() {
        return MOB_ABILITY_POOL.stream().map(k -> (EntityType)((Supplier)k.getKey()).get()).toList();
    }

    public static List<Ability> getMobAbilities(EntityType<?> entityType) {
        return MOB_ABILITY_POOL.stream().filter(k -> ((EntityType)((Supplier)k.getKey()).get()).equals(entityType)).map(Pair::getValue).findFirst().orElse(List.of());
    }

    public static <T> T selectByWeight(List<T> weightedItems, ToIntFunction<T> weightExtractor) {
        if (weightedItems == null || weightedItems.isEmpty()) {
            return null;
        }
        int totalWeight = weightedItems.stream().mapToInt(weightExtractor).sum();
        if (totalWeight <= 0) {
            return weightedItems.get(ThreadLocalRandom.current().nextInt(weightedItems.size()));
        }
        int randomValue = ThreadLocalRandom.current().nextInt(totalWeight);
        int currentWeight = 0;
        for (T item : weightedItems) {
            if (randomValue >= (currentWeight += weightExtractor.applyAsInt(item))) continue;
            return item;
        }
        return weightedItems.get(0);
    }

    public static Ability GYRO_SLASH_SPELL() {
        AbstractSpell spell = (AbstractSpell)TravelopticsSpells.GYRO_SLASH_SPELL.get();
        return new Ability((level, livingEntity, player, timeExecutor) -> {
            spell.onCast(level, AOMUtil.getRealSpellLevel((LivingEntity)player), (LivingEntity)player, CastSource.NONE, AOMAbilityConfig.getMagicData((LivingEntity)player));
            AOMAbilityConfig.playSound(player, spell);
        }).setType(Ability.AbilityType.MACHINE).setNotSpellingMob();
    }

    public static Ability STARFALL_SPELL() {
        AbstractSpell spell = (AbstractSpell)SpellRegistry.STARFALL_SPELL.get();
        return new Ability((level, livingEntity, player, timeExecutor) -> {
            Mob mob;
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() != null) {
                mob.m_7618_(EntityAnchorArgument.Anchor.EYES, mob.m_5448_().m_20182_());
                IronMagicAbility.castSpell(spell.getSpellId(), livingEntity);
            }
        }).setCooldown(200);
    }

    public static Ability ICE_BLOCK_SPELL() {
        AbstractSpell spell = (AbstractSpell)SpellRegistry.ICE_BLOCK_SPELL.get();
        return new Ability((level, livingEntity, player, timeExecutor) -> {
            Mob mob;
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() != null) {
                mob.m_7618_(EntityAnchorArgument.Anchor.EYES, mob.m_5448_().m_20182_());
                IronMagicAbility.castSpell(spell.getSpellId(), livingEntity);
            }
        }).setCooldown(60);
    }

    public static Ability SPELL_ABILITY(AbstractSpell spell) {
        return new Ability((level, livingEntity, player, timeExecutor) -> {
            Mob mob;
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() != null) {
                mob.m_7618_(EntityAnchorArgument.Anchor.EYES, mob.m_5448_().m_20182_());
                IronMagicAbility.castSpell(spell.getSpellId(), livingEntity);
            }
        });
    }

    public static void castSpell(String spellId, LivingEntity livingEntity) {
        IronMagicAbility.castSpell(spellId, livingEntity, 3, 3);
    }

    public static void castSpell(String spellId, LivingEntity livingEntity, int minLevel, int maxLevel) {
        if (!((String)spellId).contains(":")) {
            spellId = "irons_spellbooks:" + (String)spellId;
        }
        AbstractSpell spell = SpellRegistry.getSpell((String)spellId);
        Level level = livingEntity.m_9236_();
        int spellLevel = livingEntity.m_217043_().m_216332_(minLevel, maxLevel);
        if (livingEntity instanceof IMagicEntity) {
            IMagicEntity castingMob = (IMagicEntity)livingEntity;
            castingMob.initiateCastSpell(spell, spellLevel);
        } else {
            MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)livingEntity);
            if (!spell.checkPreCastConditions(level, spellLevel, livingEntity, magicData)) {
                return;
            }
            spell.onCast(level, spellLevel, livingEntity, CastSource.MOB, magicData);
            spell.onServerCastComplete(level, spellLevel, livingEntity, magicData, false);
        }
    }

    static {
        Pair[] pairArray = new Pair[3];
        pairArray[0] = new ImmutablePair(() -> EntityType.f_20551_, Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.FIREBOLT_SPELL.get()).setWeight(3).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.FIRE_BREATH_SPELL.get()).setWeight(1).setCooldown(200)));
        pairArray[1] = new ImmutablePair(() -> ((RegistryObject)ModEntities.IGNITED_BERSERKER).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.FIREBALL_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.HEAT_SURGE_SPELL.get()).setWeight(1).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.FLAMING_STRIKE_SPELL.get()).setWeight(1).setCooldown(200)));
        pairArray[2] = new ImmutablePair(() -> ((RegistryObject)ModEntities.IGNITED_REVENANT).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.FIREBALL_SPELL.get()).setWeight(3).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BLAZE_STORM_SPELL.get()).setWeight(1).setCooldown(120)));
        FIRE_MOB_ABILITY_POOL = Arrays.asList(pairArray);
        Pair[] pairArray2 = new Pair[7];
        pairArray2[0] = new ImmutablePair(() -> ((RegistryObject)TFEntities.YETI).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.ICICLE_SPELL.get()).setWeight(1).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.RAY_OF_FROST_SPELL.get()).setWeight(1).setCooldown(200)));
        pairArray2[1] = new ImmutablePair(() -> EntityType.f_20514_, Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.SUMMON_POLAR_BEAR_SPELL.get()).setWeight(1).setCooldown(200)));
        pairArray2[2] = new ImmutablePair(() -> ((RegistryObject)IafEntityRegistry.DREAD_THRALL).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.DESPAIR.get()).setWeight(1).setCooldown(100)));
        pairArray2[3] = new ImmutablePair(() -> ((RegistryObject)IafEntityRegistry.DREAD_BEAST).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.DESPAIR.get()).setWeight(1).setCooldown(100)));
        pairArray2[4] = new ImmutablePair(() -> ((RegistryObject)IafEntityRegistry.DREAD_GHOUL).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.DESPAIR.get()).setWeight(1).setCooldown(100)));
        pairArray2[5] = new ImmutablePair(() -> ((RegistryObject)IafEntityRegistry.DREAD_LICH).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.CURSED_BLAST_SPELL.get()).setWeight(1).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.CURSED_REVENANTS_SPELL.get()).setWeight(1).setCooldown(160)));
        pairArray2[6] = new ImmutablePair(() -> ((RegistryObject)IafEntityRegistry.DREAD_KNIGHT).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.HALBERD_HORIZON.get()).setWeight(1).setCooldown(100)));
        ICE_MOB_ABILITY_POOL = Arrays.asList(pairArray2);
        Pair[] pairArray3 = new Pair[6];
        pairArray3[0] = new ImmutablePair(() -> ((RegistryObject)ACEntityRegistry.FORSAKEN).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.BLOOD_HOWL_SPELL.get()).setWeight(3).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BLOOD_NEEDLES_SPELL.get()).setWeight(2).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.NOCTURNAL_SWARM_SPELL.get()).setWeight(1).setCooldown(200)));
        pairArray3[1] = new ImmutablePair(((Supplier)TGEntities.NIGHTMARE)::get, Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get()).setWeight(3).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BLOOD_NEEDLES_SPELL.get()).setWeight(2).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.RAISE_DEAD_SPELL.get()).setWeight(1).setCooldown(200)));
        pairArray3[2] = new ImmutablePair(((Supplier)TGEntities.CORRUPTED_PILLAGER)::get, Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.FANG_STRIKE_SPELL.get()).setWeight(3).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BLOOD_STEP_SPELL.get()).setWeight(1).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.SUMMON_VEX_SPELL.get()).setWeight(1).setCooldown(200)));
        pairArray3[3] = new ImmutablePair(((Supplier)TGEntities.CORRUPTED_VINDICATOR)::get, Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.FANG_WARD_SPELL.get()).setWeight(3).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BLOOD_STEP_SPELL.get()).setWeight(1).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.SUMMON_VEX_SPELL.get()).setWeight(1).setCooldown(200)));
        pairArray3[4] = new ImmutablePair(() -> ((RegistryObject)ModEntityTypes.FLESH_BLOB).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.RAY_OF_SIPHONING_SPELL.get()).setWeight(3).setCooldown(160)));
        pairArray3[5] = new ImmutablePair(() -> ((RegistryObject)ModEntityTypes.PRIMORDIAL_FLESH_BLOB).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.RAY_OF_SIPHONING_SPELL.get()).setWeight(3).setCooldown(160)));
        BLOOD_MOB_ABILITY_POOL = Arrays.asList(pairArray3);
        Pair[] pairArray4 = new Pair[3];
        pairArray4[0] = new ImmutablePair(() -> ((RegistryObject)ModEntities.CINDARIA).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.AQUA_MISSILES_SPELL.get()).setWeight(1).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.HYDROSHOT_SPELL.get()).setWeight(3).setCooldown(100)));
        pairArray4[1] = new ImmutablePair(() -> ((RegistryObject)ModEntities.URCHINKIN).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.HYDROSHOT_SPELL.get()).setWeight(3).setCooldown(100)));
        pairArray4[2] = new ImmutablePair(() -> ((RegistryObject)ModEntities.HIPPOCAMTUS).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.TIDAL_GRASP_SPELL.get()).setWeight(2).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.TIDAL_SLASH_SPELL.get()).setWeight(2).setCooldown(100)));
        WATER_MOB_ABILITY_POOL = Arrays.asList(pairArray4);
        Pair[] pairArray5 = new Pair[4];
        pairArray5[0] = new ImmutablePair(() -> ((RegistryObject)ACEntityRegistry.MAGNETRON).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BALL_LIGHTNING_SPELL.get()).setWeight(3).setCooldown(100)));
        pairArray5[1] = new ImmutablePair(() -> ((RegistryObject)ACEntityRegistry.TELETOR).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BALL_LIGHTNING_SPELL.get()).setWeight(3).setCooldown(100)));
        pairArray5[2] = new ImmutablePair(() -> ((RegistryObject)ACEntityRegistry.BOUNDROID).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.SHOCKWAVE_SPELL.get()).setWeight(3).setCooldown(100)));
        pairArray5[3] = new ImmutablePair(() -> ((RegistryObject)ACEntityRegistry.FERROUSLIME).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BALL_LIGHTNING_SPELL.get()).setWeight(3).setCooldown(100)));
        LIGHTNING_MOB_ABILITY_POOL = Arrays.asList(pairArray5);
        ENDER_MOB_ABILITY_POOL = Arrays.asList(new ImmutablePair(() -> EntityType.f_20566_, Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.MAGIC_MISSILE_SPELL.get()).setWeight(3).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.ORBITAL_VOID_SPELL.get()).setWeight(1).setCooldown(200))));
        Pair[] pairArray6 = new Pair[6];
        pairArray6[0] = new ImmutablePair(() -> IllagerEntityTypes.CONJURER, Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.FANG_STRIKE_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.FANG_WARD_SPELL.get()).setWeight(3).setCooldown(60)));
        pairArray6[1] = new ImmutablePair(() -> ((RegistryObject)IafEntityRegistry.CYCLOPS).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.EARTHQUAKE_SPELL.get()).setWeight(1).setCooldown(120), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.STOMP_SPELL.get()).setWeight(1).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.OAKSKIN_SPELL.get()).setWeight(1).setCooldown(160)));
        pairArray6[2] = new ImmutablePair(() -> ((RegistryObject)ModEntities.KOBOLEDIATOR).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.STELE_CASCADE_SPELL.get()).setWeight(1).setCooldown(120), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.GYRO_SLASH_SPELL.get()).setWeight(1).setCooldown(100)));
        pairArray6[3] = new ImmutablePair(() -> ((RegistryObject)ModEntities.WADJET).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.STELE_CASCADE_SPELL.get()).setWeight(1).setCooldown(120), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.GYRO_SLASH_SPELL.get()).setWeight(1).setCooldown(100)));
        pairArray6[4] = new ImmutablePair(() -> ((RegistryObject)EntityRegistry.KEEPER).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BLOOD_SLASH_SPELL.get()).setWeight(1).setCooldown(120), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BLOOD_NEEDLES_SPELL.get()).setWeight(1).setCooldown(100)));
        pairArray6[5] = new ImmutablePair(() -> AOMUtil.getEntityTypeDefault("eeeabsmobs:immortal_shaman"), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BLOOD_SLASH_SPELL.get()).setWeight(1).setCooldown(120), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BLOOD_NEEDLES_SPELL.get()).setWeight(1).setCooldown(100)));
        OTHER_MOB_ABILITY_POOL = Arrays.asList(pairArray6);
        Pair[] pairArray7 = new Pair[11];
        pairArray7[0] = new ImmutablePair(() -> ((RegistryObject)BMDEntities.VOID_BLOSSOM).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.VOID_ERUPTION_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.LIGHTNING_BOLT_SPELL.get()).setWeight(3).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.ORBITAL_VOID_SPELL.get()).setWeight(1).setCooldown(200), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.DESPAIR.get()).setWeight(2).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.ABYSSAL_BLAST_SPELL.get()).setWeight(1).setCooldown(200), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.CURSED_MINEFIELD_SPELL.get()).setWeight(1).setCooldown(200), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.ETERNAL_SENTINEL_SPELL.get()).setWeight(1).setCooldown(200)));
        pairArray7[1] = new ImmutablePair(() -> ((RegistryObject)BMDEntities.OBSIDILITH).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.VOID_ERUPTION_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.STARFALL_SPELL.get()).setWeight(2).setCooldown(200), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.HALBERD_HORIZON.get()).setWeight(1).setCooldown(200), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.METEOR_STORM.get()).setWeight(1).setCooldown(200)));
        pairArray7[2] = new ImmutablePair(() -> ((RegistryObject)TFEntities.SNOW_QUEEN).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.ICICLE_SPELL.get()).setWeight(1).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.SUMMON_POLAR_BEAR_SPELL.get()).setWeight(1).setCooldown(200), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.RAY_OF_FROST_SPELL.get()).setWeight(1).setCooldown(200), IronMagicAbility.ICE_BLOCK_SPELL().setWeight(2)));
        pairArray7[3] = new ImmutablePair(() -> ((RegistryObject)TFEntities.ALPHA_YETI).get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.ICICLE_SPELL.get()).setWeight(1).setCooldown(200), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.DESPAIR.get()).setWeight(2).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.HALBERD_HORIZON.get()).setWeight(1).setCooldown(200)));
        pairArray7[4] = new ImmutablePair(() -> AOMEntities.PRIDE.get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.ELDRITCH_BLAST_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.MAGIC_MISSILE_SPELL.get()).setWeight(3).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.MAGIC_ARROW_SPELL.get()).setWeight(3).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.STARFALL_SPELL.get()).setWeight(2).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.DESPAIR.get()).setWeight(2).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.VORTEX_PUNCH_SPELL.get()).setWeight(1).setCooldown(120), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.VOID_ERUPTION_SPELL.get()).setWeight(1).setCooldown(120), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.ABYSSAL_BLAST_SPELL.get()).setWeight(1).setCooldown(200)));
        pairArray7[5] = new ImmutablePair(() -> AOMEntities.GREED.get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.BLOOD_HOWL_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get()).setWeight(3).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BLOOD_SLASH_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BLOOD_NEEDLES_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.NOCTURNAL_SWARM_SPELL.get()).setWeight(2).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.RAY_OF_SIPHONING_SPELL.get()).setWeight(2).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.ACUPUNCTURE_SPELL.get()).setWeight(1).setCooldown(120), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BLOOD_STEP_SPELL.get()).setWeight(1).setCooldown(100)));
        pairArray7[6] = new ImmutablePair(() -> AOMEntities.LUST.get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.FLOOD_SLASH_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.TIDAL_SLASH_SPELL.get()).setWeight(3).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.HYDROSHOT_SPELL.get()).setWeight(3).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.CORAL_BARRAGE_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.TSUNAMI_SPELL.get()).setWeight(2).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.TIDAL_GRASP_SPELL.get()).setWeight(2).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.VORTEX_OF_THE_DEEP_SPELL.get()).setWeight(1).setCooldown(200), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.AQUA_MISSILES_SPELL.get()).setWeight(1).setCooldown(100)));
        pairArray7[7] = new ImmutablePair(() -> AOMEntities.ENVY.get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.ICICLE_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.CONE_OF_COLD_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.ICE_BLOCK_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.DESPAIR.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.CURSED_BLAST_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.RAY_OF_FROST_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.FROSTWAVE_SPELL.get()).setWeight(2).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.SUMMON_POLAR_BEAR_SPELL.get()).setWeight(2).setCooldown(160)));
        pairArray7[8] = new ImmutablePair(() -> AOMEntities.GLUTTONY.get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.ACID_ORB_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.OAKSKIN_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.POISON_ARROW_SPELL.get()).setWeight(3).setCooldown(60), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.FIREFLY_SWARM_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.POISON_SPLASH_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.BLIGHT_SPELL.get()).setWeight(2).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.SPIDER_ASPECT_SPELL.get()).setWeight(2).setCooldown(160)));
        pairArray7[9] = new ImmutablePair(() -> AOMEntities.WRATH.get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.SCORCH_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.FLAMING_STRIKE_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.FIREBALL_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)SpellRegistry.FIREBOLT_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.GYRO_SLASH_SPELL.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.BURNING_JUDGMENT.get()).setWeight(3).setCooldown(100), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.LAVA_BOMB_SPELL.get()).setWeight(2).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.ANNIHILATION_SPELL.get()).setWeight(1).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.EXTINCTION_SPELL.get()).setWeight(1).setCooldown(160)));
        pairArray7[10] = new ImmutablePair(() -> AOMEntities.SLOTH.get(), Arrays.asList(IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.THE_FORGOTTEN_BEAST_SPELL.get()).setWeight(3).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.MAGNETRON_DEPLOYMENT_SPELL.get()).setWeight(3).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.PRIMORDIAL_STEED_SPELL.get()).setWeight(3).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.SUMMON_DESERT_DWELLERS.get()).setWeight(3).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.ETERNAL_SENTINEL_SPELL.get()).setWeight(3).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.CURSED_REVENANTS_SPELL.get()).setWeight(3).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.STICKY_STEED_SUMMON_SPELL.get()).setWeight(3).setCooldown(160), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.AXE_OF_THE_DOOMED_SPELL.get()).setWeight(2).setCooldown(200), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.IGNITED_ONSLAUGHT_SPELL.get()).setWeight(2).setCooldown(200), IronMagicAbility.SPELL_ABILITY((AbstractSpell)TravelopticsSpells.CALL_FORTH_THE_DEAD_KING_SPELL.get()).setWeight(2).setCooldown(240)));
        BOSS_MOB_ABILITY_POOL = Arrays.asList(pairArray7);
        MOB_ABILITY_POOL = new ArrayList<Pair<Supplier<EntityType<?>>, List<Ability>>>(){
            {
                this.addAll(FIRE_MOB_ABILITY_POOL);
                this.addAll(ICE_MOB_ABILITY_POOL);
                this.addAll(BLOOD_MOB_ABILITY_POOL);
                this.addAll(ENDER_MOB_ABILITY_POOL);
                this.addAll(WATER_MOB_ABILITY_POOL);
                this.addAll(LIGHTNING_MOB_ABILITY_POOL);
                this.addAll(OTHER_MOB_ABILITY_POOL);
                this.addAll(BOSS_MOB_ABILITY_POOL);
            }
        };
    }
}

