/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.config.ability_config.abyss;

import com.gametechbc.traveloptics.entity.extended_projectiles.ExtendedWaterBoltEntity;
import com.gametechbc.traveloptics.entity.projectiles.BubbleSprayProjectile;
import com.gametechbc.traveloptics.entity.projectiles.coral_bolt.BlueCoralBoltProjectile;
import com.gametechbc.traveloptics.entity.projectiles.coral_bolt.PinkCoralBoltProjectile;
import com.gametechbc.traveloptics.entity.projectiles.coral_bolt.RedCoralBoltProjectile;
import com.gametechbc.traveloptics.entity.projectiles.coral_bolt.YellowCoralBoltProjectile;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsEntities;
import com.gametechbc.traveloptics.init.TravelopticsSpells;
import com.gametechbc.traveloptics.spells.aqua.AquaMissilesSpell;
import com.gametechbc.traveloptics.spells.aqua.BubbleSpraySpell;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.config.ability_config.AOMAbilityConfig;
import com.kurome.ageofmythology.model.Ability;
import com.kurome.ageofmythology.model.MorphData;
import com.kurome.ageofmythology.net.Messages;
import com.kurome.ageofmythology.net.general.ClientSyncToolTip;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.AbstractConeProjectile;
import io.redspace.ironsspellbooks.spells.EntityCastData;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AbyssAbilityConfig {
    public static int ABYSS_COOLDOWN = 100;

    public static Ability ABYSSAL_BLAST_SPELL() {
        AbstractSpell spell = (AbstractSpell)TravelopticsSpells.ABYSSAL_BLAST_SPELL.get();
        return new Ability(new MorphData(spell), (level, livingEntity, player, timeExecutor) -> {
            spell.onCast(level, AOMUtil.getRealSpellLevel((LivingEntity)player), (LivingEntity)player, CastSource.NONE, AOMAbilityConfig.getMagicData((LivingEntity)player));
            AOMAbilityConfig.playSound(player, spell);
        }).setType(Ability.AbilityType.ABYSS).setCooldown(ABYSS_COOLDOWN + 100).setNotSpellingMob();
    }

    public static Ability TIDAL_GRASP_SPELL() {
        AbstractSpell spell = (AbstractSpell)TravelopticsSpells.TIDAL_GRASP_SPELL.get();
        return new Ability(new MorphData(spell), (level, livingEntity, player, timeExecutor) -> {
            HitResult raycast = Utils.raycastForEntity((Level)level, (Entity)player, (float)32.0f, (boolean)true, (float)0.25f);
            if (raycast.m_6662_() == HitResult.Type.ENTITY) {
                Entity patt3451$temp = ((EntityHitResult)raycast).m_82443_();
                if (patt3451$temp instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)patt3451$temp;
                    LivingEntity targetEntity = target;
                    if (targetEntity instanceof LivingEntity) {
                        LivingEntity livingTarget = targetEntity;
                        Vec3 casterPos = player.m_20182_();
                        Vec3 targetPos = livingTarget.m_20182_();
                        Vec3 pullVector = casterPos.m_82546_(targetPos).m_82541_();
                        Vec3 newTargetPos = casterPos.m_82546_(pullVector.m_82490_(2.0));
                        livingTarget.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.TIDAL_GRASP_HELPER.get(), 15, 0));
                        livingTarget.m_6021_(newTargetPos.f_82479_, newTargetPos.f_82480_, newTargetPos.f_82481_);
                    }
                    player.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.TIDAL_GRASP.get(), 13, (int)spell.getSpellPower(AOMUtil.getRealSpellLevel((LivingEntity)player), (Entity)player), false, false, false));
                    AOMAbilityConfig.playSound(player, spell);
                }
            } else if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Messages.sendToPlayer(new ClientSyncToolTip(ClientSyncToolTip.ToolTipType.OVERLAY_MESSAGE.getId(), (Component)Component.m_237115_((String)"ui.irons_spellbooks.cast_error_target").m_130940_(ChatFormatting.RED)), serverPlayer);
            }
        }).setType(Ability.AbilityType.ABYSS).setCooldown(ABYSS_COOLDOWN).setNotSpellingMob();
    }

    public static Ability CORAL_BARRAGE_SPELL() {
        AbstractSpell spell = (AbstractSpell)TravelopticsSpells.CORAL_BARRAGE_SPELL.get();
        return new Ability(new MorphData(spell), (level, livingEntity, player, timeExecutor) -> {
            HitResult raycast = Utils.raycastForEntity((Level)level, (Entity)player, (float)32.0f, (boolean)true, (float)0.25f);
            if (raycast.m_6662_() == HitResult.Type.ENTITY) {
                Entity patt5766$temp = ((EntityHitResult)raycast).m_82443_();
                if (patt5766$temp instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)patt5766$temp;
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        Vec3 origin = serverPlayer.m_146892_().m_82549_(serverPlayer.m_20156_().m_82541_().m_82490_((double)0.2f));
                        switch (level.f_46441_.m_188503_(4)) {
                            case 0: {
                                BlueCoralBoltProjectile blueCoralBoltProjectile = new BlueCoralBoltProjectile(level, (LivingEntity)serverPlayer);
                                blueCoralBoltProjectile.m_146884_(origin.m_82492_(0.0, (double)blueCoralBoltProjectile.m_20206_(), 0.0));
                                Vec3 vec1 = target.m_20191_().m_82399_().m_82546_(serverPlayer.m_146892_()).m_82541_();
                                float inaccuracy1 = (float)Mth.m_14085_((double)0.2f, (double)1.4f, (double)(target.m_20182_().m_82557_(serverPlayer.m_20182_()) / 1024.0));
                                blueCoralBoltProjectile.shoot(vec1.m_82490_(0.75), inaccuracy1);
                                blueCoralBoltProjectile.setDamage(1.0f + spell.getSpellPower(AOMUtil.getRealSpellLevel((LivingEntity)player), (Entity)player));
                                blueCoralBoltProjectile.setHomingTarget(target);
                                level.m_7967_((Entity)blueCoralBoltProjectile);
                                break;
                            }
                            case 1: {
                                PinkCoralBoltProjectile pinkCoralBoltProjectile = new PinkCoralBoltProjectile(level, (LivingEntity)serverPlayer);
                                pinkCoralBoltProjectile.m_146884_(origin.m_82492_(0.0, (double)pinkCoralBoltProjectile.m_20206_(), 0.0));
                                Vec3 vec2 = target.m_20191_().m_82399_().m_82546_(serverPlayer.m_146892_()).m_82541_();
                                float inaccuracy2 = (float)Mth.m_14085_((double)0.2f, (double)1.4f, (double)(target.m_20182_().m_82557_(serverPlayer.m_20182_()) / 1024.0));
                                pinkCoralBoltProjectile.shoot(vec2.m_82490_(0.75), inaccuracy2);
                                pinkCoralBoltProjectile.setDamage(1.0f + spell.getSpellPower(AOMUtil.getRealSpellLevel((LivingEntity)player), (Entity)player));
                                pinkCoralBoltProjectile.setHomingTarget(target);
                                level.m_7967_((Entity)pinkCoralBoltProjectile);
                                break;
                            }
                            case 2: {
                                YellowCoralBoltProjectile yellowCoralBoltProjectile = new YellowCoralBoltProjectile(level, (LivingEntity)serverPlayer);
                                yellowCoralBoltProjectile.m_146884_(origin.m_82492_(0.0, (double)yellowCoralBoltProjectile.m_20206_(), 0.0));
                                Vec3 vec = target.m_20191_().m_82399_().m_82546_(serverPlayer.m_146892_()).m_82541_();
                                float inaccuracy3 = (float)Mth.m_14085_((double)0.2f, (double)1.4f, (double)(target.m_20182_().m_82557_(serverPlayer.m_20182_()) / 1024.0));
                                yellowCoralBoltProjectile.shoot(vec.m_82490_(0.75), inaccuracy3);
                                yellowCoralBoltProjectile.setDamage(1.0f + spell.getSpellPower(AOMUtil.getRealSpellLevel((LivingEntity)player), (Entity)player));
                                yellowCoralBoltProjectile.setHomingTarget(target);
                                level.m_7967_((Entity)yellowCoralBoltProjectile);
                                break;
                            }
                            case 3: {
                                RedCoralBoltProjectile redCoralBoltProjectile = new RedCoralBoltProjectile(level, (LivingEntity)serverPlayer);
                                redCoralBoltProjectile.m_146884_(origin.m_82492_(0.0, (double)redCoralBoltProjectile.m_20206_(), 0.0));
                                Vec3 vec4 = target.m_20191_().m_82399_().m_82546_(serverPlayer.m_146892_()).m_82541_();
                                float inaccuracy4 = (float)Mth.m_14085_((double)0.2f, (double)1.4f, (double)(target.m_20182_().m_82557_(serverPlayer.m_20182_()) / 1024.0));
                                redCoralBoltProjectile.shoot(vec4.m_82490_(0.75), inaccuracy4);
                                redCoralBoltProjectile.setDamage(1.0f + spell.getSpellPower(AOMUtil.getRealSpellLevel((LivingEntity)player), (Entity)player));
                                redCoralBoltProjectile.setHomingTarget(target);
                                level.m_7967_((Entity)redCoralBoltProjectile);
                            }
                        }
                        AOMAbilityConfig.playSound(player, spell);
                    }
                }
            } else if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Messages.sendToPlayer(new ClientSyncToolTip(ClientSyncToolTip.ToolTipType.OVERLAY_MESSAGE.getId(), (Component)Component.m_237115_((String)"ui.irons_spellbooks.cast_error_target").m_130940_(ChatFormatting.RED)), serverPlayer);
            }
        }).setType(Ability.AbilityType.ABYSS).setCooldown(ABYSS_COOLDOWN).setNotSpellingMob();
    }

    public static Ability AQUA_MISSILES_SPELL() {
        AbstractSpell spell = (AbstractSpell)TravelopticsSpells.AQUA_MISSILES_SPELL.get();
        int duration = ABYSS_COOLDOWN;
        return new Ability(new MorphData(spell), (level, livingEntity, player, timeExecutor) -> {
            spell.onCast(level, AOMUtil.getRealSpellLevel((LivingEntity)player), (LivingEntity)player, CastSource.NONE, AOMAbilityConfig.getMagicData((LivingEntity)player));
            Player caster = player;
            int spellLevel = AOMUtil.getRealSpellLevel((LivingEntity)player);
            if ((timeExecutor.getAge() - 1) % 3 == 0) {
                ScreenShake_Entity.ScreenShake((Level)level, (Vec3)caster.m_20182_(), (float)8.0f, (float)0.012f, (int)2, (int)3);
                double dist = ((AquaMissilesSpell)spell).getSeekingDistance(spellLevel);
                Entity randomlyValid = AquaMissilesSpell.getRandomlyLookingAtEntityFor((Level)level, (LivingEntity)caster, (double)dist);
                ExtendedWaterBoltEntity bolt = new ExtendedWaterBoltEntity((EntityType)TravelopticsEntities.EXTENDED_WATER_BOLT.get(), level);
                double offsetDirection = player.m_217043_().m_188499_() ? -0.72 : 0.72;
                double offsetX = offsetDirection * (double)Mth.m_14089_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
                double offsetZ = offsetDirection * (double)Mth.m_14031_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
                bolt.m_6034_(caster.m_20185_() + offsetX, caster.m_20188_() - (double)0.4f, caster.m_20189_() + offsetZ);
                bolt.m_5602_((Entity)caster);
                bolt.m_37251_((Entity)caster, caster.m_146909_(), caster.m_146908_(), -20.0f, 2.0f, 12.0f);
                bolt.seekAmount = 0.6f;
                if (randomlyValid != null) {
                    bolt.setArcingTowards(randomlyValid.m_20148_());
                }
                bolt.setAoeRadius(((AquaMissilesSpell)spell).getAoeRadius());
                bolt.setAoeDamageAmount(((AquaMissilesSpell)spell).getDamage(spellLevel, (LivingEntity)caster));
                level.m_7967_((Entity)bolt);
            }
            if ((timeExecutor.getAge() - 1) % 6 == 0) {
                AOMAbilityConfig.playSound(player, spell);
            }
        }).setType(Ability.AbilityType.ABYSS).setCooldown(duration).setDuration(duration).setNotSpellingMob();
    }

    public static Ability HYDROSHOT_SPELL() {
        AbstractSpell spell = (AbstractSpell)TravelopticsSpells.HYDROSHOT_SPELL.get();
        return new Ability(new MorphData(spell), (level, livingEntity, player, timeExecutor) -> {
            spell.onCast(level, AOMUtil.getRealSpellLevel((LivingEntity)player), (LivingEntity)player, CastSource.NONE, AOMAbilityConfig.getMagicData((LivingEntity)player));
            AOMAbilityConfig.playSound(player, spell);
        }).setType(Ability.AbilityType.ABYSS).setCooldown(ABYSS_COOLDOWN).setNotSpellingMob();
    }

    public static Ability TSUNAMI_SPELL() {
        AbstractSpell spell = (AbstractSpell)TravelopticsSpells.TSUNAMI_SPELL.get();
        return new Ability(new MorphData(spell), (level, livingEntity, player, timeExecutor) -> {
            spell.onCast(level, AOMUtil.getRealSpellLevel((LivingEntity)player), (LivingEntity)player, CastSource.NONE, AOMAbilityConfig.getMagicData((LivingEntity)player));
            AOMAbilityConfig.playSound(player, spell);
        }).setType(Ability.AbilityType.ABYSS).setCooldown(ABYSS_COOLDOWN + 100).setNotSpellingMob();
    }

    public static Ability FLOODGATE_SPELL() {
        AbstractSpell spell = (AbstractSpell)TravelopticsSpells.FLOODGATE_SPELL.get();
        return new Ability(new MorphData(spell), (level, livingEntity, player, timeExecutor) -> {
            spell.onCast(level, AOMUtil.getRealSpellLevel((LivingEntity)player), (LivingEntity)player, CastSource.NONE, AOMAbilityConfig.getMagicData((LivingEntity)player));
            AOMAbilityConfig.playSound(player, spell);
        }).setType(Ability.AbilityType.ABYSS).setCooldown(ABYSS_COOLDOWN).setNotSpellingMob();
    }

    public static Ability FLOOD_SLASH_SPELL() {
        AbstractSpell spell = (AbstractSpell)TravelopticsSpells.FLOOD_SLASH_SPELL.get();
        return new Ability(new MorphData(spell), (level, livingEntity, player, timeExecutor) -> {
            spell.onCast(level, AOMUtil.getRealSpellLevel((LivingEntity)player), (LivingEntity)player, CastSource.NONE, AOMAbilityConfig.getMagicData((LivingEntity)player));
            AOMAbilityConfig.playSound(player, spell);
        }).setType(Ability.AbilityType.ABYSS).setCooldown(ABYSS_COOLDOWN).setNotSpellingMob();
    }

    public static Ability BUBBLE_SPRAY_SPELL() {
        AbstractSpell spell = (AbstractSpell)TravelopticsSpells.BUBBLE_SPRAY_SPELL.get();
        int duration = 60;
        return new Ability(new MorphData(spell), (level, livingEntity, player, executor) -> {
            Object patt18344$temp;
            MagicData magicData;
            if ((executor.getAge() - 1) % 10 == 0) {
                Object patt16996$temp = executor.getExtra("magicData");
                if (patt16996$temp instanceof MagicData) {
                    EntityCastData entityCastData;
                    Entity patt17212$temp;
                    magicData = (MagicData)patt16996$temp;
                    ICastData patt17097$temp = magicData.getAdditionalCastData();
                    if (patt17097$temp instanceof EntityCastData && (patt17212$temp = (entityCastData = (EntityCastData)patt17097$temp).getCastingEntity()) instanceof AbstractConeProjectile) {
                        AbstractConeProjectile cone = (AbstractConeProjectile)patt17212$temp;
                        cone.setDealDamageActive();
                    }
                } else {
                    MagicData magicData2 = MagicData.getPlayerMagicData((LivingEntity)livingEntity);
                    BubbleSprayProjectile bubbleSprayProjectile = new BubbleSprayProjectile(level, (LivingEntity)player);
                    bubbleSprayProjectile.m_146884_(player.m_20182_().m_82520_(0.0, (double)player.m_20192_() * 0.7, 0.0));
                    bubbleSprayProjectile.setDamage(((BubbleSpraySpell)spell).getDamage(AOMUtil.getRealSpellLevel((LivingEntity)player), (LivingEntity)player));
                    level.m_7967_((Entity)bubbleSprayProjectile);
                    magicData2.setAdditionalCastData((ICastData)new EntityCastData((Entity)bubbleSprayProjectile));
                    AOMAbilityConfig.playSound(player, spell);
                    executor.setExtra("magicData", magicData2);
                }
            }
            if (executor.getAge() == duration && (patt18344$temp = executor.getExtra("magicData")) instanceof MagicData) {
                magicData = (MagicData)patt18344$temp;
                magicData.resetAdditionalCastData();
            }
        }).setType(Ability.AbilityType.ABYSS).setNotSpellingMob().setDuration(duration).setTriggerTick(1);
    }

    public static Ability TIDAL_SLASH_SPELL() {
        AbstractSpell spell = (AbstractSpell)TravelopticsSpells.TIDAL_SLASH_SPELL.get();
        return new Ability(new MorphData(spell), (level, livingEntity, player, timeExecutor) -> {
            spell.onCast(level, AOMUtil.getRealSpellLevel((LivingEntity)player), (LivingEntity)player, CastSource.NONE, AOMAbilityConfig.getMagicData((LivingEntity)player));
            AOMAbilityConfig.playSound(player, spell);
        }).setType(Ability.AbilityType.ABYSS).setCooldown(ABYSS_COOLDOWN + 100).setNotSpellingMob();
    }

    public static Ability JET_STREAM_SPELL() {
        AbstractSpell spell = (AbstractSpell)TravelopticsSpells.JET_STREAM_SPELL.get();
        return new Ability(new MorphData(spell), (level, livingEntity, player, timeExecutor) -> {
            spell.onCast(level, AOMUtil.getRealSpellLevel((LivingEntity)player), (LivingEntity)player, CastSource.NONE, AOMAbilityConfig.getMagicData((LivingEntity)player));
            AOMAbilityConfig.playSound(player, spell);
        }).setType(Ability.AbilityType.ABYSS).setCooldown(ABYSS_COOLDOWN).setNotSpellingMob();
    }

    public static Ability VORTEX_OF_THE_DEEP_SPELL() {
        AbstractSpell spell = (AbstractSpell)TravelopticsSpells.VORTEX_OF_THE_DEEP_SPELL.get();
        return new Ability(new MorphData(spell), (level, livingEntity, player, timeExecutor) -> {
            spell.onCast(level, AOMUtil.getRealSpellLevel((LivingEntity)player), (LivingEntity)player, CastSource.NONE, AOMAbilityConfig.getMagicData((LivingEntity)player));
            AOMAbilityConfig.playSound(player, spell);
        }).setType(Ability.AbilityType.ABYSS).setCooldown(ABYSS_COOLDOWN + 100).setNotSpellingMob();
    }
}

