/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.config.ability_config;

import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.kurome.ageofmythology.advancement.AOMAdvancement;
import com.kurome.ageofmythology.capability.PlayerDataCapability;
import com.kurome.ageofmythology.config.AOMTradeConfig;
import com.kurome.ageofmythology.enums.MobVariant;
import com.kurome.ageofmythology.init.AOMItems;
import com.kurome.ageofmythology.model.Ability;
import com.kurome.ageofmythology.model.MorphData;
import com.kurome.ageofmythology.net.Messages;
import com.kurome.ageofmythology.net.general.ClientSyncToolTip;
import com.kurome.ageofmythology.utils.BiomeUtil;
import com.kyanite.deeperdarker.world.otherside.OthersideDimension;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import mcjty.lostcities.setup.Registration;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import twilightforest.world.registration.TFGenerationSettings;

public class TravelAbility {
    public static Ability natural_travel() {
        return TravelAbility.travel("natural_travel", (ResourceKey<Level>)Level.f_46428_, Items.f_42517_);
    }

    public static Ability the_aether_travel() {
        return TravelAbility.travel("the_aether_travel", (ResourceKey<Level>)AetherDimensions.AETHER_LEVEL, Items.f_42517_);
    }

    public static Ability the_nether_travel() {
        return TravelAbility.travel("the_nether_travel", (ResourceKey<Level>)Level.f_46429_, Items.f_42517_);
    }

    public static Ability the_end_travel() {
        return TravelAbility.travel("the_end_travel", (ResourceKey<Level>)Level.f_46430_, Items.f_42517_);
    }

    public static Ability twilight_forest_travel() {
        return TravelAbility.travel("twilight_forest_travel", (ResourceKey<Level>)TFGenerationSettings.DIMENSION_KEY, Items.f_42517_);
    }

    public static Ability otherside_travel() {
        return TravelAbility.travel("otherside_travel", (ResourceKey<Level>)OthersideDimension.OTHERSIDE_LEVEL, Items.f_42517_);
    }

    public static Ability lost_city_travel() {
        return TravelAbility.travel("lost_city_travel", (ResourceKey<Level>)Registration.DIMENSION, Items.f_42517_);
    }

    public static Ability travel(String abilityName, ResourceKey<Level> DIMENSION, Item icon) {
        MutableComponent dimensionComponent = Component.m_237115_((String)"ageofmythology.skill.travel.%s".formatted(DIMENSION.m_135782_().m_135815_())).m_130940_(ChatFormatting.YELLOW);
        return new Ability(new MorphData(Component.m_237115_((String)"ageofmythology.skill.%s".formatted(abilityName)), Component.m_237110_((String)"ageofmythology.skill.travel.desc", (Object[])new Object[]{dimensionComponent}), icon), (level, livingEntity, player) -> {
            AtomicReference<MutableComponent> showInfo = new AtomicReference<MutableComponent>();
            if (level.m_46472_().equals((Object)DIMENSION)) {
                Holder biomeHolder = level.m_204166_(player.m_20183_());
                String biomeKey = BiomeUtil.getBiomeName(level, (Biome)biomeHolder.get());
                String addedBiomeKey = TravelAbility.wrapBiomeKey(DIMENSION, biomeKey);
                MutableComponent biomeComponent = Component.m_237115_((String)biomeKey).m_130940_(ChatFormatting.YELLOW);
                player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                    if (data.hasVisited(addedBiomeKey)) {
                        showInfo.set(Component.m_237110_((String)"ageofmythology.skill.travel.hasVisited", (Object[])new Object[]{biomeComponent}));
                    } else {
                        showInfo.set(Component.m_237110_((String)"ageofmythology.skill.travel.visit", (Object[])new Object[]{biomeComponent}));
                        data.addVisitBiome(addedBiomeKey);
                        data.sync((Player)player);
                        Vec3 pos = player.m_20182_();
                        ExperienceOrb orb = new ExperienceOrb(level, pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_, 100);
                        level.m_7967_((Entity)orb);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            AOMAdvancement.FIRST_TRAVEL.trigger(serverPlayer);
                            AOMAdvancement.LOST_CITY_TRAVEL.trigger(serverPlayer, DIMENSION);
                        }
                    }
                });
            } else {
                showInfo.set(Component.m_237110_((String)"ageofmythology.skill.travel.dimension.error", (Object[])new Object[]{dimensionComponent}));
            }
            if (showInfo.get() != null && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Messages.sendToPlayer(new ClientSyncToolTip(ClientSyncToolTip.ToolTipType.OVERLAY_MESSAGE.getId(), (Component)showInfo.get()), serverPlayer);
            }
        }).setCooldown(100);
    }

    public static String wrapBiomeKey(ResourceKey<Level> dimension, String biomeKey) {
        String dimensionName = dimension.m_135782_().m_135815_();
        return dimensionName + ":" + biomeKey;
    }

    public static Pair<String, String> unWrapBiomeKey(String key) {
        String[] rawPair = key.split(":");
        if (rawPair.length <= 1) {
            return new Pair((Object)"", (Object)"");
        }
        return new Pair((Object)rawPair[0], (Object)rawPair[1]);
    }

    public static void travelTradeConfig(MobVariant mobVariant, List<VillagerTrades.ItemListing> list) {
        switch (mobVariant) {
            case ICEANDFIRE_PIXIE: 
            case MINECRAFT_ALLAY: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42517_, 8, Items.f_41940_, 1, (Item)AOMItems.AGEOFMYTHOLOGY_NATURE_TRAVEL_ITEM.get(), 1));
                break;
            }
            case MINECRAFT_PIGLIN: 
            case MINECRAFT_GHAST: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42517_, 8, Items.f_41954_, 1, (Item)AOMItems.AGEOFMYTHOLOGY_NETHER_TRAVEL_ITEM.get(), 1));
                break;
            }
            case MINECRAFT_ENDERMAN: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42517_, 8, Items.f_42276_, 1, (Item)AOMItems.AGEOFMYTHOLOGY_END_TRAVEL_ITEM.get(), 1));
                break;
            }
            case ALEXSMOBS_CROW: 
            case TWILIGHTFOREST_RAVEN: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42517_, 8, Items.f_42577_, 1, (Item)AOMItems.AGEOFMYTHOLOGY_TWILIGHT_FOREST_TRAVEL_ITEM.get(), 1));
                break;
            }
            case MINECRAFT_WARDEN: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42517_, 8, Items.f_41984_, 1, (Item)AOMItems.AGEOFMYTHOLOGY_OTHERSIDE_SCULK_TRAVEL_ITEM.get(), 1));
                break;
            }
            case MINECRAFT_SKELETON: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42517_, 8, Items.f_42503_, 1, (Item)AOMItems.AGEOFMYTHOLOGY_LOST_CITY_TRAVEL_ITEM.get(), 1));
            }
        }
    }
}

