/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.config.ability_config;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.config.AOMFilterConfig;
import com.kurome.ageofmythology.config.AOMRarityConfig;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.data.ItemTagGenerator;
import com.kurome.ageofmythology.enums.MobVariant;
import com.kurome.ageofmythology.init.AOMItems;
import com.kurome.ageofmythology.item.AOMSkullItem;
import com.kurome.ageofmythology.model.Ability;
import com.kurome.ageofmythology.model.MorphData;
import com.kurome.ageofmythology.net.Messages;
import com.kurome.ageofmythology.net.general.ClientSyncToolTip;
import com.kurome.ageofmythology.utils.BiomeUtil;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class TradeAbilityConfig {
    private static final Supplier<Map<Rarity, Supplier<Item>>> buy_relic_value_map = () -> new HashMap<Rarity, RegistryObject>(Map.of(AOMRarityConfig.COMMON, ModItems.COIN_GOLD, AOMRarityConfig.UNCOMMON, ModItems.COIN_EMERALD, AOMRarityConfig.RARE, ModItems.COIN_DIAMOND, AOMRarityConfig.EPIC, ModItems.COIN_NETHERITE));
    private static final Supplier<Map<Rarity, Supplier<Item>>> sell_relic_value_map = () -> new HashMap<Rarity, RegistryObject>(Map.of(AOMRarityConfig.COMMON, ModItems.COIN_IRON, AOMRarityConfig.UNCOMMON, ModItems.COIN_GOLD, AOMRarityConfig.RARE, ModItems.COIN_EMERALD, AOMRarityConfig.EPIC, ModItems.COIN_DIAMOND));
    private static final Supplier<Map<ResourceLocation, Item>> sniff_trade_map = () -> new HashMap<ResourceLocation, Item>(Map.of(Biomes.f_48202_.m_135782_(), AOMUtil.getItemDefault("immortalers_delight:evolutcorn"), Biomes.f_48222_.m_135782_(), AOMUtil.getItemDefault("immortalers_delight:pearlipearl"), Biomes.f_48205_.m_135782_(), AOMUtil.getItemDefault("immortalers_delight:himekaido_seed"), Biomes.f_48208_.m_135782_(), AOMUtil.getItemDefault("immortalers_delight:contains_tea_leisamboo"), Biomes.f_48200_.m_135782_(), AOMUtil.getItemDefault("immortalers_delight:kwat_wheat_seeds"), Biomes.f_48151_.m_135782_(), AOMUtil.getItemDefault("immortalers_delight:alfalfa_seeds"), Biomes.f_151785_.m_135782_(), Items.f_271471_));
    private static final Supplier<List<ItemStack>> natural_trade_list = () -> Arrays.asList(Items.f_42436_.m_7968_(), Items.f_42677_.m_7968_(), Items.f_42546_.m_7968_(), Items.f_42437_.m_7968_(), Items.f_42716_.m_7968_(), Items.f_42415_.m_7968_(), Items.f_42701_.m_7968_());
    private static final Supplier<List<ItemStack>> pillager_trade_list = () -> Arrays.asList(Items.f_42475_.m_7968_(), Items.f_42473_.m_7968_(), Items.f_42472_.m_7968_(), Items.f_42474_.m_7968_(), Items.f_42391_.m_7968_(), Items.f_42390_.m_7968_(), Items.f_42389_.m_7968_(), Items.f_42388_.m_7968_(), Items.f_42392_.m_7968_());
    private static final Supplier<List<ItemStack>> dragon_trade_list = () -> Arrays.asList(Items.f_42475_.m_7968_(), Items.f_42473_.m_7968_(), Items.f_42472_.m_7968_(), Items.f_42474_.m_7968_(), Items.f_42391_.m_7968_(), Items.f_42390_.m_7968_(), Items.f_42389_.m_7968_(), Items.f_42388_.m_7968_(), Items.f_42392_.m_7968_());
    public static ArrayList<String> tradeSkullBlackList = new ArrayList<String>(Arrays.asList(MobVariant.AGEOFMYTHOLOGY_FLESH_CREEPER.getSkullType(), MobVariant.AGEOFMYTHOLOGY_FLESH_FISH.getSkullType(), MobVariant.AGEOFMYTHOLOGY_FLESH_GOLEM.getSkullType(), MobVariant.AGEOFMYTHOLOGY_FLESH_FOX.getSkullType(), MobVariant.AGEOFMYTHOLOGY_FLESH_VILLAGER.getSkullType(), MobVariant.AGEOFMYTHOLOGY_FLESH_SKELETON.getSkullType(), MobVariant.AGEOFMYTHOLOGY_FLESH_ENDERMAN.getSkullType()));

    public static Ability sniffer_trade() {
        String abilityName = "sniffer_trade";
        Item neededItem = Items.f_271356_;
        return new Ability(new MorphData(Component.m_237115_((String)"ageofmythology.skill.%s".formatted(abilityName)), Component.m_237110_((String)"ageofmythology.skill.trade.1", (Object[])new Object[]{Component.m_237115_((String)neededItem.m_5524_()).m_130940_(ChatFormatting.YELLOW)}), Items.f_271356_), (world, livingEntity, player) -> {
            ItemStack itemstack = player.m_21205_();
            BlockPos blockPos = player.m_20183_();
            if (itemstack.m_150930_(neededItem)) {
                Biome biome = (Biome)world.m_204166_(player.m_20183_()).get();
                ResourceLocation biomeResourceKey = BiomeUtil.getKeyForBiome(world, biome).orElseGet(() -> ((ResourceKey)Biomes.f_48173_).m_135782_());
                if (sniff_trade_map.get().containsKey(biomeResourceKey)) {
                    itemstack.m_41774_(1);
                    ItemStack tradeItem = sniff_trade_map.get().get(biomeResourceKey).m_7968_();
                    ItemEntity tradeEntity = new ItemEntity(world, (double)blockPos.m_123341_(), (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_(), tradeItem);
                    world.m_7967_((Entity)tradeEntity);
                }
            }
        });
    }

    public static Ability piglin_trade() {
        String abilityName = "piglin_trade";
        return new Ability(new MorphData(Component.m_237115_((String)"ageofmythology.skill.%s".formatted(abilityName)), Component.m_237110_((String)"ageofmythology.skill.trade", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.skill.piglin_trade.gold").m_130940_(ChatFormatting.YELLOW)}), (Item)AOMItems.MINECRAFT_PIGLIN_ITEM.get()), (world, livingEntity, player) -> {
            ItemStack itemstack = player.m_21205_();
            BlockPos blockPos = player.m_20183_();
            Vec3 pos = player.m_20182_();
            if (itemstack.m_204117_(ItemTags.f_13151_)) {
                itemstack.m_41774_(1);
                ObjectArrayList list = new ArrayList();
                if (livingEntity instanceof Piglin) {
                    Piglin piglin = (Piglin)livingEntity;
                    LootTable loottable = piglin.m_9236_().m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78738_);
                    list = loottable.m_287195_(new LootParams.Builder((ServerLevel)piglin.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)piglin).m_287235_(LootContextParamSets.f_81417_));
                }
                list.forEach(tradeItem -> {
                    ItemEntity tradeEntity = new ItemEntity(world, (double)blockPos.m_123341_(), (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_(), tradeItem);
                    world.m_7967_((Entity)tradeEntity);
                });
                world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        });
    }

    public static Ability natural_trade() {
        String abilityName = "natural_trade";
        Item neededItem = (Item)AOMItems.AGEOFMYTHOLOGY_VERDANT_ITEM.get();
        List<ItemStack> list = natural_trade_list.get();
        return new Ability(new MorphData(Component.m_237115_((String)"ageofmythology.skill.%s".formatted(abilityName)), Component.m_237110_((String)"ageofmythology.skill.trade", (Object[])new Object[]{Component.m_237115_((String)neededItem.m_5524_()).m_130940_(ChatFormatting.YELLOW)}), Items.f_42799_), (world, livingEntity, player) -> {
            ItemStack itemstack = player.m_21205_();
            BlockPos blockPos = player.m_20183_();
            if (itemstack.m_150930_(neededItem)) {
                itemstack.m_41774_(1);
                if (!list.isEmpty()) {
                    ItemStack tradeItem = (ItemStack)list.get(player.m_217043_().m_188503_(list.size()));
                    ItemEntity tradeEntity = new ItemEntity(world, (double)blockPos.m_123341_(), (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_(), tradeItem);
                    world.m_7967_((Entity)tradeEntity);
                }
            }
        });
    }

    public static Ability pillager_trade() {
        String abilityName = "pillager_trade";
        Item neededItem = (Item)AOMItems.AGEOFMYTHOLOGY_CATACLYSMIC_ITEM.get();
        List<ItemStack> list = pillager_trade_list.get();
        return new Ability(new MorphData(Component.m_237115_((String)"ageofmythology.skill.%s".formatted(abilityName)), Component.m_237110_((String)"ageofmythology.skill.trade", (Object[])new Object[]{Component.m_237115_((String)neededItem.m_5524_()).m_130940_(ChatFormatting.YELLOW)}), new ResourceLocation("textures/mob_effect/bad_omen.png")), (world, livingEntity, player) -> {
            ItemStack itemstack = player.m_21205_();
            BlockPos blockPos = player.m_20183_();
            if (itemstack.m_150930_(neededItem)) {
                itemstack.m_41774_(1);
                if (!list.isEmpty()) {
                    ItemStack tradeItem = (ItemStack)list.get(player.m_217043_().m_188503_(list.size()));
                    ItemEntity tradeEntity = new ItemEntity(world, (double)blockPos.m_123341_(), (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_(), tradeItem);
                    world.m_7967_((Entity)tradeEntity);
                }
            }
        });
    }

    public static Ability dragon_trade() {
        String abilityName = "dragon_trade";
        Item neededItem = (Item)AOMItems.AGEOFMYTHOLOGY_CATACLYSMIC_ITEM.get();
        List<ItemStack> list = dragon_trade_list.get();
        return new Ability(new MorphData(Component.m_237115_((String)"ageofmythology.skill.%s".formatted(abilityName)), Component.m_237110_((String)"ageofmythology.skill.trade", (Object[])new Object[]{Component.m_237115_((String)neededItem.m_5524_()).m_130940_(ChatFormatting.YELLOW)}), new ResourceLocation("textures/mob_effect/bad_omen.png")), (world, livingEntity, player) -> {
            ItemStack itemstack = player.m_21205_();
            BlockPos blockPos = player.m_20183_();
            if (itemstack.m_150930_(neededItem)) {
                itemstack.m_41774_(1);
                if (!list.isEmpty()) {
                    ItemStack tradeItem = (ItemStack)list.get(player.m_217043_().m_188503_(list.size()));
                    ItemEntity tradeEntity = new ItemEntity(world, (double)blockPos.m_123341_(), (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_(), tradeItem);
                    world.m_7967_((Entity)tradeEntity);
                }
            }
        });
    }

    public static Ability villager_trade() {
        String abilityName = "villager_trade";
        return new Ability(new MorphData(Component.m_237115_((String)"ageofmythology.skill.%s".formatted(abilityName)), Component.m_237115_((String)"ageofmythology.skill.%s.desc".formatted(abilityName)), Items.f_42616_), (world, livingEntity, player) -> {
            ItemStack itemstack = player.m_21205_();
            BlockPos blockPos = player.m_20183_();
            Item patt14023$temp = itemstack.m_41720_();
            if (patt14023$temp instanceof AOMSkullItem) {
                Supplier supplier;
                AOMSkullItem relic = (AOMSkullItem)patt14023$temp;
                itemstack.m_41774_(1);
                Map<Object, Object> sell_map = new HashMap();
                if (AgeOfMythologyMod.isLoadedMod("lightmanscurrency")) {
                    sell_map = sell_relic_value_map.get();
                }
                if ((supplier = (Supplier)sell_map.get(relic.m_41460_(relic.m_7968_()))) != null) {
                    ItemStack tradeItem = ((Item)supplier.get()).m_7968_();
                    ItemEntity tradeEntity = new ItemEntity(world, (double)blockPos.m_123341_(), (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_(), tradeItem);
                    world.m_7967_((Entity)tradeEntity);
                }
            } else if (itemstack.m_204117_(ItemTagGenerator.USEFUL_COIN)) {
                List<Object> tradeList = new ArrayList();
                if (itemstack.m_150930_((Item)ModItems.COIN_GOLD.get())) {
                    tradeList = TradeAbilityConfig.getTradeRelicList(AOMRarityConfig.COMMON);
                } else if (itemstack.m_150930_((Item)ModItems.COIN_EMERALD.get())) {
                    tradeList = TradeAbilityConfig.getTradeRelicList(AOMRarityConfig.UNCOMMON);
                } else if (itemstack.m_150930_((Item)ModItems.COIN_DIAMOND.get())) {
                    tradeList = TradeAbilityConfig.getTradeRelicList(AOMRarityConfig.RARE);
                }
                if (!tradeList.isEmpty()) {
                    ItemStack tradeItem = (ItemStack)tradeList.get(player.m_217043_().m_188503_(tradeList.size()));
                    ItemEntity tradeEntity = new ItemEntity(world, (double)blockPos.m_123341_(), (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_(), tradeItem);
                    world.m_7967_((Entity)tradeEntity);
                }
                itemstack.m_41774_(1);
            } else if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Messages.sendToPlayer(new ClientSyncToolTip(ClientSyncToolTip.ToolTipType.OVERLAY_MESSAGE.getId(), (Component)Component.m_237115_((String)"ageofmythology.skill.%s.fail".formatted(abilityName))), serverPlayer);
            }
        });
    }

    public static Ability trade(List<ItemStack> list, TagKey<Item> tradeTagKey, ResourceLocation icon, String abilityName) {
        return new Ability(new MorphData(Component.m_237115_((String)"ageofmythology.skill.%s".formatted(abilityName)), Component.m_237115_((String)"ageofmythology.skill.%s.desc".formatted(abilityName)), icon), (world, livingEntity, player) -> {
            ItemStack itemstack = player.m_21205_();
            BlockPos blockPos = player.m_20183_();
            Vec3 pos = player.m_20182_();
            if (itemstack.m_204117_(tradeTagKey)) {
                itemstack.m_41774_(1);
                list.forEach(tradeItem -> {
                    ItemEntity tradeEntity = new ItemEntity(world, (double)blockPos.m_123341_(), (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_(), tradeItem);
                    world.m_7967_((Entity)tradeEntity);
                });
                world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        });
    }

    public static List<ItemStack> getTradeRelicList(Rarity r) {
        return AOMItems.ITEMS.getEntries().stream().filter(itemRegistryObject -> {
            Item item = (Item)itemRegistryObject.get();
            if (item instanceof AOMSkullItem) {
                AOMSkullItem skullItem = (AOMSkullItem)item;
                if (!AOMFilterConfig.skullItemWhiteList.contains(skullItem.getSkullName())) {
                    return false;
                }
                if (tradeSkullBlackList.contains(skullItem.getSkullName())) {
                    return false;
                }
                Rarity rarity = item.m_41460_(item.m_7968_());
                return rarity == r;
            }
            return false;
        }).map(itemRegistryObject -> ((Item)itemRegistryObject.get()).m_7968_()).toList();
    }
}

