/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.config;

import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.Ender_Guardian_Entity;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.Ignis_Entity;
import com.github.L_Ender.cataclysm.init.ModBlocks;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.config.AOMFilterConfig;
import com.kurome.ageofmythology.config.AOMTradeConfig;
import com.kurome.ageofmythology.config.ability_config.TravelAbility;
import com.kurome.ageofmythology.data.tag.EntityTagGenerator;
import com.kurome.ageofmythology.enums.MobVariant;
import com.kurome.ageofmythology.init.AOMAttributes;
import com.kurome.ageofmythology.init.AOMItems;
import com.kurome.ageofmythology.item.autism.AutismSkullItem;
import com.kurome.ageofmythology.item.general.BloodBottleItem;
import com.kurome.ageofmythology.mixin.accessors.ClientAdvancementAccessor;
import com.kurome.ageofmythology.net.Messages;
import com.kurome.ageofmythology.net.general.ClientSyncToolTip;
import com.lion.graveyard.init.TGItems;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.apiimpl.storage.ItemStorageType;
import com.refinedmods.refinedstorage.util.ColorMap;
import com.refinedmods.refinedstorageaddons.RSAddonsItems;
import com.yellowbrossproductions.illageandspillage.util.ItemRegisterer;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import liushuangwuyin.bettermorph.api.PlayerIdentity;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;

public class AOMUtil {
    public static ArrayList<String> dreadMobs = new ArrayList<String>(Arrays.asList(MobVariant.ICEANDFIRE_DREAD_BEAST.getSkullType(), MobVariant.ICEANDFIRE_DREAD_GHOUL.getSkullType(), MobVariant.ICEANDFIRE_DREAD_HORSE.getSkullType(), MobVariant.ICEANDFIRE_DREAD_KNIGHT.getSkullType(), MobVariant.ICEANDFIRE_DREAD_LICH.getSkullType(), MobVariant.ICEANDFIRE_DREAD_THRALL.getSkullType(), MobVariant.ICEANDFIRE_GHOST.getSkullType(), MobVariant.ICEANDFIRE_DREAD_LICH.getSkullType(), MobVariant.ICEANDFIRE_DREAD_LICH.getSkullType(), MobVariant.ICEANDFIRE_DREAD_SCUTTLER.getSkullType()));
    public static double cataclysmHpDamage = 0.04;
    public static Supplier<HashMap<TagKey<EntityType<?>>, Function<Player, Double>>> TAGS = () -> new HashMap<TagKey<EntityType<?>>, Function<Player, Double>>(){
        {
            this.put(EntityTagGenerator.DRAGON, AOMUtil::getDragonDamage);
            this.put(EntityTagGenerator.EXPLODE, player -> AOMUtil.getExplosionPower(player));
            this.put(EntityTagGenerator.ABYSS, player -> AOMUtil.getAbyssDamage(player) * AOMUtil.getAbyssLevel(player) * 0.25);
            this.put(EntityTagGenerator.MACHINE, player -> AOMUtil.getMachineDamage(player) * AOMUtil.getMachineLevel(player) * 0.25);
            this.put(EntityTagGenerator.MAGIC, player -> AOMUtil.getSpellPower(player) * (double)AOMUtil.getSpellLevel((LivingEntity)player));
            this.put(EntityTagGenerator.GOETY, AOMUtil::getPotency);
            this.put(EntityTagGenerator.FLESH, AOMUtil::getFleshLevel);
            this.put(EntityTagGenerator.FIRE, AOMUtil::getRealFireDamage);
            this.put(EntityTagGenerator.GENERAL, AOMUtil::getAttackDamage);
        }
    };
    public static List<MobVariant> skullTradeBlackList = new ArrayList<MobVariant>(Arrays.asList(MobVariant.MINECRAFT_IRON_GOLEM, MobVariant.MINECRAFT_WARDEN, MobVariant.MINECRAFT_SNIFFER, MobVariant.ALEXSMOBS_BONE_SERPENT, MobVariant.ALEXSMOBS_SUNBIRD, MobVariant.ALEXSMOBS_CRIMSON_MOSQUITO, MobVariant.ALEXSMOBS_RATTLESNAKE, MobVariant.ALEXSMOBS_KOMODO_DRAGON, MobVariant.CATACLYSM_MALEDICTUS, MobVariant.CATACLYSM_CORALSSUS, MobVariant.CATACLYSM_CORAL_GOLEM, MobVariant.ICEANDFIRE_FIRE_DRAGON, MobVariant.ICEANDFIRE_ICE_DRAGON, MobVariant.ICEANDFIRE_LIGHTNING_DRAGON, MobVariant.GRAVEYARD_ACOLYTE, MobVariant.GRAVEYARD_CORRUPTED_PILLAGER, MobVariant.GRAVEYARD_CORRUPTED_VINDICATOR, MobVariant.GRAVEYARD_REAPER, MobVariant.GRAVEYARD_REVENANT, MobVariant.GRAVEYARD_WRAITH, MobVariant.GRAVEYARD_NIGHTMARE, MobVariant.GOETY_HOSTILE_BLACK_WOLF, MobVariant.GOETY_WIGHT, MobVariant.ALEXSCAVES_CORRODENT, MobVariant.ALEXSCAVES_VESPER, MobVariant.ALEXSCAVES_FORSAKEN, MobVariant.ALEXSMOBS_FARSEER, MobVariant.ALEXSCAVES_VALLUMRAPTOR, MobVariant.ALEXSCAVES_SUBTERRANODON, MobVariant.ALEXSCAVES_GROTTOCERATOPS, MobVariant.ALEXSCAVES_TREMORSAURUS, MobVariant.ALEXSCAVES_RELICHEIRUS, MobVariant.ALEXSCAVES_ATLATITAN));

    public static ResourceLocation getKey(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    @Nullable
    public static Item getItem(String item) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item));
    }

    public static Item getItem(String item, Item defaultItem) {
        Item originItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item));
        return originItem != null ? originItem : defaultItem;
    }

    @Nullable
    public static Attribute getAttribute(String name) {
        return (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(name));
    }

    public static Item getItemDefault(String item) {
        Item tempItem = AOMUtil.getItem(item);
        return tempItem != null ? tempItem : Items.f_41852_;
    }

    public static Supplier<Item> getItemSupplier(String item) {
        Item tempItem = AOMUtil.getItem(item);
        return tempItem != null ? () -> tempItem : () -> Items.f_41852_;
    }

    public static String getNamespace(Item item) {
        ResourceLocation key = AOMUtil.getKey(item);
        return key.m_135827_();
    }

    public static String getPath(Item item) {
        ResourceLocation key = AOMUtil.getKey(item);
        return key.m_135815_();
    }

    public static String getMobName(Entity entity) {
        return AOMUtil.getMobName(entity.m_6095_());
    }

    public static String getMobName(EntityType<?> type) {
        return EntityType.m_20613_(type).toString();
    }

    public static Optional<EntityType<?>> getEntityType(String mobName) {
        return EntityType.m_20632_((String)mobName);
    }

    public static EntityType<?> getEntityTypeDefault(String mobName) {
        Optional type = EntityType.m_20632_((String)mobName);
        return type.orElse(EntityType.f_20510_);
    }

    public static void sendToolTip(Player player, Component component) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Messages.sendToPlayer(new ClientSyncToolTip(ClientSyncToolTip.ToolTipType.OVERLAY_MESSAGE.getId(), component), serverPlayer);
        }
    }

    public static List<String> getAllTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (EntityType type : BuiltInRegistries.f_256780_) {
            Entity entity = null;
            Level level = AgeOfMythologyMod.PROXY.getClientLevel();
            if (level != null) {
                entity = type.m_20615_(level);
            }
            if (!(entity instanceof LivingEntity)) continue;
            types.add(EntityType.m_20613_((EntityType)type).toString());
        }
        return types;
    }

    public static List<LivingEntity> getEntityLivingFront(LivingEntity entity, double radius) {
        Vec3 attackRange = entity.m_20156_().m_82541_().m_82490_(radius);
        return AOMUtil.getEntityLivingBaseNearby(entity, attackRange.f_82479_, attackRange.f_82480_, attackRange.f_82481_, radius);
    }

    public static List<LivingEntity> getEntityLivingBaseNearby(LivingEntity entity, double distanceX, double distanceY, double distanceZ, double radius) {
        return AOMUtil.getEntitiesNearby(entity, LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public static <T extends Entity> List<T> getEntitiesNearby(LivingEntity entity, Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return entity.m_9236_().m_6443_(entityClass, entity.m_20191_().m_82377_(dX, dY, dZ), e -> e != entity);
    }

    public static void modifyAttribute(LivingEntity entity, Attribute attribute, UUID uuid, String name, Double value, AttributeModifier.Operation operation) {
        AttributeModifier modify;
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null && ((modify = instance.m_22111_(uuid)) == null || modify.m_22218_() != value.doubleValue())) {
            instance.m_22120_(uuid);
            AttributeModifier attr = new AttributeModifier(uuid, name, value.doubleValue(), operation);
            instance.m_22125_(attr);
        }
    }

    public static void removeAttribute(LivingEntity entity, Attribute attribute, UUID uuid) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            instance.m_22120_(uuid);
        }
    }

    public static MobVariant findMobVariantByString(String name) {
        return Arrays.stream(MobVariant.values()).filter(mob -> mob.getSkullType().equals(name)).findFirst().orElse(MobVariant.AGEOFMYTHOLOGY_VERDANT);
    }

    public static Item getAOMItemByEntityId(String id) {
        MobVariant mobVariant = AOMUtil.findMobVariantByString(id);
        MobVariant realMobVariant = AOMUtil.getMobRealVariant(mobVariant);
        String[] entityId = realMobVariant.getSkullType().split(":");
        if (entityId.length < 2) {
            return Items.f_42383_;
        }
        String itemId = entityId[0] + "_" + entityId[1] + "_item";
        return (Item)ForgeRegistries.ITEMS.getValue(AgeOfMythologyMod.id(itemId));
    }

    public static boolean checkAdvancementProgress(LivingEntity livingEntity, String advancementName) {
        return AOMUtil.checkAdvancementProgress(livingEntity, "ageofmythology", advancementName);
    }

    public static boolean checkAdvancementProgress(LivingEntity livingEntity, ResourceLocation resourceLocation) {
        return AOMUtil.checkAdvancementProgress(livingEntity, resourceLocation.m_135827_(), resourceLocation.m_135815_());
    }

    public static boolean checkAdvancementProgress(LivingEntity livingEntity, String modid, String advancementName) {
        ResourceLocation resourceLocation = new ResourceLocation(modid, advancementName);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            Advancement advancement = player.m_20194_().m_129889_().m_136041_(resourceLocation);
            if (advancement != null) {
                AdvancementProgress progress = player.m_8960_().m_135996_(advancement);
                return progress.m_8193_();
            }
        } else if (livingEntity instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)livingEntity;
            return AOMUtil.checkLocalPlayerAdvancementProgress(player, resourceLocation);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean checkAdvancementProgressClient(String advancementName) {
        return AOMUtil.checkAdvancementProgressClient(new ResourceLocation("ageofmythology", advancementName));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean checkAdvancementProgressClient(String modid, String advancementName) {
        return AOMUtil.checkAdvancementProgressClient(new ResourceLocation(modid, advancementName));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean checkAdvancementProgressClient(ResourceLocation resourceLocation) {
        Player localPlayer = AgeOfMythologyMod.PROXY.getClientPlayer();
        if (localPlayer instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)localPlayer;
            return AOMUtil.checkLocalPlayerAdvancementProgress(player, resourceLocation);
        }
        return false;
    }

    public static boolean checkLocalPlayerAdvancementProgress(LocalPlayer player, ResourceLocation resourceLocation) {
        ClientAdvancements clientAdvancements = player.f_108617_.m_105145_();
        Advancement advancement = clientAdvancements.m_104396_().m_139337_(resourceLocation);
        if (advancement != null) {
            Map<Advancement, AdvancementProgress> progressMap = ((ClientAdvancementAccessor)clientAdvancements).getProgress();
            AdvancementProgress progress = progressMap.get(advancement);
            return progress.m_8193_();
        }
        return false;
    }

    public static MobVariant getMobRealVariant(MobVariant mob) {
        String nameSpace;
        String name = mob.getSkullType();
        if (AOMFilterConfig.skullItemWhiteList.contains(name)) {
            return mob;
        }
        switch (nameSpace = name.split(":")[0]) {
            case "minecraft": {
                return MobVariant.AGEOFMYTHOLOGY_VERDANT;
            }
            case "alexsmobs": {
                if (mob == MobVariant.ALEXSMOBS_FARSEER) {
                    return MobVariant.ALEXSMOBS_FARSEER;
                }
                return MobVariant.AGEOFMYTHOLOGY_VERDANT;
            }
            case "alexscaves": {
                return MobVariant.AGEOFMYTHOLOGY_VERDANT;
            }
            case "biomancy": {
                if (mob == MobVariant.BIOMANCY_FLESH_CHICKEN) {
                    return MobVariant.AGEOFMYTHOLOGY_FLESH_CHICKEN;
                }
                if (mob == MobVariant.BIOMANCY_FLESH_COW) {
                    return MobVariant.AGEOFMYTHOLOGY_FLESH_COW;
                }
                if (mob == MobVariant.BIOMANCY_FLESH_SHEEP) {
                    return MobVariant.AGEOFMYTHOLOGY_FLESH_SHEEP;
                }
                if (mob == MobVariant.BIOMANCY_FLESH_PIG) {
                    return MobVariant.AGEOFMYTHOLOGY_FLESH_PIG;
                }
                return MobVariant.AGEOFMYTHOLOGY_FLESH;
            }
            case "bygonenether": {
                return MobVariant.AGEOFMYTHOLOGY_ELDRITCH;
            }
            case "cataclysm": {
                return MobVariant.AGEOFMYTHOLOGY_CATACLYSMIC;
            }
            case "crittersandcompanions": {
                return MobVariant.AGEOFMYTHOLOGY_VERDANT;
            }
            case "deeperdarker": {
                return MobVariant.AGEOFMYTHOLOGY_ELDRITCH;
            }
            case "graveyard": {
                return MobVariant.AGEOFMYTHOLOGY_DREAD;
            }
            case "goety": {
                return MobVariant.AGEOFMYTHOLOGY_CATACLYSMIC;
            }
            case "irons_spellbooks": {
                return MobVariant.AGEOFMYTHOLOGY_MAGIC_CORE;
            }
            case "ribbits": {
                return MobVariant.AGEOFMYTHOLOGY_VERDANT;
            }
            case "raided": {
                return MobVariant.AGEOFMYTHOLOGY_CATACLYSMIC;
            }
            case "takesapillage": {
                return MobVariant.AGEOFMYTHOLOGY_CATACLYSMIC;
            }
            case "traveloptics": {
                return MobVariant.AGEOFMYTHOLOGY_MAGIC_CORE;
            }
            case "twilightforest": {
                return MobVariant.AGEOFMYTHOLOGY_VERDANT;
            }
            case "iceandfire": {
                if (dreadMobs.contains(name)) {
                    return MobVariant.AGEOFMYTHOLOGY_DREAD;
                }
                return MobVariant.AGEOFMYTHOLOGY_VERDANT;
            }
            case "spore": {
                return MobVariant.AGEOFMYTHOLOGY_INFECT;
            }
            case "doom": {
                return MobVariant.AGEOFMYTHOLOGY_UMBRAL;
            }
        }
        return MobVariant.AGEOFMYTHOLOGY_VERDANT;
    }

    public static int getCoolDown(Player player) {
        return (int)player.m_21133_((Attribute)AOMAttributes.ABILITY_COOLDOWN.get());
    }

    public static int getExplosionPower(Player player) {
        return (int)player.m_21133_((Attribute)AOMAttributes.EXPLOSION_POWER.get()) * 5;
    }

    public static double getExplosionRange(Player player) {
        return player.m_21133_((Attribute)AOMAttributes.EXPLOSION_RANGE.get());
    }

    public static double getExplosionCoolDown(Player player) {
        return player.m_21133_((Attribute)AOMAttributes.EXPLOSION_COOLDOWN.get());
    }

    public static double getLifeDrain(Player player) {
        return player.m_21133_((Attribute)AOMAttributes.LIFE_DRAIN.get());
    }

    public static int getPotionAttack(Player player) {
        return (int)player.m_21133_((Attribute)AOMAttributes.POTION_ATTACK.get());
    }

    public static int getDebilitatingSting(Player player) {
        return (int)player.m_21133_((Attribute)AOMAttributes.Debilitating_Sting.get());
    }

    public static int getExsanguination(Player player) {
        return (int)player.m_21133_((Attribute)AOMAttributes.Exsanguination.get());
    }

    public static int getSpellLevel(LivingEntity player) {
        return (int)player.m_21133_((Attribute)AOMAttributes.ABILITY_LEVEL.get());
    }

    public static double getFireDamage(Player player) {
        return player.m_21133_((Attribute)AOMAttributes.FIRE_DAMAGE.get());
    }

    public static double getSpellPower(Player player) {
        return player.m_21133_((Attribute)AttributeRegistry.SPELL_POWER.get());
    }

    public static double getAttackDamage(LivingEntity player) {
        return player.m_21133_(Attributes.f_22281_);
    }

    public static double getRealDamage(LivingEntity livingEntity) {
        return AOMUtil.getRealDamage(livingEntity, List.of());
    }

    public static double getRealDamage(LivingEntity livingEntity, List<TagKey<EntityType<?>>> tags, String flag) {
        if (flag.equals("goety_special")) {
            return 1.0;
        }
        return AOMUtil.getRealDamage(livingEntity, tags);
    }

    public static double getRealDamage(LivingEntity livingEntity, List<TagKey<EntityType<?>>> tags) {
        double defaultDamage = AOMUtil.getAttackDamage(livingEntity);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            LivingEntity identity = PlayerIdentity.getIdentity((Player)player);
            AtomicReference<Double> damage = new AtomicReference<Double>(0.0);
            TAGS.get().forEach((tag, damageFunc) -> {
                if (identity != null && identity.m_6095_().m_204039_(tag) || tags.contains(tag)) {
                    damage.set((Double)damage.get() + (Double)damageFunc.apply(player));
                }
            });
            return damage.get();
        }
        return defaultDamage;
    }

    public static double getPotency(LivingEntity livingEntity) {
        Attribute attribute = AOMUtil.getAttribute("goety_revelation:spell_power");
        Attribute attributeMul = AOMUtil.getAttribute("goety_revelation:spell_power_multiplier");
        if (attribute != null && attributeMul != null) {
            return livingEntity.m_21133_(attribute) * livingEntity.m_21133_(attributeMul);
        }
        return 0.0;
    }

    public static double getRealFireDamage(LivingEntity player) {
        Player player1;
        LivingEntity identity;
        double multiply = 1.0;
        if (player instanceof Player && (identity = PlayerIdentity.getIdentity((Player)(player1 = (Player)player))) instanceof Ignis_Entity) {
            Ignis_Entity ignis = (Ignis_Entity)identity;
            if (ignis.getBossPhase() == 1) {
                multiply = 1.2;
            } else if (ignis.getBossPhase() == 3) {
                multiply = 1.5;
            }
        }
        return Math.max(player.m_21133_((Attribute)AOMAttributes.FIRE_DAMAGE.get()) * multiply, 15.0);
    }

    public static int getRealSpellLevel(LivingEntity livingEntity) {
        Player player;
        LivingEntity identity;
        if (livingEntity instanceof Player && (identity = PlayerIdentity.getIdentity((Player)(player = (Player)livingEntity))) != null) {
            if (identity.m_6095_().m_204039_(EntityTagGenerator.DRAGON)) {
                int dragonLevel = (int)AOMUtil.getDragonLevel(player);
                if (identity instanceof EntityDragonBase) {
                    dragonLevel = (int)(AOMUtil.getDragonLevel(player) * AOMUtil.getDragonStageMultiply(livingEntity));
                }
                return dragonLevel;
            }
            if (identity.m_6095_().m_204039_(EntityTagGenerator.EXPLODE)) {
                int explodeDamage = AOMUtil.getExplosionPower(player);
                if (explodeDamage < 10) {
                    return 2;
                }
                if (explodeDamage < 50) {
                    return 3;
                }
                if (explodeDamage < 200) {
                    return 5;
                }
                if (explodeDamage < 500) {
                    return 7;
                }
                if (explodeDamage < 800) {
                    return 8;
                }
                return 10;
            }
            if (identity.m_6095_().m_204039_(EntityTagGenerator.ABYSS)) {
                return (int)AOMUtil.getAbyssLevel(player);
            }
            if (identity instanceof Ender_Guardian_Entity) {
                return 5;
            }
        }
        int spellLevel = AOMUtil.getSpellLevel(livingEntity);
        if (livingEntity instanceof Player) {
            Player player2 = (Player)livingEntity;
            spellLevel = (int)Math.max((double)spellLevel, AOMUtil.getMachineLevel(player2));
        }
        return spellLevel;
    }

    public static double getDragonDamage(LivingEntity livingEntity) {
        Player player;
        LivingEntity identity;
        if (livingEntity instanceof Player && (identity = PlayerIdentity.getIdentity((Player)(player = (Player)livingEntity))) != null && identity.m_6095_().m_204039_(EntityTagGenerator.DRAGON)) {
            double dragonLevel = AOMUtil.getDragonLevel(player);
            if (identity instanceof EntityDragonBase) {
                dragonLevel = AOMUtil.getDragonLevel(player) * AOMUtil.getDragonStageMultiply(livingEntity);
            }
            return dragonLevel * AOMUtil.getDragonPower(player);
        }
        return 0.0;
    }

    public static double getDragonStageMultiply(LivingEntity livingEntity) {
        Player player;
        LivingEntity identity;
        double mul = 1.0;
        if (livingEntity instanceof Player && (identity = PlayerIdentity.getIdentity((Player)(player = (Player)livingEntity))) instanceof EntityDragonBase) {
            EntityDragonBase dragonBase = (EntityDragonBase)identity;
            int stage = dragonBase.getDragonStage();
            switch (stage) {
                case 1: {
                    mul = 1.0;
                    break;
                }
                case 2: {
                    mul = 1.2;
                    break;
                }
                case 3: {
                    mul = 1.5;
                    break;
                }
                case 4: {
                    mul = 1.7;
                }
            }
        }
        return mul;
    }

    public static double getFlyingSpeed(Player player) {
        return player.m_21133_((Attribute)AOMAttributes.FLYING_SPEED.get());
    }

    public static double getDragonLevel(Player player) {
        return player.m_21133_((Attribute)AOMAttributes.DRAGON_LEVEL.get());
    }

    public static double getDragonPower(Player player) {
        return player.m_21133_((Attribute)AOMAttributes.DRAGON_POWER.get());
    }

    public static double getAbyssLevel(Player player) {
        return player.m_21133_((Attribute)AOMAttributes.ABYSS_LEVEL.get());
    }

    public static double getAbyssDamage(Player player) {
        return player.m_21133_((Attribute)AOMAttributes.ABYSS_DAMAGE.get());
    }

    public static double getMachineLevel(Player player) {
        return player.m_21133_((Attribute)AOMAttributes.MACHINE_LEVEL.get());
    }

    public static double getMachineDamage(Player player) {
        return player.m_21133_((Attribute)AOMAttributes.MACHINE_DAMAGE.get());
    }

    public static double getFleshLevel(Player player) {
        return player.m_21133_((Attribute)AOMAttributes.FLESH_LEVEL.get());
    }

    public static double getEmotionValue(Player player) {
        return player.m_21133_((Attribute)AOMAttributes.EMOTION_VALUE.get());
    }

    public static double getBloodPower(Player player) {
        return player.m_21133_((Attribute)AOMAttributes.BLOOD_POWER.get());
    }

    public static Item getCurrency() {
        if (AgeOfMythologyMod.isLoadedMod("lightmanscurrency")) {
            return (Item)io.github.lightman314.lightmanscurrency.common.core.ModItems.COIN_IRON.get();
        }
        return Items.f_42616_;
    }

    public static Item getCurrency(int value) {
        if (AgeOfMythologyMod.isLoadedMod("lightmanscurrency")) {
            switch (value) {
                case 0: {
                    return (Item)io.github.lightman314.lightmanscurrency.common.core.ModItems.COIN_COPPER.get();
                }
                case 1: {
                    return (Item)io.github.lightman314.lightmanscurrency.common.core.ModItems.COIN_IRON.get();
                }
                case 2: {
                    return (Item)io.github.lightman314.lightmanscurrency.common.core.ModItems.COIN_GOLD.get();
                }
                case 3: {
                    return (Item)io.github.lightman314.lightmanscurrency.common.core.ModItems.COIN_EMERALD.get();
                }
                case 4: {
                    return (Item)io.github.lightman314.lightmanscurrency.common.core.ModItems.COIN_DIAMOND.get();
                }
                case 5: {
                    return (Item)io.github.lightman314.lightmanscurrency.common.core.ModItems.COIN_NETHERITE.get();
                }
            }
        }
        return Items.f_42616_;
    }

    public static Item getFavouriteItem(String entityId) {
        List<String> list = Arrays.stream(entityId.split(":")).toList();
        if (list.isEmpty()) {
            return AOMUtil.getCurrency();
        }
        String nameSpace = list.get(0);
        switch (AOMUtil.findMobVariantByString(entityId)) {
            case MINECRAFT_ALLAY: {
                return Items.f_151049_;
            }
            case MINECRAFT_AXOLOTL: {
                return Items.f_42528_;
            }
            case MINECRAFT_BAT: {
                return Items.f_42687_;
            }
            case MINECRAFT_BEE: {
                return Items.f_41940_;
            }
            case MINECRAFT_BLAZE: {
                return Items.f_42413_;
            }
            case MINECRAFT_CAMEL: {
                return Items.f_41982_;
            }
            case MINECRAFT_CAVE_SPIDER: {
                return Items.f_42485_;
            }
            case MINECRAFT_CAT: {
                return Items.f_42526_;
            }
            case MINECRAFT_CHICKEN: {
                return Items.f_42404_;
            }
            case MINECRAFT_COD: 
            case MINECRAFT_TROPICAL_FISH: {
                return Items.f_41910_;
            }
            case MINECRAFT_COW: {
                return Items.f_42405_;
            }
            case MINECRAFT_CREEPER: {
                return Items.f_41996_;
            }
            case MINECRAFT_DOLPHIN: {
                return Items.f_42526_;
            }
            case MINECRAFT_DONKEY: {
                return Items.f_42405_;
            }
            case MINECRAFT_DROWNED: {
                return Items.f_42589_;
            }
            case MINECRAFT_ELDER_GUARDIAN: {
                return Items.f_42695_;
            }
            case MINECRAFT_ENDER_DRAGON: {
                return Items.f_42729_;
            }
            case MINECRAFT_ENDERMAN: {
                return Items.f_42276_;
            }
            case MINECRAFT_ENDERMITE: {
                return Items.f_42584_;
            }
            case MINECRAFT_FOX: {
                return Items.f_42780_;
            }
            case MINECRAFT_FROG: {
                return Items.f_42518_;
            }
            case MINECRAFT_GHAST: {
                return Items.f_42049_;
            }
            case MINECRAFT_GIANT: {
                return Items.f_42583_;
            }
            case MINECRAFT_GLOW_SQUID: {
                return Items.f_42526_;
            }
            case MINECRAFT_GOAT: {
                return Items.f_41864_;
            }
            case MINECRAFT_GUARDIAN: {
                return Items.f_42695_;
            }
            case MINECRAFT_HOGLIN: {
                return Items.f_41954_;
            }
            case MINECRAFT_HORSE: {
                return Items.f_42405_;
            }
            case MINECRAFT_HUSK: {
                return Items.f_42583_;
            }
            case MINECRAFT_IRON_GOLEM: {
                return Items.f_41940_;
            }
            case MINECRAFT_LLAMA: 
            case MINECRAFT_TRADER_LLAMA: {
                return Items.f_42405_;
            }
            case MINECRAFT_MAGMA_CUBE: {
                return Items.f_41954_;
            }
            case MINECRAFT_MOOSHROOM: {
                return Items.f_42405_;
            }
            case MINECRAFT_MULE: {
                return Items.f_42405_;
            }
            case MINECRAFT_OCELOT: {
                return Items.f_42526_;
            }
            case MINECRAFT_PARROT: {
                return Items.f_42404_;
            }
            case MINECRAFT_PANDA: {
                return Items.f_41911_;
            }
            case MINECRAFT_PHANTOM: {
                return Items.f_42503_;
            }
            case MINECRAFT_PIG: {
                return Items.f_42619_;
            }
            case MINECRAFT_PIGLIN: {
                return Items.f_42417_;
            }
            case MINECRAFT_PIGLIN_BRUTE: {
                return Items.f_41912_;
            }
            case MINECRAFT_PILLAGER: {
                return Items.f_42616_;
            }
            case MINECRAFT_POLAR_BEAR: {
                return Items.f_42526_;
            }
            case MINECRAFT_PUFFERFISH: {
                return Items.f_41910_;
            }
            case MINECRAFT_RABBIT: {
                return Items.f_42619_;
            }
            case MINECRAFT_RAVAGER: {
                return Items.f_42110_;
            }
            case MINECRAFT_SALMON: {
                return Items.f_41910_;
            }
            case MINECRAFT_SHEEP: {
                return Items.f_42405_;
            }
            case MINECRAFT_SHULKER: {
                return Items.f_42584_;
            }
            case MINECRAFT_SILVERFISH: {
                return Items.f_41905_;
            }
            case MINECRAFT_SKELETON: {
                return Items.f_42500_;
            }
            case MINECRAFT_SKELETON_HORSE: {
                return Items.f_42583_;
            }
            case MINECRAFT_SLIME: {
                return Items.f_42518_;
            }
            case MINECRAFT_SNIFFER: {
                return Items.f_42329_;
            }
            case MINECRAFT_SNOW_GOLEM: {
                return Items.f_42452_;
            }
            case MINECRAFT_SPIDER: {
                return Items.f_42485_;
            }
            case MINECRAFT_SQUID: {
                return Items.f_41910_;
            }
            case MINECRAFT_STRAY: {
                return Items.f_42500_;
            }
            case MINECRAFT_STRIDER: {
                return Items.f_42448_;
            }
            case MINECRAFT_TADPOLE: {
                return Items.f_42518_;
            }
            case MINECRAFT_TURTLE: {
                return Items.f_41867_;
            }
            case MINECRAFT_VEX: 
            case MINECRAFT_VINDICATOR: {
                return Items.f_42616_;
            }
            case MINECRAFT_WARDEN: {
                return Items.f_42612_;
            }
            case MINECRAFT_WITCH: {
                return Items.f_42436_;
            }
            case MINECRAFT_WITHER: {
                return Items.f_42686_;
            }
            case MINECRAFT_WITHER_SKELETON: {
                return Items.f_41951_;
            }
            case MINECRAFT_WOLF: {
                return Items.f_42500_;
            }
            case MINECRAFT_ZOGLIN: {
                return Items.f_42583_;
            }
            case MINECRAFT_ZOMBIE: {
                return Items.f_42583_;
            }
            case MINECRAFT_ZOMBIE_HORSE: {
                return Items.f_42583_;
            }
            case MINECRAFT_ZOMBIE_VILLAGER: {
                return Items.f_42436_;
            }
            case MINECRAFT_ZOMBIFIED_PIGLIN: {
                return Items.f_42417_;
            }
            case ALEXSMOBS_GRIZZLY_BEAR: {
                return Items.f_42784_;
            }
            case ALEXSMOBS_ROADRUNNER: {
                return (Item)AMItemRegistry.MAGGOT.get();
            }
            case ALEXSMOBS_BONE_SERPENT: {
                return Items.f_42448_;
            }
            case ALEXSMOBS_FLY: {
                return Items.f_42583_;
            }
            case ALEXSMOBS_GAZELLE: {
                return Items.f_42405_;
            }
            case ALEXSMOBS_CROCODILE: {
                return Items.f_42583_;
            }
            case ALEXSMOBS_HUMMINGBIRD: {
                return Items.f_41940_;
            }
            case ALEXSMOBS_ORCA: {
                return Items.f_42527_;
            }
            case ALEXSMOBS_SUNBIRD: {
                return Items.f_42206_;
            }
            case ALEXSMOBS_GORILLA: {
                return (Item)AMItemRegistry.BANANA.get();
            }
            case ALEXSMOBS_CRIMSON_MOSQUITO: {
                return (Item)AMItemRegistry.MAGGOT.get();
            }
            case ALEXSMOBS_RATTLESNAKE: {
                return Items.f_42697_;
            }
            case ALEXSMOBS_HAMMERHEAD_SHARK: {
                return Items.f_42526_;
            }
            case ALEXSMOBS_LOBSTER: {
                return Items.f_41910_;
            }
            case ALEXSMOBS_KOMODO_DRAGON: {
                return Items.f_42583_;
            }
            case ALEXSMOBS_FLUTTER: {
                return Items.f_42618_;
            }
            case ALEXSMOBS_CAPUCHIN_MONKEY: {
                return (Item)AMItemRegistry.BANANA.get();
            }
            case ALEXSMOBS_WARPED_TOAD: {
                return (Item)AMItemRegistry.MOSQUITO_LARVA.get();
            }
            case ALEXSMOBS_MOOSE: {
                return Items.f_41939_;
            }
            case ALEXSMOBS_MIMICUBE: {
                return Items.f_42518_;
            }
            case ALEXSMOBS_RACCOON: {
                return Items.f_42521_;
            }
            case ALEXSMOBS_BLOBFISH: {
                return Items.f_41867_;
            }
            case ALEXSMOBS_COCKROACH: {
                return Items.f_42501_;
            }
            case ALEXSMOBS_ELEPHANT: {
                return (Item)AMItemRegistry.ACACIA_BLOSSOM.get();
            }
            case ALEXSMOBS_SOUL_VULTURE: {
                return Items.f_42049_;
            }
            case ALEXSMOBS_SNOW_LEOPARD: {
                return (Item)ACItemRegistry.SUNDAE.get();
            }
            case ALEXSMOBS_CROW: {
                return Items.f_42577_;
            }
            case ALEXSMOBS_ALLIGATOR_SNAPPING_TURTLE: {
                return Items.f_42526_;
            }
            case ALEXSMOBS_KANGAROO: {
                return Items.f_42619_;
            }
            case ALEXSMOBS_CACHALOT_WHALE: {
                return Items.f_42526_;
            }
            case ALEXSMOBS_LEAFCUTTER_ANT: {
                return (Item)AMItemRegistry.GONGYLIDIA.get();
            }
            case ALEXSMOBS_BALD_EAGLE: {
                return (Item)AMItemRegistry.FISH_OIL.get();
            }
            case ALEXSMOBS_TARANTULA_HAWK: {
                return Items.f_42591_;
            }
            case ALEXSMOBS_VOID_WORM: {
                return (Item)AMItemRegistry.MYSTERIOUS_WORM.get();
            }
            case ALEXSMOBS_FRILLED_SHARK: {
                return (Item)AMItemRegistry.BLOBFISH.get();
            }
            case ALEXSMOBS_SEAGULL: {
                return Items.f_42526_;
            }
            case ALEXSMOBS_TOUCAN: {
                return Items.f_42410_;
            }
            case ALEXSMOBS_MANED_WOLF: {
                return Items.f_42410_;
            }
            case ALEXSMOBS_SEA_BEAR: {
                return Items.f_42526_;
            }
            case ALEXSMOBS_ANTEATER: {
                return (Item)AMItemRegistry.LEAFCUTTER_ANT_PUPA.get();
            }
            case ALEXSMOBS_GIANT_SQUID: {
                return Items.f_42526_;
            }
            case ALEXSMOBS_CATFISH: 
            case ALEXSMOBS_FLYING_FISH: {
                return Items.f_41867_;
            }
            case ALEXSMOBS_RAIN_FROG: {
                return (Item)AMItemRegistry.MAGGOT.get();
            }
            case ALEXSMOBS_SKUNK: {
                return Items.f_42780_;
            }
            case ALEXSMOBS_BLUE_JAY: {
                return Items.f_151079_;
            }
            case ALEXSCAVES_NUCLEEPER: {
                return (Item)ACItemRegistry.SULFUR_DUST.get();
            }
            case ALEXSCAVES_RAYCAT: {
                return (Item)ACItemRegistry.RADGILL.get();
            }
            case ALEXSCAVES_TELETOR: 
            case ALEXSCAVES_MAGNETRON: 
            case ALEXSCAVES_BOUNDROID: 
            case ALEXSCAVES_BOUNDROID_WINCH: 
            case ALEXSCAVES_FERROUSLIME: 
            case ALEXSCAVES_NOTOR: {
                return Items.f_151050_;
            }
            case ALEXSCAVES_SEA_PIG: {
                return Items.f_42461_;
            }
            case ALEXSCAVES_DEEP_ONE: 
            case ALEXSCAVES_DEEP_ONE_KNIGHT: 
            case ALEXSCAVES_DEEP_ONE_MAGE: {
                return (Item)ACItemRegistry.DEEP_SEA_SUSHI_ROLL.get();
            }
            case ALEXSCAVES_HULLBREAKER: {
                return Items.f_42716_;
            }
            case ALEXSCAVES_TREMORZILLA: {
                return ((Block)ACBlockRegistry.NUCLEAR_BOMB.get()).m_5456_();
            }
            case ALEXSCAVES_RADGILL: {
                return (Item)ACItemRegistry.ACID_BUCKET.get();
            }
            case ALEXSMOBS_DEVILS_HOLE_PUPFISH: {
                return Blocks.f_152544_.m_5456_();
            }
            case ALEXSCAVES_GAMMAROACH: {
                return (Item)ACItemRegistry.SPELUNKIE.get();
            }
            case ALEXSCAVES_BRAINIAC: {
                return ((Block)ACBlockRegistry.WASTE_DRUM.get()).m_5456_();
            }
            case ALEXSCAVES_GUMBEEPER: {
                return (Item)ACItemRegistry.ALEX_MEAL.get();
            }
            case ALEXSCAVES_MINE_GUARDIAN: {
                return (Item)ACItemRegistry.COOKED_MUSSEL.get();
            }
            case BOSSES_OF_MASS_DESTRUCTION_GAUNTLET: {
                return Items.f_42418_;
            }
            case BOSSES_OF_MASS_DESTRUCTION_LICH: {
                return (Item)ItemRegistry.INK_LEGENDARY.get();
            }
            case BOSSES_OF_MASS_DESTRUCTION_OBSIDILITH: {
                return Items.f_41999_;
            }
            case BOSSES_OF_MASS_DESTRUCTION_VOID_BLOSSOM: {
                return Items.f_151079_;
            }
            case CATACLYSM_ENDER_GUARDIAN: {
                return Items.f_42584_;
            }
            case CATACLYSM_NETHERITE_MONSTROSITY: {
                return Items.f_42418_;
            }
            case CATACLYSM_IGNIS: {
                return (Item)ModItems.BURNING_ASHES.get();
            }
            case CATACLYSM_IGNITED_BERSERKER: 
            case CATACLYSM_IGNITED_REVENANT: {
                return Items.f_42585_;
            }
            case CATACLYSM_LIONFISH: 
            case CATACLYSM_DEEPLING: 
            case CATACLYSM_DEEPLING_ANGLER: 
            case CATACLYSM_DEEPLING_BRUTE: 
            case CATACLYSM_DEEPLING_PRIEST: 
            case CATACLYSM_DEEPLING_WARLOCK: {
                return Items.f_41910_;
            }
            case CATACLYSM_CORALSSUS: 
            case CATACLYSM_CORAL_GOLEM: {
                return Items.f_41910_;
            }
            case CATACLYSM_THE_LEVIATHAN: {
                return Items.f_42716_;
            }
            case CATACLYSM_ANCIENT_REMNANT: {
                return Items.f_41912_;
            }
            case CATACLYSM_MALEDICTUS: {
                return (Item)ModItems.CURSED_EYE.get();
            }
            case CONJURER_ILLAGER_CONJURER: {
                return (Item)AOMItems.ALEXSMOBS_CROW_ITEM.get();
            }
            case CATACLYSM_THE_HARBINGER: {
                return AOMUtil.getCurrency(3);
            }
            case CATACLYSM_THE_PROWLER: {
                return AOMUtil.getCurrency(2);
            }
            case CATACLYSM_THE_WATCHER: {
                return AOMUtil.getCurrency(1);
            }
            case GRAVEYARD_LICH: {
                return (Item)ItemRegistry.INK_LEGENDARY.get();
            }
            case GRAVEYARD_SKELETON_CREEPER: {
                return Items.f_42403_;
            }
            case TAKESAPILLAGE_CLAY_GOLEM: {
                return Items.f_41940_;
            }
            case TWILIGHTFOREST_NAGA: {
                return (Item)TFItems.TORCHBERRIES.get();
            }
            case TWILIGHTFOREST_LICH: {
                return (Item)ItemRegistry.INK_RARE.get();
            }
            case TWILIGHTFOREST_MINOSHROOM: {
                return Items.f_41953_;
            }
            case TWILIGHTFOREST_HYDRA: {
                return (Item)TFItems.RAW_VENISON.get();
            }
            case TWILIGHTFOREST_KNIGHT_PHANTOM: {
                return Items.f_42416_;
            }
            case TWILIGHTFOREST_UR_GHAST: {
                return Items.f_42451_;
            }
            case TWILIGHTFOREST_YETI: 
            case TWILIGHTFOREST_ALPHA_YETI: {
                return (Item)TFItems.HYDRA_CHOP.get();
            }
            case TWILIGHTFOREST_SNOW_QUEEN: {
                return ((Block)TFBlocks.AURORA_BLOCK.get()).m_5456_();
            }
            case ICEANDFIRE_FIRE_DRAGON: 
            case ICEANDFIRE_DRAGON_EGG: 
            case ICEANDFIRE_LIGHTNING_DRAGON: {
                return (Item)IafItemRegistry.DRAGON_MEAL.get();
            }
            case ICEANDFIRE_GORGON: {
                return Items.f_42581_;
            }
            case ICEANDFIRE_CYCLOPS: {
                return Items.f_42658_;
            }
            case ICEANDFIRE_HYDRA: {
                return Items.f_42581_;
            }
            case ICEANDFIRE_COCKATRICE: {
                return Items.f_42405_;
            }
            case ICEANDFIRE_SIREN: {
                return Items.f_42715_;
            }
            case IRONS_SPELLBOOKS_CITADEL_KEEPER: {
                return (Item)ItemRegistry.KEEPER_FLAMBERGE.get();
            }
            case IRONS_SPELLBOOKS_DEAD_KING: 
            case TRAVELOPTICS_ENRAGED_DEAD_KING: {
                return (Item)ItemRegistry.INK_LEGENDARY.get();
            }
            case AGEOFMYTHOLOGY_SHADOW_DEMON: 
            case AGEOFMYTHOLOGY_ICE_THUNDER_SOUL: 
            case AGEOFMYTHOLOGY_SCULK_SHRIEKER: 
            case AGEOFMYTHOLOGY_HELL_TRAVELER: 
            case AGEOFMYTHOLOGY_END_SCHOLAR: 
            case AGEOFMYTHOLOGY_LOST_ONE: 
            case AGEOFMYTHOLOGY_GOOD_EVIL: {
                return Items.f_42686_;
            }
            case GOETY_MINISTER: {
                return (Item)com.Polarice3.Goety.common.items.ModItems.OMINOUS_ORB.get();
            }
            case GOETY_SORCERER: {
                return (Item)com.Polarice3.Goety.common.items.ModItems.MAGIC_EMERALD.get();
            }
            case GOETY_CONQUILLAGER: {
                break;
            }
            case GOETY_CRUSHER: {
                return (Item)ItemRegistry.LIGHTNING_RUNE.get();
            }
            case GOETY_CRYOLOGER: {
                return (Item)ItemRegistry.ICE_RUNE.get();
            }
            case GOETY_ENVIOKER: {
                return Items.f_42747_;
            }
            case GOETY_INQUILLAGER: {
                return Items.f_42417_;
            }
            case GOETY_IRK: {
                break;
            }
            case GOETY_PIKER: {
                return (Item)com.Polarice3.Goety.common.items.ModItems.MAGIC_EMERALD.get();
            }
            case GOETY_PREACHER: {
                return (Item)ItemRegistry.HOLY_RUNE.get();
            }
            case GOETY_STORM_CASTER: {
                return (Item)ItemRegistry.MANA_RUNE.get();
            }
            case GOETY_TORMENTOR: {
                break;
            }
            case GOETY_TRAMPLER: {
                break;
            }
            case GOETY_VIZIER: {
                return (Item)com.Polarice3.Goety.common.items.ModItems.SOUL_EMERALD.get();
            }
            case GOETY_APOSTLE: {
                return Items.f_42686_;
            }
            case GOETY_CRONE: {
                return (Item)ItemRegistry.NATURE_RUNE.get();
            }
            case GOETY_WITHER_NECROMANCER: {
                return (Item)ItemRegistry.BLOOD_RUNE.get();
            }
            case GOETY_VIZIER_CLONE: {
                return (Item)com.Polarice3.Goety.common.items.ModItems.SOUL_EMERALD.get();
            }
            case MOWZIESMOBS_FROSTMAW: {
                return (Item)IafItemRegistry.ICE_DRAGON_FLESH.get();
            }
            case MOWZIESMOBS_UMVUTHI: {
                return (Item)IafItemRegistry.FIRE_DRAGON_FLESH.get();
            }
        }
        switch (nameSpace) {
            case "alexsmobs": {
                return AOMUtil.getCurrency();
            }
            case "alexscaves": {
                return (Item)ACItemRegistry.AMBER_CURIOSITY.get();
            }
            case "biomancy": {
                return (Item)com.github.elenterius.biomancy.init.ModItems.NUTRIENT_PASTE.get();
            }
            case "bygonenether": {
                return (Item)com.izofar.bygonenether.init.ModItems.WITHERED_DEBRIS.get();
            }
            case "crittersandcompanions": {
                return Items.f_42410_;
            }
            case "deeperdarker": {
                return Items.f_220224_;
            }
            case "goety": {
                return Items.f_42616_;
            }
            case "graveyard": {
                return (Item)TGItems.CORRUPTION.get();
            }
            case "ribbits": {
                return Items.f_42619_;
            }
            case "raided": {
                return Items.f_42616_;
            }
            case "takesapillage": {
                return Items.f_42616_;
            }
            case "iceandfire": {
                return AOMUtil.getCurrency();
            }
            case "irons_spellbooks": 
            case "traveloptics": {
                return (Item)ItemRegistry.ARCANE_ESSENCE.get();
            }
            case "twilightforest": {
                return AOMUtil.getCurrency();
            }
            case "spore": {
                return (Item)AOMItems.AGEOFMYTHOLOGY_FLESH_ITEM.get();
            }
            case "doom": {
                return (Item)AOMItems.AGEOFMYTHOLOGY_FLESH_ITEM.get();
            }
            case "mowziesmobs": {
                return Items.f_42616_;
            }
        }
        return AOMUtil.getCurrency();
    }

    public static List<VillagerTrades.ItemListing> getExtraOffer(String entityId) {
        ArrayList<VillagerTrades.ItemListing> list = new ArrayList<VillagerTrades.ItemListing>();
        switch (AOMUtil.findMobVariantByString(entityId)) {
            case MINECRAFT_ALLAY: {
                list.add(AOMTradeConfig.createItemListing(Items.f_151086_, 4, (Item)AOMItems.JOY_ITEM.get(), 1));
                break;
            }
            case MINECRAFT_BEE: {
                list.add(AOMTradeConfig.createItemListing(Items.f_41940_, 2, Items.f_42590_, 1, Items.f_42787_, 1));
                break;
            }
            case MINECRAFT_BLAZE: {
                list.add(AOMTradeConfig.createItemListing(((Block)ACBlockRegistry.PRIMAL_MAGMA.get()).m_5456_(), 8, (Item)AOMItems.ANGER_ITEM.get(), 1));
                break;
            }
            case MINECRAFT_SLIME: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42410_, 1, Items.f_42518_, 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42276_, 1, Items.f_42518_, 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42583_, 1, Items.f_42518_, 1));
                break;
            }
            case MINECRAFT_SHULKER: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42584_, 1, Items.f_42730_, 1));
                break;
            }
            case MINECRAFT_ENDERMAN: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42276_, 4, (Item)RSItems.CONTROLLER.get(ColorMap.DEFAULT_COLOR).get(), 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42276_, 4, (Item)RSItems.WIRELESS_GRID.get(), 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42276_, 64, (Item)RSAddonsItems.WIRELESS_CRAFTING_GRID.get(), 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42276_, 4, (Item)RSItems.WIRELESS_TRANSMITTER.get(ColorMap.DEFAULT_COLOR).get(), 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42276_, 4, (Item)RSItems.CRAFTING_GRID.get(ColorMap.DEFAULT_COLOR).get(), 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42276_, 4, (Item)RSItems.DISK_DRIVE.get(), 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42276_, 64, (Item)((RegistryObject)RSItems.ITEM_STORAGE_DISKS.get(ItemStorageType.SIXTY_FOUR_K)).get(), 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42276_, 64, (Item)uk.co.hexeption.rsinfinitybooster.setup.ModItems.DIMENSION_CARD.get(), 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42276_, 64, (Item)uk.co.hexeption.rsinfinitybooster.setup.ModItems.INFINITY_CARD.get(), 1));
                break;
            }
            case MINECRAFT_DOLPHIN: {
                list.add(AOMTradeConfig.createItemListing((Item)ACItemRegistry.PURPLE_SODA_BUCKET.get(), 1, (Item)AOMItems.LOVE_ITEM.get(), 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42526_, 32, Items.f_42716_, 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42527_, 32, Items.f_42716_, 1));
                break;
            }
            case MINECRAFT_GHAST: {
                list.add(AOMTradeConfig.createItemListing((Item)ModItems.LACRIMA.get(), 8, (Item)AOMItems.SORROW_ITEM.get(), 1));
                break;
            }
            case MINECRAFT_CREEPER: {
                list.add(AOMTradeConfig.createItemListing(Items.f_41996_, 16, (Item)AOMItems.FEAR_ITEM.get(), 1));
                break;
            }
            case MINECRAFT_SNIFFER: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42000_, 1, Items.f_41939_, 1, (Item)AOMItems.MINECRAFT_SNIFFER_ITEM.get(), 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_271471_, 1, Items.f_276468_, 1));
                break;
            }
            case MINECRAFT_FOX: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42780_, 2, Items.f_42616_, 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42780_, 4, Items.f_42648_, 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42780_, 4, Items.f_42649_, 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42780_, 32, Items.f_42747_, 1));
                break;
            }
            case MINECRAFT_PILLAGER: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42110_, 8, (Item)AOMItems.HATRED_ITEM.get(), 1));
                break;
            }
            case MINECRAFT_PIGLIN: {
                list.add(AOMTradeConfig.createItemListing(Items.f_41912_, 16, (Item)AOMItems.DESIRE_ITEM.get(), 1));
                break;
            }
            case MINECRAFT_IRON_GOLEM: {
                list.add(AOMTradeConfig.createItemListing((Item)AOMItems.MINECRAFT_PILLAGER_ITEM.get(), 1, Items.f_42416_, 8));
                list.add(AOMTradeConfig.createItemListing(Items.f_42416_, 32, (Item)AOMItems.MINECRAFT_IRON_GOLEM_ITEM.get(), 1));
                break;
            }
            case MINECRAFT_MOOSHROOM: {
                list.add(AOMTradeConfig.createItemListing(Items.f_41952_, 4, Items.f_42399_, 1, Items.f_42400_, 1));
                break;
            }
            case MINECRAFT_SKELETON: {
                list.add(AOMTradeConfig.createItemListing((Item)TGItems.STONE_BRICKS_GRAVESTONE.get(), 4, (Item)TGItems.CORRUPTION.get(), 1));
                list.add(AOMTradeConfig.createItemListing((Item)TGItems.DARK_IRON_INGOT.get(), 1, (Item)TGItems.OSSUARY.get(), 1));
                list.add(AOMTradeConfig.createItemListing((Item)TGItems.DARK_IRON_INGOT.get(), 1, (Item)TGItems.SOUL_FIRE_BRAZIER.get(), 1));
                list.add(AOMTradeConfig.createItemListing((Item)TGItems.OAK_COFFIN.get(), 1, (Item)TGItems.BONE_DAGGER.get(), 1));
                break;
            }
            case MINECRAFT_WARDEN: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42612_, 16, Items.f_42701_, 1, (Item)AOMItems.MINECRAFT_WARDEN_ITEM.get(), 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42612_, 16, Items.f_42752_, 1, (Item)AOMItems.MINECRAFT_WARDEN_ITEM.get(), 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_42612_, 16, Items.f_186363_, 1, (Item)AOMItems.MINECRAFT_WARDEN_ITEM.get(), 1));
                break;
            }
            case ALEXSMOBS_BONE_SERPENT: {
                list.add(AOMTradeConfig.createItemListing((Item)AMItemRegistry.SOUL_HEART.get(), 1, (Item)AOMItems.ALEXSMOBS_BONE_SERPENT_ITEM.get(), 1));
                break;
            }
            case ALEXSMOBS_SUNBIRD: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42065_, 1, Items.f_42741_, 1, (Item)AOMItems.ALEXSMOBS_SUNBIRD_ITEM.get(), 1));
                break;
            }
            case ALEXSMOBS_CRIMSON_MOSQUITO: {
                list.add(AOMTradeConfig.createItemListing(Items.f_41955_, 16, Items.f_41954_, 16, (Item)AOMItems.ALEXSMOBS_CRIMSON_MOSQUITO_ITEM.get(), 1));
                break;
            }
            case ALEXSMOBS_RATTLESNAKE: {
                list.add(AOMTradeConfig.createItemListing((Item)AMItemRegistry.ROADRUNNER_FEATHER.get(), 16, (Item)AOMItems.ALEXSMOBS_RATTLESNAKE_ITEM.get(), 1));
                break;
            }
            case ALEXSMOBS_KOMODO_DRAGON: {
                list.add(AOMTradeConfig.createItemListing((Item)AMItemRegistry.KOMODO_SPIT.get(), 8, (Item)AOMItems.ALEXSMOBS_KOMODO_DRAGON_ITEM.get(), 1));
                break;
            }
            case ALEXSMOBS_FLUTTER: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42618_, 64, (Item)shiroroku.tarotcards.Registry.ItemRegistry.the_empress.get(), 1));
                break;
            }
            case ALEXSMOBS_COCKROACH: {
                list.add(AOMTradeConfig.createItemListing((Item)AMItemRegistry.MIMICREAM.get(), 4, (Item)AMItemRegistry.SOMBRERO.get(), 1));
                list.add(AOMTradeConfig.createItemListing((Item)AMItemRegistry.MARACA.get(), 1, (Item)AMItemRegistry.SOMBRERO.get(), 1));
                list.add(AOMTradeConfig.createItemListing((Item)AMItemRegistry.MARACA.get(), 1, (Item)AMItemRegistry.MIMICREAM.get(), 4, (Item)AOMItems.ALEXSMOBS_COCKROACH_ITEM.get(), 1));
                break;
            }
            case ALEXSMOBS_CACHALOT_WHALE: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42716_, 1, (Item)AMItemRegistry.AMBERGRIS.get(), 1));
                break;
            }
            case CATACLYSM_MALEDICTUS: {
                list.add(AOMTradeConfig.createItemListing((Item)ModItems.APTRGANGR_HEAD.get(), 1, (Item)ModItems.DRAUGR_HEAD.get(), 1, (Item)AOMItems.CATACLYSM_MALEDICTUS_ITEM.get(), 1));
                break;
            }
            case ICEANDFIRE_FIRE_DRAGON: {
                list.add(AOMTradeConfig.createItemListing((Item)IafItemRegistry.DRAGON_MEAL.get(), 8, (Item)IafItemRegistry.FIRE_STEW.get(), 4, (Item)IafItemRegistry.FIRE_DRAGON_HEART.get(), 1));
                list.add(AOMTradeConfig.createItemListing((Item)IafItemRegistry.DRAGON_MEAL.get(), 8, (Item)IafItemRegistry.FIRE_STEW.get(), 4, (Item)IafItemRegistry.DRAGON_SKULL_FIRE.get(), 1));
                list.add(AOMTradeConfig.createItemListing((Item)IafItemRegistry.DRAGON_MEAL.get(), 4, (Item)IafItemRegistry.FIRE_STEW.get(), 1, (Item)IafItemRegistry.DRAGON_BONE.get(), 4));
                list.add(AOMTradeConfig.createItemListing((Item)IafItemRegistry.DRAGON_MEAL.get(), 4, (Item)IafItemRegistry.FIRE_STEW.get(), 1, (Item)IafItemRegistry.FIRE_DRAGON_BLOOD.get(), 4));
                list.add(AOMTradeConfig.createItemListing(Items.f_42417_, 64, Items.f_42616_, 8, (Item)IafItemRegistry.DRAGONEGG_RED.get(), 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_41912_, 8, (Item)ModItems.IGNITIUM_INGOT.get(), 3, (Item)AOMItems.ICEANDFIRE_FIRE_DRAGON_ITEM.get(), 1));
                break;
            }
            case ICEANDFIRE_ICE_DRAGON: {
                list.add(AOMTradeConfig.createItemListing((Item)IafItemRegistry.DRAGON_MEAL.get(), 8, (Item)IafItemRegistry.FROST_STEW.get(), 4, (Item)IafItemRegistry.ICE_DRAGON_HEART.get(), 1));
                list.add(AOMTradeConfig.createItemListing((Item)IafItemRegistry.DRAGON_MEAL.get(), 8, (Item)IafItemRegistry.FROST_STEW.get(), 4, (Item)IafItemRegistry.DRAGON_SKULL_ICE.get(), 1));
                list.add(AOMTradeConfig.createItemListing((Item)IafItemRegistry.DRAGON_MEAL.get(), 4, (Item)IafItemRegistry.FROST_STEW.get(), 1, (Item)IafItemRegistry.DRAGON_BONE.get(), 4));
                list.add(AOMTradeConfig.createItemListing((Item)IafItemRegistry.DRAGON_MEAL.get(), 4, (Item)IafItemRegistry.FROST_STEW.get(), 1, (Item)IafItemRegistry.ICE_DRAGON_BLOOD.get(), 4));
                list.add(AOMTradeConfig.createItemListing((Item)IafItemRegistry.SILVER_INGOT.get(), 16, Items.f_42616_, 8, (Item)IafItemRegistry.DRAGONEGG_BLUE.get(), 1));
                list.add(AOMTradeConfig.createItemListing((Item)IafItemRegistry.SILVER_INGOT.get(), 32, (Item)ItemRegistry.ICE_CRYSTAL.get(), 1, (Item)AOMItems.ICEANDFIRE_ICE_DRAGON_ITEM.get(), 1));
                break;
            }
            case ICEANDFIRE_LIGHTNING_DRAGON: {
                list.add(AOMTradeConfig.createItemListing((Item)IafItemRegistry.DRAGON_MEAL.get(), 8, (Item)IafItemRegistry.LIGHTNING_STEW.get(), 4, (Item)IafItemRegistry.LIGHTNING_DRAGON_HEART.get(), 1));
                list.add(AOMTradeConfig.createItemListing((Item)IafItemRegistry.DRAGON_MEAL.get(), 8, (Item)IafItemRegistry.LIGHTNING_STEW.get(), 4, (Item)IafItemRegistry.DRAGON_SKULL_LIGHTNING.get(), 1));
                list.add(AOMTradeConfig.createItemListing((Item)IafItemRegistry.DRAGON_MEAL.get(), 4, (Item)IafItemRegistry.LIGHTNING_STEW.get(), 1, (Item)IafItemRegistry.DRAGON_BONE.get(), 4));
                list.add(AOMTradeConfig.createItemListing((Item)IafItemRegistry.DRAGON_MEAL.get(), 4, (Item)IafItemRegistry.LIGHTNING_STEW.get(), 1, (Item)IafItemRegistry.LIGHTNING_DRAGON_BLOOD.get(), 4));
                list.add(AOMTradeConfig.createItemListing(Items.f_42417_, 64, Items.f_42616_, 8, (Item)IafItemRegistry.DRAGONEGG_AMYTHEST.get(), 1));
                list.add(AOMTradeConfig.createItemListing(Items.f_151000_, 16, (Item)ItemRegistry.LIGHTNING_BOTTLE.get(), 1, (Item)AOMItems.ICEANDFIRE_LIGHTNING_DRAGON_ITEM.get(), 1));
                break;
            }
            case ALEXSMOBS_FARSEER: {
                list.add(AOMTradeConfig.createItemListing(((Block)ModBlocks.VOID_STONE.get()).m_5456_(), 8, (Item)AMItemRegistry.FARSEER_ARM.get(), 1));
                break;
            }
            case CATACLYSM_CORALSSUS: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42279_, 1, (Item)AOMItems.CATACLYSM_CORALSSUS_ITEM.get(), 1));
                break;
            }
            case CATACLYSM_CORAL_GOLEM: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42279_, 1, (Item)AOMItems.CATACLYSM_CORAL_GOLEM_ITEM.get(), 1));
                break;
            }
            case CATACLYSM_NETHERITE_MONSTROSITY: {
                break;
            }
            case ALEXSCAVES_VALLUMRAPTOR: {
                list.add(AOMTradeConfig.createItemListing((Item)ACItemRegistry.AMBER_CURIOSITY.get(), 32, ((Block)ACBlockRegistry.VALLUMRAPTOR_EGG.get()).m_5456_(), 1, (Item)AOMItems.ALEXSCAVES_VALLUMRAPTOR_ITEM.get(), 1));
                break;
            }
            case ALEXSCAVES_SUBTERRANODON: {
                list.add(AOMTradeConfig.createItemListing((Item)ACItemRegistry.AMBER_CURIOSITY.get(), 32, ((Block)ACBlockRegistry.SUBTERRANODON_EGG.get()).m_5456_(), 1, (Item)AOMItems.ALEXSCAVES_SUBTERRANODON_ITEM.get(), 1));
                break;
            }
            case GRAVEYARD_ACOLYTE: {
                ItemStack itemStack = AOMUtil.setBloodBottleEntityType(EntityType.f_20501_);
                list.add(AOMTradeConfig.createItemListing(itemStack, (Item)AOMItems.GRAVEYARD_ACOLYTE_ITEM.get(), 1));
                break;
            }
            case GRAVEYARD_CORRUPTED_PILLAGER: {
                ItemStack itemStack = AOMUtil.setBloodBottleEntityType(EntityType.f_20492_);
                list.add(AOMTradeConfig.createItemListing(itemStack, (Item)AOMItems.GRAVEYARD_CORRUPTED_PILLAGER_ITEM.get(), 1));
                break;
            }
            case GRAVEYARD_CORRUPTED_VINDICATOR: {
                ItemStack itemStack = AOMUtil.setBloodBottleEntityType(EntityType.f_20492_);
                list.add(AOMTradeConfig.createItemListing(itemStack, (Item)AOMItems.GRAVEYARD_CORRUPTED_VINDICATOR_ITEM.get(), 1));
                break;
            }
            case GRAVEYARD_REAPER: {
                ItemStack itemStack = AOMUtil.setBloodBottleEntityType(EntityType.f_20520_);
                list.add(AOMTradeConfig.createItemListing(itemStack, (Item)AOMItems.GRAVEYARD_REAPER_ITEM.get(), 1));
                break;
            }
            case GRAVEYARD_REVENANT: {
                ItemStack itemStack = AOMUtil.setBloodBottleEntityType((EntityType)IafEntityRegistry.CYCLOPS.get());
                list.add(AOMTradeConfig.createItemListing(itemStack, (Item)AOMItems.GRAVEYARD_REVENANT_ITEM.get(), 1));
                break;
            }
            case GRAVEYARD_WRAITH: {
                ItemStack itemStack = AOMUtil.setBloodBottleEntityType((EntityType)IafEntityRegistry.GORGON.get());
                list.add(AOMTradeConfig.createItemListing(itemStack, (Item)AOMItems.GRAVEYARD_WRAITH_ITEM.get(), 1));
                break;
            }
            case GRAVEYARD_NIGHTMARE: {
                ItemStack itemStack = AOMUtil.setBloodBottleEntityType((EntityType)IafEntityRegistry.LIGHTNING_DRAGON.get());
                list.add(AOMTradeConfig.createItemListing(itemStack, (Item)AOMItems.GRAVEYARD_NIGHTMARE_ITEM.get(), 1));
                break;
            }
            case GOETY_HOSTILE_BLACK_WOLF: {
                ItemStack itemStack = AOMUtil.setBloodBottleEntityType(EntityType.f_20499_);
                list.add(AOMTradeConfig.createItemListing(itemStack, (Item)AOMItems.GOETY_HOSTILE_BLACK_WOLF_ITEM.get(), 1));
                break;
            }
            case GOETY_WIGHT: {
                ItemStack itemStack = AOMUtil.setBloodBottleEntityType((EntityType)ModEntities.ANCIENT_REMNANT.get());
                list.add(AOMTradeConfig.createItemListing(itemStack, (Item)AOMItems.GOETY_WIGHT_ITEM.get(), 1));
                break;
            }
            case ALEXSCAVES_CORRODENT: {
                ItemStack itemStack = AOMUtil.setBloodBottleEntityType((EntityType)ACEntityRegistry.LUXTRUCTOSAURUS.get());
                list.add(AOMTradeConfig.createItemListing(itemStack, (Item)AOMItems.ALEXSCAVES_CORRODENT_ITEM.get(), 1));
                break;
            }
            case ALEXSCAVES_VESPER: {
                ItemStack itemStack = AOMUtil.setBloodBottleEntityType((EntityType)ACEntityRegistry.HULLBREAKER.get());
                list.add(AOMTradeConfig.createItemListing(itemStack, (Item)AOMItems.ALEXSCAVES_VESPER_ITEM.get(), 1));
                break;
            }
            case ALEXSCAVES_FORSAKEN: {
                ItemStack itemStack = AOMUtil.setBloodBottleEntityType((EntityType)IafEntityRegistry.FIRE_DRAGON.get());
                list.add(AOMTradeConfig.createItemListing(itemStack, (Item)AOMItems.ALEXSCAVES_FORSAKEN_ITEM.get(), 1));
                break;
            }
            case TWILIGHTFOREST_NAGA: {
                Item item = (Item)TFItems.TORCHBERRIES.get();
                list.add(AOMTradeConfig.createItemListing(item, 4, (Item)TFItems.MUSIC_DISC_RADIANCE.get(), 1));
                break;
            }
            case TWILIGHTFOREST_LICH: {
                Item item = (Item)ItemRegistry.INK_RARE.get();
                list.add(AOMTradeConfig.createItemListing(item, 4, (Item)TFItems.MUSIC_DISC_STEPS.get(), 1));
                break;
            }
            case TWILIGHTFOREST_MINOSHROOM: {
                Item item = Items.f_41953_;
                list.add(AOMTradeConfig.createItemListing(item, 4, (Item)TFItems.MUSIC_DISC_SUPERSTITIOUS.get(), 1));
                break;
            }
            case TWILIGHTFOREST_HYDRA: {
                Item item = (Item)TFItems.RAW_VENISON.get();
                list.add(AOMTradeConfig.createItemListing(item, 4, (Item)TFItems.MUSIC_DISC_HOME.get(), 1));
                break;
            }
            case TWILIGHTFOREST_KNIGHT_PHANTOM: {
                Item item = Items.f_42416_;
                list.add(AOMTradeConfig.createItemListing(item, 4, (Item)TFItems.MUSIC_DISC_WAYFARER.get(), 1));
                break;
            }
            case TWILIGHTFOREST_UR_GHAST: {
                Item item = Items.f_42451_;
                list.add(AOMTradeConfig.createItemListing(item, 4, (Item)TFItems.MUSIC_DISC_FINDINGS.get(), 1));
                break;
            }
            case TWILIGHTFOREST_ALPHA_YETI: {
                Item item = (Item)TFItems.HYDRA_CHOP.get();
                list.add(AOMTradeConfig.createItemListing(item, 4, (Item)TFItems.MUSIC_DISC_MAKER.get(), 1));
                break;
            }
            case TWILIGHTFOREST_SNOW_QUEEN: {
                Item item = ((Block)TFBlocks.AURORA_BLOCK.get()).m_5456_();
                list.add(AOMTradeConfig.createItemListing(item, 4, (Item)TFItems.MUSIC_DISC_THREAD.get(), 1));
                break;
            }
            case TWILIGHTFOREST_QUEST_RAM: {
                Item item = Items.f_41864_;
                list.add(AOMTradeConfig.createItemListing(item, 64, (Item)TFItems.MUSIC_DISC_MOTION.get(), 1));
                break;
            }
            case ALEXSMOBS_SEAL: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42526_, 64, (Item)AMItemRegistry.MUSIC_DISC_THIME.get(), 1));
                break;
            }
            case ILLAGEANDSPILLAGE_SPIRITCALLER: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42110_, 4, (Item)ItemRegisterer.SPIRITCALLER_DISC.get(), 1));
                break;
            }
            case ILLAGEANDSPILLAGE_MAGISPELLER: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42110_, 4, (Item)ItemRegisterer.MAGISPELLER_DISC.get(), 1));
                break;
            }
            case AETHER_AERBUNNY: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42619_, 16, (Item)AOMItems.AGEOFMYTHOLOGY_TRAVEL_AETHER_ITEM.get(), 1));
                break;
            }
            case GOETY_APOSTLE: {
                list.add(AOMTradeConfig.createItemListing(Items.f_42526_, 64, (Item)com.Polarice3.Goety.common.items.ModItems.FORBIDDEN_FRAGMENT.get(), 1));
            }
        }
        TravelAbility.travelTradeConfig(AOMUtil.findMobVariantByString(entityId), list);
        AutismSkullItem.autismTradeConfig(AOMUtil.findMobVariantByString(entityId), list);
        return list;
    }

    public static ItemStack setBloodBottleEntityType(EntityType<?> type) {
        ItemStack bloodItem = ((Item)AOMItems.BLOOD_BOTTLE.get()).m_7968_();
        String mobName = AOMUtil.getMobName(type);
        BloodBottleItem.setMobName(bloodItem, mobName);
        return bloodItem;
    }
}

