/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.config;

import com.google.common.collect.ImmutableMap;
import com.kurome.ageofmythology.config.AOMRarityConfig;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.enums.MobVariant;
import com.kurome.ageofmythology.init.AOMItems;
import com.kurome.ageofmythology.mixin.accessors.ConstantValueAccessor;
import com.kurome.ageofmythology.mixin.accessors.LootItemAccessor;
import com.kurome.ageofmythology.mixin.accessors.LootPoolAccessor;
import com.kurome.ageofmythology.mixin.accessors.LootPoolSingletonContainerAccessor;
import com.kurome.ageofmythology.mixin.accessors.LootTableAccessor;
import com.kurome.ageofmythology.mixin.accessors.SetItemCountFunctionAccessor;
import com.kurome.ageofmythology.mixin.accessors.UniformGeneratorAccessor;
import com.kurome.ageofmythology.model.TriConsumer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import liushuangwuyin.bettermorph.forge.utils.TradeConfig;
import liushuangwuyin.bettermorph.forge.utils.TradeOfferFactor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.apache.commons.lang3.tuple.Pair;

public class AOMTradeConfig {
    private static final int BASE_COUNT = 1;
    private static final int RELIC_BASE_COUNT = 4;
    private static final int MAX_COUNT = 64;

    public static void register() {
        AOMTradeConfig.spore();
        AOMTradeConfig.bosses_of_mass_destruction();
    }

    private static void put(EntityType<?> id, Int2ObjectMap<VillagerTrades.ItemListing[]> list) {
        TradeConfig.tradeOfferLists.put(TradeConfig.id(id), list);
    }

    private static void put(String id, Int2ObjectMap<VillagerTrades.ItemListing[]> list) {
        TradeConfig.tradeOfferLists.put(id, list);
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> copyToFastUtilMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    private static void spore() {
        Arrays.stream(MobVariant.values()).filter(mobVariant -> mobVariant.getSkullType().contains("spore")).forEach(mobVariant -> {
            String entityId = mobVariant.getSkullType();
            ArrayList<VillagerTrades.ItemListing> offers = new ArrayList<VillagerTrades.ItemListing>();
            offers.add(AOMTradeConfig.createItemListing(AOMUtil.getFavouriteItem(entityId), 4, (Item)AOMItems.AGEOFMYTHOLOGY_INFECT_ITEM.get(), 1));
            AOMTradeConfig.put(entityId, AOMTradeConfig.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)offers.toArray(new VillagerTrades.ItemListing[0]))));
        });
    }

    private static void bosses_of_mass_destruction() {
        MobVariant mobVariant = MobVariant.BOSSES_OF_MASS_DESTRUCTION_GAUNTLET;
        String entityId = mobVariant.getSkullType();
        ArrayList<VillagerTrades.ItemListing> offers = new ArrayList<VillagerTrades.ItemListing>();
        offers.add(AOMTradeConfig.createItemListing(AOMUtil.getFavouriteItem(entityId), 3, (Item)AOMItems.BOSSES_OF_MASS_DESTRUCTION_GAUNTLET_ITEM.get(), 1));
        AOMTradeConfig.put(entityId, AOMTradeConfig.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)offers.toArray(new VillagerTrades.ItemListing[0]))));
    }

    public static void registerWrapper(LootTable lootTable, String nameSpace, String name) {
        String entityId = nameSpace + ":" + name;
        ArrayList<VillagerTrades.ItemListing> extra = new ArrayList<VillagerTrades.ItemListing>();
        Item favouriteItem = AOMUtil.getFavouriteItem(entityId);
        List<VillagerTrades.ItemListing> entityExtra = AOMUtil.getExtraOffer(entityId);
        TriConsumer<Item, Integer, List<VillagerTrades.ItemListing>> consumer = (item, sellCount, offers) -> {
            Pair<Integer, Integer> weightPair = AOMRarityConfig.getItemWeight(favouriteItem, item);
            if (!favouriteItem.equals(item) && AOMTradeConfig.checkLootTableItem(item)) {
                offers.add(AOMTradeConfig.createItemListing(favouriteItem, Math.min((Integer)weightPair.getRight(), favouriteItem.m_41459_()), item, Math.min(sellCount * 1 * (Integer)weightPair.getLeft(), item.m_41459_())));
            }
        };
        extra.addAll(entityExtra);
        Item item2 = AOMUtil.getAOMItemByEntityId(entityId);
        Pair<Integer, Integer> weightPair = AOMRarityConfig.getItemWeight(favouriteItem, item2);
        if (!AOMUtil.skullTradeBlackList.contains((Object)AOMUtil.findMobVariantByString(entityId))) {
            int left = 4 * (Integer)weightPair.getRight();
            Integer right = (Integer)weightPair.getLeft();
            extra.add(AOMTradeConfig.createItemListing(favouriteItem, Math.min(left / Math.min(left, right), favouriteItem.m_41459_()), item2, Math.min(right / Math.min(left, right), item2.m_41459_())));
        }
        AOMTradeConfig.register(lootTable, entityId, consumer, extra);
    }

    public static void register(LootTable lootTable, String entityId, TriConsumer<Item, Integer, List<VillagerTrades.ItemListing>> consumer, List<VillagerTrades.ItemListing> extra) {
        ArrayList<VillagerTrades.ItemListing> offers = new ArrayList<VillagerTrades.ItemListing>();
        List<LootPool> pools = ((LootTableAccessor)lootTable).getPools();
        pools.forEach(lootPool -> {
            LootPoolEntryContainer[] entries;
            for (LootPoolEntryContainer entry : entries = ((LootPoolAccessor)lootPool).getEntries()) {
                LootItemFunction[] functions;
                if (!(entry instanceof LootItem)) continue;
                LootItem lootItem = (LootItem)entry;
                Item item = ((LootItemAccessor)lootItem).getItem();
                int sellCount = 1;
                for (LootItemFunction function : functions = ((LootPoolSingletonContainerAccessor)lootItem).getFunctions()) {
                    UniformGenerator uniformGenerator;
                    NumberProvider max;
                    if (!(function instanceof SetItemCountFunction)) continue;
                    SetItemCountFunction itemCountFunction = (SetItemCountFunction)function;
                    NumberProvider value = ((SetItemCountFunctionAccessor)itemCountFunction).getValue();
                    if (value instanceof ConstantValue) {
                        ConstantValue constantValue = (ConstantValue)value;
                        sellCount = Math.max(sellCount, AOMTradeConfig.getSellCount(constantValue));
                        continue;
                    }
                    if (!(value instanceof UniformGenerator) || !((max = ((UniformGeneratorAccessor)(uniformGenerator = (UniformGenerator)value)).getMax()) instanceof ConstantValue)) continue;
                    ConstantValue constantValue = (ConstantValue)max;
                    sellCount = Math.max(sellCount, AOMTradeConfig.getSellCount(constantValue));
                }
                if (consumer != null) {
                    consumer.accept(item, sellCount, offers);
                    continue;
                }
                offers.add(AOMTradeConfig.createItemListing(Items.f_42616_, 1, item, sellCount * 1));
            }
        });
        if (extra != null) {
            offers.addAll(extra);
        }
        AOMTradeConfig.put(entityId, AOMTradeConfig.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)offers.toArray(new VillagerTrades.ItemListing[0]))));
    }

    public static boolean checkLootTableItem(Item item) {
        return !(item instanceof TippedArrowItem);
    }

    public static int getSellCount(ConstantValue value) {
        int sellCount = 1;
        try {
            ConstantValue constantValue = value;
            if (constantValue instanceof ConstantValueAccessor) {
                ConstantValueAccessor accessor = (ConstantValueAccessor)constantValue;
                sellCount = Math.round(accessor.getValue());
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().warn("AOMTradeConfig getSellCount error: %s | %s".formatted(value, e.getMessage()));
        }
        return sellCount;
    }

    public static VillagerTrades.ItemListing createItemListing(Item buy, int buyCount, Item sell, int sellCount) {
        if (buy.equals(Items.f_42589_)) {
            ItemStack water = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_, buyCount), (Potion)Potions.f_43599_);
            return new TradeOfferFactor(water, new ItemStack((ItemLike)sell, sellCount));
        }
        return new TradeOfferFactor(new ItemStack((ItemLike)buy, buyCount), new ItemStack((ItemLike)sell, sellCount));
    }

    public static VillagerTrades.ItemListing createItemListing(Item buy, int buyCount, Item buyB, int buyCountB, Item sell, int sellCount) {
        return new TradeOfferFactor(new ItemStack((ItemLike)buy, buyCount), new ItemStack((ItemLike)buyB, buyCountB), new ItemStack((ItemLike)sell, sellCount));
    }

    public static VillagerTrades.ItemListing createItemListing(ItemStack itemStack, Item sell, int sellCount) {
        return new TradeOfferFactor(itemStack, new ItemStack((ItemLike)sell, sellCount));
    }

    public static String compactLootTable(String name) {
        return switch (name) {
            case "dragon/fire_dragon_male" -> "fire_dragon";
            case "dragon/ice_dragon_male" -> "ice_dragon";
            case "dragon/lightning_dragon_male" -> "lightning_dragon";
            default -> name;
        };
    }
}

