/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.config;

import com.kurome.ageofmythology.enums.MobVariant;
import com.kurome.ageofmythology.init.AOMItems;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;

public class AOMMobHeadConfig {
    private static Map<String, Double> headDropChances = new HashMap<String, Double>();
    private static Map<String, Item> headType = new HashMap<String, Item>();
    private static double defaultChance = 0.03;
    private static Item defaultDropItem;

    public static void init() {
        defaultDropItem = (Item)AOMItems.AGEOFMYTHOLOGY_VERDANT_ITEM.get();
        HashMap ids = AOMItems.ITEMS.getEntries().stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item, (existing, replacement) -> existing, HashMap::new));
        for (MobVariant mob : MobVariant.values()) {
            String mobName = mob.getSkullType();
            headType.put(mobName, AOMMobHeadConfig.getItem(mobName, ids));
            if (mob == MobVariant.ALEXSMOBS_FARSEER) {
                headType.put(mobName, (Item)AOMItems.AGEOFMYTHOLOGY_END_ITEM.get());
            }
            switch (mob) {
                case MINECRAFT_IRON_GOLEM: {
                    headDropChances.put(mobName, 0.1);
                    break;
                }
                case CATACLYSM_IGNIS: 
                case CATACLYSM_ENDER_GUARDIAN: 
                case CATACLYSM_NETHERITE_MONSTROSITY: 
                case CATACLYSM_THE_HARBINGER: 
                case CATACLYSM_THE_LEVIATHAN: 
                case CATACLYSM_ANCIENT_REMNANT: 
                case CATACLYSM_MALEDICTUS: 
                case CATACLYSM_SCYLLA: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case ICEANDFIRE_FIRE_DRAGON: 
                case ICEANDFIRE_ICE_DRAGON: {
                    headDropChances.put(mobName, 0.1);
                    break;
                }
                case ICEANDFIRE_LIGHTNING_DRAGON: {
                    headDropChances.put(mobName, 0.3);
                    break;
                }
                case MINECRAFT_EVOKER: 
                case MINECRAFT_WITCH: 
                case IRONS_SPELLBOOKS_CRYOMANCER: 
                case IRONS_SPELLBOOKS_PYROMANCER: 
                case IRONS_SPELLBOOKS_NECROMANCER: 
                case IRONS_SPELLBOOKS_ARCHEVOKER: {
                    headDropChances.put(mobName, 0.2);
                    break;
                }
                case BOSSES_OF_MASS_DESTRUCTION_LICH: 
                case GRAVEYARD_LICH: 
                case IRONS_SPELLBOOKS_DEAD_KING: 
                case TRAVELOPTICS_ENRAGED_DEAD_KING: 
                case BOSSES_OF_MASS_DESTRUCTION_GAUNTLET: 
                case BOSSES_OF_MASS_DESTRUCTION_OBSIDILITH: 
                case BOSSES_OF_MASS_DESTRUCTION_VOID_BLOSSOM: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case ALEXSMOBS_FARSEER: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case ALEXSCAVES_LUXTRUCTOSAURUS: 
                case ALEXSCAVES_HULLBREAKER: 
                case ALEXSCAVES_TREMORZILLA: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case ALEXSCAVES_NUCLEEPER: {
                    headDropChances.put(mobName, 0.2);
                    break;
                }
                case CONJURER_ILLAGER_CONJURER: {
                    headDropChances.put(mobName, 0.1);
                    break;
                }
                case TWILIGHTFOREST_HYDRA: 
                case TWILIGHTFOREST_NAGA: 
                case TWILIGHTFOREST_ALPHA_YETI: 
                case TWILIGHTFOREST_SNOW_QUEEN: 
                case TWILIGHTFOREST_KNIGHT_PHANTOM: 
                case TWILIGHTFOREST_MINOSHROOM: 
                case TWILIGHTFOREST_UR_GHAST: 
                case TWILIGHTFOREST_LICH: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case MINECRAFT_ENDER_DRAGON: 
                case MINECRAFT_WITHER: 
                case ALEXSMOBS_VOID_WORM: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case MINECRAFT_WARDEN: {
                    headDropChances.put(mobName, 0.05);
                    break;
                }
                case AGEOFMYTHOLOGY_SHADOW_DEMON: 
                case AGEOFMYTHOLOGY_ICE_THUNDER_SOUL: 
                case AGEOFMYTHOLOGY_SCULK_SHRIEKER: 
                case AGEOFMYTHOLOGY_HELL_TRAVELER: 
                case AGEOFMYTHOLOGY_LOST_ONE: 
                case AGEOFMYTHOLOGY_END_SCHOLAR: 
                case AGEOFMYTHOLOGY_GOOD_EVIL: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case AGEOFMYTHOLOGY_FLESH_COW: 
                case AGEOFMYTHOLOGY_FLESH_CHICKEN: 
                case AGEOFMYTHOLOGY_FLESH_PIG: 
                case AGEOFMYTHOLOGY_FLESH_SHEEP: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case EEEABSMOBS_IMMORTAL: 
                case EEEABSMOBS_CORPSE_WARLOCK: 
                case EEEABSMOBS_NAMELESS_GUARDIAN: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case MOWZIESMOBS_FERROUS_WROUGHTNAUT: 
                case MOWZIESMOBS_FROSTMAW: 
                case MOWZIESMOBS_UMVUTHI: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case MEETYOURFIGHT_BELLRINGER: 
                case MEETYOURFIGHT_DAME_FORTUNA: 
                case MEETYOURFIGHT_ROSALYNE: 
                case MEETYOURFIGHT_SWAMPJAW: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case GAMBLER_GAMBLER: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case FDBOSSES_CHESED: 
                case FDBOSSES_MALKUTH: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case ILLAGEANDSPILLAGE_FREAKAGER: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case GOETY_APOSTLE: 
                case GOETY_VIZIER: 
                case GOETY_VIZIER_CLONE: 
                case GOETY_CRONE: 
                case GOETY_WITHER_NECROMANCER: 
                case GOETY_MINISTER: 
                case GOETY_WIGHT: 
                case ALEXSCAVES_FORSAKEN: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case AETHER_VALKYRIE_QUEEN: 
                case AETHER_SLIDER: 
                case AETHER_SUN_SPIRIT: {
                    headDropChances.put(mobName, 1.0);
                    break;
                }
                case AGEOFMYTHOLOGY_PRIDE: 
                case AGEOFMYTHOLOGY_GREED: 
                case AGEOFMYTHOLOGY_LUST: 
                case AGEOFMYTHOLOGY_ENVY: 
                case AGEOFMYTHOLOGY_GLUTTONY: 
                case AGEOFMYTHOLOGY_WRATH: 
                case AGEOFMYTHOLOGY_SLOTH: {
                    headDropChances.put(mobName, 1.0);
                }
            }
            headDropChances.putIfAbsent(mobName, 0.03);
        }
    }

    public static String id(EntityType<?> type) {
        return EntityType.m_20613_(type).toString();
    }

    public static boolean canDropHead(String mobName) {
        return !mobName.isEmpty() && headType.containsKey(mobName);
    }

    public static double getDropChance(String mobName) {
        return headDropChances.getOrDefault(mobName, defaultChance);
    }

    public static Item getDropItem(String mobName) {
        return headType.getOrDefault(mobName, defaultDropItem);
    }

    public static Item getItem(String mobName, HashMap<String, RegistryObject<Item>> ids) {
        String mobId = "ageofmythology:" + mobName.replace(":", "_") + "_item";
        if (ids.containsKey(mobId)) {
            return (Item)ids.getOrDefault(mobId, AOMItems.AGEOFMYTHOLOGY_VERDANT_ITEM).get();
        }
        return defaultDropItem;
    }
}

