/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.config;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.config.AOMRarityConfig;
import com.kurome.ageofmythology.config.AOMUUIDConfig;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.enums.MobVariant;
import com.kurome.ageofmythology.init.AOMAttributes;
import com.kurome.ageofmythology.init.AOMItems;
import com.kurome.ageofmythology.item.AOMAttributeModifier;
import com.kurome.ageofmythology.item.AOMSkullItem;
import com.kurome.ageofmythology.item.AOMSkullProps;
import dev.shadowsoffire.attributeslib.api.ALObjects;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.ForgeMod;

public class AOMItemsConfig {
    private static Map<String, Rarity> itemsRarityMap = new HashMap<String, Rarity>();
    private static Rarity defaultRarity = AOMRarityConfig.COMMON;
    private static double COMMON_ATTACK_DAMAGE = 0.25;
    private static double UNCOMMON_ATTACK_DAMAGE = 0.5;
    private static double RARE_ATTACK_DAMAGE = 1.0;
    private static double EPIC_ATTACK_DAMAGE = 2.0;
    private static double LEGENDARY_ATTACK_DAMAGE = 4.0;
    private static double MYTHIC_ATTACK_DAMAGE = 8.0;
    private static double ATTACK_KNOCKBACK = 1.0;
    private static double COMMON_MAX_HEALTH = 1.0;
    private static double UNCOMMON_MAX_HEALTH = 2.0;
    private static double RARE_MAX_HEALTH = 4.0;
    private static double EPIC_MAX_HEALTH = 8.0;
    private static double LEGENDARY_MAX_HEALTH = 16.0;
    private static double MYTHIC_MAX_HEALTH = 32.0;
    private static double COMMON_ARMOR = 1.0;
    private static double UNCOMMON_ARMOR = 2.0;
    private static double RARE_ARMOR = 4.0;
    private static double EPIC_ARMOR = 8.0;
    private static double LEGENDARY_ARMOR = 16.0;
    private static double MYTHIC_ARMOR = 16.0;
    private static double COMMON_ARMOR_TOUGHNESS = 1.0;
    private static double UNCOMMON_ARMOR_TOUGHNESS = 2.0;
    private static double RARE_ARMOR_TOUGHNESS = 4.0;
    private static double EPIC_ARMOR_TOUGHNESS = 4.0;
    private static double LEGENDARY_ARMOR_TOUGHNESS = 8.0;
    private static double MYTHIC_ARMOR_TOUGHNESS = 8.0;
    private static double COMMON_FLYING_SPEED = 0.1;
    private static double UNCOMMON_FLYING_SPEED = 0.2;
    private static double RARE_FLYING_SPEED = 0.4;
    private static double EPIC_FLYING_SPEED = 0.8;
    private static double LEGENDARY_FLYING_SPEED = 1.6;
    private static double MYTHIC_FLYING_SPEED = 3.2;
    private static double UNCOMMON_MOVEMENT_SPEED = 0.25;
    private static double MOVEMENT_SPEED = 0.5;
    private static double SWIM_SPEED = 0.5;
    private static double SLOW_SWIM_SPEED = 0.2;
    private static double MUT_BASE_ATTACK_SPEED = 0.2;
    private static double STEP_HEIGHT = 0.5;
    private static double LIFE_DRAIN = 0.2;
    private static double POTION_ATTACK_2 = 2.0;
    private static double POTION_ATTACK_3 = 3.0;
    public static Map<String, AOMSkullProps> itemsPropsMap = new HashMap<String, AOMSkullProps>();

    public static void init() {
        block240: for (MobVariant mob : MobVariant.values()) {
            UUID uuid = AOMUUIDConfig.getUUID(mob);
            if (uuid.equals(UUID.fromString("60a1283d-d60a-4e13-afd3-3d0c1978e482"))) continue;
            switch (mob) {
                case MINECRAFT_ALLAY: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().setFortuneLevel(1).setLootingLevel(1));
                    continue block240;
                }
                case MINECRAFT_BAT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case MINECRAFT_BEE: {
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.attack_damage(uuid, COMMON_ATTACK_DAMAGE, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.attack_speed(uuid, MUT_BASE_ATTACK_SPEED, AttributeModifier.Operation.MULTIPLY_BASE)));
                    continue block240;
                }
                case MINECRAFT_BLAZE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case MINECRAFT_CAMEL: {
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, COMMON_MAX_HEALTH, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_CAT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.movement_speed(uuid, MOVEMENT_SPEED, AttributeModifier.Operation.MULTIPLY_BASE)));
                    continue block240;
                }
                case MINECRAFT_CHICKEN: {
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.luck(uuid, 1.0, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_COW: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case MINECRAFT_DONKEY: {
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, COMMON_MAX_HEALTH, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_DROWNED: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, UNCOMMON_MAX_HEALTH, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.attack_damage(uuid, UNCOMMON_ATTACK_DAMAGE, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_ELDER_GUARDIAN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, RARE_MAX_HEALTH, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.attack_damage(uuid, RARE_ATTACK_DAMAGE, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_GUARDIAN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.COMMON);
                    continue block240;
                }
                case MINECRAFT_ENDER_DRAGON: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, LEGENDARY_MAX_HEALTH, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.attack_damage(uuid, LEGENDARY_ATTACK_DAMAGE, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.luck(uuid, 4.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor(uuid, LEGENDARY_ARMOR, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor_toughness(uuid, LEGENDARY_ARMOR_TOUGHNESS, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_ENDERMAN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, RARE_MAX_HEALTH, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.attack_damage(uuid, RARE_ATTACK_DAMAGE, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_EVOKER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case MINECRAFT_FOX: {
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.luck(uuid, 1.0, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_GHAST: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case MINECRAFT_GIANT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, AOMItemsConfig.getMaxHealth(AOMRarityConfig.EPIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.knockback_resistance(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor(uuid, AOMItemsConfig.getArmor(AOMRarityConfig.EPIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor_toughness(uuid, AOMItemsConfig.getArmorToughness(AOMRarityConfig.EPIC), AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_HOGLIN: 
                case MINECRAFT_ZOGLIN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case MINECRAFT_ZOMBIE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.COMMON);
                    continue block240;
                }
                case MINECRAFT_HORSE: 
                case MINECRAFT_ZOMBIE_HORSE: 
                case ALEXSMOBS_MOOSE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case MINECRAFT_HUSK: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case MINECRAFT_IRON_GOLEM: 
                case TAKESAPILLAGE_CLAY_GOLEM: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.attack_damage(uuid, RARE_ATTACK_DAMAGE * 4.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.max_health(uuid, RARE_MAX_HEALTH * 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor(uuid, RARE_ARMOR, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_MAGMA_CUBE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.knockback_resistance(uuid, 0.5, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_OCELOT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.movement_speed(uuid, MOVEMENT_SPEED, AttributeModifier.Operation.MULTIPLY_BASE)));
                    continue block240;
                }
                case MINECRAFT_PANDA: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, AOMItemsConfig.getMaxHealth(Rarity.RARE) * 2.0, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_PARROT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case MINECRAFT_PHANTOM: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case MINECRAFT_PIGLIN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case MINECRAFT_PIGLIN_BRUTE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case MINECRAFT_PILLAGER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().setLootingLevel(2));
                    continue block240;
                }
                case MINECRAFT_POLAR_BEAR: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case MINECRAFT_RABBIT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.COMMON);
                    continue block240;
                }
                case MINECRAFT_RAVAGER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.attack_damage(uuid, RARE_ATTACK_DAMAGE * 6.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.knockback_resistance(uuid, 1.0, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_SHULKER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case MINECRAFT_SKELETON: 
                case MINECRAFT_STRAY: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps());
                    continue block240;
                }
                case MINECRAFT_SKELETON_HORSE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case MINECRAFT_SPIDER: 
                case MINECRAFT_CAVE_SPIDER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps());
                    continue block240;
                }
                case MINECRAFT_SLIME: 
                case MINECRAFT_STRIDER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps());
                    continue block240;
                }
                case MINECRAFT_TURTLE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, AOMItemsConfig.getMaxHealth(Rarity.RARE) * 4.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor(uuid, AOMItemsConfig.getArmor(Rarity.RARE) * 4.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor_toughness(uuid, AOMItemsConfig.getArmorToughness(Rarity.RARE) * 2.0, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_VEX: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.attack_damage(uuid, AOMItemsConfig.getAttackDamage(Rarity.UNCOMMON), AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_VINDICATOR: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.attack_knockback(uuid, ATTACK_KNOCKBACK, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.attack_damage(uuid, AOMItemsConfig.getAttackDamage(Rarity.RARE) * 4.0, AttributeModifier.Operation.ADDITION)).setLootingLevel(2));
                    continue block240;
                }
                case MINECRAFT_WARDEN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.attack_damage(uuid, 8.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.attack_speed(uuid, 0.4, AttributeModifier.Operation.MULTIPLY_BASE)));
                    continue block240;
                }
                case MINECRAFT_WITCH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case MINECRAFT_WITHER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, LEGENDARY_MAX_HEALTH, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.attack_damage(uuid, LEGENDARY_ATTACK_DAMAGE, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor(uuid, LEGENDARY_ARMOR, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor_toughness(uuid, LEGENDARY_ARMOR_TOUGHNESS, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case MINECRAFT_WITHER_SKELETON: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case MINECRAFT_WOLF: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case MINECRAFT_SNIFFER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case MINECRAFT_ILLUSIONER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case ALEXSMOBS_GRIZZLY_BEAR: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.attack_damage(uuid, UNCOMMON_ATTACK_DAMAGE * 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor(uuid, UNCOMMON_ARMOR * 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor_toughness(uuid, UNCOMMON_ARMOR_TOUGHNESS, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.movement_speed(uuid, UNCOMMON_MOVEMENT_SPEED, AttributeModifier.Operation.MULTIPLY_BASE)));
                    continue block240;
                }
                case ALEXSMOBS_ROADRUNNER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.movement_speed(uuid, MOVEMENT_SPEED, AttributeModifier.Operation.MULTIPLY_BASE)));
                    continue block240;
                }
                case ALEXSMOBS_FLY: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.COMMON);
                    continue block240;
                }
                case ALEXSMOBS_CROCODILE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case ALEXSMOBS_HUMMINGBIRD: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSMOBS_ORCA: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSMOBS_TIGER: 
                case ALEXSMOBS_FLYING_FISH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSMOBS_MANED_WOLF: 
                case ALEXSMOBS_SEA_BEAR: 
                case ALEXSMOBS_RAIN_FROG: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_PRIDE: 
                case AGEOFMYTHOLOGY_GREED: 
                case AGEOFMYTHOLOGY_LUST: 
                case AGEOFMYTHOLOGY_ENVY: 
                case AGEOFMYTHOLOGY_GLUTTONY: 
                case AGEOFMYTHOLOGY_WRATH: 
                case AGEOFMYTHOLOGY_SLOTH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case ALEXSMOBS_SUNBIRD: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case ALEXSMOBS_ALLIGATOR_SNAPPING_TURTLE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSMOBS_GORILLA: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case ALEXSMOBS_CRIMSON_MOSQUITO: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSMOBS_RATTLESNAKE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case ALEXSMOBS_HAMMERHEAD_SHARK: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.attack_damage(uuid, UNCOMMON_ATTACK_DAMAGE * 2.0, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case ALEXSMOBS_KOMODO_DRAGON: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case ALEXSMOBS_CAPUCHIN_MONKEY: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSMOBS_WARPED_TOAD: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case ALEXSMOBS_COCKROACH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, RARE_MAX_HEALTH * 5.0, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case ALEXSMOBS_ELEPHANT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, UNCOMMON_MAX_HEALTH * 4.0, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case ALEXSMOBS_SOUL_VULTURE: 
                case ALEXSMOBS_BALD_EAGLE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case ALEXSMOBS_SNOW_LEOPARD: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSMOBS_KANGAROO: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.attack_damage(uuid, RARE_ATTACK_DAMAGE, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case ALEXSMOBS_CACHALOT_WHALE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.attack_damage(uuid, EPIC_ATTACK_DAMAGE, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.max_health(uuid, EPIC_MAX_HEALTH, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case ALEXSMOBS_LEAFCUTTER_ANT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case ALEXSMOBS_TARANTULA_HAWK: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSMOBS_LAVIATHAN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSMOBS_VOID_WORM: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case ALEXSMOBS_FRILLED_SHARK: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSMOBS_GIANT_SQUID: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSCAVES_NUCLEEPER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case ALEXSCAVES_RAYCAT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case BOSSES_OF_MASS_DESTRUCTION_GAUNTLET: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case BOSSES_OF_MASS_DESTRUCTION_OBSIDILITH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case BOSSES_OF_MASS_DESTRUCTION_VOID_BLOSSOM: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case BOSSES_OF_MASS_DESTRUCTION_LICH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case BYGONENETHER_WEX: 
                case BYGONENETHER_WRAITHER: 
                case BYGONENETHER_WARPED_ENDERMAN: 
                case BYGONENETHER_WITHER_SKELETON_KNIGHT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case CATACLYSM_ENDER_GUARDIAN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case CATACLYSM_NETHERITE_MONSTROSITY: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case CATACLYSM_IGNIS: 
                case AGEOFMYTHOLOGY_LIGHTNING_IGNIS: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case CATACLYSM_IGNITED_REVENANT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case CATACLYSM_IGNITED_BERSERKER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case CATACLYSM_THE_LEVIATHAN: 
                case CATACLYSM_THE_HARBINGER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case CATACLYSM_ANCIENT_REMNANT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case CATACLYSM_MALEDICTUS: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case CONJURER_ILLAGER_CONJURER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case EEEABSMOBS_CORPSE_WARLOCK: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case EEEABSMOBS_NAMELESS_GUARDIAN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case EEEABSMOBS_IMMORTAL: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case MOWZIESMOBS_FERROUS_WROUGHTNAUT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case MOWZIESMOBS_FROSTMAW: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case MOWZIESMOBS_UMVUTHI: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case MEETYOURFIGHT_BELLRINGER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case MEETYOURFIGHT_DAME_FORTUNA: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case MEETYOURFIGHT_SWAMPJAW: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case MEETYOURFIGHT_ROSALYNE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case GAMBLER_GAMBLER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case FDBOSSES_CHESED: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case FDBOSSES_MALKUTH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case ILLAGEANDSPILLAGE_FREAKAGER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case TRAVELOPTICS_THE_NIGHTWARDEN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case ALEXSCAVES_GUM_WORM: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case GRAVEYARD_LICH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, EPIC_MAX_HEALTH, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case ICEANDFIRE_FIRE_DRAGON: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case ICEANDFIRE_ICE_DRAGON: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case ICEANDFIRE_LIGHTNING_DRAGON: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case ICEANDFIRE_GORGON: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ICEANDFIRE_CYCLOPS: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ICEANDFIRE_SIREN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case IRONS_SPELLBOOKS_NECROMANCER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case IRONS_SPELLBOOKS_PYROMANCER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case IRONS_SPELLBOOKS_CRYOMANCER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case IRONS_SPELLBOOKS_ARCHEVOKER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case IRONS_SPELLBOOKS_DEAD_KING: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case IRONS_SPELLBOOKS_CITADEL_KEEPER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case TRAVELOPTICS_ENRAGED_DEAD_KING: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case TWILIGHTFOREST_NAGA: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case TWILIGHTFOREST_MINOSHROOM: 
                case TWILIGHTFOREST_HYDRA: 
                case TWILIGHTFOREST_KNIGHT_PHANTOM: 
                case TWILIGHTFOREST_UR_GHAST: 
                case TWILIGHTFOREST_ALPHA_YETI: 
                case TWILIGHTFOREST_SNOW_QUEEN: 
                case TWILIGHTFOREST_LICH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_MAGIC_CORE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_APPRENTICE_MAGE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_ARCH_MAGE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, 20.0, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case AGEOFMYTHOLOGY_GRAND_MAGE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    itemsPropsMap.put(mob.getSkullType(), new AOMSkullProps().add(AOMItemsConfig.max_health(uuid, 50.0, AttributeModifier.Operation.ADDITION)));
                    continue block240;
                }
                case AGEOFMYTHOLOGY_BURNING_SKELETON: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FIRE_CORE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_BURNING_CORE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_ENCHANT_DRAGON_HEAD: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case ALEXSCAVES_SUBTERRANODON: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case ALEXSCAVES_VALLUMRAPTOR: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case ALEXSCAVES_GROTTOCERATOPS: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSCAVES_RELICHEIRUS: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSCAVES_TREMORSAURUS: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSCAVES_ATLATITAN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case ALEXSCAVES_LUXTRUCTOSAURUS: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case ICEANDFIRE_HYDRA: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSMOBS_BONE_SERPENT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_NATURE_TRAVEL: 
                case AGEOFMYTHOLOGY_NETHER_TRAVEL: 
                case AGEOFMYTHOLOGY_END_TRAVEL: 
                case AGEOFMYTHOLOGY_TWILIGHT_FOREST_TRAVEL: 
                case AGEOFMYTHOLOGY_OTHERSIDE_SCULK_TRAVEL: 
                case AGEOFMYTHOLOGY_LOST_CITY_TRAVEL: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_TRAVEL_CORE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_AUTISM_SILENT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_AUTISM_LISTEN: 
                case AGEOFMYTHOLOGY_AUTISM_PERFORM: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_AUTISMER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_AUTISM_END_1: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_AUTISM_END_2: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_AUTISM_END_3: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_SHADOW_DEMON: 
                case AGEOFMYTHOLOGY_ICE_THUNDER_SOUL: 
                case AGEOFMYTHOLOGY_SCULK_SHRIEKER: 
                case AGEOFMYTHOLOGY_HELL_TRAVELER: 
                case AGEOFMYTHOLOGY_END_SCHOLAR: 
                case AGEOFMYTHOLOGY_LOST_ONE: 
                case AGEOFMYTHOLOGY_GOOD_EVIL: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_GOLEM: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_FISH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_CREEPER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_FOX: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_VILLAGER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_WORM: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_SKELETON: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_ENDERMAN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_CUBE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_EYES: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_CLUMPS: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_CHICKEN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_COW: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_PIG: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_FLESH_SHEEP: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case MINECRAFT_CREEPER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case GRAVEYARD_SKELETON_CREEPER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case ALEXSCAVES_RADGILL: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSCAVES_BRAINIAC: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case ALEXSCAVES_GAMMAROACH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSCAVES_TREMORZILLA: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case ALEXSCAVES_MINE_GUARDIAN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case ALEXSCAVES_GUMBEEPER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case CATACLYSM_DEEPLING: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case CATACLYSM_DEEPLING_ANGLER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case CATACLYSM_DEEPLING_BRUTE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case CATACLYSM_DEEPLING_PRIEST: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case CATACLYSM_DEEPLING_WARLOCK: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case CATACLYSM_LIONFISH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.COMMON);
                    continue block240;
                }
                case CATACLYSM_CORAL_GOLEM: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case CATACLYSM_CORALSSUS: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSCAVES_LANTERNFISH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case ALEXSCAVES_HULLBREAKER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case ALEXSCAVES_DEEP_ONE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSCAVES_DEEP_ONE_KNIGHT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSCAVES_DEEP_ONE_MAGE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_MACHINE_ENERGY_CORE_1: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_MACHINE_ENERGY_CORE_2: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_MACHINE_ENERGY_CORE_3: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_MACHINE_ENERGY_CORE_4: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_MACHINE_VOID_MOD_VORTEX: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_MACHINE_VOID_MOD_RAILPATH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_MACHINE_VOID_MOD_SENSOR: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_MACHINE_PYRE_MOD_CATACLYSM: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_MACHINE_PYRE_MOD_HELIX: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_MACHINE_MECH_MOD_LASER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_MACHINE_MECH_MOD_PULSE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_MACHINE_MECH_MOD_RAY: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_MACHINE_MECH_MOD_RESONANCE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_DEMON_HEAD: 
                case AGEOFMYTHOLOGY_DEMON_HEART: 
                case AGEOFMYTHOLOGY_DEMON_EYE: 
                case AGEOFMYTHOLOGY_DEMON_BROKEN_HEART: 
                case AGEOFMYTHOLOGY_DEMON_CHOPPED_MEAT: 
                case AGEOFMYTHOLOGY_FOCUSED_EYE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case GOETY_MINISTER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case GOETY_SORCERER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case GOETY_CONQUILLAGER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case GOETY_CRUSHER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case GOETY_CRYOLOGER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case GOETY_ENVIOKER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case GOETY_INQUILLAGER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case GOETY_IRK: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case GOETY_PIKER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case GOETY_PREACHER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case GOETY_STORM_CASTER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case GOETY_TORMENTOR: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case GOETY_TRAMPLER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case GOETY_VIZIER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case GOETY_APOSTLE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case GOETY_CRONE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case GOETY_WITHER_NECROMANCER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case GOETY_VIZIER_CLONE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case GRAVEYARD_ACOLYTE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case GRAVEYARD_CORRUPTED_PILLAGER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case GRAVEYARD_CORRUPTED_VINDICATOR: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case GRAVEYARD_REAPER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case GRAVEYARD_REVENANT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case GRAVEYARD_WRAITH: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.COMMON);
                    continue block240;
                }
                case GRAVEYARD_NIGHTMARE: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case GOETY_HOSTILE_BLACK_WOLF: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.UNCOMMON);
                    continue block240;
                }
                case GOETY_WIGHT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.RARE);
                    continue block240;
                }
                case ALEXSCAVES_CORRODENT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case ALEXSCAVES_VESPER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case ALEXSCAVES_FORSAKEN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case AGEOFMYTHOLOGY_GOETY_APOLLYON: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.MYTHIC);
                    continue block240;
                }
                case CATACLYSM_SCYLLA: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.LEGENDARY);
                    continue block240;
                }
                case AETHER_VALKYRIE_QUEEN: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AETHER_SLIDER: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                case AETHER_SUN_SPIRIT: {
                    itemsRarityMap.put(mob.getSkullType(), AOMRarityConfig.EPIC);
                    continue block240;
                }
                default: {
                    itemsRarityMap.putIfAbsent(mob.getSkullType(), AOMRarityConfig.COMMON);
                }
            }
        }
    }

    private static double getMaxHealth(Rarity rarity) {
        if (rarity.equals((Object)AOMRarityConfig.COMMON)) {
            return COMMON_MAX_HEALTH;
        }
        if (rarity.equals((Object)AOMRarityConfig.UNCOMMON)) {
            return UNCOMMON_MAX_HEALTH;
        }
        if (rarity.equals((Object)AOMRarityConfig.RARE)) {
            return RARE_MAX_HEALTH;
        }
        if (rarity.equals((Object)AOMRarityConfig.EPIC)) {
            return EPIC_MAX_HEALTH;
        }
        if (rarity.equals((Object)AOMRarityConfig.LEGENDARY)) {
            return LEGENDARY_MAX_HEALTH;
        }
        if (rarity.equals((Object)AOMRarityConfig.MYTHIC)) {
            return MYTHIC_MAX_HEALTH;
        }
        return COMMON_MAX_HEALTH;
    }

    private static double getAttackDamage(Rarity rarity) {
        if (rarity.equals((Object)AOMRarityConfig.COMMON)) {
            return COMMON_ATTACK_DAMAGE;
        }
        if (rarity.equals((Object)AOMRarityConfig.UNCOMMON)) {
            return UNCOMMON_ATTACK_DAMAGE;
        }
        if (rarity.equals((Object)AOMRarityConfig.RARE)) {
            return RARE_ATTACK_DAMAGE;
        }
        if (rarity.equals((Object)AOMRarityConfig.EPIC)) {
            return EPIC_ATTACK_DAMAGE;
        }
        if (rarity.equals((Object)AOMRarityConfig.LEGENDARY)) {
            return LEGENDARY_ATTACK_DAMAGE;
        }
        if (rarity.equals((Object)AOMRarityConfig.MYTHIC)) {
            return MYTHIC_ATTACK_DAMAGE;
        }
        return COMMON_ATTACK_DAMAGE;
    }

    private static double getArmor(Rarity rarity) {
        if (rarity.equals((Object)AOMRarityConfig.COMMON)) {
            return COMMON_ARMOR;
        }
        if (rarity.equals((Object)AOMRarityConfig.UNCOMMON)) {
            return UNCOMMON_ARMOR;
        }
        if (rarity.equals((Object)AOMRarityConfig.RARE)) {
            return RARE_ARMOR;
        }
        if (rarity.equals((Object)AOMRarityConfig.EPIC)) {
            return EPIC_ARMOR;
        }
        if (rarity.equals((Object)AOMRarityConfig.LEGENDARY)) {
            return LEGENDARY_ARMOR;
        }
        if (rarity.equals((Object)AOMRarityConfig.MYTHIC)) {
            return MYTHIC_ARMOR;
        }
        return COMMON_ARMOR;
    }

    private static double getArmorToughness(Rarity rarity) {
        if (rarity.equals((Object)AOMRarityConfig.COMMON)) {
            return COMMON_ARMOR_TOUGHNESS;
        }
        if (rarity.equals((Object)AOMRarityConfig.UNCOMMON)) {
            return UNCOMMON_ARMOR_TOUGHNESS;
        }
        if (rarity.equals((Object)AOMRarityConfig.RARE)) {
            return RARE_ARMOR_TOUGHNESS;
        }
        if (rarity.equals((Object)AOMRarityConfig.EPIC)) {
            return EPIC_ARMOR_TOUGHNESS;
        }
        if (rarity.equals((Object)AOMRarityConfig.LEGENDARY)) {
            return LEGENDARY_ARMOR_TOUGHNESS;
        }
        if (rarity.equals((Object)AOMRarityConfig.MYTHIC)) {
            return MYTHIC_ARMOR_TOUGHNESS;
        }
        return COMMON_ARMOR_TOUGHNESS;
    }

    public static void lazy_init() {
        AOMItems.ITEMS.getEntries().forEach(item -> {
            Object patt55023$temp = item.get();
            if (patt55023$temp instanceof AOMSkullItem) {
                AOMSkullItem skullItem = (AOMSkullItem)patt55023$temp;
                String name = skullItem.getSkullName();
                MobVariant mob = AOMUtil.findMobVariantByString(name);
                UUID uuid = AOMUUIDConfig.getUUID(mob);
                switch (mob) {
                    case MINECRAFT_SKELETON: {
                        break;
                    }
                    case MINECRAFT_ALLAY: {
                        skullItem.skullProps.add(AOMItemsConfig.entity_reach(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.block_reach(uuid, 1.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case MINECRAFT_AXOLOTL: {
                        skullItem.skullProps.add(AOMItemsConfig.swim_speed(uuid, SWIM_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_BAT: {
                        skullItem.skullProps.add(AOMItemsConfig.flying_speed(uuid, COMMON_FLYING_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_BEE: {
                        skullItem.skullProps.add(AOMItemsConfig.critical_chance(uuid, 0.1, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case MINECRAFT_BLAZE: {
                        skullItem.skullProps.add(AOMItemsConfig.fire_damage(uuid, 4.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case MINECRAFT_CAMEL: {
                        skullItem.skullProps.add(AOMItemsConfig.step_height_addition(uuid, STEP_HEIGHT, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case MINECRAFT_COD: 
                    case MINECRAFT_TROPICAL_FISH: {
                        skullItem.skullProps.add(AOMItemsConfig.swim_speed(uuid, SWIM_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_SALMON: {
                        skullItem.skullProps.add(AOMItemsConfig.swim_speed(uuid, SWIM_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_CREEPER: {
                        skullItem.skullProps.add(AOMItemsConfig.explosion_power(uuid, 6.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case MINECRAFT_DOLPHIN: {
                        skullItem.skullProps.add(AOMItemsConfig.swim_speed(uuid, SWIM_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_DONKEY: {
                        skullItem.skullProps.add(AOMItemsConfig.step_height_addition(uuid, STEP_HEIGHT, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case MINECRAFT_EVOKER: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 0.2, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_PHANTOM: {
                        skullItem.skullProps.add(AOMItemsConfig.flying_speed(uuid, COMMON_FLYING_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_VEX: {
                        skullItem.skullProps.add(AOMItemsConfig.flying_speed(uuid, UNCOMMON_FLYING_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_GLOW_SQUID: 
                    case MINECRAFT_SQUID: 
                    case ALEXSMOBS_BLOBFISH: {
                        skullItem.skullProps.add(AOMItemsConfig.swim_speed(uuid, SLOW_SWIM_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_GOAT: {
                        skullItem.skullProps.add(AOMItemsConfig.step_height_addition(uuid, STEP_HEIGHT, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case MINECRAFT_HORSE: 
                    case MINECRAFT_ZOMBIE_HORSE: 
                    case ALEXSMOBS_MOOSE: {
                        skullItem.skullProps.add(AOMItemsConfig.step_height_addition(uuid, STEP_HEIGHT, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.movement_speed(uuid, MOVEMENT_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_MAGMA_CUBE: {
                        skullItem.skullProps.add(AOMItemsConfig.fire_damage(uuid, 4.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case MINECRAFT_SKELETON_HORSE: {
                        skullItem.skullProps.add(AOMItemsConfig.step_height_addition(uuid, STEP_HEIGHT, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.movement_speed(uuid, MOVEMENT_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_STRIDER: {
                        skullItem.skullProps.add(AOMItemsConfig.fire_damage(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_ILLUSIONER: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 0.05, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.spell_resist(uuid, 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_PARROT: {
                        skullItem.skullProps.add(AOMItemsConfig.flying_speed(uuid, RARE_FLYING_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_PUFFERFISH: 
                    case MINECRAFT_TADPOLE: {
                        skullItem.skullProps.add(AOMItemsConfig.swim_speed(uuid, 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case MINECRAFT_RAVAGER: {
                        skullItem.skullProps.setLootingLevel(2);
                        break;
                    }
                    case MINECRAFT_WOLF: {
                        skullItem.skullProps.add(AOMItemsConfig.critical_chance(uuid, 0.25, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSMOBS_ORCA: {
                        skullItem.skullProps.add(AOMItemsConfig.swim_speed(uuid, SWIM_SPEED, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.attack_damage(uuid, 4.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSMOBS_FLY: {
                        skullItem.skullProps.add(AOMItemsConfig.flying_speed(uuid, COMMON_FLYING_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSMOBS_SUNBIRD: {
                        skullItem.skullProps.add(AOMItemsConfig.flying_speed(uuid, MYTHIC_FLYING_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSMOBS_SOUL_VULTURE: 
                    case ALEXSMOBS_BALD_EAGLE: {
                        skullItem.skullProps.add(AOMItemsConfig.flying_speed(uuid, UNCOMMON_FLYING_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSMOBS_CRIMSON_MOSQUITO: {
                        skullItem.skullProps.add(AOMItemsConfig.blood_power(uuid, 0.04, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.life_drain(uuid, 0.04, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.fire_damage(uuid, 0.75, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSMOBS_LAVIATHAN: {
                        skullItem.skullProps.add(AOMItemsConfig.max_health(uuid, AOMItemsConfig.getMaxHealth(Rarity.RARE), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.fire_damage(uuid, 8.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSMOBS_GAZELLE: {
                        skullItem.skullProps.add(AOMItemsConfig.movement_speed(uuid, 0.2, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSMOBS_HUMMINGBIRD: {
                        skullItem.skullProps.add(AOMItemsConfig.flying_speed(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSMOBS_RATTLESNAKE: {
                        skullItem.skullProps.add(AOMItemsConfig.potion_attack(uuid, POTION_ATTACK_2, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSMOBS_RACCOON: {
                        skullItem.skullProps.add(AOMItemsConfig.luck(uuid, 2.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSMOBS_ALLIGATOR_SNAPPING_TURTLE: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_damage(uuid, 4.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSMOBS_TIGER: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_damage(uuid, 4.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSMOBS_KOMODO_DRAGON: {
                        skullItem.skullProps.add(AOMItemsConfig.potion_attack(uuid, POTION_ATTACK_3, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSMOBS_CROW: 
                    case ALEXSMOBS_SEAGULL: {
                        skullItem.skullProps.add(AOMItemsConfig.luck(uuid, 1.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSMOBS_MANED_WOLF: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_damage(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.movement_speed(uuid, 0.2, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSMOBS_CATFISH: {
                        skullItem.skullProps.add(AOMItemsConfig.swim_speed(uuid, 0.2, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSMOBS_FLYING_FISH: {
                        skullItem.skullProps.add(AOMItemsConfig.swim_speed(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.flying_speed(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSMOBS_BLUE_JAY: {
                        skullItem.skullProps.add(AOMItemsConfig.flying_speed(uuid, 0.2, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSMOBS_HAMMERHEAD_SHARK: {
                        skullItem.skullProps.add(AOMItemsConfig.swim_speed(uuid, SWIM_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSMOBS_WARPED_TOAD: {
                        skullItem.skullProps.add(AOMItemsConfig.swim_speed(uuid, SWIM_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSMOBS_CACHALOT_WHALE: {
                        skullItem.skullProps.add(AOMItemsConfig.swim_speed(uuid, SWIM_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSMOBS_TARANTULA_HAWK: {
                        skullItem.skullProps.add(AOMItemsConfig.debilitating_sting(uuid, 1.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSMOBS_FRILLED_SHARK: {
                        skullItem.skullProps.add(AOMItemsConfig.exsanguination(uuid, 3.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case CATACLYSM_IGNIS: {
                        skullItem.skullProps.add(AOMItemsConfig.max_health(uuid, AOMItemsConfig.getMaxHealth(AOMRarityConfig.LEGENDARY), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor(uuid, AOMItemsConfig.getArmor(AOMRarityConfig.LEGENDARY), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor_toughness(uuid, AOMItemsConfig.getArmorToughness(AOMRarityConfig.LEGENDARY), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.fire_damage(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
                        break;
                    }
                    case AGEOFMYTHOLOGY_LIGHTNING_IGNIS: {
                        skullItem.skullProps.add(AOMItemsConfig.movement_speed(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case CATACLYSM_IGNITED_REVENANT: {
                        skullItem.skullProps.add(AOMItemsConfig.max_health(uuid, AOMItemsConfig.getMaxHealth(Rarity.RARE), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.fire_damage(uuid, 6.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case CATACLYSM_IGNITED_BERSERKER: {
                        skullItem.skullProps.add(AOMItemsConfig.max_health(uuid, AOMItemsConfig.getMaxHealth(Rarity.RARE), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.fire_damage(uuid, 10.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case TWILIGHTFOREST_LICH: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.ability_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.ability_cooldown(uuid, -2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.max_mana(uuid, 100.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.mana_regen(uuid, 0.2, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.cooldown_reduction(uuid, 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case IRONS_SPELLBOOKS_NECROMANCER: 
                    case IRONS_SPELLBOOKS_PYROMANCER: 
                    case IRONS_SPELLBOOKS_CRYOMANCER: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 0.3, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.max_mana(uuid, 50.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.mana_regen(uuid, 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case IRONS_SPELLBOOKS_ARCHEVOKER: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 0.3, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.max_mana(uuid, 50.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.mana_regen(uuid, 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case GRAVEYARD_LICH: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL)).add(AOMItemsConfig.max_mana(uuid, 100.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.mana_regen(uuid, 0.2, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.cooldown_reduction(uuid, 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case BOSSES_OF_MASS_DESTRUCTION_LICH: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL)).add(AOMItemsConfig.ability_level(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.ability_cooldown(uuid, -1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.max_mana(uuid, 100.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.mana_regen(uuid, 0.2, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.cooldown_reduction(uuid, 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case IRONS_SPELLBOOKS_DEAD_KING: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.ability_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.ability_cooldown(uuid, -2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.max_mana(uuid, 100.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.mana_regen(uuid, 0.2, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.cooldown_reduction(uuid, 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ICEANDFIRE_FIRE_DRAGON: {
                        skullItem.skullProps.add(AOMItemsConfig.max_health(uuid, AOMItemsConfig.getMaxHealth(AOMRarityConfig.EPIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor(uuid, AOMItemsConfig.getArmor(AOMRarityConfig.EPIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor_toughness(uuid, AOMItemsConfig.getArmorToughness(AOMRarityConfig.EPIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.fire_damage(uuid, 0.8, AttributeModifier.Operation.MULTIPLY_TOTAL)).add(AOMItemsConfig.dragon_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ICEANDFIRE_ICE_DRAGON: {
                        skullItem.skullProps.add(AOMItemsConfig.max_health(uuid, AOMItemsConfig.getMaxHealth(AOMRarityConfig.EPIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor(uuid, AOMItemsConfig.getArmor(AOMRarityConfig.EPIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor_toughness(uuid, AOMItemsConfig.getArmorToughness(AOMRarityConfig.EPIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ICEANDFIRE_LIGHTNING_DRAGON: {
                        skullItem.skullProps.add(AOMItemsConfig.max_health(uuid, AOMItemsConfig.getMaxHealth(AOMRarityConfig.EPIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor(uuid, AOMItemsConfig.getArmor(AOMRarityConfig.EPIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor_toughness(uuid, AOMItemsConfig.getArmorToughness(AOMRarityConfig.EPIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.explosion_power(uuid, 0.35, AttributeModifier.Operation.MULTIPLY_TOTAL)).add(AOMItemsConfig.explosion_range(uuid, 2.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case TRAVELOPTICS_ENRAGED_DEAD_KING: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 0.75, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.ability_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.ability_cooldown(uuid, -2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.max_mana(uuid, 200.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case TRAVELOPTICS_THE_NIGHTWARDEN: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.ability_level(uuid, 3.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.ability_cooldown(uuid, -4.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.max_mana(uuid, 1000.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.mana_regen(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.cooldown_reduction(uuid, 0.3, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case GAMBLER_GAMBLER: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.ability_level(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.ability_cooldown(uuid, -2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.luck(uuid, 3.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case EEEABSMOBS_CORPSE_WARLOCK: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL)).add(AOMItemsConfig.spell_resist(uuid, 0.2, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.ability_level(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.ability_cooldown(uuid, -1.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case MOWZIESMOBS_FROSTMAW: {
                        skullItem.skullProps.add(AOMItemsConfig.max_health(uuid, 8.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.attack_damage(uuid, 2.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case MOWZIESMOBS_FERROUS_WROUGHTNAUT: {
                        skullItem.skullProps.add(AOMItemsConfig.armor(uuid, 16.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.max_health(uuid, 8.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.attack_damage(uuid, 8.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case MOWZIESMOBS_UMVUTHI: {
                        skullItem.skullProps.add(AOMItemsConfig.fire_damage(uuid, 10.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_MAGIC_CORE: {
                        break;
                    }
                    case AGEOFMYTHOLOGY_APPRENTICE_MAGE: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 0.2, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.spell_resist(uuid, 0.1, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.ability_level(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.ability_cooldown(uuid, -1.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_ARCH_MAGE: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 0.3, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.spell_resist(uuid, 0.3, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.ability_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.ability_cooldown(uuid, -2.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_GRAND_MAGE: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL)).add(AOMItemsConfig.spell_resist(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.ability_level(uuid, 5.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.ability_cooldown(uuid, -5.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_BURNING_SKELETON: {
                        skullItem.skullProps.add(AOMItemsConfig.max_health(uuid, AOMItemsConfig.getMaxHealth(Rarity.RARE), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.fire_damage(uuid, 6.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_ENCHANT_DRAGON_HEAD: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 0.75, AttributeModifier.Operation.MULTIPLY_TOTAL));
                        break;
                    }
                    case ALEXSCAVES_SUBTERRANODON: {
                        skullItem.skullProps.add(AOMItemsConfig.dragon_level(uuid, 0.5, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 0.25, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSCAVES_VALLUMRAPTOR: {
                        skullItem.skullProps.add(AOMItemsConfig.dragon_level(uuid, 0.5, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 0.25, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSCAVES_GROTTOCERATOPS: {
                        skullItem.skullProps.add(AOMItemsConfig.dragon_level(uuid, 0.5, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 0.35, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSCAVES_RELICHEIRUS: {
                        skullItem.skullProps.add(AOMItemsConfig.dragon_level(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSCAVES_TREMORSAURUS: {
                        skullItem.skullProps.add(AOMItemsConfig.dragon_level(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSCAVES_ATLATITAN: {
                        skullItem.skullProps.add(AOMItemsConfig.dragon_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 0.3, AttributeModifier.Operation.MULTIPLY_TOTAL));
                        break;
                    }
                    case ALEXSCAVES_LUXTRUCTOSAURUS: {
                        skullItem.skullProps.add(AOMItemsConfig.dragon_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 0.3, AttributeModifier.Operation.MULTIPLY_TOTAL)).add(AOMItemsConfig.fire_damage(uuid, 1.5, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ICEANDFIRE_HYDRA: {
                        skullItem.skullProps.add(AOMItemsConfig.dragon_level(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case TWILIGHTFOREST_NAGA: {
                        skullItem.skullProps.add(AOMItemsConfig.movement_speed(uuid, 2.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case TWILIGHTFOREST_MINOSHROOM: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_damage(uuid, 10.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case TWILIGHTFOREST_KNIGHT_PHANTOM: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_speed(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case TWILIGHTFOREST_UR_GHAST: {
                        skullItem.skullProps.add(AOMItemsConfig.fire_damage(uuid, 15.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case TWILIGHTFOREST_ALPHA_YETI: {
                        skullItem.skullProps.add(AOMItemsConfig.mining_speed(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.critical_chance(uuid, 0.3, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case TWILIGHTFOREST_SNOW_QUEEN: {
                        skullItem.skullProps.add(AOMItemsConfig.life_drain(uuid, 0.08, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case TWILIGHTFOREST_HYDRA: {
                        skullItem.skullProps.add(AOMItemsConfig.dragon_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
                        break;
                    }
                    case ALEXSMOBS_BONE_SERPENT: {
                        skullItem.skullProps.add(AOMItemsConfig.dragon_power(uuid, 0.3, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case MINECRAFT_ENDER_DRAGON: {
                        skullItem.skullProps.add(AOMItemsConfig.dragon_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 2.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_SHADOW_DEMON: {
                        skullItem.skullProps.add(AOMItemsConfig.critical_chance(uuid, 0.15, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_ICE_THUNDER_SOUL: {
                        skullItem.skullProps.add(AOMItemsConfig.dragon_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 2.0, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.spell_power(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.ability_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.explosion_power(uuid, 0.35, AttributeModifier.Operation.MULTIPLY_TOTAL)).add(AOMItemsConfig.explosion_range(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_SCULK_SHRIEKER: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_speed(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.critical_chance(uuid, 0.25, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.mining_speed(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_HELL_TRAVELER: {
                        skullItem.skullProps.add(AOMItemsConfig.max_health(uuid, AOMItemsConfig.getMaxHealth(AOMRarityConfig.MYTHIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor(uuid, AOMItemsConfig.getArmor(AOMRarityConfig.MYTHIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor_toughness(uuid, AOMItemsConfig.getArmorToughness(AOMRarityConfig.MYTHIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.fire_damage(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_END_SCHOLAR: {
                        skullItem.skullProps.add(AOMItemsConfig.spell_power(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.ability_level(uuid, 5.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_LOST_ONE: {
                        skullItem.skullProps.add(AOMItemsConfig.blood_power(uuid, 0.12, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.life_drain(uuid, 0.12, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.max_health(uuid, AOMItemsConfig.getMaxHealth(AOMRarityConfig.MYTHIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor(uuid, AOMItemsConfig.getArmor(AOMRarityConfig.MYTHIC), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor_toughness(uuid, AOMItemsConfig.getArmorToughness(AOMRarityConfig.MYTHIC), AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_GOOD_EVIL: {
                        skullItem.skullProps.add(AOMItemsConfig.luck(uuid, 30.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_GOLEM: {
                        skullItem.skullProps.add(AOMItemsConfig.flesh_level(uuid, 8.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_FISH: {
                        skullItem.skullProps.add(AOMItemsConfig.flesh_level(uuid, 4.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.swim_speed(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_CREEPER: {
                        skullItem.skullProps.add(AOMItemsConfig.flesh_level(uuid, 4.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.explosion_power(uuid, 10.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_FOX: {
                        skullItem.skullProps.add(AOMItemsConfig.flesh_level(uuid, 0.35, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_VILLAGER: {
                        skullItem.skullProps.add(AOMItemsConfig.flesh_level(uuid, 0.35, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_WORM: {
                        skullItem.skullProps.add(AOMItemsConfig.flesh_level(uuid, 0.8, AttributeModifier.Operation.MULTIPLY_TOTAL)).add(AOMItemsConfig.life_drain(uuid, 0.08, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_SKELETON: {
                        skullItem.skullProps.add(AOMItemsConfig.flesh_level(uuid, 4.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_ENDERMAN: {
                        skullItem.skullProps.add(AOMItemsConfig.flesh_level(uuid, 6.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_CUBE: {
                        skullItem.skullProps.add(AOMItemsConfig.flesh_level(uuid, 0.75, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_EYES: {
                        skullItem.skullProps.add(AOMItemsConfig.flesh_level(uuid, 0.75, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_CLUMPS: {
                        skullItem.skullProps.add(AOMItemsConfig.flesh_level(uuid, 12.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_CHICKEN: {
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_COW: {
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_PIG: {
                        break;
                    }
                    case AGEOFMYTHOLOGY_FLESH_SHEEP: {
                        break;
                    }
                    case GRAVEYARD_SKELETON_CREEPER: {
                        skullItem.skullProps.add(AOMItemsConfig.explosion_power(uuid, 6.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSCAVES_NUCLEEPER: {
                        skullItem.skullProps.add(AOMItemsConfig.explosion_power(uuid, 24.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.explosion_range(uuid, 2.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSCAVES_RADGILL: {
                        skullItem.skullProps.add(AOMItemsConfig.explosion_power(uuid, 10.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSCAVES_BRAINIAC: {
                        skullItem.skullProps.add(AOMItemsConfig.explosion_power(uuid, 0.75, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSCAVES_GAMMAROACH: {
                        skullItem.skullProps.add(AOMItemsConfig.explosion_power(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSCAVES_RAYCAT: {
                        skullItem.skullProps.add(AOMItemsConfig.explosion_power(uuid, 8.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.explosion_cooldown(uuid, -1.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSCAVES_TREMORZILLA: {
                        skullItem.skullProps.add(AOMItemsConfig.explosion_power(uuid, 1.75, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.explosion_range(uuid, 8.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.explosion_cooldown(uuid, -1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_power(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSCAVES_MINE_GUARDIAN: {
                        skullItem.skullProps.add(AOMItemsConfig.explosion_power(uuid, 24.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.explosion_range(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.explosion_cooldown(uuid, -1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.abyss_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.abyss_damage(uuid, 6.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSCAVES_GUMBEEPER: {
                        skullItem.skullProps.add(AOMItemsConfig.explosion_power(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case BOSSES_OF_MASS_DESTRUCTION_GAUNTLET: {
                        skullItem.skullProps.add(AOMItemsConfig.explosion_power(uuid, 0.35, AttributeModifier.Operation.MULTIPLY_TOTAL)).add(AOMItemsConfig.explosion_range(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL)).add(AOMItemsConfig.explosion_cooldown(uuid, -1.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case MINECRAFT_GUARDIAN: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_level(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.abyss_damage(uuid, 1.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case MINECRAFT_ELDER_GUARDIAN: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.abyss_damage(uuid, 2.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case CATACLYSM_DEEPLING: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_level(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.abyss_damage(uuid, 2.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case CATACLYSM_DEEPLING_ANGLER: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_level(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.abyss_damage(uuid, 4.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case CATACLYSM_DEEPLING_BRUTE: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_damage(uuid, 6.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case CATACLYSM_DEEPLING_PRIEST: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.abyss_damage(uuid, 0.2, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case CATACLYSM_DEEPLING_WARLOCK: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_level(uuid, 4.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.abyss_damage(uuid, 0.2, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case CATACLYSM_LIONFISH: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_damage(uuid, 4.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case CATACLYSM_CORAL_GOLEM: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_damage(uuid, 6.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case CATACLYSM_CORALSSUS: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_damage(uuid, 6.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case CATACLYSM_THE_LEVIATHAN: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_level(uuid, 0.25, AttributeModifier.Operation.MULTIPLY_TOTAL)).add(AOMItemsConfig.abyss_damage(uuid, 0.25, AttributeModifier.Operation.MULTIPLY_TOTAL));
                        break;
                    }
                    case ALEXSCAVES_LANTERNFISH: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_damage(uuid, 4.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSCAVES_HULLBREAKER: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_level(uuid, 0.25, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.abyss_damage(uuid, 0.35, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case ALEXSCAVES_DEEP_ONE: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_level(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.abyss_damage(uuid, 4.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSCAVES_DEEP_ONE_KNIGHT: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_level(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.abyss_damage(uuid, 6.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSCAVES_DEEP_ONE_MAGE: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.abyss_damage(uuid, 4.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_MACHINE_ENERGY_CORE_1: {
                        break;
                    }
                    case AGEOFMYTHOLOGY_MACHINE_ENERGY_CORE_2: {
                        break;
                    }
                    case AGEOFMYTHOLOGY_MACHINE_ENERGY_CORE_3: {
                        break;
                    }
                    case AGEOFMYTHOLOGY_MACHINE_ENERGY_CORE_4: {
                        break;
                    }
                    case AGEOFMYTHOLOGY_MACHINE_VOID_MOD_VORTEX: {
                        skullItem.skullProps.add(AOMItemsConfig.machine_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.machine_damage(uuid, 0.25, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_MACHINE_VOID_MOD_RAILPATH: {
                        skullItem.skullProps.add(AOMItemsConfig.machine_level(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.machine_damage(uuid, 0.75, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.life_drain(uuid, 0.08, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_MACHINE_VOID_MOD_SENSOR: {
                        skullItem.skullProps.add(AOMItemsConfig.machine_level(uuid, 0.25, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.machine_damage(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.entity_reach(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.block_reach(uuid, 1.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_MACHINE_PYRE_MOD_CATACLYSM: {
                        skullItem.skullProps.add(AOMItemsConfig.machine_level(uuid, 3.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.machine_damage(uuid, 0.35, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_MACHINE_PYRE_MOD_HELIX: {
                        skullItem.skullProps.add(AOMItemsConfig.machine_level(uuid, 0.25, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.machine_damage(uuid, 0.35, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_MACHINE_MECH_MOD_LASER: {
                        skullItem.skullProps.add(AOMItemsConfig.machine_level(uuid, 0.3, AttributeModifier.Operation.MULTIPLY_TOTAL)).add(AOMItemsConfig.machine_damage(uuid, 0.3, AttributeModifier.Operation.MULTIPLY_TOTAL));
                        break;
                    }
                    case AGEOFMYTHOLOGY_MACHINE_MECH_MOD_PULSE: {
                        skullItem.skullProps.add(AOMItemsConfig.machine_level(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.machine_damage(uuid, 0.75, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_MACHINE_MECH_MOD_RAY: {
                        skullItem.skullProps.add(AOMItemsConfig.machine_level(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.machine_damage(uuid, 0.25, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_MACHINE_MECH_MOD_RESONANCE: {
                        skullItem.skullProps.add(AOMItemsConfig.machine_level(uuid, 5.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.machine_damage(uuid, 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FOODIE_PINK_GUMMY: {
                        skullItem.skullProps.add(AOMItemsConfig.critical_chance(uuid, 0.35, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.flesh_level(uuid, 12.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.entity_reach(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.block_reach(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.attack_speed(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FOODIE_ORANGE_GUMMY: {
                        skullItem.skullProps.add(AOMItemsConfig.life_drain(uuid, 0.08, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dragon_level(uuid, 3.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.flying_speed(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.movement_speed(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FOODIE_YELLOW_GUMMY: {
                        skullItem.skullProps.add(AOMItemsConfig.goety_spell_power_mul(uuid, 0.5, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power(uuid, 12.0, AttributeModifier.Operation.ADDITION)).setLootingLevel(10);
                        break;
                    }
                    case AGEOFMYTHOLOGY_FOODIE_GREEN_GUMMY: {
                        skullItem.skullProps.add(AOMItemsConfig.armor(uuid, 75.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.armor_toughness(uuid, 25.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.knockback_resistance(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.attack_speed(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.explosion_power(uuid, 1.2, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.explosion_cooldown(uuid, -2.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FOODIE_BLUE_GUMMY: {
                        skullItem.skullProps.add(AOMItemsConfig.swim_speed(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.movement_speed(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.flying_speed(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.step_height_addition(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.mining_speed(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.machine_level(uuid, 3.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.machine_damage(uuid, 0.3, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_FOODIE_PURPLE_GUMMY: {
                        skullItem.skullProps.add(AOMItemsConfig.block_reach(uuid, 3.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.entity_reach(uuid, 3.0, AttributeModifier.Operation.ADDITION)).setFortuneLevel(5).add(AOMItemsConfig.abyss_level(uuid, 0.3, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.abyss_damage(uuid, 0.3, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case GOETY_MINISTER: {
                        skullItem.skullProps.add(AOMItemsConfig.goety_spell_power(uuid, 12.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power_mul(uuid, 0.5, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_range(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_radius(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_spell_velocity(uuid, 2.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_SORCERER: {
                        skullItem.skullProps.add(AOMItemsConfig.goety_spell_power(uuid, 8.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power_mul(uuid, 0.2, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_CONQUILLAGER: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_damage(uuid, 6.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power(uuid, 6.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_CRUSHER: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_damage(uuid, 8.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.max_health(uuid, 12.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power(uuid, 6.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power_mul(uuid, 0.1, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_CRYOLOGER: {
                        skullItem.skullProps.add(AOMItemsConfig.goety_spell_power(uuid, 4.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power_mul(uuid, 0.1, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_ENVIOKER: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_damage(uuid, 4.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.max_health(uuid, 8.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power(uuid, 8.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_INQUILLAGER: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_damage(uuid, 4.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.max_health(uuid, 8.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power(uuid, 8.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_IRK: {
                        skullItem.skullProps.add(AOMItemsConfig.goety_spell_power(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power_mul(uuid, 0.25, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_PIKER: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_damage(uuid, 8.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.max_health(uuid, 24.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power_mul(uuid, 0.5, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_PREACHER: {
                        skullItem.skullProps.add(AOMItemsConfig.goety_spell_power(uuid, 12.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_STORM_CASTER: {
                        skullItem.skullProps.add(AOMItemsConfig.goety_spell_power(uuid, 8.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power_mul(uuid, 0.3, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_TORMENTOR: {
                        skullItem.skullProps.add(AOMItemsConfig.goety_spell_power(uuid, 4.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_TRAMPLER: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_damage(uuid, 12.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.max_health(uuid, 24.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power_mul(uuid, 0.1, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_VIZIER: {
                        skullItem.skullProps.add(AOMItemsConfig.goety_spell_power_mul(uuid, 0.8, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_range(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_radius(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_spell_velocity(uuid, 2.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_APOSTLE: {
                        skullItem.skullProps.add(AOMItemsConfig.goety_spell_power(uuid, 16.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power_mul(uuid, 0.75, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_range(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_radius(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_spell_velocity(uuid, 2.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_CRONE: {
                        skullItem.skullProps.add(AOMItemsConfig.goety_spell_power(uuid, 8.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power_mul(uuid, 0.25, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_WITHER_NECROMANCER: {
                        skullItem.skullProps.add(AOMItemsConfig.goety_spell_power(uuid, 8.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power_mul(uuid, 0.25, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_VIZIER_CLONE: {
                        skullItem.skullProps.add(AOMItemsConfig.goety_spell_range(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_radius(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_spell_velocity(uuid, 2.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GRAVEYARD_ACOLYTE: {
                        skullItem.skullProps.add(AOMItemsConfig.blood_power(uuid, 0.04, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GRAVEYARD_CORRUPTED_PILLAGER: {
                        skullItem.skullProps.add(AOMItemsConfig.blood_power(uuid, 0.06, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GRAVEYARD_CORRUPTED_VINDICATOR: {
                        skullItem.skullProps.add(AOMItemsConfig.blood_power(uuid, 0.06, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GRAVEYARD_REAPER: {
                        skullItem.skullProps.add(AOMItemsConfig.blood_power(uuid, 0.04, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GRAVEYARD_REVENANT: {
                        skullItem.skullProps.add(AOMItemsConfig.blood_power(uuid, 0.08, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GRAVEYARD_WRAITH: {
                        skullItem.skullProps.add(AOMItemsConfig.blood_power(uuid, 0.02, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GRAVEYARD_NIGHTMARE: {
                        skullItem.skullProps.add(AOMItemsConfig.blood_power(uuid, 0.12, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_HOSTILE_BLACK_WOLF: {
                        skullItem.skullProps.add(AOMItemsConfig.blood_power(uuid, 0.04, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case GOETY_WIGHT: {
                        skullItem.skullProps.add(AOMItemsConfig.blood_power(uuid, 0.08, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSCAVES_CORRODENT: {
                        skullItem.skullProps.add(AOMItemsConfig.blood_power(uuid, 0.12, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSCAVES_VESPER: {
                        skullItem.skullProps.add(AOMItemsConfig.blood_power(uuid, 0.12, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case ALEXSCAVES_FORSAKEN: {
                        skullItem.skullProps.add(AOMItemsConfig.blood_power(uuid, 0.24, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_AUTISM_END_1: {
                        skullItem.skullProps.add(AOMItemsConfig.armor_shred(uuid, 0.15, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_AUTISM_END_2: {
                        skullItem.skullProps.add(AOMItemsConfig.emotion_value(uuid, 20.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_AUTISM_END_3: {
                        skullItem.skullProps.add(AOMItemsConfig.emotion_value(uuid, -20.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_AUTISM_SILENT: {
                        skullItem.skullProps.add(AOMItemsConfig.armor_shred(uuid, 0.15, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_AUTISM_LISTEN: 
                    case AGEOFMYTHOLOGY_AUTISM_PERFORM: {
                        skullItem.skullProps.add(AOMItemsConfig.armor_shred(uuid, 0.15, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_AUTISMER: {
                        skullItem.skullProps.add(AOMItemsConfig.armor_shred(uuid, 0.15, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_GOETY_APOLLYON: {
                        skullItem.skullProps.add(AOMItemsConfig.goety_spell_power(uuid, 66.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_power_mul(uuid, 0.66, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_range(uuid, 6.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_radius(uuid, 6.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.goety_spell_spell_velocity(uuid, 6.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case CATACLYSM_SCYLLA: {
                        skullItem.skullProps.add(AOMItemsConfig.abyss_level(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.abyss_damage(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AETHER_VALKYRIE_QUEEN: {
                        skullItem.skullProps.add(AOMItemsConfig.critical_chance(uuid, 0.25, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.attack_speed(uuid, 1.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.entity_reach(uuid, 2.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AETHER_SLIDER: {
                        skullItem.skullProps.add(AOMItemsConfig.knockback_resistance(uuid, 2.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.overheal(uuid, 0.05, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AETHER_SUN_SPIRIT: {
                        skullItem.skullProps.add(AOMItemsConfig.fire_damage(uuid, 15.0, AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.dodge_change(uuid, 0.05, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_PRIDE: {
                        skullItem.skullProps.add(AOMItemsConfig.flying_speed(uuid, 10.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_GREED: {
                        skullItem.skullProps.add(AOMItemsConfig.luck(uuid, 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_LUST: {
                        skullItem.skullProps.add(AOMItemsConfig.max_health(uuid, 1000.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_ENVY: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_damage(uuid, 1000.0, AttributeModifier.Operation.ADDITION));
                        break;
                    }
                    case AGEOFMYTHOLOGY_GLUTTONY: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_speed(uuid, 10.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_WRATH: {
                        skullItem.skullProps.add(AOMItemsConfig.attack_knockback(uuid, 10.0, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case AGEOFMYTHOLOGY_SLOTH: {
                        skullItem.skullProps.add(AOMItemsConfig.movement_speed(uuid, 10.0, AttributeModifier.Operation.MULTIPLY_BASE)).add(AOMItemsConfig.step_height_addition(uuid, 10.0, AttributeModifier.Operation.ADDITION));
                    }
                }
                if (skullItem.skullProps == null || skullItem.skullProps.attributeModifiers.isEmpty()) {
                    Rarity rarity = itemsRarityMap.getOrDefault(mob.getSkullType(), AOMRarityConfig.COMMON);
                    skullItem.skullProps.add(AOMItemsConfig.max_health(uuid, AOMItemsConfig.getMaxHealth(rarity), AttributeModifier.Operation.ADDITION)).add(AOMItemsConfig.attack_damage(uuid, AOMItemsConfig.getAttackDamage(rarity), AttributeModifier.Operation.ADDITION));
                }
            }
        });
    }

    public static Rarity getItemRarity(MobVariant mob) {
        return itemsRarityMap.getOrDefault(mob.getSkullType(), defaultRarity);
    }

    public static AOMSkullProps getItemProps(MobVariant mob) {
        return itemsPropsMap.getOrDefault(mob.getSkullType(), new AOMSkullProps()).setSkullName(mob.getSkullType());
    }

    public static AOMAttributeModifier max_health(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op(Attributes.f_22276_, uuid, AgeOfMythologyMod.id("max_health").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier knockback_resistance(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op(Attributes.f_22278_, uuid, AgeOfMythologyMod.id("knockback_resistance").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier movement_speed(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op(Attributes.f_22279_, uuid, AgeOfMythologyMod.id("movement_speed").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier flying_speed(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.FLYING_SPEED.get(), uuid, AgeOfMythologyMod.id("flying_speed").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier attack_damage(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op(Attributes.f_22281_, uuid, AgeOfMythologyMod.id("attack_damage").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier attack_knockback(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op(Attributes.f_22282_, uuid, AgeOfMythologyMod.id("attack_knockback").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier attack_speed(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op(Attributes.f_22283_, uuid, AgeOfMythologyMod.id("attack_speed").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier armor(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op(Attributes.f_22284_, uuid, AgeOfMythologyMod.id("armor").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier armor_toughness(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op(Attributes.f_22285_, uuid, AgeOfMythologyMod.id("armor_toughness").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier luck(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op(Attributes.f_22286_, uuid, AgeOfMythologyMod.id("luck").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier jump_strength(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op(Attributes.f_22288_, uuid, AgeOfMythologyMod.id("jump_strength").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier swim_speed(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)ForgeMod.SWIM_SPEED.get(), uuid, AgeOfMythologyMod.id("swim_speed").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier block_reach(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)ForgeMod.BLOCK_REACH.get(), uuid, AgeOfMythologyMod.id("block_reach").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier entity_reach(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)ForgeMod.ENTITY_REACH.get(), uuid, AgeOfMythologyMod.id("entity_reach").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier step_height_addition(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), uuid, AgeOfMythologyMod.id("step_height_addition").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier mining_speed(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.MINING_SPEED.get(), uuid, AgeOfMythologyMod.id("mining_speed").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier critical_chance(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.CRITICAL_CHANCE.get(), uuid, AgeOfMythologyMod.id("critical_chance").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier minecraft_skeleton_ability_level(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.MINECRAFT_SKELETON_ABILITY_LEVEL.get(), uuid, AgeOfMythologyMod.id("minecraft_skeleton_ability_level").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier ability_level(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.ABILITY_LEVEL.get(), uuid, AgeOfMythologyMod.id("ability_level").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier ability_cooldown(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.ABILITY_COOLDOWN.get(), uuid, AgeOfMythologyMod.id("ability_cooldown").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier explosion_power(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.EXPLOSION_POWER.get(), uuid, AgeOfMythologyMod.id("explosion_power").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier explosion_range(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.EXPLOSION_RANGE.get(), uuid, AgeOfMythologyMod.id("explosion_range").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier explosion_cooldown(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.EXPLOSION_COOLDOWN.get(), uuid, AgeOfMythologyMod.id("explosion_cooldown").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier life_drain(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.LIFE_DRAIN.get(), uuid, AgeOfMythologyMod.id("life_drain").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier goety_spell_power(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        Attribute attribute = AOMUtil.getAttribute("goety_revelation:spell_power");
        if (attribute == null) {
            attribute = (Attribute)AttributeRegistry.SPELL_POWER.get();
        }
        return AOMAttributeModifier.create_op(attribute, uuid, AgeOfMythologyMod.id("goety_spell_power").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier goety_spell_power_mul(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        Attribute attribute = AOMUtil.getAttribute("goety_revelation:spell_power_multiplier");
        if (attribute == null) {
            attribute = (Attribute)AttributeRegistry.SPELL_POWER.get();
        }
        return AOMAttributeModifier.create_op(attribute, uuid, AgeOfMythologyMod.id("goety_spell_power_multiplier").toString(), () -> amount * 5.0, operation);
    }

    public static AOMAttributeModifier goety_spell_range(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        Attribute attribute = AOMUtil.getAttribute("goety_revelation:spell_range");
        if (attribute == null) {
            attribute = (Attribute)AttributeRegistry.SPELL_POWER.get();
        }
        return AOMAttributeModifier.create_op(attribute, uuid, AgeOfMythologyMod.id("goety_spell_range").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier goety_spell_radius(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        Attribute attribute = AOMUtil.getAttribute("goety_revelation:spell_radius");
        if (attribute == null) {
            attribute = (Attribute)AttributeRegistry.SPELL_POWER.get();
        }
        return AOMAttributeModifier.create_op(attribute, uuid, AgeOfMythologyMod.id("goety_spell_radius").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier goety_spell_spell_velocity(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        Attribute attribute = AOMUtil.getAttribute("goety_revelation:spell_velocity");
        if (attribute == null) {
            attribute = (Attribute)AttributeRegistry.SPELL_POWER.get();
        }
        return AOMAttributeModifier.create_op(attribute, uuid, AgeOfMythologyMod.id("goety_spell_velocity").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier potion_attack(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.POTION_ATTACK.get(), uuid, AgeOfMythologyMod.id("potion_attack").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier debilitating_sting(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.Debilitating_Sting.get(), uuid, AgeOfMythologyMod.id("debilitating_sting").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier exsanguination(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.Exsanguination.get(), uuid, AgeOfMythologyMod.id("exsanguination").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier fire_damage(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.FIRE_DAMAGE.get(), uuid, AgeOfMythologyMod.id("fire_damage").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier dragon_level(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.DRAGON_LEVEL.get(), uuid, AgeOfMythologyMod.id("dragon_level").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier dragon_power(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.DRAGON_POWER.get(), uuid, AgeOfMythologyMod.id("dragon_power").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier abyss_level(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.ABYSS_LEVEL.get(), uuid, AgeOfMythologyMod.id("abyss_level").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier abyss_damage(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.ABYSS_DAMAGE.get(), uuid, AgeOfMythologyMod.id("abyss_damage").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier machine_level(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.MACHINE_LEVEL.get(), uuid, AgeOfMythologyMod.id("machine_level").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier machine_damage(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.MACHINE_DAMAGE.get(), uuid, AgeOfMythologyMod.id("machine_damage").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier flesh_level(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.FLESH_LEVEL.get(), uuid, AgeOfMythologyMod.id("flesh_level").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier emotion_value(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.EMOTION_VALUE.get(), uuid, AgeOfMythologyMod.id("emotion_value").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier armor_shred(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)ALObjects.Attributes.ARMOR_SHRED.get(), uuid, AgeOfMythologyMod.id("armor_shred").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier overheal(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)ALObjects.Attributes.OVERHEAL.get(), uuid, AgeOfMythologyMod.id("overheal").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier dodge_change(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)ALObjects.Attributes.DODGE_CHANCE.get(), uuid, AgeOfMythologyMod.id("dodge_change").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier blood_power(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AOMAttributes.BLOOD_POWER.get(), uuid, AgeOfMythologyMod.id("blood_power").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier spell_power(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AttributeRegistry.SPELL_POWER.get(), uuid, AgeOfMythologyMod.id("spell_power").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier spell_resist(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AttributeRegistry.SPELL_RESIST.get(), uuid, AgeOfMythologyMod.id("spell_resist").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier max_mana(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AttributeRegistry.MAX_MANA.get(), uuid, AgeOfMythologyMod.id("max_mana").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier mana_regen(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AttributeRegistry.MANA_REGEN.get(), uuid, AgeOfMythologyMod.id("mana_regen").toString(), () -> amount, operation);
    }

    public static AOMAttributeModifier cooldown_reduction(UUID uuid, Double amount, AttributeModifier.Operation operation) {
        return AOMAttributeModifier.create_op((Attribute)AttributeRegistry.COOLDOWN_REDUCTION.get(), uuid, AgeOfMythologyMod.id("cooldown_reduction").toString(), () -> amount, operation);
    }
}

