/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.compat.jei;

import java.util.ArrayList;
import java.util.List;
import jeresources.compatibility.CompatBase;
import jeresources.reference.Resources;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MobTradeRecipe
implements IRecipeCategoryExtension {
    private final List<TradeContent> list;
    private final EntityType<?> entityType;
    private LivingEntity livingEntity;

    public MobTradeRecipe(EntityType<?> entityType) {
        this.entityType = entityType;
        this.list = new ArrayList<TradeContent>();
    }

    public void addList(TradeContent content) {
        this.list.add(content);
    }

    private LivingEntity getLivingEntity() {
        if (this.livingEntity == null) {
            LivingEntity livingEntity1;
            Entity entity = this.entityType.m_20615_(CompatBase.getLevel());
            this.livingEntity = entity instanceof LivingEntity ? (livingEntity1 = (LivingEntity)entity) : (LivingEntity)EntityType.f_20510_.m_20615_(CompatBase.getLevel());
        }
        return this.livingEntity;
    }

    public TradeContent getTrades(int index) {
        return this.list.get(index);
    }

    public int getSize() {
        return this.list.size();
    }

    public void drawInfo(int recipeWidth, int recipeHeight, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        LivingEntity entity = this.getLivingEntity();
        int size = (int)(48.0f * (1.0f / Math.max(entity.m_20206_(), entity.m_20205_())));
        RenderHelper.renderEntity((GuiGraphics)guiGraphics, (int)37, (int)118, (double)size, (double)-10.0, (double)-10.0, (LivingEntity)entity);
        int y = 22 * (6 - this.getSize()) / 2;
        for (int i = 0; i < this.getSize(); ++i) {
            RenderHelper.drawTexture((GuiGraphics)guiGraphics, (int)130, (int)(y + i * 22), (int)0, (int)120, (int)20, (int)20, (ResourceLocation)Resources.Gui.Jei.VILLAGER.getResource());
            RenderHelper.drawTexture((GuiGraphics)guiGraphics, (int)95, (int)(y + i * 22), (int)22, (int)120, (int)18, (int)18, (ResourceLocation)Resources.Gui.Jei.VILLAGER.getResource());
            RenderHelper.drawTexture((GuiGraphics)guiGraphics, (int)113, (int)(y + i * 22), (int)22, (int)120, (int)18, (int)18, (ResourceLocation)Resources.Gui.Jei.VILLAGER.getResource());
            RenderHelper.drawTexture((GuiGraphics)guiGraphics, (int)150, (int)(y + i * 22), (int)22, (int)120, (int)18, (int)18, (ResourceLocation)Resources.Gui.Jei.VILLAGER.getResource());
        }
        Font.normal.print(guiGraphics, TranslationHelper.translateAndFormat((String)this.entityType.m_20675_(), (Object[])new Object[0]), 5, 11);
        Font.normal.print(guiGraphics, TranslationHelper.translateAndFormat((String)"jei.mob_trade.hint", (Object[])new Object[0]), 5, 1);
    }

    public static class TradeContent {
        public ItemStack costA;
        public ItemStack costB;
        public ItemStack result;

        public TradeContent(ItemStack costA, ItemStack costB, ItemStack result) {
            this.costA = costA;
            this.costB = costB;
            this.result = result;
        }

        public List<ItemStack> getCostAs() {
            return List.of(this.costA);
        }

        public List<ItemStack> getCostBs() {
            return List.of(this.costB);
        }

        public List<ItemStack> getResult() {
            return List.of(this.result);
        }
    }
}

