/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.compat.jei;

import com.google.common.collect.ImmutableMap;
import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.compat.jei.MobTradeCategory;
import com.kurome.ageofmythology.compat.jei.MobTradeRecipe;
import com.kurome.ageofmythology.config.AOMFilterConfig;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.enums.MobVariant;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import liushuangwuyin.bettermorph.forge.IdentityForge;
import liushuangwuyin.bettermorph.forge.utils.TradeConfig;
import liushuangwuyin.bettermorph.forge.utils.TradeOfferFactor;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class AOMJeiPlugin
implements IModPlugin {
    public static final ResourceLocation MOD = AgeOfMythologyMod.id("ageofmythology");
    public static final RecipeType<MobTradeRecipe> MOB_TRADE_TYPE = RecipeType.create((String)"ageofmythology", (String)"mob_trade", MobTradeRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("ageofmythology", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new MobTradeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        for (MobVariant mobVariant : MobVariant.values()) {
            Optional<EntityType<?>> optionalEntityType;
            if (AOMFilterConfig.identityBlackList.contains(mobVariant.getSkullType()) || !(optionalEntityType = AOMUtil.getEntityType(mobVariant.getSkullType())).isPresent()) continue;
            EntityType<?> type = optionalEntityType.get();
            List<MobTradeRecipe> recipes = AOMJeiPlugin.getRecipes(type);
            for (MobTradeRecipe recipe : recipes) {
                if (recipe.getSize() <= 0) continue;
                registration.addRecipes(MOB_TRADE_TYPE, List.of(recipe));
            }
        }
    }

    public static MobTradeRecipe getRecipe(EntityType<?> entityType) {
        VillagerTrades.ItemListing[] factory;
        MobTradeRecipe recipe = new MobTradeRecipe(entityType);
        Int2ObjectMap int2ObjectMap = TradeConfig.tradeOfferLists.getOrDefault(TradeConfig.id(entityType), null);
        if (int2ObjectMap != null && !int2ObjectMap.isEmpty() && (factory = (VillagerTrades.ItemListing[])int2ObjectMap.get(1)) != null) {
            for (int i = 0; i < factory.length; ++i) {
                MerchantOffer offer = factory[i].m_213663_(null, null);
                if (offer == null) continue;
                recipe.addList(new MobTradeRecipe.TradeContent(offer.m_45358_(), offer.m_45364_(), offer.m_45368_()));
            }
        }
        return recipe;
    }

    public static List<MobTradeRecipe> getRecipes(EntityType<?> entityType) {
        VillagerTrades.ItemListing[] factory;
        ArrayList<MobTradeRecipe> recipes = new ArrayList<MobTradeRecipe>();
        Int2ObjectMap int2ObjectMap = TradeConfig.tradeOfferLists.getOrDefault(TradeConfig.id(entityType), null);
        if (int2ObjectMap != null && !int2ObjectMap.isEmpty() && (factory = (VillagerTrades.ItemListing[])int2ObjectMap.get(1)) != null && factory.length > 0) {
            MobTradeRecipe currentRecipe = null;
            int tradeCountInCurrent = 0;
            for (int i = 0; i < factory.length; ++i) {
                MerchantOffer offer = factory[i].m_213663_(null, null);
                if (offer == null) continue;
                if (currentRecipe == null || tradeCountInCurrent >= 5) {
                    currentRecipe = new MobTradeRecipe(entityType);
                    recipes.add(currentRecipe);
                    tradeCountInCurrent = 0;
                }
                currentRecipe.addList(new MobTradeRecipe.TradeContent(offer.m_45358_(), offer.m_45364_(), offer.m_45368_()));
                ++tradeCountInCurrent;
            }
        }
        return recipes;
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> createDefaultTradeOffers(EntityType<?> entityType) {
        Item item = IdentityForge.isLoadAOM() ? AOMUtil.getAOMItemByEntityId(TradeConfig.id(entityType)) : Items.f_41852_;
        return AOMJeiPlugin.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new TradeOfferFactor(new ItemStack((ItemLike)Items.f_42616_, 16), new ItemStack((ItemLike)(item != null ? item : Items.f_41852_), 1))}));
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> copyToFastUtilMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }
}

