/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.compat.curios.pehkui;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.api.ITitan;
import com.kurome.ageofmythology.compat.curios.pehkui.PehkuiHelper;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.api.TypedScaleModifier;

public final class PehkuiIntegration {
    private static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("33534fd5-d2d3-4565-a9d7-9a7e195554a9");
    private static final float DEFAULT_SCALE = 1.0f;
    private static final ScaleModifier SCALE_MODIFIER = PehkuiIntegration.registerScaleModifier("scale", () -> new TypedScaleModifier(() -> SCALE_TYPE));
    private static final ScaleType SCALE_TYPE = PehkuiIntegration.registerScaleType("size", builder -> builder.affectsDimensions().addDependentModifier(SCALE_MODIFIER));

    private PehkuiIntegration() {
    }

    public static void init(Consumer<PehkuiHelper> helperSetter) {
        ScaleTypes.BASE.getDefaultBaseValueModifiers().add(SCALE_MODIFIER);
        SCALE_TYPE.getScaleChangedEvent().add(scaleData -> {
            LivingEntity livingEntity;
            Entity patt1254$temp = scaleData.getEntity();
            if (patt1254$temp instanceof LivingEntity && !(livingEntity = (LivingEntity)patt1254$temp).m_9236_().m_5776_()) {
                float scale = scaleData.getScale();
                float targetScale = scaleData.getTargetScale();
                if (Mth.m_14033_((float)targetScale, (float)scale)) {
                    PehkuiIntegration.onScaleChangeCompleted(livingEntity, targetScale);
                }
            }
        });
        helperSetter.accept(new PehkuiHelperImpl());
    }

    private static void onScaleChangeCompleted(LivingEntity livingEntity, float targetScale) {
        PehkuiIntegration.updateMaxHealth(livingEntity, targetScale);
    }

    private static void updateMaxHealth(LivingEntity livingEntity, float targetScale) {
        AttributeInstance healthAttribute = livingEntity.m_21051_(Attributes.f_22276_);
        if (healthAttribute != null) {
            healthAttribute.m_22120_(HEALTH_MODIFIER_UUID);
            float modifierAmount = targetScale - 1.0f;
            if (modifierAmount != 0.0f) {
                healthAttribute.m_22118_(new AttributeModifier(HEALTH_MODIFIER_UUID, "tfe_scaled_mob", (double)modifierAmount, AttributeModifier.Operation.MULTIPLY_BASE));
                float maxHealth = livingEntity.m_21233_();
                livingEntity.m_21153_(maxHealth);
                if (livingEntity instanceof ITitan) {
                    ITitan titan = (ITitan)livingEntity;
                    AttributeInstance movement = livingEntity.m_21051_(Attributes.f_22279_);
                    if (movement != null) {
                        movement.m_22100_(titan.getMovement());
                    }
                }
            }
        }
    }

    private static ScaleModifier registerScaleModifier(String name, Supplier<ScaleModifier> factory) {
        return (ScaleModifier)ScaleRegistries.register((Map)ScaleRegistries.SCALE_MODIFIERS, (ResourceLocation)AgeOfMythologyMod.prefix(name), (Object)factory.get());
    }

    private static ScaleType registerScaleType(String name, UnaryOperator<ScaleType.Builder> builder) {
        return (ScaleType)ScaleRegistries.register((Map)ScaleRegistries.SCALE_TYPES, (ResourceLocation)AgeOfMythologyMod.prefix(name), (Object)((ScaleType.Builder)builder.apply(ScaleType.Builder.create())).build());
    }

    static final class PehkuiHelperImpl
    implements PehkuiHelper {
        PehkuiHelperImpl() {
        }

        @Override
        public void setScale(LivingEntity livingEntity, float scale) {
            SCALE_TYPE.getScaleData((Entity)livingEntity).setTargetScale(scale);
        }

        @Override
        public void setBaseScale(LivingEntity livingEntity, float scale) {
            SCALE_TYPE.getScaleData((Entity)livingEntity).setScale(scale);
        }

        @Override
        public void resetSize(LivingEntity livingEntity) {
            this.setScale(livingEntity, 1.0f);
        }

        @Override
        public void resize(LivingEntity livingEntity, float multiplier) {
            ScaleData scaleData = SCALE_TYPE.getScaleData((Entity)livingEntity);
            float targetScale = scaleData.getScale() * multiplier;
            scaleData.setTargetScale(targetScale);
        }

        @Override
        public float getScale(LivingEntity livingEntity) {
            ScaleData scaleData = SCALE_TYPE.getScaleData((Entity)livingEntity);
            return scaleData.getScale();
        }
    }
}

