/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.compat.curios;

import com.kurome.ageofmythology.item.ICurioSkull;
import javax.annotation.Nonnull;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.capability.CurioItemCapability;

public class CuriosCompat {
    public static ICapabilityProvider setupCuriosCapability(final ICurioSkull item, final ItemStack stack) {
        return CurioItemCapability.createProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            @Nonnull
            public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
                return new ICurio.SoundInfo(item.getEquipSound(), 1.0f, 1.0f);
            }

            public void onEquip(SlotContext context, ItemStack prevStack) {
                item.onEquip(context.entity(), stack);
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                item.onUnequip(slotContext.entity(), stack);
            }

            public void curioTick(SlotContext slotContext) {
                item.curioTick(slotContext.entity(), stack);
            }

            public boolean canEquipFromUse(SlotContext slotContext) {
                return true;
            }

            @NotNull
            public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit) {
                return ICurio.DropRule.ALWAYS_KEEP;
            }

            public int getFortuneLevel(SlotContext slotContext, @Nullable LootContext lootContext) {
                return item.getSkullProps().fortuneLevel;
            }

            public int getLootingLevel(SlotContext slotContext, DamageSource source, LivingEntity target, int baseLooting) {
                return item.getSkullProps().lootingLevel;
            }
        });
    }

    public static void registerCurioRenderers(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {});
    }
}

