/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.kurome.ageofmythology.block.AOMAbstractSkullBlock;
import com.kurome.ageofmythology.block.AOMSkullBlock;
import com.kurome.ageofmythology.block.AOMSkullBlockEntity;
import com.kurome.ageofmythology.block.AOMSkullWallBlock;
import com.kurome.ageofmythology.client.model.AOMModelLayers;
import com.kurome.ageofmythology.client.model.tileentity.GenericTrophyModel;
import com.kurome.ageofmythology.client.model.tileentity.NormalSkullModel;
import com.kurome.ageofmythology.config.AOMEntityRenderConfig;
import com.kurome.ageofmythology.enums.MobVariant;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class AOMSkullTileEntityRenderer
implements BlockEntityRenderer<AOMSkullBlockEntity> {
    private final Map<MobVariant, GenericTrophyModel> skulls;

    public AOMSkullTileEntityRenderer(BlockEntityRendererProvider.Context renderer) {
        this.skulls = AOMSkullTileEntityRenderer.createSkullRenderersUncached(renderer.m_173585_());
    }

    public static Map<MobVariant, GenericTrophyModel> createSkullRenderers(EntityModelSet set) {
        ImmutableMap.Builder trophyList = ImmutableMap.builder();
        trophyList.put((Object)MobVariant.DEFAULT, (Object)new NormalSkullModel(set.m_171103_(AOMModelLayers.NORMAL_SKULL)));
        trophyList.put((Object)MobVariant.VANILLA, (Object)new NormalSkullModel(set.m_171103_(AOMModelLayers.VANILLA_SKULL)));
        return trophyList.build();
    }

    public static Map<MobVariant, GenericTrophyModel> createSkullRenderersUncached(EntityModelSet set) {
        ImmutableMap.Builder trophyList = ImmutableMap.builder();
        trophyList.put((Object)MobVariant.DEFAULT, (Object)new NormalSkullModel(set.m_171103_(AOMModelLayers.NORMAL_SKULL)));
        trophyList.put((Object)MobVariant.VANILLA, (Object)new NormalSkullModel(set.m_171103_(AOMModelLayers.VANILLA_SKULL)));
        return trophyList.build();
    }

    public GenericTrophyModel getSkullModel(MobVariant variant) {
        GenericTrophyModel model = this.skulls.get((Object)variant);
        if (model == null) {
            return this.skulls.get((Object)MobVariant.VANILLA);
        }
        return model;
    }

    public void render(AOMSkullBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float f = tileEntityIn.getAnimationProgress(partialTicks);
        BlockState blockstate = tileEntityIn.m_58900_();
        boolean flag = blockstate.m_60734_() instanceof AOMSkullWallBlock;
        Direction direction = flag ? (Direction)blockstate.m_61143_((Property)AOMSkullWallBlock.FACING) : null;
        float f1 = 22.5f * (float)(flag ? (2 + direction.m_122416_()) * 4 : (Integer)blockstate.m_61143_((Property)AOMSkullBlock.ROTATION));
        MobVariant variant = ((AOMAbstractSkullBlock)blockstate.m_60734_()).getVariant();
        GenericTrophyModel model = this.getSkullModel(variant);
        matrixStackIn.m_85836_();
        AOMSkullTileEntityRenderer.render(direction, f1, model, variant, f, matrixStackIn, bufferIn, combinedLightIn, ItemDisplayContext.NONE);
        matrixStackIn.m_85849_();
    }

    public static void render(@Nullable Direction directionIn, float y, GenericTrophyModel model, MobVariant variant, float animationProgress, PoseStack matrixStackIn, MultiBufferSource buffer, int combinedLight, ItemDisplayContext camera) {
        matrixStackIn.m_85836_();
        if (directionIn == null) {
            matrixStackIn.m_85837_(0.5, 0.0, 0.5);
        } else {
            matrixStackIn.m_85837_((double)(0.5f - (float)directionIn.m_122429_() * 0.25f), 0.25, (double)(0.5f - (float)directionIn.m_122431_() * 0.25f));
        }
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        model.setRotations(animationProgress * 4.5f, y, 0.0f);
        ResourceLocation renderTexture = AOMEntityRenderConfig.getTexture(variant);
        VertexConsumer nagaVertex = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)renderTexture));
        model.m_7695_(matrixStackIn, nagaVertex, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
    }
}

