/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.client.color;

import com.google.gson.JsonSyntaxException;
import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.capability.PlayerDataCapability;
import com.kurome.ageofmythology.dimension.AOMDimension;
import com.kurome.ageofmythology.model.CapabilityExtraInfo;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ColorRenderEvent {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation phase_1 = AgeOfMythologyMod.id("shaders/post/phase_1.json");
    private static final ResourceLocation phase_2 = AgeOfMythologyMod.id("shaders/post/phase_2.json");
    private static final ResourceLocation phase_3 = AgeOfMythologyMod.id("shaders/post/phase_3.json");
    private static final ResourceLocation phase_4 = AgeOfMythologyMod.id("shaders/post/phase_4.json");
    private static final ResourceLocation phase_5 = AgeOfMythologyMod.id("shaders/post/phase_5.json");
    private static final ResourceLocation phase_6 = AgeOfMythologyMod.id("shaders/post/phase_6.json");
    private static final ResourceLocation phase_7 = AgeOfMythologyMod.id("shaders/post/phase_7.json");
    private static final ResourceLocation phase_404 = AgeOfMythologyMod.id("shaders/post/phase_404.json");
    private static PostChain phase_1_shader;
    private static PostChain phase_2_shader;
    private static PostChain phase_3_shader;
    private static PostChain phase_4_shader;
    private static PostChain phase_5_shader;
    private static PostChain phase_6_shader;
    private static PostChain phase_7_shader;
    private static PostChain phase_404_shader;
    private static int lastWidth;
    private static int lastHeight;
    private static PostChain lastShader;

    private static void makeColorShaders() {
        if (phase_1_shader == null) {
            phase_1_shader = ColorRenderEvent.createShaderGroup(phase_1);
        }
        if (phase_2_shader == null) {
            phase_2_shader = ColorRenderEvent.createShaderGroup(phase_2);
        }
        if (phase_3_shader == null) {
            phase_3_shader = ColorRenderEvent.createShaderGroup(phase_3);
        }
        if (phase_4_shader == null) {
            phase_4_shader = ColorRenderEvent.createShaderGroup(phase_4);
        }
        if (phase_5_shader == null) {
            phase_5_shader = ColorRenderEvent.createShaderGroup(phase_5);
        }
        if (phase_6_shader == null) {
            phase_6_shader = ColorRenderEvent.createShaderGroup(phase_6);
        }
        if (phase_7_shader == null) {
            phase_7_shader = ColorRenderEvent.createShaderGroup(phase_7);
        }
        if (phase_404_shader == null) {
            phase_404_shader = ColorRenderEvent.createShaderGroup(phase_404);
        }
    }

    private static PostChain createShaderGroup(ResourceLocation location) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            return new PostChain(mc.m_91097_(), mc.m_91098_(), mc.m_91385_(), location);
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to load shader: {}", (Object)location, (Object)ioexception);
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            LOGGER.warn("Failed to parse shader: {}", (Object)location, (Object)jsonsyntaxexception);
        }
        return null;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRender(TickEvent.RenderTickEvent event) {
        LocalPlayer player;
        if (event != null && event.phase == TickEvent.Phase.END && (player = Minecraft.m_91087_().f_91074_) != null && player.m_9236_().m_46472_().equals(AOMDimension.LOST_DREAM_LEVEL)) {
            ColorRenderEvent.makeColorShaders();
            AtomicReference activeShader = new AtomicReference();
            player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                CapabilityExtraInfo info = data.getExtraInfo();
                if (info.color_phase == 0) {
                    activeShader.set(phase_1_shader);
                } else if (info.color_phase == 1) {
                    activeShader.set(phase_2_shader);
                } else if (info.color_phase == 2) {
                    activeShader.set(phase_3_shader);
                } else if (info.color_phase == 3) {
                    activeShader.set(phase_4_shader);
                } else if (info.color_phase == 4) {
                    activeShader.set(phase_5_shader);
                } else if (info.color_phase == 5) {
                    activeShader.set(phase_6_shader);
                } else if (info.color_phase == 6) {
                    activeShader.set(phase_7_shader);
                } else if (info.color_phase == 404) {
                    activeShader.set(phase_404_shader);
                }
            });
            if (activeShader.get() != null) {
                if (lastShader != activeShader.get()) {
                    lastShader = (PostChain)activeShader.get();
                    lastWidth = 0;
                    lastHeight = 0;
                }
                ColorRenderEvent.updateShaderGroupSize((PostChain)activeShader.get());
                ((PostChain)activeShader.get()).m_110023_(event.renderTickTime);
                Minecraft.m_91087_().m_91385_().m_83947_(false);
            }
        }
    }

    public static void updateShaderGroupSize(PostChain shaderGroup) {
        if (shaderGroup != null) {
            Minecraft mc = Minecraft.m_91087_();
            int width = mc.m_91268_().m_85441_();
            int height = mc.m_91268_().m_85442_();
            if (width != lastWidth || height != lastHeight) {
                lastWidth = width;
                lastHeight = height;
                shaderGroup.m_110025_(width, height);
            }
        }
    }

    static {
        lastWidth = 0;
        lastHeight = 0;
        lastShader = null;
    }
}

