/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.capability.events;

import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.kurome.ageofmythology.advancement.criterion.moon_ritual.MoonP1RitualTrigger;
import com.kurome.ageofmythology.api.ILevel;
import com.kurome.ageofmythology.capability.PlayerDataCapability;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ageofmythology")
public class CapabilityEvents {
    private static Field validCap;
    private static final ScheduledExecutorService scheduler;

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (PlayerDataCapability.canAttachTo((ICapabilityProvider)entity)) {
            event.addCapability(PlayerDataCapability.NAME, (ICapabilityProvider)new PlayerDataCapability());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        original.reviveCaps();
        CapabilityEvents.copyCapability(PlayerDataCapability.INSTANCE, (ICapabilityProvider)original, (ICapabilityProvider)clone);
        clone.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> data.sync(clone));
        original.invalidateCaps();
    }

    @SubscribeEvent
    public static void respawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> data.sync(player));
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data2 = playerData.m_128469_("PlayerPersisted");
        float heal_health = data2.m_128457_("player_max_health");
        LogUtils.getLogger().info("respawnEvent %s %s".formatted(Float.valueOf(player.m_21233_()), Float.valueOf(heal_health)));
        player.m_5634_(heal_health - player.m_21223_());
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
            if (event.getTo().equals((Object)AetherDimensions.AETHER_LEVEL)) {
                long fixedTime = ((ILevel)player.m_9236_().m_6042_()).getAetherTime();
                data.setSunState(MoonP1RitualTrigger.getPhase(fixedTime));
            }
            data.setNoPhysics(false);
            data.sync(player);
        });
    }

    @SubscribeEvent
    public static void PlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
            data.setNoPhysics(false);
            data.sync(player);
        });
    }

    private static <T> void copyCapability(Capability<T> capability, ICapabilityProvider original, ICapabilityProvider clone) {
        original.getCapability(capability).ifPresent(dataOriginal -> clone.getCapability(capability).ifPresent(dataClone -> {
            if (dataOriginal instanceof INBTSerializable) {
                INBTSerializable originalS = (INBTSerializable)dataOriginal;
                if (dataClone instanceof INBTSerializable) {
                    INBTSerializable cloneS = (INBTSerializable)dataClone;
                    cloneS.deserializeNBT(originalS.serializeNBT());
                }
            }
        }));
    }

    static {
        scheduler = Executors.newScheduledThreadPool(1);
    }
}

