/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.capability;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.capability.api.IPlayerData;
import com.kurome.ageofmythology.model.CapabilityExtraInfo;
import com.kurome.ageofmythology.net.Messages;
import com.kurome.ageofmythology.net.capability.ClientSyncPlayerDataCapability;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import liushuangwuyin.bettermorph.impl.DimensionsRefresher;
import liushuangwuyin.bettermorph.impl.PlayerDataProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerDataCapability
implements IPlayerData,
ICapabilitySerializable<CompoundTag> {
    public static Capability<IPlayerData> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerData>(){});
    public static ResourceLocation NAME = AgeOfMythologyMod.id("traveller");
    private static final String NBT_VISIT_BIOMES = "VisitBiomes";
    private static final String NBT_VISIT_BIOMES_SIZE = "VisitBiomesSize";
    private static final String NBT_LISTENED_DISCS = "nbt_listened_discs";
    private static final String NBT_LISTENED_DISCS_SIZE = "nbt_listened_discs_size";
    public static final String NBT_FOOD_LIST = "nbt_food_list";
    public static final String NBT_FOOD_LIST_SIZE = "nbt_food_list_size";
    public static final String NBT_DRAGON_AGE = "nbt_dragon_age";
    public static final String NBT_NO_PHYSICS = "nbt_no_physics";
    public static final String NBT_SUN_STATE = "nbt_sun_state";
    private final LazyOptional<IPlayerData> holder = LazyOptional.of(() -> this);
    private Set<String> visitBiomes = new HashSet<String>();
    private Set<String> listenDiscs = new HashSet<String>();
    private Set<String> foodList = new HashSet<String>();
    private int dragonAge = 0;
    private int sunState = 0;
    private boolean noPhysics = false;
    private CapabilityExtraInfo extraInfo = new CapabilityExtraInfo();

    @Override
    public CapabilityExtraInfo getExtraInfo() {
        return this.extraInfo;
    }

    @Override
    public void setExtraInfo(CapabilityExtraInfo extraInfo) {
        this.extraInfo = extraInfo;
    }

    @Override
    public int getSunState() {
        return this.sunState;
    }

    @Override
    public void setSunState(int sunState) {
        this.sunState = sunState;
    }

    @Override
    public int getDragonAge() {
        return this.dragonAge;
    }

    @Override
    public void setDragonAge(int dragonAge) {
        this.dragonAge = dragonAge;
    }

    @Override
    public boolean getNoPhysics() {
        return this.noPhysics;
    }

    @Override
    public void setNoPhysics(boolean key) {
        this.noPhysics = key;
    }

    @Override
    public Set<String> getFoodList() {
        return this.foodList;
    }

    @Override
    public void addFood(String key) {
        this.foodList.add(key);
    }

    @Override
    public void setFoodList(Set<String> list) {
        this.foodList = list;
    }

    @Override
    public Set<String> getListenedDisc() {
        return this.listenDiscs;
    }

    @Override
    public void addDisc(String key) {
        this.listenDiscs.add(key);
    }

    @Override
    public boolean hasListened(String key) {
        return this.listenDiscs.contains(key);
    }

    @Override
    public void setDiscs(Set<String> discs) {
        this.listenDiscs = discs;
    }

    @Override
    public Set<String> getVisitBiomes() {
        return this.visitBiomes;
    }

    @Override
    public void addVisitBiome(String key) {
        this.visitBiomes.add(key);
    }

    @Override
    public boolean hasVisited(String key) {
        return this.visitBiomes.contains(key);
    }

    @Override
    public void setVisitBiomes(Set<String> visitBiomes) {
        this.visitBiomes = visitBiomes;
    }

    @Override
    public void clear() {
        this.visitBiomes.clear();
        this.listenDiscs.clear();
        this.dragonAge = 0;
        this.sunState = 0;
    }

    @Override
    public void sync(Player player) {
        if (player instanceof ServerPlayer) {
            PlayerDataProvider dataProvider;
            LivingEntity identity;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer instanceof PlayerDataProvider && (identity = (dataProvider = (PlayerDataProvider)serverPlayer).getIdentity()) instanceof EntityDragonBase) {
                EntityDragonBase dragon = (EntityDragonBase)identity;
                dragon.setAgeInDays(this.dragonAge);
                dragon.m_20011_(dragon.m_20191_());
                dragon.m_6210_();
                ((DimensionsRefresher)player).identity_refreshDimensions();
            }
            Messages.sendToPlayer(new ClientSyncPlayerDataCapability(this.getVisitBiomes(), this.getListenedDisc(), this.getFoodList(), this.getDragonAge(), this.getNoPhysics(), this.getSunState(), this.getExtraInfo()), serverPlayer);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return INSTANCE.orEmpty(cap, this.holder);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.writeSetNbt(nbt, NBT_VISIT_BIOMES, NBT_VISIT_BIOMES_SIZE, this.visitBiomes);
        this.writeSetNbt(nbt, NBT_LISTENED_DISCS, NBT_LISTENED_DISCS_SIZE, this.listenDiscs);
        this.writeSetNbt(nbt, NBT_FOOD_LIST, NBT_FOOD_LIST_SIZE, this.foodList);
        nbt.m_128405_(NBT_DRAGON_AGE, this.dragonAge);
        nbt.m_128379_(NBT_NO_PHYSICS, this.noPhysics);
        nbt.m_128405_(NBT_SUN_STATE, this.sunState);
        this.extraInfo.serializeNBT(nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.readSetNbt(nbt, NBT_VISIT_BIOMES, NBT_VISIT_BIOMES_SIZE, this::addVisitBiome);
        this.readSetNbt(nbt, NBT_LISTENED_DISCS, NBT_LISTENED_DISCS_SIZE, this::addDisc);
        this.readSetNbt(nbt, NBT_FOOD_LIST, NBT_FOOD_LIST_SIZE, this::addFood);
        this.dragonAge = nbt.m_128451_(NBT_DRAGON_AGE);
        this.noPhysics = nbt.m_128471_(NBT_NO_PHYSICS);
        this.sunState = nbt.m_128451_(NBT_SUN_STATE);
        this.extraInfo.deserializeNBT(nbt);
    }

    public static boolean canAttachTo(ICapabilityProvider entity) {
        return entity instanceof Player && !entity.getCapability(INSTANCE).isPresent();
    }

    private void readSetNbt(@Nullable CompoundTag nbt, String key, String sizeKey, Consumer<String> consumer) {
        if (nbt == null) {
            return;
        }
        int size = nbt.m_128451_(sizeKey);
        for (int i = 0; i < size; ++i) {
            String result = nbt.m_128461_(key + i);
            consumer.accept(result);
        }
    }

    private void writeSetNbt(CompoundTag nbt, String key, String sizeKey, Set<String> add) {
        List list = add.stream().toList();
        int size = list.size();
        nbt.m_128405_(sizeKey, size);
        for (int i = 0; i < size; ++i) {
            nbt.m_128359_(key + i, (String)list.get(i));
        }
    }
}

